/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.local;

import db.buffers.BufferFile;
import db.buffers.LocalBufferFile;
import db.buffers.LocalManagedBufferFile;
import db.buffers.ManagedBufferFile;
import ghidra.framework.store.CheckoutType;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.FileIDFactory;
import ghidra.framework.store.FolderItem;
import ghidra.framework.store.ItemCheckoutStatus;
import ghidra.framework.store.db.PrivateDatabase;
import ghidra.framework.store.db.VersionedDBListener;
import ghidra.framework.store.db.VersionedDatabase;
import ghidra.framework.store.local.LocalFileSystem;
import ghidra.framework.store.local.LocalFolderItem;
import ghidra.util.Msg;
import ghidra.util.PropertyFile;
import ghidra.util.ReadOnlyException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.IOException;

public class LocalDatabaseItem
extends LocalFolderItem
implements DatabaseItem {
    private PrivateDatabase privateDb;
    private VersionedDatabase versionedDb;
    private LocalVersionedDbListener versionedDbListener;
    private String deleteUser;

    private LocalDatabaseItem(LocalFileSystem fileSystem, PropertyFile propertyFile, boolean create) throws IOException {
        super(fileSystem, propertyFile, true, create);
        if (this.isVersioned) {
            this.versionedDbListener = new LocalVersionedDbListener();
        }
    }

    LocalDatabaseItem(LocalFileSystem fileSystem, PropertyFile propertyFile) throws IOException {
        super(fileSystem, propertyFile, true, false);
        if (this.isVersioned) {
            this.versionedDbListener = new LocalVersionedDbListener();
            this.versionedDb = new VersionedDatabase(this.getDataDir(), this.versionedDbListener);
            this.versionedDb.setSynchronizationObject(fileSystem);
        } else {
            this.privateDb = new PrivateDatabase(this.getDataDir());
            this.privateDb.setIsCheckoutCopy(this.isCheckedOut());
            this.privateDb.setSynchronizationObject(fileSystem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalDatabaseItem(LocalFileSystem fileSystem, PropertyFile propertyFile, BufferFile srcFile, String contentType, String fileID, String comment, boolean resetDatabaseId, TaskMonitor monitor, String user) throws IOException, CancelledException {
        super(fileSystem, propertyFile, true, true);
        boolean success = false;
        long checkoutId = -1L;
        try {
            if (fileID != null) {
                String oldFileId = propertyFile.getFileID();
                propertyFile.setFileID(fileID);
                fileSystem.fileIdChanged(propertyFile, oldFileId);
            }
            propertyFile.putInt("FILE_TYPE", 0);
            propertyFile.putBoolean("READ_ONLY", false);
            propertyFile.putString("CONTENT_TYPE", contentType);
            if (this.isVersioned) {
                ItemCheckoutStatus coStatus = this.checkout(CheckoutType.NORMAL, user, null);
                checkoutId = coStatus.getCheckoutId();
                this.beginCheckin(checkoutId);
                this.versionedDbListener = new LocalVersionedDbListener();
                this.versionedDb = new VersionedDatabase(this.getDataDir(), srcFile, (VersionedDBListener)this.versionedDbListener, checkoutId, comment, monitor);
                this.versionedDb.setSynchronizationObject(fileSystem);
                this.terminateCheckout(checkoutId, false);
            } else {
                this.privateDb = new PrivateDatabase(this.getDataDir(), srcFile, resetDatabaseId, monitor);
                this.privateDb.setIsCheckoutCopy(this.isCheckedOut());
                this.privateDb.setSynchronizationObject(fileSystem);
            }
            propertyFile.writeState();
            success = true;
        }
        finally {
            if (!success) {
                if (this.isVersioned) {
                    this.endCheckin(checkoutId);
                }
                this.abortCreate();
            }
        }
        this.fireItemCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalDatabaseItem(LocalFileSystem fileSystem, PropertyFile propertyFile, File packedFile, String contentType, TaskMonitor monitor, String user) throws IOException, CancelledException {
        super(fileSystem, propertyFile, true, true);
        if (this.isVersioned) {
            throw new UnsupportedOperationException();
        }
        boolean success = false;
        long checkoutId = -1L;
        try {
            propertyFile.putInt("FILE_TYPE", 0);
            propertyFile.putBoolean("READ_ONLY", false);
            propertyFile.putString("CONTENT_TYPE", contentType);
            String oldFileId = propertyFile.getFileID();
            propertyFile.setFileID(FileIDFactory.createFileID());
            fileSystem.fileIdChanged(propertyFile, oldFileId);
            this.privateDb = new PrivateDatabase(this.getDataDir(), packedFile, monitor);
            this.privateDb.setIsCheckoutCopy(this.isCheckedOut());
            this.privateDb.setSynchronizationObject(fileSystem);
            propertyFile.writeState();
            success = true;
        }
        finally {
            if (!success) {
                if (this.isVersioned) {
                    this.endCheckin(checkoutId);
                }
                this.abortCreate();
            }
        }
        this.fireItemCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LocalManagedBufferFile create(LocalFileSystem fileSystem, PropertyFile propertyFile, int bufferSize, String contentType, String fileID, String user, String projectPath) throws IOException {
        LocalDatabaseItem dbItem = new LocalDatabaseItem(fileSystem, propertyFile, true);
        File dbDir = dbItem.getDataDir();
        long checkoutId = -1L;
        boolean success = false;
        try {
            LocalManagedBufferFile bfile;
            if (fileID != null) {
                String oldFileId = propertyFile.getFileID();
                propertyFile.setFileID(fileID);
                fileSystem.fileIdChanged(propertyFile, oldFileId);
            }
            propertyFile.putInt("FILE_TYPE", 0);
            propertyFile.putBoolean("READ_ONLY", false);
            propertyFile.putString("CONTENT_TYPE", contentType);
            if (fileSystem.isVersioned()) {
                ItemCheckoutStatus coStatus = dbItem.checkout(CheckoutType.NORMAL, user, projectPath);
                checkoutId = coStatus.getCheckoutId();
                dbItem.beginCheckin(checkoutId);
                bfile = VersionedDatabase.createVersionedDatabase(dbDir, bufferSize, dbItem.versionedDbListener, checkoutId);
            } else {
                bfile = PrivateDatabase.createDatabase(dbDir, (db, version) -> {
                    LocalFileSystem localFileSystem = fileSystem;
                    synchronized (localFileSystem) {
                        if (version == 1) {
                            if (dbItem.privateDb == null) {
                                db.setSynchronizationObject((Object)dbItem.fileSystem);
                                dbItem.privateDb = (PrivateDatabase)db;
                            }
                            dbItem.fireItemCreated();
                        }
                    }
                }, bufferSize);
            }
            propertyFile.writeState();
            success = true;
            LocalManagedBufferFile localManagedBufferFile = bfile;
            return localManagedBufferFile;
        }
        finally {
            if (!success) {
                if (fileSystem.isVersioned()) {
                    dbItem.endCheckin(checkoutId);
                }
                dbItem.abortCreate();
            }
        }
    }

    @Override
    public long length() throws IOException {
        if (this.isVersioned) {
            return this.versionedDb.length();
        }
        return this.privateDb.length();
    }

    @Override
    void moveTo(File newFolder, String newStorageName, String newFolderPath, String newName) throws IOException {
        super.moveTo(newFolder, newStorageName, newFolderPath, newName);
        if (this.isVersioned) {
            this.versionedDb.dbMoved(this.getDataDir());
        } else {
            this.privateDb.dbMoved(this.getDataDir());
        }
    }

    @Override
    void fireItemChanged() {
        if (this.privateDb != null) {
            this.privateDb.setIsCheckoutCopy(this.isCheckedOut());
        }
        super.fireItemChanged();
    }

    @Override
    public int getCurrentVersion() {
        if (this.isVersioned) {
            return this.versionedDb != null ? this.versionedDb.getCurrentVersion() : 0;
        }
        return this.privateDb != null ? this.privateDb.getCurrentVersion() : 0;
    }

    @Override
    public int getMinimumVersion() throws IOException {
        if (this.isVersioned) {
            if (this.versionedDb == null) {
                throw new IllegalStateException();
            }
            return this.versionedDb.getMinimumVersion();
        }
        if (this.privateDb == null) {
            throw new IllegalStateException();
        }
        return this.privateDb.getCurrentVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteMinimumVersion(String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                this.deleteUser = user;
                this.versionedDb.deleteMinimumVersion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void deleteCurrentVersion(String user) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                this.deleteUser = user;
                this.versionedDb.deleteCurrentVersion();
            }
        }
    }

    public LocalManagedBufferFile open(int version, int minChangeDataVer) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                return this.versionedDb.openBufferFile(version, minChangeDataVer);
            }
            if (version == -1) {
                return this.privateDb.openBufferFile();
            }
            throw new IllegalArgumentException("only LATEST_VERSION may be opened");
        }
    }

    public LocalManagedBufferFile open(int version) throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                return this.versionedDb.openBufferFile(version, -1);
            }
            if (version == -1) {
                return this.privateDb.openBufferFile();
            }
            throw new IllegalArgumentException("only LATEST_VERSION may be opened");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalManagedBufferFile open() throws IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                return this.versionedDb.openBufferFile(-1, -1);
            }
            return this.privateDb.openBufferFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LocalManagedBufferFile openForUpdate(long checkoutId) throws IOException {
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            LocalManagedBufferFile localManagedBufferFile;
            block8: {
                if (!this.isVersioned) return this.privateDb.openBufferFileForUpdate();
                this.beginCheckin(checkoutId);
                boolean success = false;
                try {
                    LocalManagedBufferFile bfile = this.versionedDb.openBufferFileForUpdate(checkoutId);
                    success = true;
                    localManagedBufferFile = bfile;
                    if (success) break block8;
                }
                catch (Throwable throwable) {
                    if (success) throw throwable;
                    this.endCheckin(checkoutId);
                    throw throwable;
                }
                this.endCheckin(checkoutId);
            }
            return localManagedBufferFile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canRecover() {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            return this.privateDb != null && this.privateDb.canRecover();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void output(File outputFile, int version, TaskMonitor monitor) throws CancelledException, IOException {
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            if (this.isVersioned) {
                this.versionedDb.output(version, outputFile, this.getName(), 0, this.getContentType(), monitor);
            } else {
                this.privateDb.output(outputFile, this.getName(), 0, this.getContentType(), monitor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCheckout(FolderItem versionedFolderItem, boolean updateItem, TaskMonitor monitor) throws IOException, CancelledException {
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            long checkoutId = this.getCheckoutId();
            boolean exclusive = this.isCheckedOutExclusive();
            if (this.isVersioned || checkoutId == -1L) {
                throw new IOException(this.getName() + " is not checked-out");
            }
            DatabaseItem verDbItem = (DatabaseItem)versionedFolderItem;
            int ver = verDbItem.getCurrentVersion();
            if (updateItem) {
                ManagedBufferFile verBf = verDbItem.open(ver);
                try {
                    this.privateDb.updateCheckoutCopy(verBf, this.getCheckoutVersion(), monitor);
                }
                finally {
                    try {
                        verBf.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            this.privateDb.updateCheckoutCopy();
            this.setCheckout(checkoutId, exclusive, ver, this.getCurrentVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCheckout(FolderItem item, int checkoutVersion) throws IOException {
        if (this.fileSystem.isReadOnly()) {
            throw new ReadOnlyException();
        }
        LocalFileSystem localFileSystem = this.fileSystem;
        synchronized (localFileSystem) {
            long checkoutId = this.getCheckoutId();
            if (this.isVersioned || checkoutId == -1L) {
                throw new IOException(this.getName() + " is not checked-out");
            }
            if (!(item instanceof LocalDatabaseItem)) {
                throw new IllegalArgumentException("Expected local database item");
            }
            LocalDatabaseItem dbItem = (LocalDatabaseItem)item;
            if (this.fileSystem != dbItem.fileSystem) {
                throw new IllegalArgumentException("Items must be from same file system");
            }
            try {
                this.privateDb.updateCheckoutFrom(dbItem.privateDb);
                this.setCheckout(checkoutId, this.isCheckedOutExclusive(), checkoutVersion, this.getLocalCheckoutVersion());
            }
            finally {
                item.delete(-1, null);
            }
        }
    }

    @Override
    public long lastModified() {
        if (this.privateDb != null) {
            return this.privateDb.lastModified();
        }
        return this.versionedDb.lastModified();
    }

    @Override
    public LocalFolderItem refresh() throws IOException {
        if (super.refresh() == null) {
            return null;
        }
        if (this.isVersioned) {
            this.versionedDb.refresh();
        } else {
            this.privateDb.refresh();
            this.privateDb.setIsCheckoutCopy(this.isCheckedOut());
        }
        return this;
    }

    static void cleanupOldPresaveFiles(File root) {
        Thread t = new Thread((Runnable)new CleanupRunnable(root), "Database-Item-Cleanup");
        t.start();
    }

    private static class CleanupRunnable
    implements Runnable {
        private File root;

        CleanupRunnable(File root) {
            this.root = root;
        }

        @Override
        public void run() {
            try {
                File f = File.createTempFile("tmp", ".tmp", this.root);
                long now = f.lastModified();
                f.delete();
                this.cleanupDir(this.root, now);
            }
            catch (IOException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        }

        private void cleanupDir(File dir, long beforeNow) {
            File[] files = dir.listFiles();
            if (files != null) {
                for (File f : files) {
                    if (!f.isDirectory()) continue;
                    String fname = f.getName();
                    if (!LocalFileSystem.isHiddenDirName(fname)) {
                        this.cleanupDir(f, beforeNow);
                        continue;
                    }
                    if (!fname.endsWith(".db")) continue;
                    LocalBufferFile.cleanupOldPreSaveFiles((File)f, (long)beforeNow);
                }
            }
        }
    }

    private class LocalVersionedDbListener
    implements VersionedDBListener {
        private LocalVersionedDbListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void versionsChanged(int minVersion, int currentVersion) {
            LocalFileSystem localFileSystem = LocalDatabaseItem.this.fileSystem;
            synchronized (localFileSystem) {
                if (minVersion != 0 || currentVersion == 0) {
                    // empty if block
                }
                try {
                    if (LocalDatabaseItem.this.historyMgr.fixHistory(minVersion, currentVersion)) {
                        LocalDatabaseItem.this.fireItemChanged();
                    }
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Failed to update version history: " + LocalDatabaseItem.this.getPathName()), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean versionCreated(VersionedDatabase database, int version, long time, String comment, long dbCheckinId) {
            LocalFileSystem localFileSystem = LocalDatabaseItem.this.fileSystem;
            synchronized (localFileSystem) {
                try {
                    ItemCheckoutStatus coStatus = LocalDatabaseItem.this.checkoutMgr.getCheckout(dbCheckinId);
                    if (coStatus == null || LocalDatabaseItem.this.checkinId != dbCheckinId) {
                        LocalDatabaseItem.this.log("ERROR! version " + version + " created without valid checkin", null);
                        return false;
                    }
                    if (version == 1 && LocalDatabaseItem.this.versionedDb == null) {
                        LocalDatabaseItem.this.versionedDb = database;
                        LocalDatabaseItem.this.versionedDb.setSynchronizationObject(LocalDatabaseItem.this.fileSystem);
                    }
                    String user = coStatus.getUser();
                    LocalDatabaseItem.this.historyMgr.versionAdded(version, time, comment, user);
                    LocalDatabaseItem.this.checkoutMgr.updateCheckout(dbCheckinId, version);
                }
                catch (IOException e) {
                    Msg.error((Object)(LocalDatabaseItem.this.getName() + " versioning error"), (Object)e);
                }
            }
            if (version == 1) {
                LocalDatabaseItem.this.fireItemCreated();
            } else {
                LocalDatabaseItem.this.fireItemChanged();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void versionDeleted(int version) {
            LocalFileSystem localFileSystem = LocalDatabaseItem.this.fileSystem;
            synchronized (localFileSystem) {
                try {
                    LocalDatabaseItem.this.historyMgr.versionDeleted(version, LocalDatabaseItem.this.deleteUser);
                }
                catch (IOException e) {
                    Msg.error((Object)this, (Object)("Failed to update version history: " + LocalDatabaseItem.this.getPathName()), (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getCheckoutVersion(long checkoutId) throws IOException {
            LocalFileSystem localFileSystem = LocalDatabaseItem.this.fileSystem;
            synchronized (localFileSystem) {
                ItemCheckoutStatus coStatus = LocalDatabaseItem.this.checkoutMgr.getCheckout(checkoutId);
                return coStatus != null ? coStatus.getCheckoutVersion() : -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkinCompleted(long dbCheckinId) {
            LocalFileSystem localFileSystem = LocalDatabaseItem.this.fileSystem;
            synchronized (localFileSystem) {
                if (LocalDatabaseItem.this.isVersioned) {
                    LocalDatabaseItem.this.endCheckin(dbCheckinId);
                }
                if (LocalDatabaseItem.this.versionedDb == null || LocalDatabaseItem.this.versionedDb.getCurrentVersion() == 0) {
                    try {
                        if (LocalDatabaseItem.this.isVersioned) {
                            LocalDatabaseItem.this.checkoutMgr.endCheckout(dbCheckinId);
                        }
                        LocalDatabaseItem.this.deleteContent(null);
                        LocalDatabaseItem.this.fileSystem.itemDeleted(LocalDatabaseItem.this.getParentPath(), LocalDatabaseItem.this.getName());
                        LocalDatabaseItem.this.fileSystem.deleteEmptyVersionedFolders(LocalDatabaseItem.this.getParentPath());
                    }
                    catch (IOException e) {
                        Msg.error((Object)this, (Object)(LocalDatabaseItem.this.getName() + " versioning error"), (Throwable)e);
                    }
                }
            }
        }
    }
}

