/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import docking.DockingWindowManager;
import docking.ToolTipManager;
import docking.framework.SplashScreen;
import ghidra.GhidraApplicationLayout;
import ghidra.GhidraLaunchable;
import ghidra.GhidraThreadGroup;
import ghidra.StatusReportingTaskMonitor;
import ghidra.base.help.GhidraHelpService;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.GhidraApplicationConfiguration;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.data.DomainObjectAdapter;
import ghidra.framework.main.FrontEndTool;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.model.ProjectManager;
import ghidra.framework.plugintool.dialog.ExtensionUtils;
import ghidra.framework.project.DefaultProjectManager;
import ghidra.framework.remote.InetNameLookup;
import ghidra.framework.store.LockException;
import ghidra.program.database.ProgramDB;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.UsrException;
import ghidra.util.task.InvokeInSwingTask;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import utility.application.ApplicationLayout;

public class GhidraRun
implements GhidraLaunchable {
    private final String MASTER_HELP_SET_HS = "Base_HelpSet.hs";
    private Logger log;

    public void launch(GhidraApplicationLayout layout, String[] args) {
        Runnable mainTask = () -> {
            GhidraApplicationConfiguration configuration = new GhidraApplicationConfiguration();
            configuration.setTaskMonitor((TaskMonitor)new StatusReportingTaskMonitor());
            Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)configuration);
            this.log = LogManager.getLogger(GhidraRun.class);
            this.log.info("User " + SystemUtilities.getUserName() + " started Ghidra.");
            this.initializeTooltips();
            this.updateSplashScreenStatusMessage("Populating Ghidra help...");
            GhidraHelpService.install();
            DockingWindowManager.enableDiagnosticActions((boolean)SystemUtilities.isInDevelopmentMode());
            ExtensionUtils.cleanupUninstalledExtensions();
            DomainObjectAdapter.setDefaultContentClass(ProgramDB.class);
            this.updateSplashScreenStatusMessage("Checking for previous project...");
            SystemUtilities.runSwingLater(() -> {
                String projectPath = this.processArguments(args);
                this.openProject(projectPath);
            });
        };
        InetNameLookup.setDisableOnFailure((boolean)true);
        Thread mainThread = new Thread(new GhidraThreadGroup(), mainTask, "Ghidra");
        mainThread.start();
    }

    private String processArguments(String[] args) {
        if (args.length == 1 && (args[0].startsWith("-D") || args[0].indexOf(" -D") >= 0)) {
            args = args[0].split(" ");
        }
        String projectPath = null;
        for (String arg : args) {
            if (arg.startsWith("-D")) {
                String[] split = arg.substring(2).split("=");
                if (split.length != 2) continue;
                System.setProperty(split[0], split[1]);
                continue;
            }
            projectPath = arg;
        }
        return projectPath;
    }

    private void updateSplashScreenStatusMessage(String message) {
        SystemUtilities.runSwingNow(() -> SplashScreen.updateSplashScreenStatus((String)message));
    }

    private void initializeTooltips() {
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        int currentDelay = toolTipManager.getDismissDelay();
        toolTipManager.setDismissDelay(currentDelay * 2);
    }

    private void openProject(String projectPath) {
        this.updateSplashScreenStatusMessage("Creating project manager...");
        GhidraProjectManager pm = new GhidraProjectManager();
        this.updateSplashScreenStatusMessage("Creating front end tool...");
        FrontEndTool tool = new FrontEndTool((ProjectManager)pm);
        boolean reopen = true;
        ProjectLocator projectLocator = null;
        if (projectPath != null) {
            File projectFile = new File(projectPath);
            String name = projectFile.getName();
            if (!name.endsWith(ProjectLocator.getProjectExtension())) {
                Msg.showInfo(GhidraRun.class, null, (String)"Invalid Project", (Object)("The specified file is not a project file: " + projectPath));
            } else {
                projectLocator = new ProjectLocator(projectFile.getParent(), name);
                reopen = false;
            }
        }
        if (projectLocator == null) {
            this.updateSplashScreenStatusMessage("Checking for last opened project...");
            projectLocator = pm.getLastOpenedProject();
        }
        if (Application.isTestBuild()) {
            Msg.showWarn(GhidraRun.class, (Component)tool.getToolFrame(), (String)"Unsupported Ghidra Distribution", (Object)"WARNING! Please be aware that this is an unsupported and uncertified\nbuild of Ghidra!  This software may be unstable and data created\nmay be incompatible with future releases.");
        }
        tool.setVisible(true);
        if (projectLocator != null) {
            this.openProject(tool, projectLocator, reopen);
        }
    }

    private void openProject(FrontEndTool tool, ProjectLocator projectLocator, boolean reopen) {
        SplashScreen.updateSplashScreenStatus((String)((reopen ? "Reopening" : "Opening") + " project: " + projectLocator.getName()));
        Runnable r = () -> this.doOpenProject(tool, projectLocator, reopen);
        InvokeInSwingTask task = new InvokeInSwingTask("Opening Project", r);
        new TaskLauncher((Task)task, (Component)tool.getToolFrame(), 0);
    }

    private void doOpenProject(FrontEndTool tool, ProjectLocator projectLocator, boolean reopen) {
        try {
            ProjectManager pm = tool.getProjectManager();
            Project activeProject = pm.openProject(projectLocator, true, false);
            if (activeProject == null) {
                return;
            }
            tool.setActiveProject(activeProject);
            RepositoryAdapter repository = activeProject.getRepository();
            if (repository != null && !repository.isConnected()) {
                Msg.showInfo(GhidraRun.class, null, (String)"Working Off-Line ", (Object)"Even though you are not connected to the Ghidra Server,\nyou can still work off-line on checked out files or private files.\nYou can also try reconnecting to the server by selecting the connect\nbutton on the Ghidra Project Window.\n \nSee the Ghidra Help topic 'Project Repository' for troubleshooting\na failed connection.");
            }
        }
        catch (Throwable t) {
            if (t instanceof UsrException) {
                if (t instanceof LockException) {
                    Msg.showInfo(GhidraRun.class, null, (String)"Project is Locked", (Object)("Can't open project: " + projectLocator.toString() + "\nProject is already locked"));
                } else {
                    Msg.showInfo(GhidraRun.class, null, (String)"Project Open Failed", (Object)("Failed to " + (reopen ? "reopen last" : "open") + " project: " + projectLocator.toString() + "\n\n" + t.getClass().getSimpleName() + ": " + t.getMessage()));
                }
            } else {
                Msg.showError(GhidraRun.class, null, (String)"Project Open Failed", (Object)("Failed to " + (reopen ? "reopen last" : "open") + " project: " + projectLocator.toString() + "\n\n" + t.getClass().getSimpleName() + ": " + t.getMessage()), (Throwable)t);
            }
            tool.setActiveProject(null);
        }
    }

    private class GhidraProjectManager
    extends DefaultProjectManager {
        private GhidraProjectManager() {
        }
    }
}

