/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.actions;

import docking.ActionContext;
import docking.DockingUtils;
import ghidra.app.actions.AbstractSharedKeybindingAction;
import ghidra.app.plugin.core.navigation.FindAppliedDataTypesService;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import javax.swing.KeyStroke;

public abstract class AbstractFindReferencesDataTypeAction
extends AbstractSharedKeybindingAction {
    public static final String NAME = "Find References To";
    public static final KeyStroke DEFAULT_KEY_STROKE = KeyStroke.getKeyStroke(70, DockingUtils.CONTROL_KEY_MODIFIER_MASK | 0x40);

    protected AbstractFindReferencesDataTypeAction(PluginTool tool, String name, String owner) {
        this(tool, name, owner, null);
    }

    protected AbstractFindReferencesDataTypeAction(PluginTool tool, String name, String owner, KeyStroke defaultKeyStroke) {
        super(tool, name, owner, defaultKeyStroke);
        this.setHelpLocation(new HelpLocation("LocationReferencesPlugin", "Data_Types"));
        this.setDescription("Shows all uses of the selected data type");
    }

    protected abstract DataType getDataType(ActionContext var1);

    protected String getDataTypeField() {
        return null;
    }

    public boolean isEnabledForContext(ActionContext context) {
        DataType dataType = this.getDataType(context);
        return dataType != null;
    }

    public void actionPerformed(ActionContext context) {
        FindAppliedDataTypesService service = (FindAppliedDataTypesService)this.tool.getService(FindAppliedDataTypesService.class);
        if (service == null) {
            Msg.showError((Object)((Object)this), null, (String)"Missing Plugin", (Object)"The FindAppliedDataTypesService is not installed.\nPlease add the plugin implementing this service.");
            return;
        }
        DataType dataType = this.getDataType(context);
        DataType baseDataType = ReferenceUtils.getBaseDataType(dataType);
        String field = this.getDataTypeField();
        if (field != null && !(baseDataType instanceof Composite)) {
            Msg.error((Object)((Object)this), (Object)("Somehow have a field without a Composite parent--searching only for the parent type '" + dataType + "'; field '" + field + "'"));
            SystemUtilities.runSwingLater(() -> service.findAndDisplayAppliedDataTypeAddresses(dataType));
            return;
        }
        if (field == null) {
            SystemUtilities.runSwingLater(() -> service.findAndDisplayAppliedDataTypeAddresses(dataType));
        } else {
            SystemUtilities.runSwingLater(() -> service.findAndDisplayAppliedDataTypeAddresses((Composite)baseDataType, field));
        }
    }
}

