/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.formats;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.macos.MacException;
import ghidra.app.util.bin.format.macos.asd.AppleSingleDouble;
import ghidra.app.util.bin.format.macos.asd.EntryDescriptor;
import ghidra.app.util.bin.format.macos.asd.EntryDescriptorID;
import ghidra.app.util.bin.format.macos.cfm.CFragResource;
import ghidra.app.util.bin.format.macos.cfm.CFragResourceMember;
import ghidra.app.util.bin.format.macos.rm.ReferenceListEntry;
import ghidra.app.util.bin.format.macos.rm.ResourceHeader;
import ghidra.app.util.bin.format.macos.rm.ResourceMap;
import ghidra.app.util.bin.format.macos.rm.ResourceType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.cmd.BinaryAnalysisCommand;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.mem.Memory;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.List;

public class AppleSingleDoubleBinaryAnalysisCommand
extends FlatProgramAPI
implements BinaryAnalysisCommand,
AnalysisWorker {
    private MessageLog messages = new MessageLog();

    @Override
    public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor monitor) throws CancelledException, Exception {
        try {
            MemoryByteProvider provider = new MemoryByteProvider(this.currentProgram.getMemory(), this.currentProgram.getAddressFactory().getDefaultAddressSpace());
            AppleSingleDouble header = new AppleSingleDouble(provider);
            Address address = this.toAddr(0);
            DataType headerDT = header.toDataType();
            this.createData(address, headerDT);
            this.setPlateComment(address, headerDT.getName());
            this.createFragment(headerDT.getName(), address, headerDT.getLength());
            address = address.add((long)headerDT.getLength());
            List<EntryDescriptor> entryList = header.getEntryList();
            for (EntryDescriptor descriptor : entryList) {
                if (monitor.isCancelled()) break;
                DataType descriptorDT = descriptor.toDataType();
                this.createData(address, descriptorDT);
                this.setPlateComment(address, descriptorDT.getName());
                this.createFragment(descriptorDT.getName(), address, descriptorDT.getLength());
                address = address.add((long)descriptorDT.getLength());
                String name = EntryDescriptorID.convertEntryIdToName(descriptor.getEntryID());
                this.createFragment(name, this.toAddr(descriptor.getOffset()), descriptor.getLength());
                Object entryObject = descriptor.getEntry();
                if (descriptor.getEntryID() != 2) continue;
                this.markup((ResourceHeader)entryObject, descriptor);
            }
            this.removeEmptyFragments();
            return true;
        }
        catch (MacException e) {
            this.messages.appendMsg("Not a binary AppleSingleDouble program: AppleSingleDouble header not found.");
            return false;
        }
    }

    @Override
    public String getWorkerName() {
        return this.getName();
    }

    @Override
    public boolean applyTo(Program program, TaskMonitor monitor) throws Exception {
        this.set(program, monitor);
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager(this.currentProgram);
        return manager.scheduleWorker(this, null, false, monitor);
    }

    @Override
    public boolean canApply(Program program) {
        try {
            Memory memory = program.getMemory();
            int magicNumber = memory.getInt(program.getAddressFactory().getDefaultAddressSpace().getAddress(0L));
            if (magicNumber == 333312 || magicNumber == 333319) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public MessageLog getMessages() {
        return this.messages;
    }

    @Override
    public String getName() {
        return "Apple Single/Double Header Annotation";
    }

    private void markup(ResourceHeader header, EntryDescriptor descriptor) throws Exception {
        DataType headerDT = header.toDataType();
        Address address = this.toAddr(descriptor.getOffset());
        this.createData(address, headerDT);
        this.setPlateComment(address, headerDT.getName());
        this.createFragment(headerDT.getName(), address, headerDT.getLength());
        Address resourceDataAddress = this.toAddr(header.getResourceDataOffset() + descriptor.getOffset());
        this.markupResourceData(resourceDataAddress, header.getResourceDataLength());
        ResourceMap map = header.getMap();
        Address mapAddress = this.markupResourceMap(header, descriptor, map);
        ProgramModule typeModule = this.createModule("ResourceType");
        Address typeAddress = mapAddress.add((long)(map.getResourceTypeListOffset() + 2));
        List<ResourceType> types = map.getResourceTypeList();
        for (ResourceType type : types) {
            if (this.monitor.isCancelled()) {
                return;
            }
            int length = this.markupResourceType(type, typeAddress, typeModule);
            typeAddress = typeAddress.add((long)length);
            this.markupReferenceListEntry(map, mapAddress, type, resourceDataAddress);
            this.markupCFM(type, resourceDataAddress);
        }
        this.markupResourceNameList(map, mapAddress);
    }

    private void markupCFM(ResourceType type, Address resourceDataAddress) throws Exception {
        if (type.getType() != 1667658343) {
            return;
        }
        List<ReferenceListEntry> entries = type.getReferenceList();
        if (entries.size() != 1) {
            throw new AssertException();
        }
        int dataOffset = entries.get(0).getDataOffset();
        Address address = resourceDataAddress.add((long)(dataOffset + 4));
        CFragResource cFragResource = (CFragResource)type.getResourceObject();
        DataType dt = cFragResource.toDataType();
        this.createData(address, dt);
        this.setPlateComment(address, dt.getName());
        this.createFragment(dt.getName(), address, dt.getLength());
        address = address.add((long)dt.getLength());
        List<CFragResourceMember> members = cFragResource.getMembers();
        for (CFragResourceMember member : members) {
            DataType memberDT = member.toDataType();
            this.createData(address, memberDT);
            String comment = "Name:   " + member.getName() + "\nOffset: 0x" + Integer.toHexString(member.getOffset()) + "\nLength: 0x" + Integer.toHexString(member.getLength()) + "\n";
            this.setPlateComment(address, comment);
            this.createFragment(memberDT.getName(), address, member.getMemberSize());
            address = address.add((long)member.getMemberSize());
        }
    }

    private Address markupResourceMap(ResourceHeader header, EntryDescriptor descriptor, ResourceMap map) throws DuplicateNameException, IOException, Exception {
        Address address = this.toAddr(descriptor.getOffset() + header.getResourceMapOffset());
        DataType mapDT = map.toDataType();
        this.createData(address, mapDT);
        this.setPlateComment(address, mapDT.getName());
        this.createFragment(mapDT.getName(), address, mapDT.getLength());
        return address;
    }

    private void markupReferenceListEntry(ResourceMap map, Address mapAddress, ResourceType type, Address resourceDataAddress) throws DuplicateNameException, IOException, Exception {
        ProgramModule module = this.createModule("ResourceListEntry");
        int id = 0;
        Address entryAddress = mapAddress.add((long)(map.getResourceTypeListOffset() + type.getOffsetToReferenceList()));
        List<ReferenceListEntry> reference = type.getReferenceList();
        for (ReferenceListEntry entry : reference) {
            if (this.monitor.isCancelled()) {
                return;
            }
            DataType entryDT = entry.toDataType();
            this.createData(entryAddress, entryDT);
            this.createFragment(module, type.getTypeAsString() + this.hack(), entryAddress, entryDT.getLength());
            String name = "" + id++;
            if (entry.getName() != null) {
                name = name + " - " + entry.getName();
            }
            this.setPlateComment(entryAddress, name);
            entryAddress = entryAddress.add((long)entryDT.getLength());
            Address dataAddress = resourceDataAddress.add((long)entry.getDataOffset());
            this.setPlateComment(dataAddress, type.getTypeAsString() + " - " + entry.getName());
        }
    }

    private String hack() {
        return " ";
    }

    private int markupResourceType(ResourceType type, Address typeAddress, ProgramModule typeModule) throws Exception {
        DataType typeDT = type.toDataType();
        this.createData(typeAddress, typeDT);
        this.setPlateComment(typeAddress, typeDT.getName() + " - " + type.getTypeAsString());
        this.createFragment(typeModule, type.getTypeAsString(), typeAddress, typeDT.getLength());
        return typeDT.getLength();
    }

    private void markupResourceNameList(ResourceMap map, Address mapAddress) throws Exception {
        Address nameAddress = mapAddress.add((long)map.getResourceNameListOffset());
        while (nameAddress.compareTo((Object)this.currentProgram.getMaxAddress()) < 0) {
            if (this.monitor.isCancelled()) {
                return;
            }
            this.createData(nameAddress, (DataType)new PascalString255DataType());
            Data data = this.getDataAt(nameAddress);
            this.createFragment("ResourceNameList", nameAddress, data.getLength());
            nameAddress = nameAddress.add((long)data.getLength());
        }
    }

    private void markupResourceData(Address address, int resourceDataLength) throws Exception {
        ProgramModule module = this.createModule("ResourceData");
        int size = 0;
        int id = 0;
        while (size < resourceDataLength) {
            if (this.monitor.isCancelled()) {
                return;
            }
            this.createData(address, (DataType)new DWordDataType());
            this.setEOLComment(address, "Data Length");
            int length = this.getInt(address);
            this.createFragment(module, "" + id++, address, length + 4);
            size += length + 4;
            address = address.add((long)(length + 4));
        }
    }

    private ProgramModule createModule(String moduleName) throws Exception {
        ProgramModule module = this.currentProgram.getListing().getDefaultRootModule();
        try {
            return module.createModule(moduleName);
        }
        catch (DuplicateNameException e) {
            return (ProgramModule)this.findGroup(module, moduleName);
        }
    }

    private Group findGroup(ProgramModule module, String groupName) {
        Group[] groups;
        for (Group group : groups = module.getChildren()) {
            if (this.monitor.isCancelled()) {
                return null;
            }
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    private void removeEmptyFragments() throws NotEmptyException {
        String[] treeNames;
        this.monitor.setMessage("Removing empty fragments...");
        block0: for (String treeName : treeNames = this.currentProgram.getListing().getTreeNames()) {
            Group[] children;
            if (this.monitor.isCancelled()) break;
            ProgramModule rootModule = this.currentProgram.getListing().getRootModule(treeName);
            for (Group child : children = rootModule.getChildren()) {
                ProgramFragment fragment;
                if (this.monitor.isCancelled()) continue block0;
                if (!(child instanceof ProgramFragment) || !(fragment = (ProgramFragment)child).isEmpty()) continue;
                rootModule.removeChild(fragment.getName());
            }
        }
    }
}

