/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import docking.widgets.EmptyBorderButton;
import docking.widgets.fieldpanel.FieldPanel;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import ghidra.app.merge.MergeManager;
import ghidra.app.merge.util.ConflictCountPanel;
import ghidra.app.plugin.core.codebrowser.hover.DataTypeListingHover;
import ghidra.app.plugin.core.codebrowser.hover.FunctionNameListingHover;
import ghidra.app.plugin.core.codebrowser.hover.ReferenceListingHover;
import ghidra.app.plugin.core.codebrowser.hover.TruncatedTextListingHover;
import ghidra.app.services.CodeFormatService;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.app.util.viewer.listingpanel.EmptyListingModel;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.app.util.viewer.multilisting.AddressTranslator;
import ghidra.app.util.viewer.multilisting.MultiListingLayoutModel;
import ghidra.app.util.viewer.util.TitledPanel;
import ghidra.framework.data.DomainObjectMergeManager;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSplitPane;
import resources.ResourceManager;
import resources.icons.EmptyIcon;

class ExternalAddConflictPanel
extends JPanel
implements CodeFormatService {
    public static final String KEEP_LATEST_BUTTON_NAME = "LatestVersionRB";
    public static final String KEEP_MY_BUTTON_NAME = "CheckedOutVersionRB";
    public static final String KEEP_BOTH_BUTTON_NAME = "KeepBothVersionsRB";
    public static final String MERGE_BOTH_BUTTON_NAME = "MergeBothVersionsRB";
    private static Icon hideIcon = ResourceManager.loadImage((String)"images/collapse.gif");
    private static Icon showIcon = ResourceManager.loadImage((String)"images/expand.gif");
    private DomainObjectMergeManager mergeManager;
    private int totalConflicts;
    private ConflictCountPanel countPanel;
    private TitledPanel latestTitlePanel;
    private TitledPanel myTitlePanel;
    private ListingPanel latestPanel;
    private ListingPanel myPanel;
    private JRadioButton keepLatestRB;
    private JRadioButton keepMyRB;
    private JRadioButton keepBothRB;
    private JRadioButton mergeBothRB;
    private ButtonGroup buttonGroup;
    private JComponent bottomComp;
    private Program latestProgram;
    private Program myProgram;
    private PluginTool tool;
    private FormatManager formatMgr;
    private MultiListingLayoutModel multiModel;
    private ReferenceListingHover referenceHoverService;
    private DataTypeListingHover dataTypeHoverService;
    private TruncatedTextListingHover truncatedTextHoverService;
    private FunctionNameListingHover functionNameHoverService;
    private boolean showListingPanel;

    ExternalAddConflictPanel(MergeManager mergeManager, int totalConflicts, Program latestProgram, Program myProgram, boolean showListingPanel) {
        this.tool = mergeManager.getMergeTool();
        this.mergeManager = mergeManager;
        this.totalConflicts = totalConflicts;
        this.latestProgram = latestProgram;
        this.myProgram = myProgram;
        this.showListingPanel = showListingPanel;
        this.create();
        this.initializeListingHoverService();
    }

    private void initializeListingHoverService() {
        this.referenceHoverService = new ReferenceListingHover(this.tool, this);
        this.dataTypeHoverService = new DataTypeListingHover(this.tool);
        this.truncatedTextHoverService = new TruncatedTextListingHover(this.tool);
        this.functionNameHoverService = new FunctionNameListingHover(this.tool);
        this.initializeListingHoverService(this.latestPanel);
        this.initializeListingHoverService(this.myPanel);
    }

    private void initializeListingHoverService(ListingPanel listingPanel) {
        listingPanel.addHoverService(this.referenceHoverService);
        listingPanel.addHoverService(this.dataTypeHoverService);
        listingPanel.addHoverService(this.truncatedTextHoverService);
        listingPanel.addHoverService(this.functionNameHoverService);
        listingPanel.setHoverMode(true);
    }

    void setConflictInfo(int conflictIndex, ExternalLocation latestLocation, ExternalLocation myLocation) {
        this.mergeManager.setApplyEnabled(false);
        this.countPanel.updateCount(conflictIndex, this.totalConflicts);
        Address latestAddress = latestLocation.getExternalSpaceAddress();
        Address myAddress = myLocation.getExternalSpaceAddress();
        AddressSet latestSet = new AddressSet(latestAddress, latestAddress);
        AddressSet mySet = new AddressSet(myAddress, myAddress);
        this.latestPanel.setView((AddressSetView)latestSet);
        this.myPanel.setView((AddressSetView)mySet);
        this.buttonGroup.remove(this.keepLatestRB);
        this.buttonGroup.remove(this.keepMyRB);
        this.buttonGroup.remove(this.keepBothRB);
        this.buttonGroup.remove(this.mergeBothRB);
        this.keepLatestRB.setSelected(false);
        this.keepMyRB.setSelected(false);
        this.keepBothRB.setSelected(false);
        this.mergeBothRB.setSelected(false);
        this.buttonGroup.add(this.keepLatestRB);
        this.buttonGroup.add(this.keepMyRB);
        this.buttonGroup.add(this.keepBothRB);
        this.buttonGroup.add(this.mergeBothRB);
    }

    int getSelectedOption() {
        if (this.keepLatestRB.isSelected()) {
            return 1;
        }
        if (this.keepMyRB.isSelected()) {
            return 2;
        }
        if (this.keepBothRB.isSelected()) {
            return 4;
        }
        if (this.mergeBothRB.isSelected()) {
            return 8;
        }
        return 0;
    }

    private ToolOptions getFieldOptions() {
        ToolOptions fieldOptions = new ToolOptions("field");
        fieldOptions.setBoolean("Register Field.Display Hidden Registers", true);
        return fieldOptions;
    }

    private ToolOptions getDisplayOptions() {
        return new ToolOptions("display");
    }

    private void create() {
        this.formatMgr = new FormatManager(this.getDisplayOptions(), this.getFieldOptions());
        this.multiModel = new MultiListingLayoutModel(this.formatMgr, new Program[]{this.latestProgram, this.myProgram}, (AddressSetView)this.latestProgram.getMemory());
        this.latestPanel = new ListingPanel(this.formatMgr, new EmptyListingModel()){

            @Override
            protected ListingModel createListingModel(Program program) {
                if (program == null) {
                    return null;
                }
                if (ExternalAddConflictPanel.this.showListingPanel) {
                    return ExternalAddConflictPanel.this.multiModel.getAlignedModel(0);
                }
                return new EmptyListingModel();
            }
        };
        this.myPanel = new ListingPanel(this.formatMgr, new EmptyListingModel()){

            @Override
            protected ListingModel createListingModel(Program program) {
                if (program == null) {
                    return null;
                }
                if (ExternalAddConflictPanel.this.showListingPanel) {
                    return ExternalAddConflictPanel.this.multiModel.getAlignedModel(1);
                }
                return new EmptyListingModel();
            }
        };
        this.latestPanel.setProgram(this.latestProgram);
        this.myPanel.setProgram(this.myProgram);
        new FieldPanelCoordinator(new FieldPanel[]{this.latestPanel.getFieldPanel(), this.myPanel.getFieldPanel()});
        this.buttonGroup = new ButtonGroup();
        ItemListener listener = e -> {
            if (e.getStateChange() == 1) {
                this.mergeManager.clearStatusText();
                this.mergeManager.setApplyEnabled(true);
            }
        };
        this.keepLatestRB = new JRadioButton("Latest");
        this.keepLatestRB.setName(KEEP_LATEST_BUTTON_NAME);
        this.keepLatestRB.addItemListener(listener);
        this.keepMyRB = new JRadioButton("Checked Out");
        this.keepMyRB.setName(KEEP_MY_BUTTON_NAME);
        this.keepMyRB.addItemListener(listener);
        this.keepBothRB = new JRadioButton("Both");
        this.keepBothRB.setName(KEEP_BOTH_BUTTON_NAME);
        this.keepBothRB.addItemListener(listener);
        this.mergeBothRB = new JRadioButton("Merge");
        this.mergeBothRB.setName(MERGE_BOTH_BUTTON_NAME);
        this.mergeBothRB.addItemListener(listener);
        this.buttonGroup.add(this.keepLatestRB);
        this.buttonGroup.add(this.keepMyRB);
        this.buttonGroup.add(this.keepBothRB);
        this.buttonGroup.add(this.mergeBothRB);
        this.setLayout(new BoxLayout(this, 1));
        this.countPanel = new ConflictCountPanel();
        JPanel centerPanel = new JPanel(new BorderLayout());
        this.latestTitlePanel = new TitledPanel("Latest", this.latestPanel, 5);
        this.myTitlePanel = new TitledPanel("Checked Out", this.myPanel, 5);
        this.latestTitlePanel.addTitleComponent((JComponent)((Object)new ShowHeaderButton()));
        this.myTitlePanel.addTitleComponent(new JLabel((Icon)new EmptyIcon(22, 22)));
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setResizeWeight(0.5);
        splitPane.setDividerSize(4);
        splitPane.setBorder(BorderFactory.createEmptyBorder());
        splitPane.setLeftComponent(this.latestTitlePanel);
        splitPane.setRightComponent(this.myTitlePanel);
        centerPanel.add((Component)splitPane, "Center");
        this.setLayout(new BorderLayout());
        this.add((Component)this.countPanel, "North");
        this.add((Component)centerPanel, "Center");
    }

    public void setBottomComponent(JComponent comp) {
        if (this.bottomComp == comp) {
            return;
        }
        if (this.bottomComp != null) {
            this.remove(this.bottomComp);
        }
        this.invalidate();
        this.repaint();
        this.bottomComp = comp;
        if (this.bottomComp != null) {
            this.add((Component)this.bottomComp, "South");
        }
        this.invalidate();
        this.repaint();
    }

    public void addDomainObjectListener() {
        DomainObjectListener listingModel = (DomainObjectListener)this.multiModel.getModel(0);
        this.latestProgram.addListener(listingModel);
    }

    public void removeDomainObjectListener() {
        DomainObjectListener listingModel = (DomainObjectListener)this.multiModel.getModel(0);
        this.latestProgram.removeListener(listingModel);
    }

    public void setAddressTranslator(AddressTranslator translator) {
        this.multiModel.setAddressTranslator(translator);
    }

    @Override
    public FormatManager getFormatManager() {
        return this.formatMgr;
    }

    class ShowHeaderButton
    extends EmptyBorderButton {
        ShowHeaderButton() {
            super(showIcon);
            this.setFocusable(false);
            this.setToolTipText("Toggle Format Header");
            this.addActionListener(e -> {
                if (this.isSelected()) {
                    this.setSelected(false);
                    this.setIcon(showIcon);
                    ExternalAddConflictPanel.this.latestPanel.showHeader(false);
                } else {
                    this.setSelected(true);
                    this.setIcon(hideIcon);
                    ExternalAddConflictPanel.this.latestPanel.showHeader(true);
                }
            });
        }
    }
}

