/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.listing;

import ghidra.app.merge.listing.AbstractListingMerger;
import ghidra.app.merge.listing.ListingMergeManager;
import ghidra.app.merge.listing.VerticalChoicesPanel;
import ghidra.app.merge.tool.ListingMergePanel;
import ghidra.app.merge.util.ConflictUtility;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.program.database.external.ExternalManagerDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CircularDependencyException;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.DiffUtility;
import ghidra.program.util.MultiAddressIterator;
import ghidra.program.util.ProgramConflictException;
import ghidra.program.util.ProgramMerge;
import ghidra.program.util.SimpleDiffUtility;
import ghidra.util.Msg;
import ghidra.util.datastruct.LongArrayList;
import ghidra.util.datastruct.LongLongHashtable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NoValueException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class SymbolMerger
extends AbstractListingMerger {
    static final String SYMBOLS_PHASE = "Symbols";
    private static final int REMOVE_CONFLICT = 1;
    private static final int RENAME_CONFLICT = 2;
    private static final int NAMESPACE_CONFLICT = 3;
    private static final int ADDRESS_CONFLICT = 4;
    private static final int PRIMARY_CONFLICT = 5;
    VerticalChoicesPanel conflictPanel;
    VerticalChoicesPanel emptyConflictPanel;
    Symbol currentSymbol;
    String currentSymbolName;
    Namespace currentNamespace;
    AddressSet currentBackgroundSet;
    String uniqueName;
    String currentSymbolComment;
    SymbolTable latestSymTab;
    SymbolTable mySymTab;
    SymbolTable originalSymTab;
    SymbolTable resultSymTab;
    AddressSetView latestDetailSet;
    AddressSetView myDetailSet;
    AddressSet addEntryPts;
    AddressSet removeEntryPts;
    long[] myAddIDs;
    long[] myChangeIDs;
    long[] myRemoveIDs;
    long[] myModifiedIDs;
    long[] myRenameIDs;
    long[] myPrimaryChangeIDs;
    long[] mySourceChangeIDs;
    long[] myAnchorChangeIDs;
    LongHashSet myPrimaryAddIDs;
    AddressSet mySetPrimary;
    long[] latestAddIDs;
    long[] latestChangeIDs;
    long[] latestRemoveIDs;
    long[] latestModifiedIDs;
    long[] latestRenameIDs;
    long[] latestPrimaryChangeIDs;
    long[] latestSourceChangeIDs;
    long[] latestAnchorChangeIDs;
    LongHashSet latestPrimaryAddIDs;
    AddressSet latestSetPrimary;
    LongLongHashtable externalTypeConflictHash;
    LongHashSet deferredRemoveIDs;
    LongHashSet renamedConflictIDs;
    Hashtable<Address, LongArrayList> removes;
    AddressSet removeConflicts;
    Hashtable<Address, LongArrayList> renames;
    AddressSet renameConflicts;
    Hashtable<Address, ArrayList<SymbolPath>> symbolAddressConflicts;
    AddressSet addressConflicts;
    Hashtable<Address, LongArrayList> addComments;
    AddressSet addCommentConflicts;
    AddressSet primaryConflicts;
    LongLongHashtable originalHash;
    LongLongHashtable latestHash;
    LongLongHashtable myHash;
    private int totalConflicts;
    private int conflictNum;
    private String DEFAULT_PROGRESS_MESSAGE = "Auto-merging Symbols and determining conflicts.";
    protected int addressSymbolChoice = 0;
    protected int primarySymbolChoice = 0;
    protected int removeSymbolChoice = 0;
    protected int renameSymbolChoice = 0;
    SymbolConflictType currentConflictType = null;

    SymbolMerger(ListingMergeManager listingMergeMgr) {
        super(listingMergeMgr);
    }

    @Override
    public void init() {
        super.init();
        this.latestSymTab = this.latestPgm.getSymbolTable();
        this.mySymTab = this.myPgm.getSymbolTable();
        this.originalSymTab = this.originalPgm.getSymbolTable();
        this.resultSymTab = this.resultPgm.getSymbolTable();
        this.removes = new Hashtable();
        this.removeConflicts = new AddressSet();
        this.renames = new Hashtable();
        this.renameConflicts = new AddressSet();
        this.symbolAddressConflicts = new Hashtable();
        this.addressConflicts = new AddressSet();
        this.addComments = new Hashtable();
        this.addCommentConflicts = new AddressSet();
        this.primaryConflicts = new AddressSet();
        this.mySetPrimary = new AddressSet();
        this.latestSetPrimary = new AddressSet();
        this.deferredRemoveIDs = new LongHashSet();
        this.renamedConflictIDs = new LongHashSet();
        this.addEntryPts = new AddressSet();
        this.removeEntryPts = new AddressSet();
        this.originalHash = new LongLongHashtable();
        this.latestHash = new LongLongHashtable();
        this.myHash = new LongLongHashtable();
        this.externalTypeConflictHash = new LongLongHashtable();
        this.setResolveInformation();
        this.emptyConflictPanel = new VerticalChoicesPanel();
        this.emptyConflictPanel.clear();
    }

    private void setResolveInformation() {
        if (this.mergeManager != null) {
            this.mergeManager.setResolveInformation("ResolvedLatestSymbols", this.latestHash);
            this.mergeManager.setResolveInformation("ResolvedMySymbols", this.myHash);
            this.mergeManager.setResolveInformation("ResolvedOriginalSymbols", this.originalHash);
        }
    }

    @Override
    public String getConflictType() {
        return "Symbol";
    }

    private long resolveSymbolID(Program pgm, long symbolID) {
        int pgmIndex = this.getProgramIndex(pgm);
        try {
            switch (pgmIndex) {
                case 1: {
                    return this.getResultIDFromLatestID(symbolID);
                }
                case 2: {
                    return this.getResultIDFromMyID(symbolID);
                }
                case 3: {
                    return this.getResultIDFromOriginalID(symbolID);
                }
                case 0: {
                    if (this.resultSymTab.getSymbol(symbolID) == null) break;
                    return symbolID;
                }
            }
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        return -1L;
    }

    Namespace resolveNamespace(Program srcProgram, Namespace srcNamespace) throws DuplicateNameException, InvalidInputException {
        Namespace srcGlobalNs = srcProgram.getGlobalNamespace();
        if (srcNamespace == null) {
            return null;
        }
        if (srcNamespace.equals(srcGlobalNs)) {
            return this.resultPgm.getGlobalNamespace();
        }
        Namespace resolvedNamespace = null;
        SymbolTable resolveSymTab = this.resultPgm.getSymbolTable();
        Symbol srcNsSymbol = srcNamespace.getSymbol();
        long srcNsID = srcNsSymbol.getID();
        long resolveNsID = this.resolveSymbolID(srcProgram, srcNsID);
        if (resolveNsID >= 0L) {
            Symbol resolveSym = resolveSymTab.getSymbol(resolveNsID);
            resolvedNamespace = (Namespace)resolveSym.getObject();
        } else {
            Namespace origParentNs = srcNamespace.getParentNamespace();
            Namespace resultParentNs = this.resolveNamespace(srcProgram, origParentNs);
            String name = srcNsSymbol.getName();
            SymbolType st = srcNsSymbol.getSymbolType();
            Address resultAddr = SimpleDiffUtility.getCompatibleAddress((Program)srcProgram, (Address)srcNsSymbol.getAddress(), (Program)this.resultPgm);
            resolvedNamespace = this.createNamespace(this.resultPgm, name, st, resultAddr, resultParentNs, srcProgram, srcNsSymbol.getID(), srcNsSymbol.getSource());
        }
        return resolvedNamespace;
    }

    private Namespace createNamespace(Program resultProgram, String name, SymbolType st, Address resultAddr, Namespace resultParentNs, Program srcPgm, long srcSymID, SourceType source) throws DuplicateNameException, InvalidInputException {
        SymbolTable symtab = resultProgram.getSymbolTable();
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            Object obj;
            Object uniqueSymbolName = i == 0 ? name : name + ProgramMerge.SYMBOL_CONFLICT_SUFFIX + i;
            Namespace ns = symtab.getNamespace((String)uniqueSymbolName, resultParentNs);
            if (ns != null) {
                Symbol s = ns.getSymbol();
                if (!s.getAddress().equals((Object)resultAddr) || !s.getSymbolType().equals((Object)st)) continue;
                return ns;
            }
            Symbol uniqueSymbol = this.createSymbol((String)uniqueSymbolName, st, resultAddr, resultParentNs, srcPgm, srcSymID, source);
            if (uniqueSymbol == null || !((obj = uniqueSymbol.getObject()) instanceof Namespace)) break;
            if (!((String)uniqueSymbolName).equals(name)) {
                this.renamedConflictIDs.add(uniqueSymbol.getID());
            }
            return (Namespace)obj;
        }
        throw new DuplicateNameException("Couldn't create namespace '" + name + "' in namespace '" + resultParentNs.getName(true) + "'.");
    }

    private void setupSymbolChanges(TaskMonitor monitor) throws CancelledException {
        long[] tempMyAddIDs = this.listingMergeMgr.myChanges.getSymbolAdditions();
        long[] tempMyChangeIDs = this.listingMergeMgr.myChanges.getSymbolChanges();
        long[] tempLatestAddIDs = this.listingMergeMgr.latestChanges.getSymbolAdditions();
        long[] tempLatestChangeIDs = this.listingMergeMgr.latestChanges.getSymbolChanges();
        int max = tempMyAddIDs.length + tempMyChangeIDs.length + tempLatestAddIDs.length + tempLatestChangeIDs.length + 5;
        monitor.setMessage("Symbol Merge: Pre-processing symbol changes...");
        monitor.initialize((long)max);
        this.myPrimaryAddIDs = new LongHashSet();
        this.latestPrimaryAddIDs = new LongHashSet();
        monitor.setProgress(monitor.getProgress() + 1L);
        this.myAddIDs = new long[tempMyAddIDs.length];
        System.arraycopy(tempMyAddIDs, 0, this.myAddIDs, 0, tempMyAddIDs.length);
        Arrays.sort(this.myAddIDs);
        monitor.setProgress(monitor.getProgress() + 1L);
        this.latestAddIDs = new long[tempLatestAddIDs.length];
        System.arraycopy(tempLatestAddIDs, 0, this.latestAddIDs, 0, tempLatestAddIDs.length);
        Arrays.sort(this.latestAddIDs);
        monitor.setProgress(monitor.getProgress() + 1L);
        this.myChangeIDs = new long[tempMyChangeIDs.length];
        System.arraycopy(tempMyChangeIDs, 0, this.myChangeIDs, 0, tempMyChangeIDs.length);
        Arrays.sort(this.myChangeIDs);
        monitor.setProgress(monitor.getProgress() + 1L);
        this.latestChangeIDs = new long[tempLatestChangeIDs.length];
        System.arraycopy(tempLatestChangeIDs, 0, this.latestChangeIDs, 0, tempLatestChangeIDs.length);
        Arrays.sort(this.latestChangeIDs);
        monitor.checkCanceled();
        monitor.setProgress(monitor.getProgress() + 1L);
        this.getPrimariesAdded(this.myAddIDs, this.mySymTab, this.myPrimaryAddIDs, this.mySetPrimary);
        this.getPrimariesAdded(this.latestAddIDs, this.latestSymTab, this.latestPrimaryAddIDs, this.latestSetPrimary);
        this.getChanges(this.mySymTab);
        this.getChanges(this.latestSymTab);
        this.myAddIDs = this.getNonMatchingIDsInFirst(this.myAddIDs, new long[]{-1L}, monitor);
        this.latestAddIDs = this.getNonMatchingIDsInFirst(this.latestAddIDs, new long[]{-1L}, monitor);
        monitor.setProgress((long)max);
    }

    private long[] getNonMatchingIDsInFirst(long[] first, long[] second, TaskMonitor monitor) throws CancelledException {
        long[] uniqueIDs = new long[first.length];
        int u = 0;
        for (long element : first) {
            monitor.checkCanceled();
            monitor.setProgress(monitor.getProgress() + 1L);
            boolean matched = false;
            for (long element2 : second) {
                if (element2 != element) continue;
                matched = true;
                break;
            }
            if (matched) continue;
            uniqueIDs[u++] = element;
        }
        long[] results = new long[u];
        System.arraycopy(uniqueIDs, 0, results, 0, u);
        return results;
    }

    private void getPrimariesAdded(long[] symbolAddIDs, SymbolTable symTab, LongHashSet primaryAdds, AddressSet setPrimary) {
        for (long id : symbolAddIDs) {
            SymbolType symType;
            Symbol sym = symTab.getSymbol(id);
            if (sym == null || !sym.isPrimary() || (symType = sym.getSymbolType()) != SymbolType.CODE && symType != SymbolType.FUNCTION || sym.isExternal()) continue;
            primaryAdds.add(id);
            Address addr = sym.getAddress();
            setPrimary.addRange(addr, addr);
        }
    }

    private void getChanges(SymbolTable newSymTab) {
        AddressSet setPrimary;
        long[] symbolChangeIDs;
        long[] symbolAddIDs;
        if (newSymTab == this.latestSymTab) {
            symbolAddIDs = this.latestAddIDs;
            symbolChangeIDs = this.latestChangeIDs;
            setPrimary = this.latestSetPrimary;
        } else if (newSymTab == this.mySymTab) {
            symbolAddIDs = this.myAddIDs;
            symbolChangeIDs = this.myChangeIDs;
            setPrimary = this.mySetPrimary;
        } else {
            return;
        }
        LongArrayList tempRemoves = new LongArrayList();
        LongArrayList modifies = new LongArrayList();
        LongArrayList renameChanges = new LongArrayList();
        LongArrayList primaryChanges = new LongArrayList();
        LongArrayList sourceChanges = new LongArrayList();
        LongArrayList anchorChanges = new LongArrayList();
        boolean changeSymbolErrorOccurred = false;
        for (long id : symbolChangeIDs) {
            boolean sourceChanged;
            Symbol newSym = newSymTab.getSymbol(id);
            int index = this.indexOf(symbolAddIDs, id);
            if (index >= 0 && index < symbolAddIDs.length) {
                if (newSym != null) continue;
                symbolAddIDs[index] = -1L;
                continue;
            }
            Symbol oldSym = this.originalSymTab.getSymbol(id);
            if (newSym == null) {
                if (oldSym != null) {
                    tempRemoves.add(id);
                    continue;
                }
                if (id >= 400000000L) continue;
                Msg.warn((Object)this, (Object)("Symbol Merge Error: Could not find removed symbol in original program.\n  Symbol ID = " + id));
                changeSymbolErrorOccurred = true;
                continue;
            }
            if (oldSym == null) {
                Msg.warn((Object)this, (Object)("Symbol Merge Error: Could not find changed symbol in original program.\n  Symbol ID = " + id + "  Symbol Name = " + newSym.getName(true) + "  Address = " + newSym.getAddress().toString()));
                changeSymbolErrorOccurred = true;
                continue;
            }
            boolean renamed = false;
            if (!newSym.getName().equals(oldSym.getName())) {
                renameChanges.add(id);
                renamed = true;
            } else if (!newSym.getParentNamespace().equals(oldSym.getParentNamespace())) {
                renameChanges.add(id);
                renamed = true;
            }
            boolean bl = sourceChanged = newSym.getSource() != oldSym.getSource();
            if (sourceChanged) {
                sourceChanges.add(id);
            }
            if (renamed || sourceChanged) {
                modifies.add(id);
            }
            if (newSym.isPinned() != oldSym.isPinned()) {
                anchorChanges.add(id);
            }
            if (!newSym.isPrimary() || oldSym.isPrimary()) continue;
            primaryChanges.add(id);
            Address addr = newSym.getAddress();
            setPrimary.addRange(addr, addr);
        }
        if (newSymTab == this.latestSymTab) {
            this.latestRemoveIDs = tempRemoves.toLongArray();
            this.latestModifiedIDs = modifies.toLongArray();
            this.latestRenameIDs = renameChanges.toLongArray();
            this.latestSourceChangeIDs = sourceChanges.toLongArray();
            this.latestAnchorChangeIDs = anchorChanges.toLongArray();
            this.latestPrimaryChangeIDs = primaryChanges.toLongArray();
        } else if (newSymTab == this.mySymTab) {
            this.myRemoveIDs = tempRemoves.toLongArray();
            this.myModifiedIDs = modifies.toLongArray();
            this.myRenameIDs = renameChanges.toLongArray();
            this.mySourceChangeIDs = sourceChanges.toLongArray();
            this.myAnchorChangeIDs = anchorChanges.toLongArray();
            this.myPrimaryChangeIDs = primaryChanges.toLongArray();
        }
        if (changeSymbolErrorOccurred) {
            Msg.error((Object)this, (Object)"Symbol Merge Error: Could not find changed symbol in original program.\n  See log for more details.");
        }
    }

    private int indexOf(long[] symbolAddIDs, long id) {
        for (int index = 0; index < symbolAddIDs.length; ++index) {
            if (id != symbolAddIDs[index]) continue;
            return index;
        }
        return -1;
    }

    @Override
    public boolean apply() {
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictPanel.getUseForAll()) {
            this.setChoiceForSymbolConflictType(this.currentConflictType, this.conflictOption);
        }
        return super.apply();
    }

    private void setChoiceForSymbolConflictType(SymbolConflictType symbolConflictType, int choiceForSymbolConflict) {
        switch (symbolConflictType) {
            case ADDRESS_SYMBOL_CONFLICT: {
                this.addressSymbolChoice = choiceForSymbolConflict;
                break;
            }
            case PRIMARY_SYMBOL_CONFLICT: {
                this.primarySymbolChoice = choiceForSymbolConflict;
                break;
            }
            case REMOVE_SYMBOL_CONFLICT: {
                this.removeSymbolChoice = choiceForSymbolConflict;
                break;
            }
            case RENAME_SYMBOL_CONFLICT: {
                this.renameSymbolChoice = choiceForSymbolConflict;
                break;
            }
            default: {
                Msg.showError((Object)this, (Component)this.listingMergePanel, (String)"Unrecognized Symbol Conflict Type", (Object)("Unrecognized indicator (" + symbolConflictType + ") for symbol conflict type to merge."));
            }
        }
    }

    @Override
    public void autoMerge(int progressMinimum, int progressMaximum, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        this.initializeAutoMerge("Auto-merging Symbols and determining conflicts.", progressMinimum, progressMaximum, monitor);
        if (this.mergeManager != null) {
            this.loadSymbolMapInfo("ResolvedLatestSymbols", this.latestHash);
            this.loadSymbolMapInfo("ResolvedMySymbols", this.myHash);
            this.loadSymbolMapInfo("ResolvedOriginalSymbols", this.originalHash);
        }
        if (this.currentMonitor != monitor) {
            this.currentMonitor = monitor;
        }
        monitor.checkCanceled();
        this.setupSymbolChanges(monitor);
        this.totalChanges = (long)(this.myRemoveIDs.length + this.myModifiedIDs.length + this.myAddIDs.length + this.myAnchorChangeIDs.length) + this.mySetPrimary.getNumAddresses() + this.removeEntryPts.getNumAddresses() + this.addEntryPts.getNumAddresses() + (long)this.deferredRemoveIDs.size();
        this.getEntryPtChanges(monitor);
        this.processRemoves(monitor);
        this.processModifies(monitor);
        this.processAdds(monitor);
        this.processAnchorChanges(monitor);
        this.processPrimaryChanges(monitor);
        this.updateEntryPtChanges(monitor);
        this.processDeferredRemoves(monitor);
        this.updateProgress(100, "Done auto-merging Symbols and determining conflicts.");
        this.cleanupIdArrays();
        monitor.setMessage("Auto-merging Symbols completed.");
        monitor.setProgress(0L);
    }

    private void loadSymbolMapInfo(String symbolMapIdentifier, LongLongHashtable mapToLoadInto) {
        long[] symbolKeys;
        LongLongHashtable resolvedSymbols = (LongLongHashtable)this.mergeManager.getResolveInformation(symbolMapIdentifier);
        for (long key : symbolKeys = resolvedSymbols.getKeys()) {
            try {
                mapToLoadInto.put(key, resolvedSymbols.get(key));
            }
            catch (NoValueException e) {
                // empty catch block
            }
        }
        symbolKeys = null;
        resolvedSymbols = null;
    }

    private void cleanupIdArrays() {
        this.latestRemoveIDs = null;
        this.latestModifiedIDs = null;
        this.latestRenameIDs = null;
        this.latestSourceChangeIDs = null;
        this.latestAnchorChangeIDs = null;
        this.latestPrimaryChangeIDs = null;
        this.myRemoveIDs = null;
        this.myModifiedIDs = null;
        this.myRenameIDs = null;
        this.mySourceChangeIDs = null;
        this.myAnchorChangeIDs = null;
        this.myPrimaryChangeIDs = null;
    }

    private StringBuffer getRenamedConflictsInfo() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.renamedConflictIDs.iterator();
        boolean hasSome = iter.hasNext();
        if (hasSome) {
            buf.append("The following symbols were renamed to avoid conflicts: \n");
        }
        while (iter.hasNext()) {
            long id = (Long)iter.next();
            Symbol s = this.resultSymTab.getSymbol(id);
            buf.append(s.getName(true) + "\n");
        }
        if (hasSome) {
            buf.append("\n");
        }
        return buf;
    }

    private StringBuffer getDeferredRemovesInfo() {
        StringBuffer buf = new StringBuffer();
        Iterator iter = this.deferredRemoveIDs.iterator();
        boolean hasSome = iter.hasNext();
        if (hasSome) {
            buf.append("The following namespaces were not removed since they were not empty: \n");
        }
        while (iter.hasNext()) {
            long id = (Long)iter.next();
            Symbol s = this.resultSymTab.getSymbol(id);
            buf.append(s.getName(true) + "\n");
        }
        if (hasSome) {
            buf.append("\n");
        }
        return buf;
    }

    private void processDeferredRemoves(TaskMonitor monitor) throws CancelledException {
        boolean removedSome;
        this.updateProgressMessage("Removing symbols that had been deferred...");
        monitor.setMessage("Symbol Merge: Processing removal of deferred symbols...");
        monitor.setProgress(0L);
        LongArrayList list = new LongArrayList();
        Iterator iter = this.deferredRemoveIDs.iterator();
        while (iter.hasNext()) {
            long id = (Long)iter.next();
            list.add(id);
        }
        do {
            removedSome = false;
            monitor.initialize((long)list.size());
            for (int i = 0; i < list.size(); ++i) {
                SymbolIterator symIter;
                monitor.setProgress((long)i);
                monitor.checkCanceled();
                long id = list.get(i);
                Symbol resultSymbol = this.resultSymTab.getSymbol(id);
                if (resultSymbol == null) {
                    this.updateResolveIDs(this.originalPgm, id, -1L);
                    this.deferredRemoveIDs.remove(id);
                    this.incrementProgress(1);
                    continue;
                }
                Object obj = resultSymbol.getObject();
                if (!(obj instanceof Namespace) || (symIter = this.resultSymTab.getChildren(resultSymbol)).hasNext()) continue;
                resultSymbol.delete();
                this.updateResolveIDs(this.originalPgm, id, -1L);
                this.deferredRemoveIDs.remove(id);
                list.remove(i--);
                removedSome |= true;
                this.incrementProgress(1);
            }
        } while (removedSome);
        monitor.setProgress((long)list.size());
    }

    private void processRemoves(TaskMonitor monitor) throws CancelledException {
        this.updateProgressMessage("Processing removed symbols...");
        monitor.setMessage("Symbol Merge: Processing removed symbols...");
        int len = this.myRemoveIDs.length;
        monitor.initialize((long)len);
        for (int i = 0; i < len; ++i) {
            monitor.setProgress((long)i);
            monitor.checkCanceled();
            long id = this.myRemoveIDs[i];
            Symbol originalSym = this.originalSymTab.getSymbol(id);
            SymbolType originalType = originalSym.getSymbolType();
            if ((originalType != SymbolType.CODE || originalSym.isExternal()) && originalType != SymbolType.CLASS && originalType != SymbolType.NAMESPACE) continue;
            this.processSingleRemove(id, originalSym);
        }
        monitor.setProgress((long)len);
    }

    private void processSingleRemove(long id, Symbol originalSym) {
        Symbol resultSym = this.resultSymTab.getSymbol(id);
        int index = Arrays.binarySearch(this.latestChangeIDs, id);
        if (index >= 0) {
            int removeIndex = Arrays.binarySearch(this.latestRemoveIDs, id);
            if (removeIndex < 0) {
                this.saveRemoveConflict(originalSym);
            }
        } else if (resultSym != null) {
            this.removeSymbol(resultSym, id);
        }
    }

    private void processModifies(TaskMonitor monitor) throws CancelledException {
        this.updateProgressMessage("Processing modified symbols...");
        monitor.setMessage("Symbol Merge: Processing modified symbols...");
        int len = this.myModifiedIDs.length;
        monitor.initialize((long)len);
        for (int i = 0; i < len; ++i) {
            boolean sourceChangedInLatest;
            monitor.setProgress((long)i);
            monitor.checkCanceled();
            this.incrementProgress(1);
            long id = this.myModifiedIDs[i];
            Symbol mySym = this.mySymTab.getSymbol(id);
            SymbolType myType = mySym.getSymbolType();
            Symbol resultSym = this.getResultSymbolFromMySymbol(mySym);
            if (myType == SymbolType.FUNCTION) {
                if (resultSym == null) continue;
                this.processModifiedFunctionNamespace(id, mySym, resultSym);
                this.processModifiedFunctionSymbol(id, resultSym, mySym);
                continue;
            }
            if (myType != SymbolType.CODE && myType != SymbolType.CLASS && myType != SymbolType.NAMESPACE || myType == SymbolType.CODE && mySym.isExternal()) continue;
            boolean removedInLatest = Arrays.binarySearch(this.latestRemoveIDs, id) >= 0;
            boolean renamedInMy = Arrays.binarySearch(this.myRenameIDs, id) >= 0;
            boolean sourceChangedInMy = Arrays.binarySearch(this.mySourceChangeIDs, id) >= 0;
            boolean renamedInLatest = Arrays.binarySearch(this.latestRenameIDs, id) >= 0;
            boolean bl = sourceChangedInLatest = Arrays.binarySearch(this.latestSourceChangeIDs, id) >= 0;
            if (removedInLatest) {
                if (!renamedInMy) continue;
                this.saveRemoveConflict(mySym);
                continue;
            }
            if (renamedInMy) {
                if (renamedInLatest) {
                    Symbol latestSym = this.latestSymTab.getSymbol(id);
                    String myName = mySym.getName();
                    Namespace myNamespace = mySym.getParentNamespace();
                    String latestName = latestSym.getName();
                    Namespace latestNamespace = latestSym.getParentNamespace();
                    Namespace equivNamespace = DiffUtility.getNamespace(latestNamespace, this.myPgm);
                    if (!myName.equals(latestName) || myNamespace != equivNamespace) {
                        this.saveRenameConflict(id);
                        continue;
                    }
                }
                try {
                    this.renameResultSymbol(mySym);
                }
                catch (Exception e) {
                    String msg = "Failed to rename '" + mySym.getName(true) + "'.";
                    Msg.showError((Object)this, null, (String)"Rename Symbol Error", (Object)msg, (Throwable)e);
                }
                continue;
            }
            if (resultSym == null || !sourceChangedInMy || sourceChangedInLatest) continue;
            try {
                resultSym.setSource(mySym.getSource());
                continue;
            }
            catch (IllegalArgumentException e) {
                Msg.warn((Object)this, (Object)e.getMessage());
            }
        }
        monitor.setProgress((long)len);
    }

    private void processModifiedFunctionNamespace(long id, Symbol mySym, Symbol resultSym) {
        Namespace myNs = mySym.getParentNamespace();
        Namespace resultNs = resultSym.getParentNamespace();
        try {
            Namespace desiredNs = this.resolveNamespace(this.myPgm, myNs);
            if (desiredNs != null && desiredNs != resultNs) {
                boolean renamedInLatest;
                boolean renamedInMy = Arrays.binarySearch(this.myRenameIDs, id) >= 0;
                boolean bl = renamedInLatest = Arrays.binarySearch(this.latestRenameIDs, id) >= 0;
                if (renamedInMy && renamedInLatest) {
                    Namespace latestNamespace;
                    Namespace equivNamespace;
                    Symbol latestSym = this.latestSymTab.getSymbol(id);
                    Namespace myNamespace = mySym.getParentNamespace();
                    if (myNamespace != (equivNamespace = DiffUtility.getNamespace(latestNamespace = latestSym.getParentNamespace(), this.myPgm))) {
                        this.saveRenameConflict(id);
                    }
                } else {
                    resultSym.setNamespace(desiredNs);
                }
            }
        }
        catch (UsrException e1) {
            String msg = "Failed to set namespace to '" + myNs.getName(true) + "' for function '" + resultSym.getName(true) + "'.";
            Msg.showError((Object)this, null, (String)"Rename Function Symbol Error", (Object)msg);
        }
    }

    private void processModifiedFunctionSymbol(long id, Symbol resultSym, Symbol mySym) {
        boolean renamed;
        boolean renamedInMy = Arrays.binarySearch(this.myRenameIDs, id) >= 0;
        boolean sourceChangedInMy = Arrays.binarySearch(this.mySourceChangeIDs, id) >= 0;
        boolean renamedInLatest = Arrays.binarySearch(this.latestRenameIDs, id) >= 0;
        boolean sourceChangedInLatest = Arrays.binarySearch(this.latestSourceChangeIDs, id) >= 0;
        boolean bl = renamed = renamedInMy || renamedInLatest;
        if (!renamed && sourceChangedInMy && !sourceChangedInLatest) {
            try {
                resultSym.setSource(mySym.getSource());
            }
            catch (IllegalArgumentException e) {
                Msg.warn((Object)this, (Object)e.getMessage());
            }
        }
    }

    private void processAnchorChanges(TaskMonitor monitor) throws CancelledException {
        this.updateProgressMessage("Processing symbol flag changes...");
        monitor.setMessage("Symbol Merge: Processing symbol flag changes...");
        int len = this.myAnchorChangeIDs.length;
        monitor.initialize((long)len);
        for (int i = 0; i < len; ++i) {
            boolean removedInLatest;
            monitor.setProgress((long)i);
            monitor.checkCanceled();
            this.incrementProgress(1);
            long id = this.myAnchorChangeIDs[i];
            Symbol mySym = this.mySymTab.getSymbol(id);
            boolean bl = removedInLatest = Arrays.binarySearch(this.latestRemoveIDs, id) >= 0;
            if (removedInLatest) continue;
            Symbol resultSym = this.resultSymTab.getSymbol(id);
            resultSym.setPinned(mySym.isPinned());
            this.incrementProgress(1);
        }
        monitor.setProgress((long)len);
    }

    private void processPrimaryChanges(TaskMonitor monitor) throws CancelledException {
        this.updateProgressMessage("Processing change of primary symbols...");
        monitor.setMessage("Symbol Merge: Processing change of primary symbols...");
        monitor.initialize(this.mySetPrimary.getNumAddresses());
        AddressIterator iter = this.mySetPrimary.getAddresses(true);
        while (iter.hasNext()) {
            Symbol originalSymbol;
            monitor.incrementProgress(1L);
            monitor.checkCanceled();
            this.incrementProgress(1);
            Address addr = iter.next();
            Symbol myPrimary = this.mySymTab.getPrimarySymbol(addr);
            if (myPrimary == null) continue;
            long myID = myPrimary.getID();
            int removeIndex = Arrays.binarySearch(this.latestRemoveIDs, myID);
            if (removeIndex >= 0 && (originalSymbol = this.originalSymTab.getSymbol(myID)) != null) {
                this.saveRemoveConflict(originalSymbol);
            }
            if (this.latestSetPrimary.contains(addr)) {
                Symbol latestSameAsMy;
                Symbol latestPrimary = this.latestSymTab.getPrimarySymbol(addr);
                if (SymbolMerger.same(latestPrimary, latestSameAsMy = SimpleDiffUtility.getSymbol((Symbol)myPrimary, (Program)this.latestPgm))) continue;
                this.savePrimaryConflict(addr);
                continue;
            }
            Symbol resultSym = this.getResultSymbolFromMySymbol(myPrimary);
            if (resultSym == null) continue;
            resultSym.setPrimary();
        }
    }

    private void processAdds(TaskMonitor monitor) throws CancelledException {
        this.updateProgressMessage("Processing added symbols...");
        monitor.setMessage("Symbol Merge: Processing added symbols...");
        int len = this.myAddIDs.length;
        monitor.initialize((long)len);
        for (int i = 0; i < len; ++i) {
            monitor.checkCanceled();
            this.incrementProgress(1);
            monitor.incrementProgress(1L);
            long id = this.myAddIDs[i];
            Symbol mySym = this.mySymTab.getSymbol(id);
            if (this.myHash.contains(id) || mySym == null) continue;
            SymbolType myType = mySym.getSymbolType();
            if (!(mySym.isExternal() || myType != SymbolType.FUNCTION && myType != SymbolType.LOCAL_VAR && myType != SymbolType.PARAMETER)) {
                this.processAddedFunctionSymbol(mySym);
            } else if (myType != SymbolType.CODE && myType != SymbolType.CLASS && myType != SymbolType.NAMESPACE) continue;
            try {
                SymbolType mySymbolType = mySym.getSymbolType();
                if (mySym.isExternal() && mySymbolType == SymbolType.CODE) continue;
                this.addSymbol(mySym);
                this.updateProgressMessage("Adding symbol: " + mySym.getName(true));
                monitor.setMessage("Symbol Merge: Added symbol " + i + " of " + len + "...");
                continue;
            }
            catch (UsrException e) {
                String msg = "Failed to add '" + mySym.getName(true) + "'.";
                Msg.showError((Object)this, null, (String)"Add Symbol Error", (Object)msg);
            }
        }
        monitor.setProgress((long)len);
        this.updateProgressMessage(this.DEFAULT_PROGRESS_MESSAGE);
    }

    private void processAddedFunctionSymbol(Symbol mySym) {
        long id = mySym.getID();
        Symbol resultSym = this.myHash.contains(id) ? this.getResultSymbolFromMyID(id) : SimpleDiffUtility.getSymbol((Symbol)mySym, (Program)this.resultPgm);
        if (resultSym != null) {
            boolean renamed;
            boolean renamedInMy = Arrays.binarySearch(this.myRenameIDs, id) >= 0;
            boolean sourceChangedInMy = Arrays.binarySearch(this.mySourceChangeIDs, id) >= 0;
            boolean renamedInLatest = Arrays.binarySearch(this.latestRenameIDs, id) >= 0;
            boolean sourceChangedInLatest = Arrays.binarySearch(this.latestSourceChangeIDs, id) >= 0;
            boolean bl = renamed = renamedInMy || renamedInLatest;
            if (!renamed && sourceChangedInMy && !sourceChangedInLatest) {
                try {
                    resultSym.setSource(mySym.getSource());
                }
                catch (IllegalArgumentException e) {
                    Msg.warn((Object)this, (Object)e.getMessage());
                }
            }
        }
    }

    private void getEntryPtChanges(TaskMonitor monitor) throws CancelledException {
        AddressIterator originalIter = this.originalSymTab.getExternalEntryPointIterator();
        AddressIterator latestIter = this.latestSymTab.getExternalEntryPointIterator();
        AddressIterator myIter = this.mySymTab.getExternalEntryPointIterator();
        this.updateProgressMessage("Finding entry point changes...");
        monitor.setMessage("Symbol Merge: Finding entry point changes...");
        monitor.setProgress(0L);
        MultiAddressIterator multiIter = new MultiAddressIterator(new AddressIterator[]{originalIter, latestIter, myIter});
        while (multiIter.hasNext()) {
            monitor.checkCanceled();
            Address[] addrs = multiIter.nextAddresses();
            if (addrs[0] != null) {
                if (addrs[1] != null && addrs[2] != null) continue;
                this.removeEntryPts.addRange(addrs[0], addrs[0]);
                continue;
            }
            if (addrs[1] != null) {
                this.addEntryPts.addRange(addrs[1], addrs[1]);
                continue;
            }
            if (addrs[2] == null) continue;
            this.addEntryPts.addRange(addrs[2], addrs[2]);
        }
    }

    private void updateEntryPtChanges(TaskMonitor monitor) throws CancelledException {
        Address addr;
        this.updateProgressMessage("Updating entry point changes...");
        monitor.setMessage("Symbol Merge: Updating entry point changes...");
        monitor.setProgress(0L);
        SymbolTable tempResultSymTab = this.resultPgm.getSymbolTable();
        AddressIterator iter = this.removeEntryPts.getAddresses(true);
        while (iter.hasNext()) {
            monitor.checkCanceled();
            addr = iter.next();
            tempResultSymTab.removeExternalEntryPoint(addr);
            this.incrementProgress(1);
        }
        iter = this.addEntryPts.getAddresses(true);
        while (iter.hasNext()) {
            monitor.checkCanceled();
            addr = iter.next();
            tempResultSymTab.addExternalEntryPoint(addr);
            this.incrementProgress(1);
        }
    }

    private void renameResultSymbol(Symbol mySym) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        long id = mySym.getID();
        String name = mySym.getName();
        Address addr = mySym.getAddress();
        SourceType source = mySym.getSource();
        Namespace myNamespace = mySym.getParentNamespace();
        Namespace resultNamespace = DiffUtility.getNamespace(myNamespace, this.resultPgm);
        if (resultNamespace == null) {
            resultNamespace = DiffUtility.createNamespace(this.myPgm, myNamespace, this.resultPgm);
        }
        Symbol resultSym = this.resultSymTab.getSymbol(id);
        if (mySym.isDynamic() && resultSym.isDynamic()) {
            return;
        }
        Symbol addressSymbol = this.resultSymTab.getSymbol(name, addr, resultNamespace);
        if (addressSymbol != null && addressSymbol != resultSym) {
            this.saveAddressConflict(addr, mySym);
        }
        List symbols = this.resultSymTab.getSymbols(name, resultNamespace);
        for (Symbol symbol : symbols) {
            if (symbol != resultSym) continue;
            return;
        }
        boolean nameChanged = !name.equals(resultSym.getName());
        boolean scopeChanged = resultSym.getParentNamespace() != resultNamespace;
        String tempName = null;
        if (nameChanged) {
            try {
                resultSym.setName(name, source);
            }
            catch (DuplicateNameException e) {
                if (scopeChanged) {
                    tempName = ProgramMerge.getUniqueName(this.resultSymTab, name, addr, resultSym.getParentNamespace(), resultNamespace, resultSym.getSymbolType());
                    if (tempName == null) {
                        throw e;
                    }
                    resultSym.setName(tempName, source);
                }
                String uniqueResultName = ProgramMerge.getUniqueName(this.resultSymTab, name, addr, resultSym.getParentNamespace(), resultNamespace, resultSym.getSymbolType());
                if (uniqueResultName == null) {
                    throw e;
                }
                resultSym.setName(uniqueResultName, source);
                this.renamedConflictIDs.add(resultSym.getID());
            }
        }
        if (scopeChanged) {
            resultSym.setNamespace(resultNamespace);
        }
        if (tempName != null) {
            try {
                resultSym.setName(name, source);
            }
            catch (DuplicateNameException e) {
                this.renamedConflictIDs.add(resultSym.getID());
            }
        }
    }

    private void addSymbol(Symbol mySym) throws DuplicateNameException, InvalidInputException {
        Symbol resultSym;
        long id = mySym.getID();
        if (this.myHash.contains(id)) {
            return;
        }
        String name = mySym.getName();
        SymbolType myType = mySym.getSymbolType();
        if (myType == SymbolType.LOCAL_VAR || myType == SymbolType.PARAMETER) {
            return;
        }
        Address resultAddr = SimpleDiffUtility.getCompatibleAddress((Program)this.myPgm, (Address)mySym.getAddress(), (Program)this.resultPgm);
        Namespace namespace = mySym.getParentNamespace();
        Namespace resultNamespace = this.resolveNamespace(this.myPgm, namespace);
        if (resultNamespace == null) {
            resultNamespace = DiffUtility.createNamespace(this.myPgm, namespace, this.resultPgm);
        }
        if ((resultSym = this.resultSymTab.getSymbol(name, resultAddr, resultNamespace)) != null && resultSym.getSymbolType() == myType) {
            long resultID = resultSym.getID();
            if (resultID != id) {
                this.myHash.put(id, resultID);
            }
            return;
        }
        Object newName = name;
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            try {
                resultSym = this.createSymbol((String)newName, myType, resultAddr, resultNamespace, this.myPgm, id, mySym.getSource());
                if (resultSym != null && i > 1) {
                    this.renamedConflictIDs.add(resultSym.getID());
                }
                return;
            }
            catch (DuplicateNameException duplicateNameException) {
                newName = name + ProgramMerge.SYMBOL_CONFLICT_SUFFIX + i;
                continue;
            }
        }
        throw new DuplicateNameException("Couldn't create symbol '" + mySym.getName(true) + "'.");
    }

    private void saveRemoveConflict(Symbol originalSymbol) {
        Address addr = originalSymbol.getAddress();
        LongArrayList list = this.removes.get(addr);
        if (list == null) {
            list = new LongArrayList();
            this.removes.put(addr, list);
        }
        list.add(originalSymbol.getID());
        this.removeConflicts.addRange(addr, addr);
    }

    private void saveRenameConflict(long symbolID) {
        Address addr = this.originalSymTab.getSymbol(symbolID).getAddress();
        LongArrayList list = this.renames.get(addr);
        if (list == null) {
            list = new LongArrayList();
            this.renames.put(addr, list);
        }
        list.add(symbolID);
        this.renameConflicts.addRange(addr, addr);
    }

    private void saveAddressConflict(Address addr, Symbol symbol) {
        SymbolPath symbolPath;
        ArrayList<Object> list = this.symbolAddressConflicts.get(addr);
        if (list == null) {
            list = new ArrayList(1);
            this.symbolAddressConflicts.put(addr, list);
        }
        if (!list.contains(symbolPath = new SymbolPath(symbol.getPath()))) {
            list.add(symbolPath);
        }
        this.addressConflicts.addRange(addr, addr);
    }

    private void savePrimaryConflict(Address addr) {
        this.primaryConflicts.addRange(addr, addr);
    }

    private int getIDCount(Hashtable<Address, LongArrayList> conflictHashtable, Address addr) {
        LongArrayList list = conflictHashtable.get(addr);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public boolean hasConflict(Address addr) {
        return this.removeConflicts.contains(addr) || this.renameConflicts.contains(addr) || this.addressConflicts.contains(addr) || this.addCommentConflicts.contains(addr) || this.primaryConflicts.contains(addr);
    }

    @Override
    public int getConflictCount(Address addr) {
        return this.getIDCount(this.removes, addr) + this.getIDCount(this.renames, addr) + this.getConflictCountFromConflicts(addr) + this.getIDCount(this.addComments, addr) + (this.primaryConflicts.contains(addr) ? 1 : 0);
    }

    private int getConflictCountFromConflicts(Address addr) {
        ArrayList<SymbolPath> list = this.symbolAddressConflicts.get(addr);
        if (list == null) {
            return 0;
        }
        return list.size();
    }

    @Override
    public AddressSetView getConflicts() {
        AddressSet conflicts = new AddressSet();
        conflicts.add((AddressSetView)this.removeConflicts);
        conflicts.add((AddressSetView)this.renameConflicts);
        conflicts.add((AddressSetView)this.addressConflicts);
        conflicts.add((AddressSetView)this.addCommentConflicts);
        conflicts.add((AddressSetView)this.primaryConflicts);
        return conflicts;
    }

    @Override
    public void mergeConflicts(ListingMergePanel listingPanel, Address addr, int chosenConflictOption, TaskMonitor monitor) throws CancelledException, MemoryAccessException {
        if (!this.hasConflict(addr)) {
            return;
        }
        if (this.currentMonitor != monitor) {
            this.currentMonitor = monitor;
        }
        monitor.setMessage("Resolving Symbol conflicts.");
        this.handleRemoveConflict(listingPanel, addr, chosenConflictOption);
        this.handleRenameConflict(listingPanel, addr, chosenConflictOption);
        this.handleAddressConflict(listingPanel, addr, chosenConflictOption);
        this.handlePrimaryConflict(listingPanel, addr, chosenConflictOption);
        this.updateEntryPtChanges(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeConflicts(TaskMonitor monitor) throws MemoryAccessException, CancelledException {
        try {
            this.mergeManager.showProgressIcon(false);
            int originalConflictOption = this.conflictOption;
            AddressSetView listingConflictSet = this.getConflicts();
            long totalAddresses = listingConflictSet.getNumAddresses();
            AddressIterator iter = listingConflictSet.getAddresses(true);
            int addressNum = 1;
            while (iter.hasNext()) {
                Address addr = iter.next();
                this.conflictNum = 1;
                this.totalConflicts = this.getConflictCount(addr);
                if (this.listingMergePanel != null) {
                    this.conflictInfoPanel.setAddressInfo(addr, addressNum, totalAddresses);
                }
                this.mergeConflicts(this.listingMergePanel, addr, originalConflictOption, monitor);
                ++addressNum;
            }
        }
        finally {
            this.mergeManager.showProgressIcon(true);
        }
    }

    public void merge(int progressMinimum, int progressMaximum, TaskMonitor monitor) throws ProgramConflictException, MemoryAccessException, CancelledException {
        monitor.checkCanceled();
        monitor.setProgress(0L);
        this.clearResolveInfo();
        this.autoMerge(progressMinimum, progressMaximum, monitor);
        monitor.checkCanceled();
        this.mergeConflicts(monitor);
        monitor.checkCanceled();
        this.processDeferredRemoves(monitor);
        monitor.checkCanceled();
        this.infoBuf.append(this.getDeferredRemovesInfo());
        this.infoBuf.append(this.getRenamedConflictsInfo());
        monitor.checkCanceled();
        this.showResolveInfo();
    }

    private void handlePrimaryConflict(ListingMergePanel listingPanel, Address addr, int chosenConflictOption) throws CancelledException {
        boolean askUser;
        this.currentConflictType = SymbolConflictType.PRIMARY_SYMBOL_CONFLICT;
        boolean bl = askUser = this.primarySymbolChoice == 0 && chosenConflictOption == 0;
        if (this.primaryConflicts.contains(addr)) {
            Symbol latestPrimary = this.latestSymTab.getPrimarySymbol(addr);
            Symbol latestResultSymbol = this.getResultSymbolFromLatestSymbol(latestPrimary);
            Symbol myPrimary = this.mySymTab.getPrimarySymbol(addr);
            Symbol myResultSymbol = this.getResultSymbolFromMySymbol(myPrimary);
            if (myResultSymbol == null || SymbolMerger.same(myResultSymbol, latestResultSymbol)) {
                return;
            }
            this.currentAddress = addr;
            this.currentBackgroundSet = new AddressSet(addr, addr);
            if (askUser && this.mergeManager != null) {
                this.showConflictPanel(listingPanel, 5, this.primarySymbolChoice, "Primary Symbol");
            } else {
                int optionToUse = this.primarySymbolChoice == 0 ? chosenConflictOption : this.primarySymbolChoice;
                this.setPrimary(addr, optionToUse);
            }
        }
    }

    private void handleAddressConflict(ListingMergePanel listingPanel, Address addr, int chosenConflictOption) throws CancelledException {
        boolean askUser;
        this.currentConflictType = SymbolConflictType.ADDRESS_SYMBOL_CONFLICT;
        boolean bl = askUser = this.addressSymbolChoice == 0 && chosenConflictOption == 0;
        if (this.addressConflicts.contains(addr)) {
            ArrayList<SymbolPath> addressConflictList = this.symbolAddressConflicts.get(addr);
            for (SymbolPath symbolPath : addressConflictList) {
                Symbol mySymbol = this.getSymbol(this.myPgm, symbolPath, addr);
                this.currentAddress = addr;
                this.currentSymbol = mySymbol;
                this.currentNamespace = mySymbol.getParentNamespace();
                this.currentSymbolName = mySymbol.getName();
                Namespace resultNamespace = DiffUtility.getNamespace(this.currentNamespace, this.resultPgm);
                this.uniqueName = ProgramMerge.getUniqueName(this.resultSymTab, this.currentSymbolName, this.currentAddress, resultNamespace, mySymbol.getSymbolType());
                this.currentBackgroundSet = new AddressSet(addr, addr);
                if (askUser && this.mergeManager != null) {
                    this.showConflictPanel(listingPanel, 4, this.addressSymbolChoice, "Symbol Address");
                    continue;
                }
                int optionToUse = this.addressSymbolChoice == 0 ? chosenConflictOption : this.addressSymbolChoice;
                this.mergeSymbol(this.currentSymbol, optionToUse);
            }
        }
    }

    private Symbol getSymbol(Program program, SymbolPath symbolPath, Address address) {
        List symbols = NamespaceUtils.getSymbols((String)symbolPath.getPath(), (Program)program);
        for (Symbol symbol : symbols) {
            if (!symbol.getAddress().equals((Object)address)) continue;
            return symbol;
        }
        throw new AssertException("Expected a matching symbol when handling address conflicts");
    }

    private void handleRemoveConflict(ListingMergePanel listingPanel, Address addr, int chosenConflictOption) throws CancelledException {
        boolean askUser;
        this.currentConflictType = SymbolConflictType.REMOVE_SYMBOL_CONFLICT;
        boolean bl = askUser = this.removeSymbolChoice == 0 && chosenConflictOption == 0;
        if (this.removeConflicts.contains(addr)) {
            long[] removeIDs;
            for (long removeID : removeIDs = this.removes.get(addr).toLongArray()) {
                if (this.isUnresolvableChange(removeID)) continue;
                Symbol originalSym = this.originalSymTab.getSymbol(removeID);
                this.currentAddress = addr;
                this.currentSymbol = originalSym;
                this.currentSymbolName = originalSym.getName();
                this.currentNamespace = originalSym.getParentNamespace();
                this.currentBackgroundSet = new AddressSet(addr, addr);
                if (askUser && this.mergeManager != null) {
                    this.showConflictPanel(listingPanel, 1, this.removeSymbolChoice, "Remove Symbol");
                    continue;
                }
                try {
                    int optionToUse = this.removeSymbolChoice == 0 ? chosenConflictOption : this.removeSymbolChoice;
                    this.resolveRemoveVsChange(removeID, optionToUse);
                }
                catch (Exception e) {
                    String msg = "Failed to resolve symbol '" + originalSym.getName(true) + "'.";
                    Msg.showError((Object)this, null, (String)"Remove vs Change Symbol Error", (Object)msg, (Throwable)e);
                }
            }
        }
    }

    private void handleRenameConflict(ListingMergePanel listingPanel, Address addr, int chosenConflictOption) throws CancelledException {
        boolean askUser;
        this.currentConflictType = SymbolConflictType.RENAME_SYMBOL_CONFLICT;
        boolean bl = askUser = this.renameSymbolChoice == 0 && chosenConflictOption == 0;
        if (this.renameConflicts.contains(addr)) {
            long[] renameIDs;
            for (long renameID : renameIDs = this.renames.get(addr).toLongArray()) {
                Symbol originalSym = this.originalSymTab.getSymbol(renameID);
                this.currentAddress = addr;
                this.currentSymbol = originalSym;
                this.currentBackgroundSet = new AddressSet(addr, addr);
                if (askUser && this.mergeManager != null) {
                    this.showConflictPanel(listingPanel, 2, this.renameSymbolChoice, "Rename Symbol");
                    continue;
                }
                try {
                    int optionToUse = this.renameSymbolChoice == 0 ? chosenConflictOption : this.renameSymbolChoice;
                    this.resolveRename(renameID, optionToUse);
                }
                catch (Exception e) {
                    String msg = "Failed to rename symbol '" + originalSym.getName(true) + "'.";
                    Msg.showError((Object)this, null, (String)"Rename Symbol Error", (Object)msg, (Throwable)e);
                }
            }
        }
    }

    private boolean isUnresolvableChange(long id) {
        Symbol original = this.originalSymTab.getSymbol(id);
        Symbol latest = this.latestSymTab.getSymbol(id);
        Symbol my = this.mySymTab.getSymbol(id);
        if (original != null) {
            if (latest != null && my == null) {
                return this.hasSymbolWithNameConflict(this.latestPgm, latest, this.myPgm, true);
            }
            if (my != null && latest == null) {
                return this.hasSymbolWithNameConflict(this.myPgm, my, this.latestPgm, true);
            }
        }
        return false;
    }

    private boolean hasSymbolWithNameConflict(Program program, Symbol symbol, Program otherProgram, boolean saveConflict) {
        Symbol s = SimpleDiffUtility.getSymbol((Symbol)symbol, (Program)otherProgram);
        if (s != null) {
            return false;
        }
        String name = symbol.getName();
        Namespace namespace = DiffUtility.getNamespace(symbol.getParentNamespace(), otherProgram);
        SymbolTable otherSymTab = otherProgram.getSymbolTable();
        Address address = SimpleDiffUtility.getCompatibleAddress((Program)program, (Address)symbol.getAddress(), (Program)otherProgram);
        Symbol addressSymbol = address != null ? otherSymTab.getSymbol(name, address, namespace) : null;
        List sameNamespaceSymbols = otherSymTab.getSymbols(name, namespace);
        boolean addressConflict = this.isAddressConflict(addressSymbol);
        boolean namespaceConflict = this.isNamespaceConflict(sameNamespaceSymbols, symbol);
        if (saveConflict) {
            if (addressConflict) {
                this.saveAddressConflict(address, symbol);
            }
            if (namespaceConflict && program == this.myPgm) {
                Address myAddr = symbol.getAddress();
                Namespace myNs = symbol.getParentNamespace();
                String myName = symbol.getName();
                Namespace resultNs = DiffUtility.getNamespace(myNs, this.resultPgm);
                this.uniqueName = ProgramMerge.getUniqueName(this.resultSymTab, myName, myAddr, resultNs, symbol.getSymbolType());
                this.mergeSymbol(symbol, 64);
            }
        }
        return addressConflict || namespaceConflict;
    }

    private boolean isAddressConflict(Symbol addressSymbol) {
        return addressSymbol != null;
    }

    private boolean isNamespaceConflict(List<Symbol> sameNamespaceSymbols, Symbol symbol) {
        if (symbol.getSymbolType().allowsDuplicates()) {
            return false;
        }
        for (Symbol namespaceSymbol : sameNamespaceSymbols) {
            if (namespaceSymbol.getSymbolType().allowsDuplicates()) continue;
            return true;
        }
        return false;
    }

    private void resolveRemoveVsChange(long originalSymbolID, int chosenConflictOption) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        boolean myRemoved;
        Symbol latest = this.latestSymTab.getSymbol(originalSymbolID);
        Symbol my = this.mySymTab.getSymbol(originalSymbolID);
        Symbol result = null;
        try {
            long resultID = this.getResultIDFromOriginalID(originalSymbolID);
            if (resultID != -1L) {
                result = this.resultSymTab.getSymbol(resultID);
            }
        }
        catch (NoValueException noValueException) {
            // empty catch block
        }
        boolean latestRemoved = latest == null;
        boolean bl = myRemoved = my == null;
        if ((chosenConflictOption & 2) != 0) {
            if (!latestRemoved) {
                if (result == null) {
                    Symbol s = this.createSymbol(this.resultPgm, this.latestPgm, latest);
                    long newID = s.getID();
                    this.originalHash.put(originalSymbolID, newID);
                    this.latestHash.put(originalSymbolID, newID);
                } else {
                    this.replaceSymbol(this.resultPgm, result, this.latestPgm, latest);
                }
            } else if (result != null) {
                this.removeSymbol(result, originalSymbolID);
            }
        } else if ((chosenConflictOption & 4) != 0) {
            if (!myRemoved) {
                if (result == null) {
                    Symbol s = this.createSymbol(this.resultPgm, this.myPgm, my);
                    long newID = s.getID();
                    this.originalHash.put(originalSymbolID, newID);
                    this.myHash.put(originalSymbolID, newID);
                } else {
                    this.replaceSymbol(this.resultPgm, result, this.myPgm, my);
                }
            } else if (result != null) {
                this.removeSymbol(result, originalSymbolID);
            }
        }
    }

    private void resolveRename(long originalSymbolID, int chosenConflictOption) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        Symbol original = this.originalSymTab.getSymbol(originalSymbolID);
        Symbol latest = this.latestSymTab.getSymbol(originalSymbolID);
        Symbol my = this.mySymTab.getSymbol(originalSymbolID);
        Symbol result = null;
        try {
            long resultID = this.getResultIDFromOriginalID(originalSymbolID);
            result = this.resultSymTab.getSymbol(resultID);
        }
        catch (NoValueException e) {
            String msg = "Failed to rename symbol '" + original.getName(true) + "'.";
            Msg.showError((Object)this, null, (String)"Rename Symbol Error", (Object)msg);
        }
        if ((chosenConflictOption & 2) != 0) {
            this.renameSymbol(this.resultPgm, result, this.latestPgm, latest);
        } else if ((chosenConflictOption & 4) != 0) {
            this.renameSymbol(this.resultPgm, result, this.myPgm, my);
        }
    }

    private long getResultIDFromOriginalID(long originalSymbolID) throws NoValueException {
        if (this.resultSymTab.getSymbol(originalSymbolID) != null) {
            return originalSymbolID;
        }
        return this.originalHash.get(originalSymbolID);
    }

    private Symbol getResultSymbolFromMySymbol(Symbol s) {
        if (s == null) {
            return null;
        }
        try {
            return this.resultSymTab.getSymbol(this.getResultIDFromMyID(s.getID()));
        }
        catch (NoValueException e) {
            return null;
        }
    }

    private Symbol getResultSymbolFromMyID(long symbolID) {
        try {
            return this.resultSymTab.getSymbol(this.getResultIDFromMyID(symbolID));
        }
        catch (NoValueException e) {
            return null;
        }
    }

    private long getResultIDFromMyID(long mySymbolID) throws NoValueException {
        try {
            return this.myHash.get(mySymbolID);
        }
        catch (NoValueException e) {
            Symbol resultSymbol;
            SymbolType originalSymbolType;
            Symbol mySymbol = this.mySymTab.getSymbol(mySymbolID);
            Symbol originalSymbol = this.originalSymTab.getSymbol(mySymbolID);
            SymbolType mySymbolType = mySymbol != null ? mySymbol.getSymbolType() : null;
            SymbolType symbolType = originalSymbolType = originalSymbol != null ? originalSymbol.getSymbolType() : null;
            if (originalSymbolType != null && originalSymbolType == mySymbolType) {
                SymbolType resultSymbolType;
                resultSymbol = this.resultSymTab.getSymbol(mySymbolID);
                SymbolType symbolType2 = resultSymbolType = resultSymbol != null ? resultSymbol.getSymbolType() : null;
                if (originalSymbolType == resultSymbolType) {
                    return mySymbolID;
                }
            }
            if (mySymbol != null && (resultSymbol = SimpleDiffUtility.getSymbol((Symbol)mySymbol, (Program)this.resultPgm)) != null) {
                return resultSymbol.getID();
            }
            throw e;
        }
    }

    private Symbol getResultSymbolFromLatestSymbol(Symbol s) {
        if (s == null) {
            return null;
        }
        try {
            return this.resultSymTab.getSymbol(this.getResultIDFromLatestID(s.getID()));
        }
        catch (NoValueException e) {
            return null;
        }
    }

    private Symbol getResultSymbolFromOriginalSymbol(Symbol s) {
        if (s == null) {
            return null;
        }
        try {
            return this.resultSymTab.getSymbol(this.getResultIDFromOriginalID(s.getID()));
        }
        catch (NoValueException e) {
            return null;
        }
    }

    private long getResultIDFromLatestID(long latestSymbolID) throws NoValueException {
        try {
            return this.latestHash.get(latestSymbolID);
        }
        catch (NoValueException e) {
            Symbol resultSymbol;
            if (this.resultSymTab.getSymbol(latestSymbolID) != null) {
                return latestSymbolID;
            }
            Symbol latestSymbol = this.mySymTab.getSymbol(latestSymbolID);
            if (latestSymbol != null && (resultSymbol = SimpleDiffUtility.getSymbol((Symbol)latestSymbol, (Program)this.resultPgm)) != null) {
                return resultSymbol.getID();
            }
            throw e;
        }
    }

    private void showConflictPanel(final ListingMergePanel listingPanel, final int conflictType, int choice, String conflictTypeText) throws CancelledException {
        try {
            final ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    SymbolMerger.this.clearResolveInfo();
                    int chosenConflictOption = SymbolMerger.this.conflictPanel.getSelectedOptions();
                    if (chosenConflictOption == 0) {
                        if (SymbolMerger.this.mergeManager != null) {
                            SymbolMerger.this.mergeManager.setApplyEnabled(false);
                        }
                        return;
                    }
                    if (SymbolMerger.this.mergeManager != null) {
                        SymbolMerger.this.mergeManager.clearStatusText();
                    }
                    try {
                        SymbolMerger.this.mergeConflict(conflictType, chosenConflictOption);
                        if (SymbolMerger.this.mergeManager != null) {
                            SymbolMerger.this.mergeManager.setApplyEnabled(true);
                        }
                    }
                    catch (Exception e1) {
                        String msg = "Failed to resolve symbol '" + (SymbolMerger.this.currentSymbol != null ? SymbolMerger.this.currentSymbol.getName(true) : "") + "'.";
                        Msg.showError((Object)this, null, (String)"Resolve Symbol Error", (Object)msg, (Throwable)e1);
                    }
                    SymbolMerger.this.showResolveInfo();
                }
            };
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    SymbolMerger.this.getConflictPanel(conflictType, changeListener);
                    if (SymbolMerger.this.conflictPanel != null) {
                        listingPanel.setBottomComponent(SymbolMerger.this.conflictPanel);
                    } else {
                        listingPanel.setBottomComponent(SymbolMerger.this.emptyConflictPanel);
                    }
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    listingPanel.clearAllBackgrounds();
                    if (SymbolMerger.this.currentBackgroundSet != null) {
                        listingPanel.paintAllBackgrounds((AddressSetView)SymbolMerger.this.currentBackgroundSet);
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Msg.error((Object)this, (Object)("Couldn't display Symbol Merger conflict panel. " + e.getMessage()));
            return;
        }
        catch (InvocationTargetException e) {
            Msg.error((Object)this, (Object)("Couldn't display Symbol Merger conflict panel. " + e.getMessage()));
            return;
        }
        if (this.listingMergePanel != null) {
            this.conflictInfoPanel.setConflictInfo(this.conflictNum, this.totalConflicts);
        }
        if (this.mergeManager != null) {
            if (this.conflictPanel == null) {
                return;
            }
            this.mergeManager.setApplyEnabled(false);
            boolean useForAll = choice != 0;
            this.conflictPanel.setUseForAll(useForAll);
            this.conflictPanel.setConflictType(conflictTypeText);
            this.mergeManager.showListingMergePanel(this.currentAddress);
        }
        this.conflictOption = this.conflictPanel.getSelectedOptions();
        if (this.conflictOption == -1) {
            throw new CancelledException();
        }
        this.processDeferredRemoves(this.currentMonitor);
    }

    protected VerticalChoicesPanel getConflictPanel(int conflictType, ChangeListener listener) {
        if (this.conflictPanel == null) {
            this.conflictPanel = new VerticalChoicesPanel();
            this.currentConflictPanel = this.conflictPanel;
            this.conflictPanel.setTitle("Symbol");
        }
        switch (conflictType) {
            case 1: {
                return this.getRemoveConflictPanel(this.currentSymbol, listener);
            }
            case 2: {
                return this.getRenameConflictPanel(this.currentSymbol, listener);
            }
            case 3: {
                return this.getNamespaceConflictPanel(this.currentNamespace, this.currentSymbolName, listener);
            }
            case 4: {
                return this.getAddressConflictPanel(this.currentAddress, this.currentSymbolName, listener);
            }
            case 5: {
                return this.getPrimaryConflictPanel(this.currentAddress, listener);
            }
        }
        return null;
    }

    private void mergeConflict(int conflictType, int chosenConflictOption) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        switch (conflictType) {
            case 1: {
                this.resolveRemoveVsChange(this.currentSymbol.getID(), chosenConflictOption);
                break;
            }
            case 2: {
                this.resolveRename(this.currentSymbol.getID(), chosenConflictOption);
                break;
            }
            case 3: 
            case 4: {
                this.mergeSymbol(this.currentSymbol, chosenConflictOption);
                break;
            }
            case 5: {
                this.setPrimary(this.currentAddress, chosenConflictOption);
            }
        }
    }

    private Symbol createSymbol(Program resultProgram, Program sourceProgram, Symbol sourceSymbol) throws DuplicateNameException, InvalidInputException {
        SymbolTable resultSymbolTable = resultProgram.getSymbolTable();
        String resultName = sourceSymbol.getName();
        Address sourceAddress = sourceSymbol.getAddress();
        Namespace resultNamespace = this.getResultNamespace(resultProgram, sourceProgram, sourceSymbol);
        Address resultAddress = null;
        if (!sourceSymbol.isExternal() || sourceAddress == Address.NO_ADDRESS) {
            resultAddress = SimpleDiffUtility.getCompatibleAddress((Program)sourceProgram, (Address)sourceAddress, (Program)resultProgram);
        }
        Symbol resultSymbol = null;
        if (resultAddress != null) {
            resultSymbol = resultSymbolTable.getSymbol(resultName, resultAddress, resultNamespace);
        } else {
            Namespace namespace = resultSymbolTable.getNamespace(resultName, resultNamespace);
            if (namespace != null) {
                resultSymbol = namespace.getSymbol();
            }
        }
        if (resultSymbol == null && (resultSymbol = this.createResultSymbol(sourceSymbol, resultAddress, resultNamespace)) != null && sourceSymbol.isPrimary() && !resultSymbol.isPrimary()) {
            resultSymbol.setPrimary();
        }
        return resultSymbol;
    }

    private Namespace getResultNamespace(Program resultProgram, Program sourceProgram, Symbol sourceSymbol) throws DuplicateNameException, InvalidInputException {
        Symbol resultNsSymbol = null;
        Namespace sourceNamespace = sourceSymbol.getParentNamespace();
        Symbol sourceNsSymbol = sourceNamespace.getSymbol();
        if (sourceProgram == this.myPgm) {
            resultNsSymbol = this.getResultSymbolFromMySymbol(sourceNsSymbol);
        } else if (sourceProgram == this.latestPgm) {
            resultNsSymbol = this.getResultSymbolFromLatestSymbol(sourceNsSymbol);
        } else if (sourceProgram == this.originalPgm) {
            resultNsSymbol = this.getResultSymbolFromOriginalSymbol(sourceNsSymbol);
        }
        Namespace resultNamespace = resultNsSymbol == null ? DiffUtility.getNamespace(sourceSymbol.getParentNamespace(), resultProgram) : (Namespace)resultNsSymbol.getObject();
        if (resultNamespace == null) {
            resultNamespace = this.resolveNamespace(sourceProgram, sourceNamespace);
        }
        return resultNamespace;
    }

    private void replaceSymbol(Program oldProgram, Symbol oldSymbol, Program newProgram, Symbol newSymbol) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        this.renameSymbol(oldProgram, oldSymbol, newProgram, newSymbol);
        if (newSymbol.isPrimary() && !oldSymbol.isPrimary()) {
            oldSymbol.setPrimary();
        }
    }

    private void renameSymbol(Program oldProgram, Symbol oldSymbol, Program newProgram, Symbol newSymbol) throws DuplicateNameException, InvalidInputException, CircularDependencyException {
        block10: {
            SourceType source = newSymbol.getSource();
            String newName = newSymbol.getName();
            Address addressInOldProgram = SimpleDiffUtility.getCompatibleAddress((Program)newProgram, (Address)newSymbol.getAddress(), (Program)oldProgram);
            Namespace namespaceInOldProgram = DiffUtility.getNamespace(newSymbol.getParentNamespace(), oldProgram);
            if (namespaceInOldProgram == null) {
                throw new InvalidInputException("Couldn't get namespace '" + newSymbol.getParentNamespace().toString() + "' in result program.");
            }
            SymbolTable oldSymTab = oldProgram.getSymbolTable();
            Symbol existingSymbol = oldSymTab.getSymbol(newName, addressInOldProgram, namespaceInOldProgram);
            if (oldSymbol == existingSymbol) {
                return;
            }
            String oldName = oldSymbol.getName();
            Namespace oldNamespace = oldSymbol.getParentNamespace();
            boolean nameChanged = !newName.equals(oldName);
            boolean scopeChanged = namespaceInOldProgram != oldNamespace;
            String tempName = null;
            if (nameChanged) {
                try {
                    oldSymbol.setName(newName, source);
                }
                catch (DuplicateNameException e) {
                    tempName = ProgramMerge.getUniqueName(oldSymTab, newName, addressInOldProgram, oldNamespace, namespaceInOldProgram, oldSymbol.getSymbolType());
                    if (tempName == null) {
                        throw e;
                    }
                    oldSymbol.setName(tempName, source);
                }
            }
            if (scopeChanged) {
                oldSymbol.setNamespace(namespaceInOldProgram);
            }
            if (tempName != null) {
                try {
                    oldSymbol.setName(newName, source);
                }
                catch (DuplicateNameException e) {
                    if (tempName.equals(newName)) break block10;
                    this.renamedConflictIDs.add(oldSymbol.getID());
                }
            }
        }
    }

    private void removeMySymbol(Symbol resultSymbol, long myID) {
        if (resultSymbol == null) {
            return;
        }
        Symbol originalSymbol = this.originalSymTab.getSymbol(myID);
        if (originalSymbol != null) {
            this.removeSymbol(resultSymbol, myID);
            return;
        }
        resultSymbol.delete();
        this.myHash.remove(myID);
    }

    private void removeSymbol(Symbol resultSymbol, long originalID) {
        SymbolIterator iter;
        if (resultSymbol == null) {
            return;
        }
        Object obj = resultSymbol.getObject();
        if (obj instanceof Namespace && (iter = this.resultSymTab.getChildren(resultSymbol)).hasNext()) {
            this.deferredRemoveIDs.add(originalID);
            return;
        }
        resultSymbol.delete();
        this.updateResolveIDs(this.originalPgm, originalID, -1L);
        this.incrementProgress(1);
    }

    private void mergeSymbol(Symbol originalOrMySymbol, int chosenConflictOption) {
        long myID = originalOrMySymbol.getID();
        if (chosenConflictOption == 32) {
            long resultID;
            try {
                resultID = this.myHash.get(myID);
            }
            catch (NoValueException e) {
                this.myHash.put(myID, -1L);
                return;
            }
            Symbol resultSymbol = this.resultSymTab.getSymbol(resultID);
            if (resultSymbol != null) {
                this.removeMySymbol(resultSymbol, myID);
            }
        } else if (chosenConflictOption == 64) {
            try {
                this.myHash.get(myID);
                Msg.error((Object)this, (Object)("Error: My symbol '" + originalOrMySymbol.toString() + "' has already been merged."));
                return;
            }
            catch (NoValueException resultID) {
                try {
                    this.renameToMySymbol(originalOrMySymbol);
                }
                catch (Exception e1) {
                    String msg = "Failed to rename '" + originalOrMySymbol.getName(true) + "'.";
                    Msg.showError((Object)this, null, (String)"Rename Symbol Error", (Object)msg, (Throwable)e1);
                }
            }
        }
    }

    private void renameToMySymbol(Symbol mySymbol) throws DuplicateNameException, InvalidInputException {
        long myID = mySymbol.getID();
        String myName = mySymbol.getName();
        Address myAddr = mySymbol.getAddress();
        Namespace myNamespace = mySymbol.getParentNamespace();
        SymbolType myType = mySymbol.getSymbolType();
        Object myObject = mySymbol.getObject();
        Address resultAddress = SimpleDiffUtility.getCompatibleAddress((Program)this.myPgm, (Address)myAddr, (Program)this.resultPgm);
        Namespace resultNamespace = this.resolveNamespace(this.myPgm, myNamespace);
        String tempUniqueName = ProgramMerge.getUniqueName(this.resultSymTab, myName, resultAddress, resultNamespace, myType);
        Symbol resultSymbol = null;
        if (myType == SymbolType.FUNCTION) {
            Function myFunction = (Function)myObject;
            Function f = DiffUtility.getFunction(myFunction, this.resultPgm);
            if (f != null) {
                f.setName(tempUniqueName, mySymbol.getSource());
                resultSymbol = f.getSymbol();
            }
        } else {
            resultSymbol = this.createSymbol(tempUniqueName, myType, resultAddress, resultNamespace, this.myPgm, myID, mySymbol.getSource());
        }
        if (resultSymbol != null) {
            this.myHash.put(myID, resultSymbol.getID());
        }
    }

    public String[] getPath(String name, Namespace namespace) {
        String[] namespacePath = namespace.getSymbol().getPath();
        String[] path = new String[namespacePath.length + 1];
        System.arraycopy(namespacePath, 0, path, 0, namespacePath.length);
        path[namespacePath.length] = name;
        return path;
    }

    private Symbol createSymbol(String name, SymbolType type, Address resultAddr, Namespace resultParentNs, Program srcPgm, long srcSymID, SourceType source) throws DuplicateNameException, InvalidInputException {
        Symbol symbol = null;
        if (type == SymbolType.CODE) {
            symbol = this.resultSymTab.createLabel(resultAddr, name, resultParentNs, source);
        } else if (type == SymbolType.CLASS) {
            GhidraClass newGhidraClass = this.resultSymTab.createClass(resultParentNs, name, source);
            symbol = newGhidraClass.getSymbol();
        } else if (type == SymbolType.NAMESPACE) {
            Namespace newNamespace = this.resultSymTab.createNameSpace(resultParentNs, name, source);
            symbol = newNamespace.getSymbol();
        } else if (type == SymbolType.LIBRARY) {
            ExternalManager srcExtMgr = srcPgm.getExternalManager();
            String path = srcExtMgr.getExternalLibraryPath(name);
            ExternalManagerDB extMgr = (ExternalManagerDB)this.resultPgm.getExternalManager();
            extMgr.setExternalPath(name, path, source == SourceType.USER_DEFINED);
            symbol = this.resultSymTab.getLibrarySymbol(name);
        }
        if (symbol != null && symbol.getParentNamespace().equals(resultParentNs)) {
            long resolveSymID = symbol.getID();
            this.updateResolveIDs(srcPgm, srcSymID, resolveSymID);
        }
        return symbol;
    }

    private void updateResolveIDs(Program srcPgm, long srcSymID, long resolveSymID) {
        int pgmIndex = this.getProgramIndex(srcPgm);
        if (this.originalSymTab.getSymbol(srcSymID) != null) {
            this.latestHash.put(srcSymID, resolveSymID);
            this.myHash.put(srcSymID, resolveSymID);
            this.originalHash.put(srcSymID, resolveSymID);
        } else {
            switch (pgmIndex) {
                case 1: {
                    this.latestHash.put(srcSymID, resolveSymID);
                    break;
                }
                case 2: {
                    this.myHash.put(srcSymID, resolveSymID);
                }
            }
        }
    }

    private Symbol createResultSymbol(Symbol originalSymbol, Address address, Namespace namespace) throws DuplicateNameException, InvalidInputException {
        Symbol resultSymbol = null;
        SymbolType symType = originalSymbol.getSymbolType();
        String symbolName = originalSymbol.getName();
        SourceType source = originalSymbol.getSource();
        if (symType == SymbolType.CODE) {
            if (originalSymbol.isExternal()) {
                ExternalManager resultExternalManager = this.resultPgm.getExternalManager();
                ExternalLocation resultExtLocation = resultExternalManager.addExtLocation(namespace, symbolName, address, source);
                resultSymbol = resultExtLocation.getSymbol();
            } else {
                resultSymbol = this.resultSymTab.createLabel(address, symbolName, namespace, source);
            }
        } else if (symType == SymbolType.CLASS) {
            GhidraClass newGhidraClass = this.resultSymTab.createClass(namespace, symbolName, source);
            resultSymbol = newGhidraClass.getSymbol();
        } else if (symType == SymbolType.LIBRARY) {
            this.resultSymTab.createExternalLibrary(symbolName, source);
        } else if (symType == SymbolType.NAMESPACE) {
            Namespace newNamespace = this.resultSymTab.createNameSpace(namespace, symbolName, source);
            resultSymbol = newNamespace.getSymbol();
        }
        return resultSymbol;
    }

    private void setPrimary(Address addr, int conflictOption) {
        Symbol primary = null;
        switch (conflictOption) {
            case 2: {
                primary = this.getResultSymbolFromLatestSymbol(this.latestSymTab.getPrimarySymbol(addr));
                break;
            }
            case 4: {
                primary = this.getResultSymbolFromMySymbol(this.mySymTab.getPrimarySymbol(addr));
                break;
            }
            case 1: {
                primary = this.getResultSymbolFromOriginalSymbol(this.originalSymTab.getPrimarySymbol(addr));
            }
        }
        if (primary != null && !primary.isPrimary()) {
            primary.setPrimary();
        }
    }

    protected VerticalChoicesPanel getRemoveConflictPanel(Symbol symbol, ChangeListener listener) {
        long symbolID = symbol.getID();
        String text = "Symbol '" + ConflictUtility.getEmphasizeString(symbol.getName(true)) + "' @ address " + ConflictUtility.getAddressString(symbol.getAddress()) + "' was removed in one version and changed in other.";
        this.conflictPanel.clear();
        this.conflictPanel.setHeader(text);
        this.conflictPanel.setRowHeader(this.getSymbolInfo(null, null));
        Symbol latestSymbol = this.latestPgm.getSymbolTable().getSymbol(symbolID);
        Symbol mySymbol = this.myPgm.getSymbolTable().getSymbol(symbolID);
        String latestPrefix = latestSymbol == null ? "Remove as in '" : "Change as in '";
        String myPrefix = mySymbol == null ? "Remove as in '" : "Change as in '";
        String suffix = "' version";
        this.conflictPanel.addRadioButtonRow(this.getSymbolInfo(this.latestPgm, latestSymbol, latestPrefix, suffix), "LatestVersionRB", 2, listener);
        this.conflictPanel.addRadioButtonRow(this.getSymbolInfo(this.myPgm, mySymbol, myPrefix, suffix), "CheckedOutVersionRB", 4, listener);
        this.conflictPanel.addInfoRow(this.getSymbolInfo(this.originalPgm, symbolID, "'", suffix));
        return this.conflictPanel;
    }

    protected VerticalChoicesPanel getRenameConflictPanel(Symbol symbol, ChangeListener listener) {
        long symbolID = symbol.getID();
        String text = "Symbol: " + ConflictUtility.getEmphasizeString(symbol.getName(true)) + ConflictUtility.spaces(4) + "Address: " + ConflictUtility.getAddressString(symbol.getAddress());
        this.conflictPanel.clear();
        this.conflictPanel.setHeader(text);
        this.conflictPanel.setRowHeader(this.getSymbolInfo(null, null));
        String prefix = "Rename as in '";
        String suffix = "' version";
        this.conflictPanel.addRadioButtonRow(this.getSymbolInfo(this.latestPgm, symbolID, prefix, suffix), "LatestVersionRB", 2, listener);
        this.conflictPanel.addRadioButtonRow(this.getSymbolInfo(this.myPgm, symbolID, prefix, suffix), "CheckedOutVersionRB", 4, listener);
        this.conflictPanel.addInfoRow(this.getSymbolInfo(this.originalPgm, symbolID, "'", suffix));
        return this.conflictPanel;
    }

    protected VerticalChoicesPanel getNamespaceConflictPanel(Namespace myNamespace, String symbolName, ChangeListener listener) {
        Symbol latest = this.latestSymTab.getNamespace(symbolName, DiffUtility.getNamespace(myNamespace, this.latestPgm)).getSymbol();
        Symbol my = this.mySymTab.getNamespace(symbolName, myNamespace).getSymbol();
        String text = "Namespace Conflict";
        this.conflictPanel.clear();
        this.conflictPanel.setHeader(text);
        this.conflictPanel.setRowHeader(this.getSymbolInfo(null, my));
        String prefix = "'";
        String suffix = "' version";
        this.conflictPanel.addInfoRow(this.getSymbolInfo(this.latestPgm, latest, prefix, suffix));
        this.conflictPanel.addInfoRow(this.getSymbolInfo(this.myPgm, my, prefix, suffix));
        String removeMsg = "Discard 'Checked Out' symbol";
        String renameMsg = "Rename 'Checked Out' symbol to '" + this.uniqueName + "'";
        this.conflictPanel.addRadioButtonRow(new String[]{removeMsg}, "RemoveCheckedOutRB", 32, listener);
        this.conflictPanel.addRadioButtonRow(new String[]{renameMsg}, "RenameCheckedOutRB", 64, listener);
        return this.conflictPanel;
    }

    protected VerticalChoicesPanel getAddressConflictPanel(Address address, String symbolName, ChangeListener listener) {
        Symbol my = this.currentSymbol;
        Namespace latestNamespace = DiffUtility.getNamespace(this.currentNamespace, this.latestPgm);
        Symbol latest = this.latestSymTab.getSymbol(symbolName, this.currentAddress, latestNamespace);
        String text = "Symbol Name Conflict @ " + ConflictUtility.getAddressString(this.currentAddress) + "<br>Can't have symbols with same name and different scope at an address.";
        this.conflictPanel.clear();
        this.conflictPanel.setHeader(text);
        this.conflictPanel.setRowHeader(this.getSymbolInfo(null, my));
        String prefix = "'";
        String suffix = "' version";
        this.conflictPanel.addInfoRow(this.getSymbolInfo(this.latestPgm, latest, prefix, suffix));
        this.conflictPanel.addInfoRow(this.getSymbolInfo(this.myPgm, my, prefix, suffix));
        this.conflictPanel.addInfoRow(new String[]{"", "", "", "", "", "", ""});
        String removeMsg = "Discard 'Checked Out' symbol";
        String renameMsg = "Rename 'Checked Out' symbol to '" + this.uniqueName + "'";
        this.conflictPanel.addRadioButtonRow(new String[]{removeMsg, "", "", "", "", "", ""}, "RemoveCheckedOutRB", 32, listener);
        this.conflictPanel.addRadioButtonRow(new String[]{renameMsg, "", "", "", "", "", ""}, "RenameCheckedOutRB", 64, listener);
        return this.conflictPanel;
    }

    private VerticalChoicesPanel getPrimaryConflictPanel(Address address, ChangeListener listener) {
        Symbol original = this.originalSymTab.getPrimarySymbol(address);
        Symbol latest = this.latestSymTab.getPrimarySymbol(address);
        Symbol my = this.mySymTab.getPrimarySymbol(address);
        try {
            latest = this.resultSymTab.getSymbol(this.getResultIDFromLatestID(latest.getID()));
        }
        catch (NoValueException e) {
            this.conflictPanel = null;
            return null;
        }
        try {
            my = this.resultSymTab.getSymbol(this.getResultIDFromMyID(my.getID()));
        }
        catch (NoValueException e) {
            this.conflictPanel = null;
            return null;
        }
        String text = "Primary Symbol Conflict";
        this.conflictPanel.clear();
        this.conflictPanel.setHeader(text);
        this.conflictPanel.setRowHeader(this.getPrimarySymbolInfo(null, null, null, null));
        this.conflictPanel.addRadioButtonRow(this.getPrimarySymbolInfo(this.latestPgm, latest, "Set '", "' to primary"), "LatestVersionRB", 2, listener);
        this.conflictPanel.addRadioButtonRow(this.getPrimarySymbolInfo(this.myPgm, my, "Set '", "' to primary"), "CheckedOutVersionRB", 4, listener);
        this.conflictPanel.addInfoRow(this.getPrimarySymbolInfo(this.originalPgm, original, "'", "' version"));
        return this.conflictPanel;
    }

    private String[] getSymbolInfo(Program pgm, long id, String prefix, String suffix) {
        Symbol s = pgm != null ? pgm.getSymbolTable().getSymbol(id) : null;
        return this.getSymbolInfo(pgm, s, prefix, suffix);
    }

    private String[] getSymbolInfo(Program pgm, Symbol s) {
        return this.getSymbolInfo(pgm, s, "", "");
    }

    private String[] getSymbolInfo(Program pgm, Symbol s, String prefix, String suffix) {
        if (pgm == null) {
            return new String[]{"Option", "Symbol", "Scope", "Address", "Type", "Primary", "Source"};
        }
        String[] info = new String[]{"", "", "", "", "", "", ""};
        String version = "";
        if (pgm == this.originalPgm) {
            version = "Original";
        } else if (pgm == this.latestPgm) {
            version = "Latest";
        } else if (pgm == this.myPgm) {
            version = "Checked Out";
        } else if (pgm == this.resultPgm) {
            version = "Result";
        }
        info[0] = prefix + version + suffix;
        if (s != null) {
            info[1] = s.getName(false);
            info[2] = s.getParentNamespace().getSymbol().getName();
            info[3] = s.getAddress().toString();
            info[4] = s.getSymbolType().toString();
            info[5] = "" + s.isPrimary();
            info[6] = s.getSource().toString();
        }
        return info;
    }

    private String[] getPrimarySymbolInfo(Program pgm, Symbol s, String prefix, String suffix) {
        if (pgm == null) {
            return new String[]{"Option", "Symbol", "Scope", "Address", "Type", "Source"};
        }
        String[] info = new String[]{"", "", "", "", "", ""};
        String version = "";
        if (pgm == this.originalPgm) {
            version = "Original";
        } else if (pgm == this.latestPgm) {
            version = "Latest";
        } else if (pgm == this.myPgm) {
            version = "Checked Out";
        } else if (pgm == this.resultPgm) {
            version = "Result";
        }
        info[0] = prefix + version + suffix;
        if (s != null) {
            info[1] = s.getName(false);
            info[2] = s.getParentNamespace().getSymbol().getName();
            Address symbolAddress = s.getAddress();
            if (s.isExternal()) {
                ExternalManager externalManager = pgm.getExternalManager();
                ExternalLocation externalLocation = externalManager.getExternalLocation(s);
                symbolAddress = externalLocation.getAddress();
            }
            info[3] = symbolAddress != null ? symbolAddress.toString() : "";
            info[4] = s.getSymbolType().toString();
            info[5] = s.getSource().toString();
        }
        return info;
    }

    private class LongHashSet
    extends HashSet<Long> {
        private static final long serialVersionUID = 1L;

        private LongHashSet() {
        }

        @Override
        public boolean add(long l) {
            return super.add(new Long(l));
        }

        public boolean contains(long l) {
            return super.contains(new Long(l));
        }

        public boolean remove(long l) {
            return super.remove(new Long(l));
        }
    }

    protected static enum SymbolConflictType {
        ADDRESS_SYMBOL_CONFLICT,
        PRIMARY_SYMBOL_CONFLICT,
        REMOVE_SYMBOL_CONFLICT,
        RENAME_SYMBOL_CONFLICT;

    }
}

