/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.memory;

import ghidra.app.merge.ProgramMultiUserMergeManager;
import ghidra.app.merge.memory.BlockConflictPanel;
import ghidra.app.merge.memory.CommentsConflictPanel;
import ghidra.app.merge.util.ConflictCountPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MemoryMergePanel
extends JPanel {
    private ProgramMultiUserMergeManager mergeManager;
    private int totalConflicts;
    private ConflictCountPanel countPanel;
    private CommentsConflictPanel commentPanel;
    private BlockConflictPanel namePanel;
    private CardLayout cardLayout;
    private JPanel cardPanel;
    private JPanel currentPanel;
    private static final String USE_FOR_ALL_CHECKBOX = "UseForAllConflictCheckBox";
    private JCheckBox useForAllCB;
    static String COMMENT_PANEL_ID = "Comment Conflict";
    static String CONFLICT_PANEL_ID = "Block Conflict";
    static final String LATEST_BUTTON_NAME = "Latest";
    static final String MY_BUTTON_NAME = "Checked Out";
    static final String ORIGINAL_BUTTON_NAME = "Original";

    MemoryMergePanel(ProgramMultiUserMergeManager mergeManager, int totalConflicts) {
        super(new BorderLayout());
        this.mergeManager = mergeManager;
        this.totalConflicts = totalConflicts;
        this.create();
    }

    void setConflictInfo(int conflictIndex, String panelID, String title, String latestStr, String myStr, String origStr) {
        this.countPanel.updateCount(conflictIndex, this.totalConflicts);
        this.cardPanel.setBorder(BorderFactory.createTitledBorder(title));
        if (panelID == COMMENT_PANEL_ID) {
            this.cardLayout.show(this.cardPanel, COMMENT_PANEL_ID);
            this.currentPanel = this.commentPanel;
            this.commentPanel.setComments(latestStr, myStr, origStr);
        } else {
            this.cardLayout.show(this.cardPanel, CONFLICT_PANEL_ID);
            this.currentPanel = this.namePanel;
            this.namePanel.setConflictInfo(latestStr, myStr, origStr);
        }
    }

    int getSelectedOption() {
        return this.currentPanel == this.commentPanel ? this.commentPanel.getSelectedOption() : this.namePanel.getSelectedOption();
    }

    private void create() {
        this.setLayout(new BorderLayout());
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BoxLayout(boxPanel, 1));
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.cardPanel.setBorder(BorderFactory.createTitledBorder("Resolve Block Conflict"));
        ChangeListener listener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MemoryMergePanel.this.mergeManager.setApplyEnabled(true);
            }
        };
        this.commentPanel = new CommentsConflictPanel(listener);
        this.cardPanel.add((Component)this.commentPanel, COMMENT_PANEL_ID);
        this.namePanel = new BlockConflictPanel(listener);
        this.cardPanel.add((Component)this.namePanel, CONFLICT_PANEL_ID);
        this.cardLayout.show(this.cardPanel, CONFLICT_PANEL_ID);
        this.countPanel = new ConflictCountPanel();
        boxPanel.add(this.countPanel);
        boxPanel.add(Box.createVerticalStrut(10));
        boxPanel.add(this.cardPanel);
        this.add((Component)boxPanel, "Center");
        this.add((Component)this.createUseForAllCheckBox(), "South");
    }

    private JCheckBox createUseForAllCheckBox() {
        this.useForAllCB = new JCheckBox(this.getUseAllString("Memory Block"));
        this.useForAllCB.setName(USE_FOR_ALL_CHECKBOX);
        return this.useForAllCB;
    }

    private String getUseAllString(String conflictType) {
        return "Use the selected option for resolving all remaining '" + conflictType + "' conflicts.";
    }

    void setUseForAll(boolean useForAll) {
        this.useForAllCB.setSelected(useForAll);
    }

    boolean getUseForAll() {
        return this.useForAllCB.isSelected();
    }
}

