/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.util.GraphicsUtils;
import docking.widgets.dialogs.NumberInputDialog;
import docking.widgets.tree.AbstractGTreeRootNode;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRootNode;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.support.GTreeSelectionListener;
import docking.widgets.tree.tasks.GTreeExpandAllTask;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.plugin.core.calltree.CallNode;
import ghidra.app.plugin.core.calltree.CallTreePlugin;
import ghidra.app.plugin.core.calltree.IncomingCallsRootNode;
import ghidra.app.plugin.core.calltree.OutgoingCallsRootNode;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.preferences.Preferences;
import ghidra.program.database.symbol.FunctionSymbol;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import resources.Icons;
import resources.ResourceManager;

public class CallTreeProvider
extends ComponentProviderAdapter
implements DomainObjectListener {
    static final String EXPAND_ACTION_NAME = "Fully Expand Selected Nodes";
    private static final String TITLE = "Function Call Trees";
    private static final Icon EMPTY_ICON = ResourceManager.loadImage((String)"images/EmptyIcon16.gif");
    private static final Icon EXPAND_ICON = Icons.EXPAND_ALL_ICON;
    private static final Icon COLLAPSE_ICON = Icons.COLLAPSE_ALL_ICON;
    private static ImageIcon REFRESH_ICON = Icons.REFRESH_ICON;
    private static Icon REFRESH_NOT_NEEDED_ICON = ResourceManager.getDisabledIcon((Icon)REFRESH_ICON, (int)60);
    private static final String RECURSE_DEPTH_PROPERTY_NAME = "call.tree.recurse.depth";
    private static final String DEFAULT_RECURSE_DEPTH = "5";
    private final CallTreePlugin plugin;
    private JComponent component;
    private JSplitPane splitPane;
    private GTree incomingTree;
    private GTree outgoingTree;
    private SwingUpdateManager reloadUpdateManager = new SwingUpdateManager(500, () -> this.doUpdate());
    private Program currentProgram;
    private Function currentFunction;
    private DockingAction recurseDepthAction;
    private ToggleDockingAction filterDuplicates;
    private ToggleDockingAction navigationOutgoingAction;
    private ToggleDockingAction navigateIncomingToggleAction;
    private DockingAction refreshAction;
    private boolean isFiringNavigationEvent;
    private AtomicInteger recurseDepth = new AtomicInteger();
    private NumberIcon recurseIcon;

    public CallTreeProvider(CallTreePlugin plugin) {
        super(plugin.getTool(), TITLE, plugin.getName());
        this.plugin = plugin;
        this.component = this.buildComponent();
        this.component.setPreferredSize(new Dimension(800, 400));
        this.setTransient();
        this.setWindowMenuGroup(TITLE);
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setIcon(CallTreePlugin.PROVIDER_ICON);
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Call_Tree_Plugin"));
        this.addToTool();
        this.loadRecurseDepthPreference();
        this.createActions();
    }

    private void createActions() {
        String expandMenu = Integer.toString(1);
        String selectionMenuGroup = Integer.toString(2);
        String goToMenu = Integer.toString(3);
        String newTreeMenu = Integer.toString(4);
        String homeToolbarGroup = Integer.toString(1);
        String filterOptionsToolbarGroup = Integer.toString(2);
        String navigationOptionsToolbarGroup = Integer.toString(3);
        DockingAction fullyExpandNodesAction = new DockingAction(EXPAND_ACTION_NAME, this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                TreePath[] paths;
                Object contextObject = context.getContextObject();
                GTree gTree = (GTree)contextObject;
                for (TreePath treePath : paths = gTree.getSelectionPaths()) {
                    GTreeNode node = (GTreeNode)treePath.getLastPathComponent();
                    gTree.runTask((GTreeTask)new ExpandToDepthTask(gTree, node, CallTreeProvider.this.recurseDepth.get()));
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == CallTreeProvider.this.outgoingTree || contextObject == CallTreeProvider.this.incomingTree;
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                return contextObject == CallTreeProvider.this.outgoingTree || contextObject == CallTreeProvider.this.incomingTree;
            }
        };
        fullyExpandNodesAction.setPopupMenuData(new MenuData(new String[]{"Expand Nodes to Depth Limit"}, EXPAND_ICON, expandMenu));
        fullyExpandNodesAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Context_Action_Expand_Nodes"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)fullyExpandNodesAction);
        DockingAction collapseAllNodesAction = new DockingAction("Collapse All", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                Object contextObject = context.getContextObject();
                GTree gTree = (GTree)contextObject;
                GTreeRootNode rootNode = gTree.getRootNode();
                List children = rootNode.getChildren();
                for (GTreeNode child : children) {
                    gTree.collapseAll(child);
                }
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (contextObject != CallTreeProvider.this.outgoingTree && contextObject != CallTreeProvider.this.incomingTree) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                if (gTree.getSelectionPaths().length != 1) {
                    return false;
                }
                TreePath path = gTree.getSelectionPath();
                if (path == null) {
                    return false;
                }
                GTreeNode node = (GTreeNode)path.getLastPathComponent();
                return node instanceof CallNode;
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GTree)) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                return selectionPaths.length != 0;
            }
        };
        collapseAllNodesAction.setPopupMenuData(new MenuData(new String[]{"Collapse All Nodes"}, COLLAPSE_ICON, expandMenu));
        collapseAllNodesAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Context_Action_Collapse_Nodes"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)collapseAllNodesAction);
        DockingAction goToDestinationAction = new DockingAction("Go To Destination", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                Object contextObject = context.getContextObject();
                GTree gTree = (GTree)contextObject;
                TreePath path = gTree.getSelectionPath();
                CallNode node = (CallNode)((Object)path.getLastPathComponent());
                CallTreeProvider.this.goTo(node.getLocation());
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (contextObject != CallTreeProvider.this.outgoingTree) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                if (gTree.getSelectionPaths().length != 1) {
                    return false;
                }
                TreePath path = gTree.getSelectionPath();
                if (path == null) {
                    return false;
                }
                GTreeNode node = (GTreeNode)path.getLastPathComponent();
                return node instanceof CallNode;
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GTree)) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                if (selectionPaths.length == 0) {
                    return false;
                }
                for (TreePath path : selectionPaths) {
                    GTreeNode node = (GTreeNode)path.getLastPathComponent();
                    if (!(node instanceof GTreeRootNode)) continue;
                    return false;
                }
                return true;
            }
        };
        goToDestinationAction.setPopupMenuData(new MenuData(new String[]{"Go To Call Destination"}, goToMenu));
        goToDestinationAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Context_Action_Goto_Destination"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)goToDestinationAction);
        DockingAction goToSourceAction = new DockingAction("Go To Source", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                Object contextObject = context.getContextObject();
                GTree gTree = (GTree)contextObject;
                TreePath path = gTree.getSelectionPath();
                CallNode node = (CallNode)((Object)path.getLastPathComponent());
                CallTreeProvider.this.goTo(new ProgramLocation(CallTreeProvider.this.currentProgram, node.getSourceAddress()));
            }

            public boolean isEnabledForContext(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GTree)) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                if (gTree.getSelectionPaths().length != 1) {
                    return false;
                }
                TreePath path = gTree.getSelectionPath();
                if (path == null) {
                    return false;
                }
                GTreeNode node = (GTreeNode)path.getLastPathComponent();
                return node instanceof CallNode;
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GTree)) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                if (selectionPaths.length == 0) {
                    return false;
                }
                for (TreePath path : selectionPaths) {
                    GTreeNode node = (GTreeNode)path.getLastPathComponent();
                    if (!(node instanceof GTreeRootNode)) continue;
                    return false;
                }
                return true;
            }
        };
        goToSourceAction.setPopupMenuData(new MenuData(new String[]{"Go To Call Source"}, goToMenu));
        goToSourceAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Context_Action_Goto_Source"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)goToSourceAction);
        this.filterDuplicates = new ToggleDockingAction("Filter Duplicates", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                CallTreeProvider.this.doUpdate();
            }
        };
        this.filterDuplicates.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/application_double.png"), filterOptionsToolbarGroup, "1"));
        this.filterDuplicates.setSelected(true);
        this.filterDuplicates.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Action_Filter"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.filterDuplicates);
        this.recurseDepthAction = new DockingAction("Recurse Depth", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                NumberInputDialog dialog = new NumberInputDialog("", "", Integer.valueOf(CallTreeProvider.this.recurseDepth.get()), 0, Integer.MAX_VALUE, false);
                if (!dialog.show()) {
                    return;
                }
                int newValue = dialog.getValue();
                CallTreeProvider.this.setRecurseDepth(newValue);
            }
        };
        this.recurseDepthAction.setDescription("<html>Recurse Depth<br><br>Limits the depth to which recursing tree operations<br> will go.  Example operations include <b>Expand All</b> and filtering");
        this.recurseIcon = new NumberIcon(this.recurseDepth.get());
        this.recurseDepthAction.setToolBarData(new ToolBarData((Icon)this.recurseIcon, filterOptionsToolbarGroup, "2"));
        this.recurseDepthAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Action_Recurse_Depth"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.recurseDepthAction);
        this.navigationOutgoingAction = new ToggleDockingAction("Navigate Outgoing Nodes", this.plugin.getName()){};
        this.navigationOutgoingAction.setSelected(true);
        this.navigationOutgoingAction.setDescription("<html>Outgoing Navigation<br><br>Toggled <b>on</b> triggers node selections<br>in the tree to navigate the Listing to<br>the <b>source</b> location of the call");
        this.navigationOutgoingAction.setToolBarData(new ToolBarData((Icon)Icons.NAVIGATE_ON_OUTGOING_EVENT_ICON, navigationOptionsToolbarGroup, "1"));
        this.navigationOutgoingAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Action_Navigation"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.navigationOutgoingAction);
        this.navigateIncomingToggleAction = new ToggleDockingAction("Navigation Incoming Location Changes", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
            }

            public void setSelected(boolean newValue) {
                super.setSelected(newValue);
                if (this.isSelected()) {
                    CallTreeProvider.this.setLocation(CallTreeProvider.this.plugin.getCurrentLocation());
                }
            }
        };
        this.navigateIncomingToggleAction.setSelected(false);
        this.navigateIncomingToggleAction.setToolBarData(new ToolBarData((Icon)Icons.NAVIGATE_ON_INCOMING_EVENT_ICON, navigationOptionsToolbarGroup, "2"));
        this.navigateIncomingToggleAction.setDescription(HTMLUtilities.toHTML((String)"Incoming Navigation<br><br>Toggle <b>On</b>  - change the displayed function on Listing navigation events<br>Toggled <b>Off</b> - don't change the displayed function on Listing navigation events"));
        this.navigateIncomingToggleAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Action_Incoming_Navigation"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.navigateIncomingToggleAction);
        DockingAction selectSourceAction = new DockingAction("Select Call Source", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GTree gTree = (GTree)context.getContextObject();
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                CallTreeProvider.this.makeSelectionFromPaths(selectionPaths, true);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (CallTreeProvider.this.currentFunction == null) {
                    return false;
                }
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GTree)) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                return selectionPaths.length > 0;
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GTree)) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                if (selectionPaths.length == 0) {
                    return false;
                }
                for (TreePath path : selectionPaths) {
                    GTreeNode node = (GTreeNode)path.getLastPathComponent();
                    if (!(node instanceof GTreeRootNode)) continue;
                    return false;
                }
                return true;
            }
        };
        ImageIcon icon = ResourceManager.loadImage((String)"images/text_align_justify.png");
        selectSourceAction.setPopupMenuData(new MenuData(new String[]{"Select Call Source"}, (Icon)icon, selectionMenuGroup));
        selectSourceAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Context_Action_Select_Source"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)selectSourceAction);
        DockingAction selectDestinationAction = new DockingAction("Select Call Destination", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GTree gTree = (GTree)context.getContextObject();
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                CallTreeProvider.this.makeSelectionFromPaths(selectionPaths, false);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (CallTreeProvider.this.currentFunction == null) {
                    return false;
                }
                Object contextObject = context.getContextObject();
                if (contextObject != CallTreeProvider.this.outgoingTree) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                return selectionPaths.length > 0;
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GTree)) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                if (selectionPaths.length == 0) {
                    return false;
                }
                for (TreePath path : selectionPaths) {
                    GTreeNode node = (GTreeNode)path.getLastPathComponent();
                    if (!(node instanceof GTreeRootNode)) continue;
                    return false;
                }
                return this.isEnabledForContext(context);
            }
        };
        selectDestinationAction.setPopupMenuData(new MenuData(new String[]{"Select Call Destination"}, (Icon)icon, selectionMenuGroup));
        selectDestinationAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Context_Action_Select_Destination"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)selectDestinationAction);
        DockingAction homeAction = new DockingAction("Home", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                FunctionSignatureFieldLocation location = new FunctionSignatureFieldLocation(CallTreeProvider.this.currentProgram, CallTreeProvider.this.currentFunction.getEntryPoint());
                CallTreeProvider.this.goTo((ProgramLocation)location);
            }

            public boolean isEnabledForContext(ActionContext context) {
                return CallTreeProvider.this.currentFunction != null;
            }
        };
        homeAction.setToolBarData(new ToolBarData((Icon)ResourceManager.loadImage((String)"images/go-home.png"), homeToolbarGroup));
        homeAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Action_Home"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)homeAction);
        this.refreshAction = new DockingAction("Refresh", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                CallTreeProvider.this.reloadUpdateManager.updateNow();
            }
        };
        this.refreshAction.setToolBarData(new ToolBarData(REFRESH_NOT_NEEDED_ICON, homeToolbarGroup));
        this.refreshAction.setEnabled(true);
        this.refreshAction.setDescription("<html>Push at any time to refresh the current trees.<br>This is highlighted when the data <i>may</i> be stale.<br>");
        this.refreshAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Action_Refresh"));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.refreshAction);
        DockingAction newCallTree = new DockingAction("Show Call Tree For Function", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                GTree gTree = (GTree)context.getContextObject();
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                CallNode callNode = (CallNode)((Object)selectionPaths[0].getLastPathComponent());
                ProgramLocation location = null;
                location = gTree == CallTreeProvider.this.incomingTree ? new ProgramLocation(CallTreeProvider.this.currentProgram, callNode.getSourceAddress()) : callNode.getLocation();
                CallTreeProvider.this.plugin.showOrCreateNewCallTree(location);
            }

            public boolean isEnabledForContext(ActionContext context) {
                if (CallTreeProvider.this.currentFunction == null) {
                    return false;
                }
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GTree)) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                return selectionPaths.length == 1;
            }

            public boolean isAddToPopup(ActionContext context) {
                Object contextObject = context.getContextObject();
                if (!(contextObject instanceof GTree)) {
                    return false;
                }
                GTree gTree = (GTree)contextObject;
                TreePath[] selectionPaths = gTree.getSelectionPaths();
                if (selectionPaths.length == 0) {
                    return false;
                }
                for (TreePath path : selectionPaths) {
                    GTreeNode node = (GTreeNode)path.getLastPathComponent();
                    if (!(node instanceof GTreeRootNode)) continue;
                    return false;
                }
                return true;
            }
        };
        newCallTree.setHelpLocation(new HelpLocation(this.plugin.getName(), "Call_Tree_Context_Action_Show_Call_Tree_For_Function"));
        newCallTree.setPopupMenuData(new MenuData(new String[]{"Show Call Tree For Function"}, CallTreePlugin.PROVIDER_ICON, newTreeMenu));
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)newCallTree);
    }

    private void makeSelectionFromPaths(TreePath[] paths, boolean selectSource) {
        AddressSet set = new AddressSet();
        for (TreePath path : paths) {
            CallNode callNode = (CallNode)((Object)path.getLastPathComponent());
            Address address = null;
            address = selectSource ? callNode.getSourceAddress() : callNode.getLocation().getAddress();
            set.addRange(address, address);
        }
        ProgramSelection selection = new ProgramSelection((AddressSetView)set);
        this.tool.firePluginEvent((PluginEvent)new ProgramSelectionPluginEvent(this.plugin.getName(), selection, this.currentProgram));
    }

    private void goTo(ProgramLocation location) {
        this.isFiringNavigationEvent = true;
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        if (goToService != null) {
            goToService.goTo(location);
            this.isFiringNavigationEvent = false;
            return;
        }
        this.plugin.firePluginEvent(new ProgramLocationPluginEvent(this.getName(), location, this.currentProgram));
        this.isFiringNavigationEvent = false;
    }

    public ActionContext getActionContext(MouseEvent e) {
        if (e == null) {
            return new ActionContext((ComponentProvider)this, (Object)this.getActiveComponent());
        }
        Object source = e.getSource();
        if (source instanceof JTree) {
            JTree jTree = (JTree)source;
            GTree gTree = this.incomingTree;
            if (this.outgoingTree.isMyJTree(jTree)) {
                gTree = this.outgoingTree;
            }
            return new ActionContext((ComponentProvider)this, (Object)gTree);
        }
        return null;
    }

    private Component getActiveComponent() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = manager.getFocusOwner();
        if (focusOwner == null) {
            return this.component;
        }
        if (SwingUtilities.isDescendingFrom(focusOwner, (Component)this.outgoingTree)) {
            return this.outgoingTree;
        }
        if (SwingUtilities.isDescendingFrom(focusOwner, (Component)this.incomingTree)) {
            return this.incomingTree;
        }
        return this.component;
    }

    private JComponent buildComponent() {
        JPanel container = new JPanel(new BorderLayout());
        this.splitPane = new JSplitPane(1);
        this.incomingTree = this.createTree();
        this.outgoingTree = this.createTree();
        GTreeSelectionListener treeSelectionListener = e -> {
            if (e.getEventOrigin() != GTreeSelectionEvent.EventOrigin.USER_GENERATED) {
                return;
            }
            if (!this.navigationOutgoingAction.isSelected()) {
                return;
            }
            if (this.currentFunction == null) {
                return;
            }
            TreePath path = e.getPath();
            if (path == null) {
                return;
            }
            CallNode node = (CallNode)((Object)((Object)path.getLastPathComponent()));
            Address sourceAddress = node.getSourceAddress();
            this.goTo(new ProgramLocation(this.currentProgram, sourceAddress));
        };
        this.outgoingTree.addGTreeSelectionListener(treeSelectionListener);
        this.incomingTree.addGTreeSelectionListener(treeSelectionListener);
        GTreeSelectionListener contextSelectionListener = e -> this.notifyContextChanged();
        this.incomingTree.addGTreeSelectionListener(contextSelectionListener);
        this.outgoingTree.addGTreeSelectionListener(contextSelectionListener);
        this.splitPane.setLeftComponent(this.createTreePanel(true, this.incomingTree));
        this.splitPane.setRightComponent(this.createTreePanel(false, this.outgoingTree));
        this.splitPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                long changeFlags = e.getChangeFlags();
                if (2L == (changeFlags & 2L) && CallTreeProvider.this.splitPane.isDisplayable()) {
                    SwingUtilities.invokeLater(() -> CallTreeProvider.this.splitPane.setDividerLocation(0.5));
                    CallTreeProvider.this.splitPane.removeHierarchyListener(this);
                }
            }
        });
        container.add((Component)this.splitPane, "Center");
        return container;
    }

    private JPanel createTreePanel(boolean isIncoming, GTree tree) {
        JPanel panel = new JPanel(new BorderLayout());
        String name = isIncoming ? "Incoming Calls" : "Outgoing Calls";
        JLabel label = new JLabel(name);
        panel.add((Component)label, "North");
        panel.add((Component)tree, "Center");
        return panel;
    }

    private GTree createTree() {
        GTree tree = new GTree((GTreeRootNode)new EmptyRootNode());
        tree.setPaintHandlesForLeafNodes(false);
        return tree;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void componentShown() {
        this.reload();
    }

    public void componentHidden() {
        this.plugin.removeProvider(this);
    }

    private void reload() {
        this.setLocation(this.plugin.getCurrentLocation());
    }

    void dispose() {
        this.reloadUpdateManager.dispose();
        this.incomingTree.dispose();
        this.outgoingTree.dispose();
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
            this.currentProgram = null;
        }
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.recurseDepthAction);
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.refreshAction);
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.filterDuplicates);
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.navigationOutgoingAction);
        this.tool.removeLocalAction((ComponentProvider)this, (DockingActionIf)this.navigateIncomingToggleAction);
        this.recurseDepthAction.dispose();
        this.refreshAction.dispose();
        this.filterDuplicates.dispose();
        this.navigationOutgoingAction.dispose();
        this.navigateIncomingToggleAction.dispose();
    }

    void setLocation(ProgramLocation location) {
        if (this.isFiringNavigationEvent) {
            return;
        }
        if (!this.followLocationChanges()) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        this.doSetLocation(location);
    }

    private void doSetLocation(ProgramLocation location) {
        if (location == null) {
            this.setFunction(null);
            return;
        }
        if (this.currentProgram == null) {
            this.currentProgram = this.plugin.getCurrentProgram();
        }
        Function function = this.plugin.getFunction(location);
        this.setFunction(function);
    }

    private void setFunction(Function function) {
        if (function != null && function.equals(this.currentFunction)) {
            return;
        }
        this.doSetFunction(function);
    }

    private void doSetFunction(Function function) {
        this.currentFunction = function;
        this.notifyContextChanged();
        if (this.currentFunction == null) {
            this.clearTrees();
            return;
        }
        this.resetTrees();
        this.updateTitle();
        this.reloadUpdateManager.update();
    }

    private void notifyContextChanged() {
        this.tool.contextChanged((ComponentProvider)this);
    }

    private void clearTrees() {
        if (this.incomingTree.getRootNode() instanceof EmptyRootNode) {
            return;
        }
        this.updateTitle();
        this.incomingTree.setRootNode((GTreeRootNode)new EmptyRootNode());
        this.outgoingTree.setRootNode((GTreeRootNode)new EmptyRootNode());
    }

    private void resetTrees() {
        this.incomingTree.setRootNode((GTreeRootNode)new PendingRootNode());
        this.outgoingTree.setRootNode((GTreeRootNode)new PendingRootNode());
    }

    private void doUpdate() {
        this.updateIncomingReferencs(this.currentFunction);
        this.updateOutgoingReferences(this.currentFunction);
        this.setStale(false);
    }

    private void updateIncomingReferencs(Function function) {
        Object rootNode = null;
        rootNode = function == null ? new EmptyRootNode() : new IncomingCallsRootNode(this.currentProgram, function, function.getEntryPoint(), this.filterDuplicates.isSelected(), this.recurseDepth);
        this.incomingTree.setRootNode((GTreeRootNode)rootNode);
    }

    private void updateOutgoingReferences(Function function) {
        Object rootNode = null;
        rootNode = function == null ? new EmptyRootNode() : new OutgoingCallsRootNode(this.currentProgram, function, function.getEntryPoint(), this.filterDuplicates.isSelected(), this.recurseDepth);
        this.outgoingTree.setRootNode((GTreeRootNode)rootNode);
    }

    private void updateTitle() {
        Object title = TITLE;
        Object subTitle = "<No Function>";
        if (this.currentFunction != null) {
            String programName = this.currentProgram != null ? this.currentProgram.getDomainFile().getName() : "";
            title = "Function Call Trees: " + this.currentFunction.getName();
            subTitle = " (" + programName + ")";
        }
        this.setTitle((String)title);
        this.setSubTitle((String)subTitle);
    }

    void initialize(Program program, ProgramLocation location) {
        if (program == null) {
            this.setLocation(null);
            return;
        }
        this.currentProgram = program;
        this.currentProgram.addListener((DomainObjectListener)this);
        this.doSetLocation(location);
    }

    void programActivated(Program program) {
        if (!this.followLocationChanges() && this.currentProgram != null) {
            return;
        }
        this.currentProgram = program;
        this.currentProgram.addListener((DomainObjectListener)this);
        this.setLocation(this.plugin.getCurrentLocation());
    }

    void programDeactivated(Program program) {
        if (!this.followLocationChanges()) {
            return;
        }
        this.clearState();
    }

    void programClosed(Program program) {
        if (program != this.currentProgram) {
            return;
        }
        program.removeListener((DomainObjectListener)this);
        this.clearState();
        this.currentProgram = null;
    }

    private void clearState() {
        this.incomingTree.cancelWork();
        this.outgoingTree.cancelWork();
        this.currentFunction = null;
        this.reloadUpdateManager.update();
    }

    boolean isShowingLocation(ProgramLocation location) {
        if (this.currentFunction == null) {
            return false;
        }
        AddressSetView body = this.currentFunction.getBody();
        return body.contains(location.getAddress());
    }

    private boolean followLocationChanges() {
        return this.navigateIncomingToggleAction.isSelected();
    }

    public void domainObjectChanged(DomainObjectChangedEvent event) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isEmpty()) {
            return;
        }
        if (event.containsEvent(4)) {
            this.setStale(true);
            return;
        }
        block4: for (int i = 0; i < event.numRecords(); ++i) {
            DomainObjectChangeRecord domainObjectRecord = event.getChangeRecord(i);
            int eventType = domainObjectRecord.getEventType();
            switch (eventType) {
                case 21: 
                case 23: 
                case 40: 
                case 41: 
                case 60: 
                case 61: {
                    this.setStale(true);
                    continue block4;
                }
                case 46: {
                    Symbol symbol = (Symbol)((ProgramChangeRecord)domainObjectRecord).getObject();
                    if (!(symbol instanceof FunctionSymbol)) continue block4;
                    FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
                    Function function = (Function)functionSymbol.getObject();
                    if (this.updateRootNodes(function)) {
                        return;
                    }
                    this.incomingTree.runTask((GTreeTask)new UpdateFunctionNodeTask(this.incomingTree, function));
                    this.outgoingTree.runTask((GTreeTask)new UpdateFunctionNodeTask(this.outgoingTree, function));
                }
            }
        }
    }

    private boolean isEmpty() {
        GTreeRootNode rootNode = this.incomingTree.getRootNode();
        return rootNode instanceof EmptyRootNode;
    }

    private boolean updateRootNodes(Function function) {
        CallNode callNode = (CallNode)this.incomingTree.getRootNode();
        Function nodeFunction = callNode.getContainingFunction();
        if (nodeFunction.equals(function)) {
            this.reloadUpdateManager.update();
            return true;
        }
        return false;
    }

    private void setStale(boolean stale) {
        if (stale) {
            this.refreshAction.getToolBarData().setIcon((Icon)REFRESH_ICON);
        } else {
            this.refreshAction.getToolBarData().setIcon(REFRESH_NOT_NEEDED_ICON);
        }
    }

    public void setRecurseDepth(int depth) {
        if (depth < 1) {
            return;
        }
        if (this.recurseDepth.get() == depth) {
            return;
        }
        this.recurseDepth.set(depth);
        this.recurseIcon.setNumber(depth);
        this.removeFilterCache();
        this.saveRecurseDepth();
    }

    private void removeFilterCache() {
        GTreeRootNode rootNode = this.incomingTree.getRootNode();
        rootNode.removeAll();
        rootNode = this.outgoingTree.getRootNode();
        rootNode.removeAll();
    }

    private void saveRecurseDepth() {
        Preferences.setProperty((String)RECURSE_DEPTH_PROPERTY_NAME, (String)Integer.toString(this.recurseDepth.get()));
        Preferences.store();
    }

    private void loadRecurseDepthPreference() {
        int intValue;
        String value = Preferences.getProperty((String)RECURSE_DEPTH_PROPERTY_NAME, (String)DEFAULT_RECURSE_DEPTH);
        try {
            intValue = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            intValue = Integer.parseInt(DEFAULT_RECURSE_DEPTH);
        }
        this.recurseDepth.set(intValue);
    }

    public int getRecurseDepth() {
        return this.recurseDepth.get();
    }

    public void setIncomingFilter(String text) {
        this.incomingTree.setFilterText(text);
    }

    public void setOutgoingFilter(String text) {
        this.outgoingTree.setFilterText(text);
    }

    private class EmptyRootNode
    extends AbstractGTreeRootNode {
        private EmptyRootNode() {
        }

        public Icon getIcon(boolean expanded) {
            return EMPTY_ICON;
        }

        public String getName() {
            return "No Function";
        }

        public String getToolTip() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    private class PendingRootNode
    extends AbstractGTreeRootNode {
        private PendingRootNode() {
        }

        public Icon getIcon(boolean expanded) {
            return CallTreePlugin.FUNCTION_ICON;
        }

        public String getName() {
            return "Pending...";
        }

        public String getToolTip() {
            return null;
        }

        public boolean isLeaf() {
            return true;
        }
    }

    private class NumberIcon
    implements Icon {
        private String number;
        private float bestFontSize = -1.0f;

        NumberIcon(int number) {
            this.number = Integer.toString(number);
        }

        void setNumber(int number) {
            this.number = Integer.toString(number);
            this.bestFontSize = -1.0f;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(Color.WHITE);
            g.fillRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.setColor(new Color(11916799));
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            float fontSize = this.getMaxFontSize(g, this.getIconWidth() - 1, this.getIconHeight());
            Font originalFont = g.getFont();
            Font textFont = originalFont.deriveFont(fontSize).deriveFont(1);
            g.setFont(textFont);
            FontMetrics fontMetrics = g.getFontMetrics(textFont);
            Rectangle2D stringBounds = fontMetrics.getStringBounds(this.number, g);
            int textHeight = (int)stringBounds.getHeight();
            int iconHeight = this.getIconHeight();
            int space = y + iconHeight - textHeight;
            int halfSpace = space >> 1;
            int baselineY = y + iconHeight - halfSpace;
            int textWidth = (int)stringBounds.getWidth();
            int iconWidth = this.getIconWidth();
            int halfWidth = iconWidth >> 1;
            int halfTextWidth = textWidth >> 1;
            int baselineX = x + halfWidth - halfTextWidth;
            g.setColor(Color.BLACK);
            JComponent jc = null;
            if (c instanceof JComponent) {
                jc = (JComponent)c;
            }
            GraphicsUtils.drawString((JComponent)jc, (Graphics)g, (String)this.number, (int)baselineX, (int)baselineY);
        }

        private float getMaxFontSize(Graphics g, int width, int height) {
            if (this.bestFontSize > 0.0f) {
                return this.bestFontSize;
            }
            float size = 12.0f;
            Font font = g.getFont().deriveFont(size);
            if (this.textFitsInFont(g, font, width, height)) {
                this.bestFontSize = size;
                return this.bestFontSize;
            }
            while (!this.textFitsInFont(g, font = g.getFont().deriveFont(size -= 1.0f), width, height)) {
            }
            this.bestFontSize = Math.max(1.0f, size);
            return this.bestFontSize;
        }

        private boolean textFitsInFont(Graphics g, Font font, int width, int height) {
            FontMetrics fontMetrics = g.getFontMetrics(font);
            int textWidth = fontMetrics.stringWidth(this.number);
            if (textWidth > width) {
                return false;
            }
            int textHeight = fontMetrics.getHeight();
            return textHeight < height;
        }

        @Override
        public int getIconHeight() {
            return 16;
        }

        @Override
        public int getIconWidth() {
            return 16;
        }
    }

    private class ExpandToDepthTask
    extends GTreeExpandAllTask {
        private int maxDepth;

        public ExpandToDepthTask(GTree tree, GTreeNode node, int maxDepth) {
            super(tree, node);
            TreePath treePath = node.getTreePath();
            int startDepth = treePath.getPathCount();
            this.maxDepth = maxDepth + startDepth - 1;
        }

        protected void expandNode(GTreeNode node, TaskMonitor monitor) throws CancelledException {
            TreePath treePath = node.getTreePath();
            Object[] path = treePath.getPath();
            if (path.length > this.maxDepth) {
                return;
            }
            CallNode callNode = (CallNode)node;
            if (callNode.functionIsInPath()) {
                return;
            }
            super.expandNode(node, monitor);
        }
    }

    private class UpdateFunctionNodeTask
    extends GTreeTask {
        private Function function;

        protected UpdateFunctionNodeTask(GTree tree, Function function) {
            super(tree);
            this.function = function;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            CallNode rootNode = (CallNode)this.tree.getRootNode();
            List children = rootNode.getChildren();
            for (GTreeNode node : children) {
                this.updateFunction((CallNode)node);
            }
        }

        private void updateFunction(CallNode node) {
            if (!node.isChildrenLoadedOrInProgress()) {
                return;
            }
            if (this.function.equals(node.getContainingFunction())) {
                GTreeNode parent = node.getParent();
                parent.removeNode((GTreeNode)node);
                parent.addNode((GTreeNode)node.recreate());
                return;
            }
            List children = node.getChildren();
            for (GTreeNode child : children) {
                this.updateFunction((CallNode)child);
            }
        }
    }
}

