/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.codebrowser.actions;

import docking.action.MenuData;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.context.ProgramLocationContextAction;
import ghidra.app.plugin.core.codebrowser.CodeViewerProvider;
import ghidra.app.util.viewer.listingpanel.ListingModel;
import ghidra.app.util.viewer.listingpanel.ListingPanel;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskLauncher;

public class CollapseAllDataAction
extends ProgramLocationContextAction {
    private CodeViewerProvider provider;

    public CollapseAllDataAction(CodeViewerProvider provider) {
        super("Collapse All Data", provider.getName());
        this.provider = provider;
        this.setPopupMenuData(new MenuData(new String[]{"Collapse All Data"}, null, "Structure"));
        this.setHelpLocation(new HelpLocation("CodeBrowserPlugin", "ExpandCollapseActions"));
        this.setEnabled(true);
    }

    @Override
    protected boolean isEnabledForContext(ProgramLocationActionContext context) {
        if (context.getSelection() != null && !context.getSelection().isEmpty()) {
            this.updatePopupMenuName(true);
            return true;
        }
        Data componentData = this.getTopLevelComponentData(context.getLocation());
        if (componentData == null) {
            return false;
        }
        if (!this.isOpen(componentData)) {
            return false;
        }
        this.updatePopupMenuName(false);
        return true;
    }

    private boolean isOpen(Data componentData) {
        return this.getModel().isOpen(componentData);
    }

    private void updatePopupMenuName(boolean hasSelection) {
        if (hasSelection) {
            this.getPopupMenuData().setMenuPath(new String[]{"Collapse All Data In Selection"});
            this.setDescription("Closes all data recursively in the current selection.");
        } else {
            this.getPopupMenuData().setMenuPath(new String[]{"Collapse All Data"});
            this.setDescription("Closes all data recursively from the outer most component containing this location.");
        }
    }

    @Override
    protected void actionPerformed(ProgramLocationActionContext context) {
        ListingModel model = this.getModel();
        ProgramSelection selection = context.getSelection();
        if (selection != null && !selection.isEmpty()) {
            TaskLauncher.launchModal((String)"Collapse Data In Selection", monitor -> model.closeAllData(selection, monitor));
            return;
        }
        ProgramLocation location = context.getLocation();
        Data data = this.getTopLevelComponentData(location);
        TaskLauncher.launchModal((String)"Collapse Data", monitor -> model.closeAllData(data, monitor));
    }

    private ListingModel getModel() {
        ListingPanel listingPanel = this.provider.getListingPanel();
        return listingPanel.getListingModel();
    }

    private Data getTopLevelComponentData(ProgramLocation location) {
        if (location == null) {
            return null;
        }
        Address address = location.getAddress();
        if (address == null) {
            return null;
        }
        Program program = this.provider.getProgram();
        Data topLevelData = program.getListing().getDataContaining(address);
        if (topLevelData == null || topLevelData.getNumComponents() <= 0) {
            return null;
        }
        return topLevelData;
    }
}

