/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.comments;

import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CommentHistory;
import ghidra.program.model.listing.Program;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabSet;
import javax.swing.text.TabStop;

class CommentHistoryPanel
extends JPanel {
    private static final String NO_HISTORY = "No History Found";
    private SimpleAttributeSet userAttrSet;
    private SimpleAttributeSet dateAttrSet;
    private SimpleAttributeSet textAttrSet;
    private SimpleAttributeSet tabAttrSet;
    private StyledDocument doc;
    private JTextPane textPane;
    private SimpleDateFormat formatter;
    private int commentType;

    CommentHistoryPanel(int commentType) {
        super(new BorderLayout());
        this.setUpAttributes();
        this.commentType = commentType;
        this.formatter = new SimpleDateFormat("yyyy MMM dd hh:mm aaa");
        this.create();
    }

    void showCommentHistory(Program program, Address addr) {
        this.textPane.setText("");
        CommentHistory[] historyItems = program.getListing().getCommentHistory(addr, this.commentType);
        try {
            if (historyItems.length == 0) {
                this.doc.insertString(0, NO_HISTORY, null);
                this.doc.setCharacterAttributes(0, NO_HISTORY.length(), this.textAttrSet, true);
                return;
            }
            for (int i = 0; i < historyItems.length; ++i) {
                this.formatHistory(historyItems[i]);
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.textPane.setCaretPosition(0);
    }

    private void create() {
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.add((Component)this.textPane, "Center");
        this.doc = this.textPane.getStyledDocument();
    }

    private void formatHistory(CommentHistory history) throws BadLocationException {
        int offset = this.doc.getLength();
        Object userName = history.getUserName();
        if (offset > 0) {
            userName = "\n" + (String)userName;
        }
        this.doc.insertString(offset, (String)userName, this.userAttrSet);
        offset = this.doc.getLength();
        this.doc.insertString(offset, "\t" + this.formatter.format(history.getModificationDate()), this.dateAttrSet);
        this.doc.setParagraphAttributes(offset, 1, this.tabAttrSet, false);
        offset = this.doc.getLength();
        this.doc.insertString(offset, "\n" + history.getComments() + "\n", this.textAttrSet);
    }

    private void setUpAttributes() {
        this.textAttrSet = new SimpleAttributeSet();
        this.textAttrSet.addAttribute(StyleConstants.FontFamily, "Monospaced");
        this.textAttrSet.addAttribute(StyleConstants.FontSize, new Integer(12));
        this.textAttrSet.addAttribute(StyleConstants.Foreground, Color.BLUE);
        this.userAttrSet = new SimpleAttributeSet();
        this.userAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.userAttrSet.addAttribute(StyleConstants.FontSize, new Integer(12));
        this.userAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.dateAttrSet = new SimpleAttributeSet();
        this.dateAttrSet.addAttribute(StyleConstants.FontFamily, "Tahoma");
        this.dateAttrSet.addAttribute(StyleConstants.FontSize, new Integer(11));
        this.dateAttrSet.addAttribute(StyleConstants.Bold, Boolean.TRUE);
        this.dateAttrSet.addAttribute(StyleConstants.Foreground, new Color(124, 37, 18));
        this.tabAttrSet = new SimpleAttributeSet();
        TabStop tabs = new TabStop(100.0f, 0, 0);
        StyleConstants.setTabSet(this.tabAttrSet, new TabSet(new TabStop[]{tabs}));
    }
}

