/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.UsrException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class MoveDownAction
extends CompositeEditorTableAction {
    private static final ImageIcon moveDownIcon = ResourceManager.loadImage((String)"images/down.png");
    private static final String ACTION_NAME = "Move Components Down";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Move the selected components down";
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(40, 8);
    private static String[] popupPath = new String[]{"Move Components Down"};

    public MoveDownAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Move Components Down", GROUP_NAME, popupPath, null, moveDownIcon);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        try {
            this.model.moveDown();
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage(), true);
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isMoveDownAllowed());
    }
}

