/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.util.exception.UsrException;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import resources.ResourceManager;

public class MoveUpAction
extends CompositeEditorTableAction {
    private static final ImageIcon moveUpIcon = ResourceManager.loadImage((String)"images/up.png");
    private static final String ACTION_NAME = "Move Components Up";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Move selected components up";
    private KeyStroke keyStroke = KeyStroke.getKeyStroke(38, 8);
    private static String[] popupPath = new String[]{"Move Components Up"};

    public MoveUpAction(CompositeEditorProvider provider) {
        super(provider, "Editor: Move Components Up", GROUP_NAME, popupPath, null, moveUpIcon);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(this.keyStroke));
        this.adjustEnablement();
    }

    public void actionPerformed(ActionContext context) {
        try {
            this.model.moveUp();
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage(), true);
        }
        this.requestTableFocus();
    }

    @Override
    public void adjustEnablement() {
        this.setEnabled(this.model.isMoveUpAllowed());
    }
}

