/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.archive;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ArchiveUtils;
import ghidra.app.plugin.core.datamgr.archive.BuiltInArchive;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.archive.ProjectArchive;
import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.framework.store.LockException;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.FileDataTypeManager;
import ghidra.util.exception.DuplicateFileException;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import javax.swing.ImageIcon;
import resources.ResourceManager;

public class FileArchive
implements Archive {
    private static ImageIcon CLOSED_ICON = ResourceManager.loadImage((String)"images/closedBookGreen.png");
    private static ImageIcon OPEN_ICON = ResourceManager.loadImage((String)"images/openBookGreen.png");
    private ResourceFile archiveFile;
    private boolean hasWriteLock;
    private boolean changed;
    private DataTypeManagerHandler archiveManager;
    private FileDataTypeManager fileDataTypeManager;
    DataTypeManagerChangeListener categoryListener;
    private String name;

    FileArchive(DataTypeManagerHandler archiveManager, File file) throws IOException {
        this(archiveManager, FileDataTypeManager.createFileArchive((File)file));
        this.archiveFile = new ResourceFile(file.getCanonicalFile());
        this.hasWriteLock = true;
    }

    FileArchive(DataTypeManagerHandler archiveManager, ResourceFile file, boolean acquireWriteLock) throws IOException {
        this(archiveManager, FileDataTypeManager.openFileArchive((ResourceFile)file, (boolean)acquireWriteLock));
        this.archiveFile = file.getCanonicalFile();
        this.hasWriteLock = acquireWriteLock;
    }

    private FileArchive(DataTypeManagerHandler archiveManager, FileDataTypeManager manager) {
        this.archiveManager = archiveManager;
        this.fileDataTypeManager = manager;
        this.categoryListener = new ArchiveCategoryChangeListener();
        manager.addDataTypeManagerListener(this.categoryListener);
        this.name = this.fileDataTypeManager.getName();
        this.changed = this.fileDataTypeManager.isChanged();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Archive archive) {
        if (archive instanceof BuiltInArchive || archive instanceof ProgramArchive || archive instanceof ProjectArchive) {
            return 1;
        }
        if (archive instanceof FileArchive) {
            return this.getName().compareToIgnoreCase(archive.getName());
        }
        return -1;
    }

    @Override
    public void close() {
        this.fileDataTypeManager.removeDataTypeManagerListener(this.categoryListener);
        this.fileDataTypeManager.close();
        this.archiveManager.archiveClosed(this);
        this.fileDataTypeManager = null;
    }

    public void delete() throws IOException {
        this.fileDataTypeManager.removeDataTypeManagerListener(this.categoryListener);
        this.fileDataTypeManager.delete();
        this.archiveManager.archiveClosed(this);
        this.fileDataTypeManager = null;
    }

    public void acquireWriteLock() throws LockException, IOException {
        this.refreshArchive(true);
        this.hasWriteLock = true;
        this.fireStateChanged();
    }

    public void releaseWriteLock() throws IOException {
        try {
            this.refreshArchive(false);
        }
        catch (LockException lockException) {
            // empty catch block
        }
        this.hasWriteLock = false;
        this.setChanged(false);
    }

    public void saveAs(File file) throws DuplicateFileException, IOException {
        File newFile = FileDataTypeManager.convertFilename((File)file);
        this.fileDataTypeManager.saveAs(newFile);
        this.archiveFile = new ResourceFile(newFile);
        this.hasWriteLock = true;
        this.setChanged(false);
    }

    @Override
    public void save() throws IOException {
        this.fileDataTypeManager.save();
        this.setChanged(false);
    }

    public ResourceFile getFile() {
        return this.archiveFile;
    }

    public boolean hasWriteLock() {
        return this.hasWriteLock;
    }

    @Override
    public boolean isChanged() {
        return this.changed || this.fileDataTypeManager.isChanged();
    }

    public DataTypeManager getDataTypeManager() {
        return this.fileDataTypeManager;
    }

    boolean isClosed() {
        return this.fileDataTypeManager == null;
    }

    @Override
    public boolean isSavable() {
        return this.archiveFile != null;
    }

    @Override
    public boolean isModifiable() {
        return this.hasWriteLock();
    }

    public DataTypeManagerHandler getArchiveManager() {
        return this.archiveManager;
    }

    private void fireStateChanged() {
        this.archiveManager.fireArchiveStateChanged(this);
    }

    private void refreshArchive(boolean forUpdate) throws LockException, IOException {
        if (this.archiveFile != null) {
            FileDataTypeManager newManager = FileDataTypeManager.openFileArchive((ResourceFile)this.archiveFile, (boolean)forUpdate);
            FileDataTypeManager oldManager = this.fileDataTypeManager;
            oldManager.removeDataTypeManagerListener(this.categoryListener);
            oldManager.close();
            this.fileDataTypeManager = newManager;
            this.fileDataTypeManager.addDataTypeManagerListener(this.categoryListener);
            this.archiveManager.dataTypeManagerChanged(this, (DataTypeManager)oldManager, (DataTypeManager)newManager);
        }
    }

    private void setChanged(boolean change) {
        if (this.changed == change) {
            return;
        }
        this.changed = change;
        this.fireStateChanged();
    }

    @Override
    public void saveAs(Component component) throws IOException {
        File saveAsFile = ArchiveUtils.getFile(component, this);
        if (saveAsFile == null) {
            return;
        }
        if (saveAsFile.equals(this.getFile())) {
            this.save();
        } else {
            this.saveAs(saveAsFile);
        }
    }

    @Override
    public ImageIcon getIcon(boolean expanded) {
        return expanded ? OPEN_ICON : CLOSED_ICON;
    }

    class ArchiveCategoryChangeListener
    implements DataTypeManagerChangeListener {
        ArchiveCategoryChangeListener() {
        }

        public void categoryAdded(DataTypeManager dtm, CategoryPath path) {
            FileArchive.this.setChanged(true);
        }

        public void categoryMoved(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            FileArchive.this.setChanged(true);
        }

        public void categoryRemoved(DataTypeManager dtm, CategoryPath path) {
            FileArchive.this.setChanged(true);
        }

        public void categoryRenamed(DataTypeManager dtm, CategoryPath oldPath, CategoryPath newPath) {
            if (!oldPath.equals((Object)newPath)) {
                FileArchive.this.setChanged(true);
            }
        }

        public void dataTypeAdded(DataTypeManager dtm, DataTypePath path) {
            FileArchive.this.setChanged(true);
        }

        public void dataTypeChanged(DataTypeManager dtm, DataTypePath path) {
            FileArchive.this.setChanged(true);
        }

        public void dataTypeMoved(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            FileArchive.this.setChanged(true);
        }

        public void dataTypeRemoved(DataTypeManager dtm, DataTypePath path) {
            FileArchive.this.setChanged(true);
        }

        public void dataTypeRenamed(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath) {
            FileArchive.this.setChanged(true);
        }

        public void dataTypeReplaced(DataTypeManager dtm, DataTypePath oldPath, DataTypePath newPath, DataType newDataType) {
            FileArchive.this.setChanged(true);
        }

        public void favoritesChanged(DataTypeManager dtm, DataTypePath path, boolean isFavorite) {
        }

        public void sourceArchiveAdded(DataTypeManager dtm, SourceArchive dataTypeSource) {
            FileArchive.this.setChanged(true);
        }

        public void sourceArchiveChanged(DataTypeManager dtm, SourceArchive dataTypeSource) {
            FileArchive.this.setChanged(true);
        }
    }
}

