/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.dialogs.NumberInputDialog;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.framework.options.DummyKeyBindingsOptionsAction;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;
import ghidra.util.HelpLocation;
import javax.swing.KeyStroke;

class CreateArrayAction
extends ListingContextAction
implements OptionsChangeListener {
    private static final KeyStroke DEFAULT_KEY_STROKE = KeyStroke.getKeyStroke(91, 0);
    private FunctionPlugin plugin;

    public CreateArrayAction(FunctionPlugin plugin) {
        super("Define Array", plugin.getName(), false);
        this.plugin = plugin;
        this.setPopupMenu(plugin.getDataActionMenuName(null));
        this.setHelpLocation(new HelpLocation(plugin.getName(), "DataType"));
        this.initializeKeybinding();
    }

    private void initializeKeybinding() {
        PluginTool tool = this.plugin.getTool();
        DummyKeyBindingsOptionsAction dummyKeybindingsAction = new DummyKeyBindingsOptionsAction(this.getName(), DEFAULT_KEY_STROKE);
        tool.addAction((DockingActionIf)dummyKeybindingsAction);
        ToolOptions options = tool.getOptions("Key Bindings");
        options.addOptionsChangeListener((OptionsChangeListener)this);
        KeyStroke keyStroke = options.getKeyStroke(dummyKeybindingsAction.getFullName(), DEFAULT_KEY_STROKE);
        if (!DEFAULT_KEY_STROKE.equals(keyStroke)) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        } else {
            this.setKeyBindingData(new KeyBindingData(keyStroke));
        }
    }

    private void setPopupMenu(String name) {
        this.setPopupMenuData(new MenuData(new String[]{"Set Data Type", "Array..."}, null, "Array"));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection()) {
            return false;
        }
        ProgramLocation location = context.getLocation();
        if (this.plugin.isValidDataLocation(location)) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location));
            return true;
        }
        if (location instanceof VariableLocation) {
            this.setPopupMenu(this.plugin.getDataActionMenuName(location));
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        VariableLocation varLoc;
        Variable var;
        ProgramLocation loc = context.getLocation();
        Function fun = this.plugin.getFunction(context);
        if (loc instanceof FunctionSignatureFieldLocation) {
            DataType dt = fun.getReturnType();
            if (dt == DataType.VOID) {
                dt = DataType.DEFAULT;
            }
            if (dt.getLength() < 1) {
                return;
            }
            int n = this.getNumElements(dt, Integer.MAX_VALUE, 1);
            if (n == 0) {
                return;
            }
            ArrayDataType array = new ArrayDataType(dt, n, dt.getLength());
            this.plugin.createData((DataType)array, context, false);
        } else if (loc instanceof VariableLocation && (var = (varLoc = (VariableLocation)loc).getVariable()).isStackVariable()) {
            int n;
            DataType dt = var.getDataType();
            int len = var.getLength();
            int defaultElements = this.plugin.getMaxStackVariableSize(fun, var);
            if (defaultElements <= 0) {
                defaultElements = 1;
            }
            if ((n = this.getNumElements(dt, Integer.MAX_VALUE, defaultElements)) == 0) {
                return;
            }
            ArrayDataType array = new ArrayDataType(dt, n, len);
            this.plugin.createData((DataType)array, context, true);
        }
    }

    private int getNumElements(DataType dt, int maxElements, int initial) {
        NumberInputDialog dialog = new NumberInputDialog(dt.getDisplayName() + " Elements", initial, 1, maxElements);
        if (!dialog.show()) {
            return 0;
        }
        return dialog.getValue();
    }

    public void optionsChanged(ToolOptions options, String optionName, Object oldValue, Object newValue) {
        KeyStroke keyStroke = (KeyStroke)newValue;
        if (optionName.startsWith(this.getName())) {
            this.setUnvalidatedKeyBindingData(new KeyBindingData(keyStroke));
        }
    }
}

