/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import docking.ActionContext;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.cmd.function.DeleteVariableCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.context.ListingContextAction;
import ghidra.app.plugin.core.function.FunctionPlugin;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.VariableLocation;

class VariableDeleteAction
extends ListingContextAction {
    FunctionPlugin funcPlugin;

    VariableDeleteAction(FunctionPlugin plugin) {
        super("Delete Function Variable", plugin.getName(), true);
        this.funcPlugin = plugin;
        this.setPopupMenuPath(false);
        this.setKeyBindingData(new KeyBindingData(127, 0));
    }

    private void setPopupMenuPath(boolean isParameter) {
        this.setPopupMenuData(new MenuData(new String[]{"Function Variables", "Delete " + (isParameter ? "Parameter" : "Local Variable")}, null, "FunctionVariable"));
    }

    @Override
    public void actionPerformed(ListingActionContext context) {
        Function function = this.funcPlugin.getFunction(context);
        if (function == null) {
            return;
        }
        Variable var = this.getVariable(function, context.getLocation());
        if (var == null) {
            return;
        }
        this.funcPlugin.execute(context.getProgram(), new DeleteVariableCmd(var));
    }

    @Override
    protected boolean isEnabledForContext(ListingActionContext context) {
        if (context.hasSelection() || context.getAddress() == null) {
            return false;
        }
        ProgramLocation loc = context.getLocation();
        if (!(loc instanceof VariableLocation)) {
            return false;
        }
        VariableLocation varLoc = (VariableLocation)loc;
        Variable var = varLoc.getVariable();
        if (var == null || varLoc.isReturn()) {
            return false;
        }
        this.setPopupMenuPath(varLoc.isParameter());
        return true;
    }

    private Variable getVariable(Function function, ProgramLocation currentLocation) {
        if (function == null) {
            return null;
        }
        if (currentLocation instanceof VariableLocation) {
            return ((VariableLocation)currentLocation).getVariable();
        }
        return null;
    }

    public boolean isValidGlobalContext(ActionContext globalContext) {
        return false;
    }
}

