/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare;

import docking.ComponentProvider;
import ghidra.app.plugin.core.functioncompare.FunctionChoiceComparisonPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.util.HelpLocation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;

public class MappedFunctionComparisonPanel
extends FunctionChoiceComparisonPanel {
    private HashMap<Function, HashSet<Function>> functionMap;

    public MappedFunctionComparisonPanel(ComponentProvider provider, PluginTool tool, HashMap<Function, HashSet<Function>> functionMap) {
        super(provider, tool, null, null);
        this.functionMap = functionMap;
        this.establishLeftFunctions(0);
        this.establishRightFunctions(0);
        if (this.leftWrappedFunctions.length > 1 || this.rightWrappedFunctions.length > 1) {
            this.addChoicePanel();
        }
        this.reloadLeftFunctions();
        this.reloadRightFunctions();
        this.createActions();
        help.registerHelp((Object)this, new HelpLocation("FunctionComparison", "Function Comparison"));
    }

    private void establishLeftFunctions(int leftFunctionIndex) {
        Set<Function> leftFunctionSet = this.functionMap.keySet();
        Function[] leftSortedFunctions = this.getSortedFunctions(leftFunctionSet);
        this.leftWrappedFunctions = this.getWrappedFunctions(leftSortedFunctions);
        this.leftIndex = leftFunctionIndex < leftSortedFunctions.length ? leftFunctionIndex : 0;
    }

    private void adjustRightFunctions(int rightFunctionIndex) {
        this.establishRightFunctions(rightFunctionIndex);
        this.reloadRightFunctions();
    }

    private void establishRightFunctions(int rightFunctionIndex) {
        Set rightFunctionSet = this.functionMap.get(this.getLeftFunction());
        Function[] rightSortedFunctions = rightFunctionSet != null ? this.getSortedFunctions(rightFunctionSet) : new Function[]{};
        this.rightWrappedFunctions = this.getWrappedFunctions(rightSortedFunctions);
        this.rightIndex = rightFunctionIndex < rightSortedFunctions.length ? rightFunctionIndex : 0;
    }

    private void reloadLeftFunctions() {
        if (this.leftIndex >= this.leftWrappedFunctions.length) {
            this.leftIndex = 0;
        }
        if (this.leftComboBox != null) {
            this.leftComboBox.setModel(new DefaultComboBoxModel<FunctionChoiceComparisonPanel.WrappedFunction>(this.leftWrappedFunctions));
            this.adjustSelectedLeftFunction();
        }
        Function leftFunctionAtIndex = this.leftIndex < this.leftWrappedFunctions.length ? this.leftWrappedFunctions[this.leftIndex].getFunction() : null;
        this.setLeftFunction(leftFunctionAtIndex);
    }

    private void reloadRightFunctions() {
        if (this.rightIndex >= this.rightWrappedFunctions.length) {
            this.rightIndex = 0;
        }
        if (this.rightComboBox != null) {
            this.rightComboBox.setModel(new DefaultComboBoxModel<FunctionChoiceComparisonPanel.WrappedFunction>(this.rightWrappedFunctions));
            this.adjustSelectedRightFunction();
        }
        Function rightFunctionAtIndex = this.rightIndex < this.rightWrappedFunctions.length ? this.rightWrappedFunctions[this.rightIndex].getFunction() : null;
        this.setRightFunction(rightFunctionAtIndex);
    }

    boolean matchesTheseFunctions(HashMap<Function, HashSet<Function>> myFunctionMap) {
        return this.functionMap.equals(myFunctionMap);
    }

    @Override
    public void loadFunctions(Function newLeftFunction, Function newRightFunction) {
        Function myLeftFunction = this.getLeftFunction();
        super.loadFunctions(newLeftFunction, newRightFunction);
        if (myLeftFunction != this.getLeftFunction()) {
            this.adjustRightFunctions(0);
        }
    }
}

