/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functionwindow;

import docking.ActionContext;
import docking.ComponentProvider;
import ghidra.app.plugin.core.functionwindow.FunctionRowObject;
import ghidra.app.plugin.core.functionwindow.FunctionTableModel;
import ghidra.app.plugin.core.functionwindow.FunctionWindowPlugin;
import ghidra.app.services.GoToService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import resources.ResourceManager;

public class FunctionWindowProvider
extends ComponentProviderAdapter {
    public static final ImageIcon icon = ResourceManager.loadImage((String)"images/functions.gif");
    private FunctionWindowPlugin plugin;
    private GhidraTable functionTable;
    private FunctionTableModel functionModel;
    private JComponent mainPanel;
    private GhidraTableFilterPanel<FunctionRowObject> tableFilterPanel;
    private GhidraThreadedTablePanel<FunctionRowObject> threadedTablePanel;

    FunctionWindowProvider(FunctionWindowPlugin plugin) {
        super(plugin.getTool(), "Functions Window", plugin.getName());
        this.setTitle("Functions");
        this.plugin = plugin;
        this.setIcon(icon);
        this.setHelpLocation(new HelpLocation(plugin.getName(), plugin.getName()));
        this.tool = plugin.getTool();
        this.mainPanel = this.createWorkPanel();
        this.tool.addComponentProvider((ComponentProvider)this, false);
    }

    public void componentHidden() {
        this.functionModel.reload(null);
    }

    public void componentShown() {
        this.functionModel.reload(this.plugin.getProgram());
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (event != null && event.getSource() == this.functionTable) {
            return new ActionContext((ComponentProvider)this, (Object)this.functionTable);
        }
        return null;
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    void programOpened(Program program) {
        if (this.isVisible()) {
            this.functionModel.reload(program);
        }
    }

    void programClosed() {
        this.functionModel.reload(null);
    }

    void showFunctions() {
        this.tool.showComponentProvider((ComponentProvider)this, true);
    }

    void dispose() {
        this.tool.removeComponentProvider((ComponentProvider)this);
        this.threadedTablePanel.dispose();
        this.tableFilterPanel.dispose();
    }

    void reload() {
        if (this.isVisible()) {
            this.functionModel.reload(this.plugin.getProgram());
        }
    }

    private JComponent createWorkPanel() {
        this.functionModel = new FunctionTableModel(this.plugin.getTool(), null);
        this.threadedTablePanel = new GhidraThreadedTablePanel<FunctionRowObject>(this.functionModel, 1000);
        this.functionTable = this.threadedTablePanel.getTable();
        this.functionTable.setName("FunctionTable");
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        if (goToService != null) {
            this.functionTable.installNavigation(goToService, goToService.getDefaultNavigatable());
        }
        this.functionTable.setAutoLookupColumn(0);
        this.functionTable.setAutoResizeMode(2);
        this.functionTable.setPreferredScrollableViewportSize(new Dimension(350, 150));
        this.functionTable.setRowSelectionAllowed(true);
        this.functionTable.setSelectionMode(2);
        this.functionTable.getSelectionModel().addListSelectionListener(e -> this.plugin.setActionsEnabled(this.functionTable.getSelectedRowCount() > 0));
        this.functionModel.addTableModelListener(e -> {
            int rowCount = this.functionModel.getRowCount();
            int unfilteredCount = this.functionModel.getUnfilteredCount();
            StringBuilder buffy = new StringBuilder();
            buffy.append(rowCount).append(" items");
            if (rowCount != unfilteredCount) {
                buffy.append(" (of ").append(unfilteredCount).append(" )");
            }
            this.setSubTitle(buffy.toString());
        });
        JTableHeader functionHeader = this.functionTable.getTableHeader();
        functionHeader.setUpdateTableInRealTime(true);
        this.setFunctionTableRenderer();
        this.tableFilterPanel = new GhidraTableFilterPanel((JTable)((Object)this.functionTable), this.functionModel);
        JPanel container = new JPanel(new BorderLayout());
        container.add((Component)((Object)this.threadedTablePanel), "Center");
        container.add((Component)((Object)this.tableFilterPanel), "South");
        return container;
    }

    ProgramSelection selectFunctions() {
        return this.functionTable.getProgramSelection();
    }

    private void setFunctionTableRenderer() {
        this.functionTable.getColumnModel().getColumn(1).setPreferredWidth(50);
    }

    void update(Function function) {
        if (this.isVisible()) {
            this.functionModel.update(function);
        }
    }

    void functionAdded(Function function) {
        if (this.isVisible()) {
            this.functionModel.functionAdded(function);
        }
    }

    void functionRemoved(Function function) {
        if (this.isVisible()) {
            this.functionModel.functionRemoved(function);
        }
    }

    GhidraTable getTable() {
        return this.functionTable;
    }

    FunctionTableModel getModel() {
        return this.functionModel;
    }

    public String getWindowSubMenuName() {
        return null;
    }

    public boolean isTransient() {
        return false;
    }
}

