/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.memory;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.memory.MemoryMapManager;
import ghidra.app.plugin.core.memory.MemoryMapProvider;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.util.ProgramLocation;
import java.awt.Cursor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.ResourceManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Memory Map View", description="This plugin provides the memory map component which allows users to add, remove, and edit memory blocks.", servicesRequired={GoToService.class}, eventsProduced={ProgramLocationPluginEvent.class})
public class MemoryMapPlugin
extends ProgramPlugin
implements DomainObjectListener {
    static final Cursor WAIT_CURSOR = new Cursor(3);
    static final Cursor NORM_CURSOR = new Cursor(0);
    private DockingAction memViewAction;
    private MemoryMapProvider provider;
    private GoToService goToService;
    private MemoryMapManager memManager = new MemoryMapManager(this);

    public MemoryMapPlugin(PluginTool tool) {
        super(tool, true, false);
        this.provider = new MemoryMapProvider(this);
        this.createActions();
    }

    public void dispose() {
        if (this.memViewAction != null) {
            this.memViewAction.dispose();
        }
        if (this.provider != null) {
            this.provider.dispose();
            this.provider = null;
        }
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
            this.currentProgram = null;
        }
        super.dispose();
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (this.provider == null || !this.provider.isVisible()) {
            return;
        }
        if (ev.containsEvent(20) || ev.containsEvent(21) || ev.containsEvent(23) || ev.containsEvent(24) || ev.containsEvent(25) || ev.containsEvent(4)) {
            this.provider.updateMap();
        } else if (ev.containsEvent(22)) {
            this.provider.updateData();
        }
    }

    protected void init() {
        this.goToService = (GoToService)this.tool.getService(GoToService.class);
        if (this.currentProgram != null) {
            this.programActivated(this.currentProgram);
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.memManager.setProgram(program);
        this.provider.setProgram(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.memManager.setProgram(null);
        this.provider.setProgram(null);
    }

    MemoryMapManager getMemoryMapManager() {
        return this.memManager;
    }

    MemoryMapProvider getMemoryMapProvider() {
        return this.provider;
    }

    Memory getMemory() {
        return this.currentProgram.getMemory();
    }

    void blockSelected(MemoryBlock block, Address addr) {
        ProgramLocation loc = new ProgramLocation(this.currentProgram, addr);
        this.goToService.goTo(loc);
    }

    private void createActions() {
        this.memViewAction = new DockingAction("View Memory Map", this.getName()){

            public void actionPerformed(ActionContext context) {
                MemoryMapPlugin.this.showMemory();
            }
        };
        ImageIcon tableImage = ResourceManager.loadImage((String)"images/memory16.gif");
        this.memViewAction.setToolBarData(new ToolBarData((Icon)tableImage, "View"));
        this.memViewAction.setDescription("Display Memory Map");
        this.tool.addAction((DockingActionIf)this.memViewAction);
    }

    private void showMemory() {
        this.tool.showComponentProvider((ComponentProvider)this.provider, true);
    }
}

