/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.LabelFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.LabelFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;

class LabelLocationDescriptor
extends LocationDescriptor {
    LabelLocationDescriptor(ProgramLocation location, Program program) {
        super(location, program);
        if (location == null) {
            throw new NullPointerException("Cannot create a LocationDescriptor from a null ProgramLocation");
        }
        if (!(location instanceof LabelFieldLocation)) {
            throw new AssertException("Unexpected ProgramLocation type - Cannot create a LocationDescriptor for type: " + location);
        }
        LabelFieldLocation labelLocation = (LabelFieldLocation)location;
        this.label = labelLocation.getName();
        this.homeAddress = labelLocation.getAddress();
    }

    @Override
    public String getTypeName() {
        return this.label;
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        ReferenceUtils.getReferences(accumulator, this.programLocation, monitor);
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        int offset;
        Address currentAddress = this.getAddressForHighlightObject(object);
        if (!this.isInAddresses(currentAddress)) {
            return this.EMPTY_HIGHLIGHTS;
        }
        if (OperandFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            int offset2 = text.indexOf(this.label);
            if (offset2 >= 0) {
                return new Highlight[]{new Highlight(offset2, this.label.length() + offset2 - 1, highlightColor)};
            }
        } else if (LabelFieldFactory.class.isAssignableFrom(fieldFactoryClass) && currentAddress.equals((Object)this.homeAddress) && (offset = text.indexOf(this.label)) != -1) {
            return new Highlight[]{new Highlight(offset, this.label.length() + offset - 1, highlightColor)};
        }
        return this.EMPTY_HIGHLIGHTS;
    }
}

