/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.overview.entropy;

import docking.util.GraphicsUtils;
import ghidra.app.plugin.core.overview.entropy.KnotRecord;
import ghidra.app.plugin.core.overview.entropy.Palette;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class KnotPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private static final int SPACING = 5;
    private static final Font FONT = new Font("SansSerif", 0, 10);
    private Palette palette = null;
    private FontMetrics metrics;
    private ChangeListener paletteListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent e) {
            KnotPanel.this.buildLabels();
        }
    };

    public KnotPanel() {
        this.addComponentListener(this);
        this.metrics = this.getFontMetrics(FONT);
        this.setPreferredSize(new Dimension(100, 5 + this.metrics.getMaxAscent() + this.metrics.getMaxDescent()));
    }

    public void oldPaintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(this.getBackground());
        Rectangle clip = g.getClipBounds();
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        if (this.palette == null) {
            return;
        }
        g.setColor(Color.BLACK);
        g.setFont(FONT);
        int height = this.getHeight();
        int width = this.getWidth();
        int palsize = this.palette.getSize();
        int fontHeight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
        int baseline = (height - fontHeight - 1) / 2 + this.metrics.getMaxAscent();
        ArrayList<KnotRecord> knots = this.palette.getKnots();
        for (int i = 0; i < knots.size(); ++i) {
            KnotRecord rec = knots.get(i);
            int start = rec.start * width / palsize;
            int end = rec.end * width / palsize;
            g.drawLine(start, 0, start, height - 1);
            g.drawLine(end, 0, end, height - 1);
            g.drawLine(start, height - 1, end, height - 1);
            FontMetrics currentMetrics = this.metrics;
            int w = currentMetrics.stringWidth(rec.name);
            int knotwidth = end - start;
            while (w > knotwidth) {
                currentMetrics = this.getSmallerFontMetrics(currentMetrics);
                w = currentMetrics.stringWidth(rec.name);
                if (currentMetrics.getFont().getSize() > 4) continue;
            }
            if (w < knotwidth) {
                g.setFont(currentMetrics.getFont());
                GraphicsUtils.drawString((JComponent)this, (Graphics)g, (String)rec.name, (int)(start + (knotwidth - 1) / 2 - w / 2), (int)baseline);
                g.setFont(FONT);
            } else {
                String ellipsis = "...";
                w = this.metrics.stringWidth(ellipsis);
                GraphicsUtils.drawString((JComponent)this, (Graphics)g, (String)ellipsis, (int)(start + (knotwidth - 1) / 2 - w / 2), (int)baseline);
            }
            currentMetrics = this.metrics;
        }
    }

    private FontMetrics getSmallerFontMetrics(FontMetrics fontMetrics) {
        Font currentFont = fontMetrics.getFont();
        int size = currentFont.getSize();
        Font newFont = currentFont.deriveFont((float)(--size));
        return this.getFontMetrics(newFont);
    }

    public void setPalette(Palette pal) {
        this.palette = pal;
        this.palette.addPaletteListener(this.paletteListener);
        this.buildLabels();
        this.repaint();
    }

    private void buildLabels() {
        this.removeAll();
        this.setLayout(null);
        int paletteSize = this.palette.getSize();
        Container parent = this.getParent();
        ArrayList<KnotRecord> knots = this.palette.getKnots();
        for (KnotRecord record : knots) {
            JLabel label = new JLabel(record.name);
            label.setFont(FONT);
            label.setBorder(new ToplessLineBorder(Color.BLACK));
            label.setHorizontalAlignment(0);
            label.setToolTipText(record.name);
            int height = this.getHeight();
            int width = this.getWidth();
            int start = record.start * width / paletteSize;
            int end = record.end * width / paletteSize;
            int labelWidth = end - start;
            int labelHeight = height - 1;
            int x = start + ((end - start >> 1) - (labelWidth >> 1));
            int y = 0;
            label.setBounds(x, y, labelWidth, labelHeight);
            this.add(label);
        }
        this.invalidate();
        if (parent != null) {
            parent.validate();
        }
    }

    public void refresh() {
        this.buildLabels();
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.refresh();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private class ToplessLineBorder
    extends LineBorder {
        public ToplessLineBorder(Color color) {
            super(color);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            super.paintBorder(c, g, x, y - 1, width, height + 1);
        }
    }
}

