/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.references;

import ghidra.app.cmd.refs.UpdateExternalNameCmd;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ExternalNamesTableModel
extends AbstractTableModel {
    static final int NAME_COL = 0;
    static final int PATH_COL = 1;
    static final String EXTERNAL_NAME = "Name";
    static final String PATH_NAME = "Ghidra Program";
    private final String[] columnNames = new String[]{"Name", "Ghidra Program"};
    private List<String> nameList = new ArrayList<String>();
    private List<String> pathNameList = new ArrayList<String>();
    private Program program;
    private PluginTool tool;

    public ExternalNamesTableModel(PluginTool tool) {
        this.tool = tool;
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public int getRowCount() {
        return this.nameList.size();
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.nameList.size()) {
            return "";
        }
        switch (columnIndex) {
            case 0: {
                return this.nameList.get(rowIndex);
            }
            case 1: {
                return this.pathNameList.get(rowIndex);
            }
        }
        return "Unknown Column!";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String extName = ((String)aValue).trim();
        if ("".equals(extName)) {
            return;
        }
        if (this.nameList.contains(extName)) {
            if (this.nameList.indexOf(extName) != rowIndex) {
                Window window = this.tool.getActiveWindow();
                Msg.showInfo(this.getClass(), (Component)window, (String)"Duplicate Name", (Object)("Name already exists: " + extName));
            }
            return;
        }
        UpdateExternalNameCmd cmd = new UpdateExternalNameCmd(this.nameList.get(rowIndex), extName, SourceType.USER_DEFINED);
        if (!this.tool.execute((Command)cmd, (DomainObject)this.program)) {
            this.tool.setStatusInfo(cmd.getStatusMsg());
        }
    }

    void setProgram(Program program) {
        this.program = program;
        this.updateTableData();
    }

    void updateTableData() {
        this.nameList.clear();
        this.pathNameList.clear();
        if (this.program == null) {
            this.fireTableDataChanged();
            return;
        }
        ExternalManager extMgr = this.program.getExternalManager();
        Object[] programNames = extMgr.getExternalLibraryNames();
        Arrays.sort(programNames);
        for (int i = 0; i < programNames.length; ++i) {
            if ("<EXTERNAL>".equals(programNames[i])) continue;
            this.nameList.add((String)programNames[i]);
            this.pathNameList.add(extMgr.getExternalLibraryPath((String)programNames[i]));
        }
        this.fireTableDataChanged();
    }
}

