/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DiscoverableTableUtils;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GBooleanCellRenderer;
import docking.widgets.table.GDynamicColumnTableModel;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.cmd.function.DeleteFunctionCmd;
import ghidra.app.cmd.label.DeleteLabelCmd;
import ghidra.app.cmd.label.RenameLabelCmd;
import ghidra.app.plugin.core.symtable.NewSymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolFilter;
import ghidra.app.plugin.core.symtable.SymbolProvider;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.docking.settings.Settings;
import ghidra.framework.cmd.Command;
import ghidra.framework.cmd.CompoundCmd;
import ghidra.framework.model.DomainObject;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.LabelHistory;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.LongArrayList;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.AbstractWrapperTypeColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.table.field.AbstractProgramBasedDynamicTableColumn;
import ghidra.util.table.field.AbstractProgramLocationTableColumn;
import ghidra.util.table.field.AddressBasedLocation;
import ghidra.util.table.field.SymbolTypeTableColumn;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ConcurrentModificationException;
import java.util.List;

class SymbolTableModel
extends AddressBasedTableModel<SymbolRowObject> {
    static final int LABEL_COL = 0;
    static final int LOCATION_COL = 1;
    static final int TYPE_COL = 2;
    static final int DATATYPE_COL = 3;
    static final int NAMESPACE_COL = 4;
    static final int SOURCE_COL = 5;
    static final int REFS_COL = 6;
    static final String LABEL_COL_NAME = "Labels";
    static final String LOCATION_COL_NAME = "Location";
    static final String TYPE_COL_NAME = "Type";
    static final String DATATYPE_COL_NAME = "Datatype";
    static final String REFS_COL_NAME = "# Refs";
    static final String NAMESPACE_COL_NAME = "Namespace";
    static final String SOURCE_COL_NAME = "Source";
    private SymbolProvider provider;
    private PluginTool tool;
    private SymbolTable symbolTable;
    private ReferenceManager refMgr;
    private Symbol lastSymbol;
    private SymbolFilter filter;

    SymbolTableModel(SymbolProvider provider, PluginTool tool) {
        super("Symbols", (ServiceProvider)tool, null, null);
        this.provider = provider;
        this.tool = tool;
        this.filter = new NewSymbolFilter();
    }

    @Override
    protected TableColumnDescriptor<SymbolRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new NameTableColumn(), 1, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new LocationTableColumn());
        descriptor.addVisibleColumn(DiscoverableTableUtils.adaptColumForModel((GDynamicColumnTableModel)this, (AbstractDynamicTableColumn)new SymbolTypeTableColumn()));
        descriptor.addVisibleColumn((DynamicTableColumn)new DataTypeTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new NamespaceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new SourceTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new ReferenceCountTableColumn());
        descriptor.addVisibleColumn((DynamicTableColumn)new OffcutReferenceCountTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new PinnedTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new UserTableColumn());
        descriptor.addHiddenColumn((DynamicTableColumn)new OriginalNameColumn());
        return descriptor;
    }

    void setFilter(SymbolFilter filter) {
        this.filter = filter;
        this.reload();
    }

    Symbol getSymbol(long symbolID) {
        if (this.symbolTable != null) {
            return this.symbolTable.getSymbol(symbolID);
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.symbolTable = null;
        this.refMgr = null;
        this.lastSymbol = null;
        this.provider = null;
    }

    void reload(Program prog) {
        this.cancelAllUpdates();
        this.lastSymbol = null;
        if (prog != null) {
            this.setProgram(prog);
            this.symbolTable = prog.getSymbolTable();
            this.refMgr = prog.getReferenceManager();
            this.reload();
        } else {
            this.setProgram(null);
            this.symbolTable = null;
            this.refMgr = null;
        }
    }

    public int getKeyCount() {
        if (this.symbolTable != null) {
            int cnt = this.symbolTable.getNumSymbols();
            if (this.filter.acceptsDefaultLabelSymbols()) {
                cnt += this.refMgr.getReferenceDestinationCount();
            }
            return cnt;
        }
        return 0;
    }

    protected void doLoad(Accumulator<SymbolRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.symbolTable == null) {
            return;
        }
        SymbolIterator it = this.symbolTable.getDefinedSymbols();
        monitor.initialize((long)this.getKeyCount());
        int value = 0;
        while (it.hasNext()) {
            monitor.setProgress((long)value++);
            monitor.checkCanceled();
            Symbol s = it.next();
            if (!this.filter.accepts(s, this.getProgram())) continue;
            accumulator.add((Object)new SymbolRowObject(s.getID()));
        }
        if (this.filter.acceptsDefaultLabelSymbols()) {
            AddressIterator addrIt = this.refMgr.getReferenceDestinationIterator((AddressSetView)this.getProgram().getAddressFactory().getAddressSet(), true);
            while (addrIt.hasNext()) {
                monitor.setProgress((long)value++);
                monitor.checkCanceled();
                Address a = addrIt.next();
                Symbol s = this.symbolTable.getPrimarySymbol(a);
                if (!s.isDynamic() || !this.filter.accepts(s, this.getProgram())) continue;
                accumulator.add((Object)new SymbolRowObject(s.getID()));
            }
        }
    }

    public boolean isSortable(int columnIndex) {
        return true;
    }

    public boolean isCellEditable(int key, int columnIndex) {
        return columnIndex == 0;
    }

    public void setValueAt(Object aValue, int row, int columnIndex) {
        if (this.provider == null || this.symbolTable == null || aValue == null) {
            return;
        }
        if (row < 0 || row >= this.filteredData.size()) {
            return;
        }
        SymbolRowObject rowObject = (SymbolRowObject)this.filteredData.get(row);
        Symbol symbol = this.symbolTable.getSymbol(rowObject.getKey());
        if (symbol == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                try {
                    RenameLabelCmd renameCmd;
                    String newName = aValue.toString();
                    if (symbol.getName().equals(newName) || this.tool.execute((Command)(renameCmd = new RenameLabelCmd(symbol.getAddress(), symbol.getName(), newName, symbol.getParentNamespace(), SourceType.USER_DEFINED)), (DomainObject)this.getProgram())) break;
                    Msg.showError(this.getClass(), (Component)this.provider.getComponent(), (String)"Error Renaming Symbol", (Object)renameCmd.getStatusMsg());
                    break;
                }
                catch (ConcurrentModificationException exc) {
                    Msg.showError(this.getClass(), (Component)this.provider.getComponent(), (String)"Invalid Symbol", (Object)"Symbol no longer valid.");
                }
            }
        }
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int column) {
        Symbol s = (Symbol)this.getValueAt(row, 0);
        if (s != null) {
            return s.getProgramLocation();
        }
        return null;
    }

    public ProgramLocation getProgramLocation(int row) {
        return (ProgramLocation)this.getValueAt(row, 1);
    }

    @Override
    public ProgramSelection getProgramSelection(int[] rows) {
        AddressSet set = new AddressSet();
        for (int element : rows) {
            AddressBasedLocation symbolLocation = this.getSymbolLocation((SymbolRowObject)this.getRowObject(element));
            if (!symbolLocation.isMemoryLocation()) continue;
            set.add(symbolLocation.getAddress());
        }
        return new ProgramSelection((AddressSetView)set);
    }

    public void reload() {
        this.lastSymbol = null;
        super.reload();
    }

    void symbolAdded(Symbol s) {
        if (this.filter.accepts(s, this.getProgram())) {
            this.addObject(new SymbolRowObject(s.getID()));
            this.lastSymbol = s;
        }
    }

    void symbolRemoved(long symbolID) {
        if (this.lastSymbol != null && this.lastSymbol.getID() == symbolID) {
            this.lastSymbol = null;
        }
        this.removeObject(new SymbolRowObject(symbolID));
    }

    void symbolChanged(Symbol s) {
        SymbolRowObject symbolRowObject = new SymbolRowObject(s.getID());
        if (this.filter.accepts(s, this.getProgram())) {
            this.updateObject(symbolRowObject);
        } else {
            this.removeObject(symbolRowObject);
        }
    }

    void delete(List<SymbolRowObject> rowObjects) {
        if (rowObjects == null || rowObjects.size() == 0) {
            return;
        }
        this.tool.setStatusInfo("");
        LongArrayList deleteList = new LongArrayList();
        CompoundCmd cmd = new CompoundCmd("Delete symbol(s)");
        for (int i = 0; i < rowObjects.size(); ++i) {
            Symbol[] symbols;
            Symbol symbol = this.symbolTable.getSymbol(rowObjects.get(i).getKey());
            if (symbol == null) continue;
            if (symbol.isDynamic() && (symbols = this.symbolTable.getSymbols(symbol.getAddress())).length == 1) {
                this.tool.setStatusInfo("Unable to delete symbol: " + symbol.getName());
                continue;
            }
            deleteList.add(rowObjects.get(i).getKey());
            String label = symbol.getName();
            if (symbol.getSymbolType() == SymbolType.FUNCTION) {
                Function function = (Function)symbol.getObject();
                boolean ignoreMissingFunction = function.isThunk();
                cmd.add((Command)new DeleteFunctionCmd(symbol.getAddress(), ignoreMissingFunction));
                if (symbol.getSource() == SourceType.DEFAULT) continue;
                cmd.add((Command)new DeleteLabelCmd(symbol.getAddress(), label, symbol.getParentNamespace()));
                continue;
            }
            cmd.add((Command)new DeleteLabelCmd(symbol.getAddress(), label, symbol.getParentNamespace()));
        }
        if (cmd.size() == 0) {
            return;
        }
        if (this.tool.execute((Command)cmd, (DomainObject)this.getProgram())) {
            for (int k = 0; k < deleteList.size(); ++k) {
                this.removeObject(new SymbolRowObject(deleteList.get(k)));
            }
            this.updateNow();
        } else {
            this.tool.setStatusInfo(cmd.getStatusMsg());
            this.reload();
        }
    }

    public SymbolFilter getFilter() {
        return this.filter;
    }

    public Class<?> getSortedColumnClass(int columnIndex) {
        if (columnIndex == 1) {
            return Address.class;
        }
        return super.getSortedColumnClass(columnIndex);
    }

    public static int getPreferredWidth(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return 140;
            }
            case 1: {
                return 40;
            }
            case 2: 
            case 3: 
            case 5: {
                return 30;
            }
            case 4: {
                return 80;
            }
            case 6: {
                return 20;
            }
        }
        return 40;
    }

    @Override
    public Address getAddress(int row) {
        Symbol symbol = this.symbolTable.getSymbol(((SymbolRowObject)this.getRowObject(row)).getKey());
        if (symbol == null) {
            return null;
        }
        return symbol.getAddress();
    }

    Symbol getSymbolForRowObject(SymbolRowObject storageObject) {
        if (this.symbolTable == null) {
            return null;
        }
        long key = storageObject.getKey();
        Symbol localSymbol = this.lastSymbol;
        if (localSymbol == null || localSymbol.getID() != key) {
            localSymbol = this.lastSymbol = this.symbolTable.getSymbol(key);
        }
        return localSymbol;
    }

    AddressBasedLocation getSymbolLocation(SymbolRowObject rowObject) {
        Symbol s = this.getSymbolForRowObject(rowObject);
        if (s == null) {
            return new AddressBasedLocation();
        }
        SymbolType type = s.getSymbolType();
        if (type == SymbolType.PARAMETER || type == SymbolType.LOCAL_VAR) {
            return new VariableSymbolLocation((Variable)s.getObject());
        }
        return new AddressBasedLocation(this.program, s.getAddress());
    }

    private class OriginalNameColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        private OriginalNameColumn() {
        }

        public String getColumnName() {
            return "Original Imported Name";
        }

        public String getColumnDescription() {
            return "The orignal (pre-demangled) import name (External Symbols Only)";
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = SymbolTableModel.this.getSymbolForRowObject(rowObject);
            if (symbol == null || !symbol.isExternal()) {
                return null;
            }
            SymbolType symbolType = symbol.getSymbolType();
            if (symbolType != SymbolType.FUNCTION && symbolType != SymbolType.CODE) {
                return null;
            }
            ExternalManager externalManager = p.getExternalManager();
            ExternalLocation externalLocation = externalManager.getExternalLocation(symbol);
            if (externalLocation != null) {
                return externalLocation.getOriginalImportedName();
            }
            return null;
        }
    }

    private class UserTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        private UserTableColumn() {
        }

        public String getColumnName() {
            return "User";
        }

        public String getColumnDescription() {
            return "The user that created or last edited this symbol.";
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = SymbolTableModel.this.getSymbolForRowObject(rowObject);
            if (symbol == null) {
                return null;
            }
            SourceType source = symbol.getSource();
            if (source != SourceType.USER_DEFINED) {
                return null;
            }
            Address address = symbol.getAddress();
            LabelHistory[] labelHistory = SymbolTableModel.this.symbolTable.getLabelHistory(address);
            if (labelHistory.length > 0) {
                return labelHistory[0].getUserName();
            }
            return null;
        }
    }

    private class OffcutReferenceCountTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, Integer> {
        private OffcutReferenceCountTableColumn() {
        }

        public String getColumnName() {
            return "Offcut Ref Count";
        }

        public Integer getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            CodeUnit codeUnit;
            Symbol symbol = SymbolTableModel.this.getSymbolForRowObject(rowObject);
            if (symbol == null) {
                return null;
            }
            Address address = symbol.getAddress();
            int count = 0;
            if (address.isMemoryAddress() && (codeUnit = p.getListing().getCodeUnitContaining(address)) != null) {
                AddressSet set = new AddressSet(codeUnit.getMinAddress(), codeUnit.getMaxAddress());
                set.deleteRange(address, address);
                ReferenceManager referenceManager = p.getReferenceManager();
                AddressIterator it = referenceManager.getReferenceDestinationIterator((AddressSetView)set, true);
                while (it.hasNext()) {
                    it.next();
                    ++count;
                }
            }
            return count;
        }
    }

    private class ReferenceCountTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, Integer> {
        private ReferenceCountTableColumn() {
        }

        public String getColumnName() {
            return "Reference Count";
        }

        public Integer getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = SymbolTableModel.this.getSymbolForRowObject(rowObject);
            if (symbol == null) {
                return null;
            }
            return symbol.getReferenceCount();
        }
    }

    private class SourceTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, SourceType> {
        private GColumnRenderer<SourceType> renderer = new AbstractGColumnRenderer<SourceType>(){

            protected String getText(Object value) {
                if (value == null) {
                    return "";
                }
                return ((SourceType)value).getDisplayString();
            }

            public String getFilterString(SourceType t, Settings settings) {
                return this.getText(t);
            }
        };

        private SourceTableColumn() {
        }

        public String getColumnName() {
            return SymbolTableModel.SOURCE_COL_NAME;
        }

        public GColumnRenderer<SourceType> getColumnRenderer() {
            return this.renderer;
        }

        public SourceType getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = SymbolTableModel.this.getSymbolForRowObject(rowObject);
            if (symbol == null) {
                return null;
            }
            return symbol.getSource();
        }
    }

    private class NamespaceTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        private NamespaceTableColumn() {
        }

        public String getColumnName() {
            return SymbolTableModel.NAMESPACE_COL_NAME;
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = SymbolTableModel.this.getSymbolForRowObject(rowObject);
            if (symbol == null) {
                return null;
            }
            return symbol.getParentNamespace().getName(true);
        }
    }

    private class DataTypeTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, String> {
        private DataTypeTableColumn() {
        }

        public String getColumnName() {
            return "Data Type";
        }

        public String getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = SymbolTableModel.this.getSymbolForRowObject(rowObject);
            if (symbol == null) {
                return null;
            }
            DataType dt = null;
            Object obj = symbol.getObject();
            if (obj instanceof Data) {
                dt = ((Data)obj).getDataType();
            } else if (obj instanceof Function) {
                dt = ((Function)obj).getReturnType();
            } else if (obj instanceof Variable) {
                dt = ((Variable)obj).getDataType();
            } else if (obj instanceof ExternalLocation) {
                dt = ((ExternalLocation)obj).getDataType();
            }
            if (dt != null) {
                return dt.getDisplayName();
            }
            return "";
        }
    }

    private class VariableSymbolLocation
    extends AddressBasedLocation {
        VariableSymbolLocation(Variable variable) {
            super(variable.getSymbol().getAddress(), variable.getVariableStorage().toString());
        }
    }

    private class LocationTableColumn
    extends AbstractProgramLocationTableColumn<SymbolRowObject, AddressBasedLocation> {
        private LocationTableColumn() {
        }

        public String getColumnName() {
            return SymbolTableModel.LOCATION_COL_NAME;
        }

        public AddressBasedLocation getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            return SymbolTableModel.this.getSymbolLocation(rowObject);
        }

        @Override
        public ProgramLocation getProgramLocation(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) {
            Symbol symbol = SymbolTableModel.this.getSymbolForRowObject(rowObject);
            if (symbol == null) {
                return null;
            }
            return symbol.getProgramLocation();
        }
    }

    private class PinnedTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, Boolean> {
        private PinnedRenderer renderer = new PinnedRenderer();

        private PinnedTableColumn() {
        }

        public String getColumnName() {
            return "Pinned";
        }

        public Boolean getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            Symbol symbol = SymbolTableModel.this.getSymbolForRowObject(rowObject);
            if (symbol == null) {
                return null;
            }
            return symbol.isPinned();
        }

        public GColumnRenderer<Boolean> getColumnRenderer() {
            return this.renderer;
        }

        private class PinnedRenderer
        extends GBooleanCellRenderer
        implements AbstractWrapperTypeColumnRenderer<Boolean> {
            private PinnedRenderer() {
            }
        }
    }

    private class NameTableColumn
    extends AbstractProgramBasedDynamicTableColumn<SymbolRowObject, Symbol> {
        private NameTableColumn() {
        }

        public String getColumnName() {
            return "Name";
        }

        public Symbol getValue(SymbolRowObject rowObject, Settings settings, Program p, ServiceProvider svcProvider) throws IllegalArgumentException {
            return SymbolTableModel.this.getSymbolForRowObject(rowObject);
        }
    }
}

