/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import ghidra.app.util.viewer.util.AddressPixelMap;
import ghidra.program.model.mem.MemoryBlock;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BlockPanel
extends JPanel
implements ComponentListener {
    private static final long serialVersionUID = 1L;
    private static final int SPACING = 5;
    private static final Font FONT = new Font("SansSerif", 0, 10);
    private AddressPixelMap map;
    private FontMetrics metrics;

    public BlockPanel() {
        this.setBackground(Color.WHITE);
        this.addComponentListener(this);
        this.metrics = this.getFontMetrics(FONT);
        this.setPreferredSize(new Dimension(100, 5 + this.metrics.getMaxAscent() + this.metrics.getMaxDescent()));
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.BLACK);
        g.setFont(FONT);
        int height = this.getHeight();
        MemoryBlock[] blocks = this.map.getBlocks();
        if (blocks == null) {
            return;
        }
        for (int i = 0; i < blocks.length; ++i) {
            Rectangle rect = this.map.getBlockPosition(blocks[i]);
            g.drawLine(rect.x, 0, rect.x, height - 1);
        }
        g.drawLine(this.getWidth() - 1, 0, this.getWidth() - 1, height - 1);
        g.drawLine(0, height - 1, this.getWidth() - 1, height - 1);
    }

    @Override
    protected void paintChildren(Graphics g) {
        Color oldColor = g.getColor();
        g.setColor(this.getBackground());
        Rectangle clip = g.getClipBounds();
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(oldColor);
        super.paintChildren(g);
        this.paintComponent(g);
    }

    public void setMemoryBlockMap(AddressPixelMap map) {
        this.map = map;
        this.repaint();
    }

    private void buildLabels() {
        this.removeAll();
        this.setLayout(null);
        Container parent = this.getParent();
        MemoryBlock[] blocks = this.map.getBlocks();
        if (blocks == null) {
            return;
        }
        for (MemoryBlock block : blocks) {
            JLabel label = new JLabel(block.getName());
            label.setFont(FONT);
            label.setHorizontalAlignment(0);
            label.setToolTipText(block.getName());
            Rectangle rect = this.map.getBlockPosition(block);
            int height = this.getHeight();
            int width = this.metrics.stringWidth(block.getName());
            if (rect.width < width) {
                label.setText("...");
            }
            int labelWidth = Math.min(rect.width, width);
            labelWidth = Math.max(labelWidth, 3);
            int labelHeight = height - 1;
            int x = rect.x + (rect.width - 1) / 2 - labelWidth / 2;
            int y = 0;
            label.setBounds(x, y, labelWidth, labelHeight);
            this.add(label);
        }
        this.invalidate();
        if (parent != null) {
            parent.validate();
        }
    }

    public void refresh() {
        this.buildLabels();
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.refresh();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }
}

