/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.line;

import ghidra.app.util.bin.BinaryReader;
import java.io.IOException;

class LEB128 {
    private long value;

    LEB128(BinaryReader reader, boolean isSigned) throws IOException {
        if (isSigned) {
            throw new UnsupportedOperationException();
        }
        int shift = 0;
        while (true) {
            int nextByte = reader.readNextByte() & 0xFF;
            this.value |= (long)((nextByte & 0x7F) << shift);
            if ((nextByte & 0x80) == 0) break;
            shift += 7;
        }
    }

    long getValue() {
        return this.value;
    }

    public String toString() {
        return "0x" + Long.toHexString(this.value);
    }
}

