/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.OffsetValidator;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFLineNumber;
import ghidra.app.util.bin.format.pe.debug.DebugCOFFSymbolTable;
import ghidra.app.util.bin.format.pe.debug.DebugDirectory;
import ghidra.util.Msg;
import java.io.IOException;

public class DebugCOFFSymbolsHeader {
    private int numberOfSymbols;
    private int lvaToFirstSymbol;
    private int numberOfLinenumbers;
    private int lvaToFirstLinenumber;
    private int rvaToFirstByteOfCode;
    private int rvaToLastByteOfCode;
    private int rvaToFirstByteOfData;
    private int rvaToLastByteOfData;
    private DebugCOFFSymbolTable symbolTable;
    private DebugCOFFLineNumber[] lineNumbers;

    static DebugCOFFSymbolsHeader createDebugCOFFSymbolsHeader(FactoryBundledWithBinaryReader reader, DebugDirectory debugDir, OffsetValidator validator) throws IOException {
        DebugCOFFSymbolsHeader debugCOFFSymbolsHeader = (DebugCOFFSymbolsHeader)reader.getFactory().create(DebugCOFFSymbolsHeader.class, new Object[0]);
        debugCOFFSymbolsHeader.initDebugCOFFSymbolsHeader(reader, debugDir, validator);
        return debugCOFFSymbolsHeader;
    }

    private void initDebugCOFFSymbolsHeader(FactoryBundledWithBinaryReader reader, DebugDirectory debugDir, OffsetValidator validator) throws IOException {
        int ptr = debugDir.getPointerToRawData();
        if (!validator.checkPointer(ptr)) {
            Msg.error((Object)this, (Object)("Invalid pointer " + Long.toHexString(ptr)));
            return;
        }
        this.numberOfSymbols = reader.readInt(ptr);
        this.lvaToFirstSymbol = reader.readInt(ptr += 4);
        this.numberOfLinenumbers = reader.readInt(ptr += 4);
        this.lvaToFirstLinenumber = reader.readInt(ptr += 4);
        this.rvaToFirstByteOfCode = reader.readInt(ptr += 4);
        this.rvaToLastByteOfCode = reader.readInt(ptr += 4);
        this.rvaToFirstByteOfData = reader.readInt(ptr += 4);
        this.rvaToLastByteOfData = reader.readInt(ptr += 4);
        ptr += 4;
        if (this.numberOfLinenumbers > 0 && this.numberOfLinenumbers < 65536) {
            this.lineNumbers = new DebugCOFFLineNumber[this.numberOfLinenumbers];
            for (int i = 0; i < this.numberOfLinenumbers; ++i) {
                this.lineNumbers[i] = DebugCOFFLineNumber.createDebugCOFFLineNumber(reader, ptr);
                ptr += 6;
            }
        }
        this.symbolTable = DebugCOFFSymbolTable.createDebugCOFFSymbolTable(reader, this, debugDir.getPointerToRawData());
    }

    public DebugCOFFSymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public DebugCOFFLineNumber[] getLineNumbers() {
        return this.lineNumbers;
    }

    public int getNumberOfSymbols() {
        return this.numberOfSymbols;
    }

    public int getFirstSymbolLVA() {
        return this.lvaToFirstSymbol;
    }

    public int getNumberOfLinenumbers() {
        return this.numberOfLinenumbers;
    }

    public int getFirstLinenumberLVA() {
        return this.lvaToFirstLinenumber;
    }

    public int getFirstByteOfCodeRVA() {
        return this.rvaToFirstByteOfCode;
    }

    public int getLastByteOfCodeRVA() {
        return this.rvaToLastByteOfCode;
    }

    public int getFirstByteOfDataRVA() {
        return this.rvaToFirstByteOfData;
    }

    public int getLastByteOfDataRVA() {
        return this.rvaToLastByteOfData;
    }
}

