/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.datatype;

import ghidra.app.util.datatype.DataTypeSelectionDialog;
import ghidra.app.util.datatype.DataTypeSelectionEditor;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataTypeManager;
import ghidra.util.data.DataTypeParser;
import ghidra.util.layout.VerticalLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ApplyEnumDialog
extends DataTypeSelectionDialog {
    private boolean shouldApplyOnSubOps;

    public ApplyEnumDialog(PluginTool pluginTool, DataTypeManager dtm) {
        super(pluginTool, dtm, -1, DataTypeParser.AllowedDataTypes.FIXED_LENGTH);
    }

    @Override
    protected JComponent createEditorPanel(DataTypeSelectionEditor dtEditor) {
        this.setTitle("Apply Enum");
        JPanel updatedPanel = new JPanel();
        updatedPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 0));
        updatedPanel.setLayout((LayoutManager)new VerticalLayout(5));
        JLabel label = new JLabel("Choose an Enum data type to apply.");
        label.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        JCheckBox subOpCB = new JCheckBox("Apply to sub-operands", this.shouldApplyOnSubOps);
        subOpCB.setName("subOpCB");
        subOpCB.setToolTipText("Applies this enum to the 'nested scalars'.");
        subOpCB.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        subOpCB.addActionListener(evt -> {
            this.shouldApplyOnSubOps = subOpCB.isSelected();
        });
        updatedPanel.add(label);
        updatedPanel.add(dtEditor.getEditorComponent());
        updatedPanel.add(subOpCB);
        return updatedPanel;
    }

    public boolean shouldApplyOnSubOps() {
        return this.shouldApplyOnSubOps;
    }
}

