/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.cmd.label.SetLabelPrimaryCmd;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledType;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.demangler.DemanglerUtil;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import util.demangler.GenericDemangledObject;
import util.demangler.GenericDemangledType;

public abstract class DemangledObject {
    protected static final String SPACE = " ";
    protected static final Pattern SPACE_PATTERN = Pattern.compile(" ");
    protected static final String NAMESPACE_SEPARATOR = "::";
    protected static final String EMPTY_STRING = "";
    protected String originalMangled;
    protected String utilDemangled;
    protected String specialPrefix;
    protected String specialMidfix;
    protected String specialSuffix;
    protected DemangledType namespace;
    protected String visibility;
    protected String storageClass;
    private String demangledName;
    private String name;
    private boolean isConst;
    private boolean isVolatile;
    private boolean isPointer64;
    protected boolean isStatic;
    protected boolean isVirtual;
    protected boolean isThunk;
    protected boolean isUnaligned;
    protected boolean isRestrict;
    protected String basedName;
    protected String memberScope;
    private String signature;

    DemangledObject() {
    }

    DemangledObject(GenericDemangledObject other) {
        this.originalMangled = other.getOriginalMangled();
        this.specialPrefix = other.getSpecialPrefix();
        this.specialMidfix = other.getSpecialMidfix();
        this.specialSuffix = other.getSpecialSuffix();
        GenericDemangledType otherNamespace = other.getNamespace();
        if (otherNamespace != null) {
            this.namespace = DemangledType.convertToNamespace(otherNamespace);
        }
        this.visibility = other.getVisibility();
        this.storageClass = other.getStorageClass();
        this.setName(other.getName());
        this.isConst = other.isConst();
        this.isVolatile = other.isVolatile();
        this.isPointer64 = other.isPointer64();
        this.isStatic = other.isStatic();
        this.isVirtual = other.isVirtual();
        this.isThunk = other.isThunk();
        this.isUnaligned = other.isUnaligned();
        this.isRestrict = other.isRestrict();
        this.basedName = other.getBasedName();
        this.memberScope = other.getMemberScope();
    }

    public String getDemangledName() {
        return this.demangledName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public void setConst(boolean isConst) {
        this.isConst = isConst;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    public void setVolatile(boolean isVolatile) {
        this.isVolatile = isVolatile;
    }

    public boolean isPointer64() {
        return this.isPointer64;
    }

    public void setPointer64(boolean isPointer64) {
        this.isPointer64 = isPointer64;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setVirtual(boolean isVirtual) {
        this.isVirtual = isVirtual;
    }

    public boolean isThunk() {
        return this.isThunk;
    }

    public void setThunk(boolean isThunk) {
        this.isThunk = isThunk;
    }

    public void setUnaligned() {
        this.isUnaligned = true;
    }

    public boolean isUnaligned() {
        return this.isUnaligned;
    }

    public void setRestrict() {
        this.isRestrict = true;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    public String getBasedName() {
        return this.basedName;
    }

    public void setBasedName(String basedName) {
        this.basedName = basedName;
    }

    public String getMemberScope() {
        return this.memberScope;
    }

    public void setMemberScope(String memberScope) {
        this.memberScope = memberScope;
    }

    public void setName(String name) {
        this.demangledName = name;
        this.name = name;
        if (name != null) {
            this.name = DemanglerUtil.stripSuperfluousSignatureSpaces(name).trim().replace(' ', '_');
        }
    }

    public void setOriginalMangled(String mangled) {
        this.originalMangled = mangled;
    }

    public void setUtilDemangled(String utilDemangled) {
        this.utilDemangled = utilDemangled;
    }

    public String getUtilDemangled() {
        return this.utilDemangled;
    }

    public DemangledType getNamespace() {
        return this.namespace;
    }

    public void setNamespace(DemangledType namespace) {
        this.namespace = namespace;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibilty(String visibility) {
        this.visibility = visibility;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    public String getSpecialPrefix() {
        return this.specialPrefix;
    }

    public void setSpecialPrefix(String special) {
        this.specialPrefix = special;
    }

    public String getSpecialMidfix() {
        return this.specialMidfix;
    }

    public void setSpecialMidfix(String chargeType) {
        this.specialMidfix = chargeType;
    }

    public String getSpecialSuffix() {
        return this.specialSuffix;
    }

    public void setSpecialSuffix(String specialSuffix) {
        this.specialSuffix = specialSuffix;
    }

    public abstract String getSignature(boolean var1);

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String toString() {
        return this.getSignature(false);
    }

    protected boolean isAlreadyDemangled(Program program, Address address) {
        Symbol[] symbols;
        String symbolName = DemangledObject.ensureNameLength(this.name);
        if (address.isExternalAddress()) {
            Symbol extSymbol = program.getSymbolTable().getPrimarySymbol(address);
            if (extSymbol == null) {
                return false;
            }
            ExternalLocation extLoc = program.getExternalManager().getExternalLocation(extSymbol);
            return extLoc.getOriginalImportedName() != null;
        }
        for (Symbol symbol : symbols = program.getSymbolTable().getSymbols(address)) {
            SymbolType symbolType;
            if (!symbol.getName().equals(symbolName) || symbol.getParentNamespace().isGlobal() || (symbolType = symbol.getSymbolType()) != SymbolType.CODE && symbolType != SymbolType.FUNCTION) continue;
            return true;
        }
        return false;
    }

    public boolean applyTo(Program program, Address address, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        if (this.originalMangled.equals(this.name)) {
            return false;
        }
        Object comment = program.getListing().getComment(3, address);
        String newComment = this.generatePlateComment();
        if (comment == null || ((String)comment).indexOf(newComment) < 0) {
            comment = comment == null ? newComment : (String)comment + "\n" + newComment;
            program.getListing().setComment(address, 3, (String)comment);
        }
        return true;
    }

    protected String generatePlateComment() {
        if (this.utilDemangled != null) {
            return this.utilDemangled;
        }
        return this.signature == null ? this.getSignature(true) : this.signature;
    }

    protected String pad(int len) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            buffer.append(' ');
        }
        return buffer.toString();
    }

    protected Symbol applyDemangledName(Address addr, boolean setPrimary, boolean functionNamespacePermitted, Program prog) throws InvalidInputException {
        return this.applyDemangledName(this.name, addr, setPrimary, functionNamespacePermitted, prog);
    }

    protected Symbol applyDemangledName(String symbolName, Address addr, boolean setPrimary, boolean functionNamespacePermitted, Program prog) throws InvalidInputException {
        symbolName = DemangledObject.ensureNameLength(symbolName);
        if (addr.isExternalAddress()) {
            return this.updateExternalSymbol(prog, addr, symbolName, this.namespace);
        }
        SymbolTable symbolTable = prog.getSymbolTable();
        Namespace ns = DemangledObject.createNamespace(prog, this.namespace, null, functionNamespacePermitted);
        Symbol demangledSymbol = SymbolUtilities.createPreferredLabelOrFunctionSymbol((Program)prog, (Address)addr, (Namespace)ns, (String)symbolName, (SourceType)SourceType.ANALYSIS);
        if (demangledSymbol == null || !setPrimary) {
            return demangledSymbol;
        }
        SetLabelPrimaryCmd cmd = new SetLabelPrimaryCmd(addr, symbolName, ns);
        cmd.applyTo((DomainObject)prog);
        return symbolTable.getPrimarySymbol(addr);
    }

    private Symbol updateExternalSymbol(Program program, Address externalAddr, String symbolName, DemangledType demangledNamespace) {
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol s = symbolTable.getPrimarySymbol(externalAddr);
        if (s == null) {
            Msg.error(DemangledObject.class, (Object)("No such external address " + externalAddr + " for " + symbolName));
        }
        try {
            Namespace ns = DemangledObject.createNamespace(program, demangledNamespace, s.getParentNamespace(), false);
            ExternalLocation extLoc = s.getProgram().getExternalManager().getExternalLocation(s);
            extLoc.setName(ns, symbolName, SourceType.IMPORTED);
        }
        catch (Exception e) {
            Msg.error(DemangledObject.class, (Object)("Unexpected Exception setting name and namespace for " + symbolName + " in " + s.getParentNamespace()), (Throwable)e);
        }
        return s;
    }

    private static List<String> getNamespaceList(DemangledType typeNamespace) {
        ArrayList<String> list = new ArrayList<String>();
        for (DemangledType ns = typeNamespace; ns != null; ns = ns.getNamespace()) {
            list.add(0, ns.getName());
        }
        return list;
    }

    public static Namespace createNamespace(Program program, DemangledType typeNamespace, Namespace parentNamespace, boolean functionPermitted) {
        Namespace namespace = parentNamespace;
        if (namespace == null) {
            namespace = program.getGlobalNamespace();
        }
        for (String namespaceName : DemangledObject.getNamespaceList(typeNamespace)) {
            namespaceName = DemangledObject.ensureNameLength(namespaceName);
            SymbolTable symbolTable = program.getSymbolTable();
            List symbols = symbolTable.getSymbols(namespaceName, namespace);
            Symbol namespaceSymbol = symbols.stream().filter(s -> s.getSymbolType() == SymbolType.NAMESPACE || s.getSymbolType() == SymbolType.CLASS).findFirst().orElse(null);
            if (namespaceSymbol == null) {
                try {
                    namespace = symbolTable.createNameSpace(namespace, namespaceName, SourceType.IMPORTED);
                    continue;
                }
                catch (DuplicateNameException e) {
                    Msg.error(DemangledObject.class, (Object)("Failed to create namespace due to name conflict: " + NamespaceUtils.getNamespaceQualifiedName((Namespace)namespace, (String)namespaceName, (boolean)false)));
                    break;
                }
                catch (InvalidInputException e) {
                    Msg.error(DemangledObject.class, (Object)("Failed to create namespace: " + e.getMessage()));
                    break;
                }
            }
            if (DemangledObject.isPermittedNamespaceSymbol(namespaceSymbol, functionPermitted)) {
                namespace = (Namespace)namespaceSymbol.getObject();
                continue;
            }
            Msg.error(DemangledObject.class, (Object)("Failed to create namespace due to name conflict: " + NamespaceUtils.getNamespaceQualifiedName((Namespace)namespace, (String)namespaceName, (boolean)false)));
            break;
        }
        return namespace;
    }

    private static boolean isPermittedNamespaceSymbol(Symbol symbol, boolean functionPermitted) {
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType == SymbolType.CLASS || symbolType == SymbolType.NAMESPACE) {
            return true;
        }
        return functionPermitted && symbolType == SymbolType.FUNCTION;
    }

    protected static String ensureNameLength(String name) {
        int length = name.length();
        if (length <= 2000) {
            return name;
        }
        StringBuilder buffy = new StringBuilder();
        buffy.append(name.substring(0, 1000));
        buffy.append("...");
        buffy.append(length - 100);
        return buffy.toString();
    }

    protected Structure createClassStructure(Program prog, Function func) {
        DemangledType classStructureNamespace;
        Structure classStructure;
        DataTypeManager dataTypeManager = prog.getDataTypeManager();
        if (this.namespace == null) {
            return null;
        }
        String structureName = this.namespace.getName();
        Symbol parentSymbol = func.getSymbol().getParentSymbol();
        if (parentSymbol.getSymbolType() == SymbolType.NAMESPACE) {
            try {
                NamespaceUtils.convertNamespaceToClass((Namespace)((Namespace)parentSymbol.getObject()));
            }
            catch (InvalidInputException e) {
                throw new AssertException((Throwable)e);
            }
        }
        if ((classStructure = (Structure)DemangledDataType.findDataType(dataTypeManager, classStructureNamespace = this.namespace.getNamespace(), structureName)) == null) {
            classStructure = DemangledDataType.createPlaceHolderStructure(structureName, classStructureNamespace);
        }
        classStructure = (Structure)dataTypeManager.resolve((DataType)classStructure, DataTypeConflictHandler.DEFAULT_HANDLER);
        return classStructure;
    }
}

