/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table;

import docking.ActionContext;
import docking.action.MenuData;
import docking.action.ToolBarData;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.ThreadedTableModel;
import ghidra.app.actions.AbstractSharedKeybindingAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.timer.GTimer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.table.TableModel;
import resources.ResourceManager;

public class DeleteTableRowAction
extends AbstractSharedKeybindingAction {
    private static final KeyStroke DEFAULT_KEYSTROKE = KeyStroke.getKeyStroke(127, 0);
    private static final ImageIcon ICON = ResourceManager.loadImage((String)"images/table_delete.png");
    private static final String NAME = "Remove Items";
    private GTable table;

    public static void registerDummy(PluginTool tool) {
        new DummyDeleteAction(tool);
    }

    private DeleteTableRowAction(PluginTool tool) {
        super(tool, NAME, "Tool", DEFAULT_KEYSTROKE);
    }

    public DeleteTableRowAction(PluginTool tool, GTable table, String owner) {
        this(tool, NAME, owner, DEFAULT_KEYSTROKE);
        this.table = table;
    }

    private DeleteTableRowAction(PluginTool tool, String name, String owner, KeyStroke defaultkeyStroke) {
        super(tool, name, owner, defaultkeyStroke);
        this.setDescription("Remove the selected rows from the table");
        this.setHelpLocation(new HelpLocation("Search", "Remove_Items"));
        this.setToolBarData(new ToolBarData((Icon)ICON, null));
        this.setPopupMenuData(new MenuData(new String[]{NAME}, (Icon)ICON, null));
    }

    public boolean isEnabledForContext(ActionContext context) {
        return this.table.getSelectedRowCount() > 0;
    }

    public void actionPerformed(ActionContext context) {
        this.removeSelectedItems();
    }

    protected void removeSelectedItems() {
        TableModel model = this.table.getModel();
        if (!(model instanceof RowObjectTableModel)) {
            throw new AssertException("This action cannot delete rows for the given table model.You can override this method to peform the delete action yourself.");
        }
        if (this.checkForBusy(model)) {
            Msg.showInfo((Object)((Object)this), (Component)this.table, (String)"Table is Busy", (Object)"Cannot remove items from the table while it is working");
            return;
        }
        RowObjectTableModel rowObjectModel = (RowObjectTableModel)model;
        int[] rows = this.table.getSelectedRows();
        ArrayList<Object> itemsToRemove = new ArrayList<Object>();
        for (int row : rows) {
            itemsToRemove.add(rowObjectModel.getRowObject(row));
        }
        this.removeRowObjects(model, itemsToRemove);
        int restoreRow = rows[0];
        this.selectRow(model, restoreRow);
    }

    protected void removeRowObjects(TableModel model, List<Object> itemsToRemove) {
        if (!(model instanceof ThreadedTableModel)) {
            throw new AssertException("This action cannot delete rows for the given table model.You can override this method to peform the delete action yourself.");
        }
        ThreadedTableModel threadedModel = (ThreadedTableModel)model;
        for (Object o : itemsToRemove) {
            threadedModel.removeObject(o);
        }
    }

    public boolean checkForBusy(TableModel model) {
        if (!(model instanceof ThreadedTableModel)) {
            return false;
        }
        ThreadedTableModel threadedModel = (ThreadedTableModel)model;
        return threadedModel.isBusy();
    }

    private void selectRow(TableModel model, int row) {
        SwingUtilities.invokeLater(() -> {
            if (this.checkForBusy(model)) {
                GTimer.scheduleRunnable((long)500L, () -> this.selectRow(model, row));
                return;
            }
            int rowCount = model.getRowCount();
            if (rowCount == 0) {
                return;
            }
            if (row < 0) {
                return;
            }
            int selectRow = row;
            if (row >= rowCount) {
                selectRow = rowCount - 1;
            }
            this.table.setRowSelectionInterval(selectRow, selectRow);
        });
    }

    private static class DummyDeleteAction
    extends DeleteTableRowAction {
        DummyDeleteAction(PluginTool tool) {
            super(tool);
        }

        @Override
        public void actionPerformed(ActionContext context) {
        }
    }
}

