/*
 * Decompiled with CFR 0.152.
 */
package util.demangler;

public class CharacterIterator {
    public static final char DONE = '\uffff';
    private String string;
    private int index;

    public CharacterIterator(String str) {
        this.string = str;
    }

    public String getString() {
        return this.string;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.string.length();
    }

    public void setIndex(int index) {
        if (index < 0 || index > this.string.length() - 1) {
            throw new IllegalArgumentException();
        }
        this.index = index;
    }

    public boolean hasNext() {
        return this.index < this.string.length() - 1;
    }

    public char peek() {
        try {
            return this.string.charAt(this.index);
        }
        catch (IndexOutOfBoundsException e) {
            return '\uffff';
        }
    }

    public char peek(int lookAhead) {
        try {
            return this.string.charAt(this.index + lookAhead);
        }
        catch (IndexOutOfBoundsException e) {
            return '\uffff';
        }
    }

    public char next() {
        try {
            return this.string.charAt(++this.index);
        }
        catch (IndexOutOfBoundsException e) {
            this.index = this.string.length();
            return '\uffff';
        }
    }

    public char getAndIncrement() {
        try {
            return this.string.charAt(this.index++);
        }
        catch (IndexOutOfBoundsException e) {
            this.index = this.string.length();
            return '\uffff';
        }
    }

    public char previous() {
        try {
            return this.string.charAt(--this.index);
        }
        catch (IndexOutOfBoundsException e) {
            this.index = 0;
            return '\uffff';
        }
    }

    public String nextString(int len) {
        String s = this.string.substring(this.index, this.index + len);
        this.index += len;
        return s;
    }

    public int nextInteger() {
        int origIndex = this.index;
        while (Character.isDigit(this.peek())) {
            this.getAndIncrement();
        }
        if (origIndex == this.index) {
            return this.string.charAt(this.index) - 48;
        }
        String s = this.string.substring(origIndex, this.index);
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.index = origIndex;
            throw e;
        }
    }

    public int find(char c) {
        for (int i = this.index; i < this.string.length(); ++i) {
            if (this.string.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return "currnt = " + this.peek() + "; next = " + this.peek(1);
    }

    public String getContext() {
        StringBuilder buffy = new StringBuilder();
        int amount = 5;
        int start = this.index - amount;
        for (int i = start = Math.max(start, 0); i < this.index; ++i) {
            buffy.append(this.string.charAt(i));
        }
        buffy.append('[').append(this.string.charAt(this.index)).append(']');
        int end = this.index + amount + 1;
        end = Math.min(end, this.string.length());
        for (int i = this.index + 1; i < end; ++i) {
            buffy.append(this.string.charAt(i));
        }
        buffy.append(" @ ").append(this.index);
        return buffy.toString();
    }
}

