/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.Field;
import db.LongField;
import db.Record;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class Schema {
    private static final String NAME_SEPARATOR = ";";
    private int version;
    private Field keyType;
    private String keyName;
    private Class<?>[] fieldClasses;
    private String[] fieldNames;
    private boolean isVariableLength;
    private int fixedLength;

    public Schema(int version, Class<? extends Field> keyFieldClass, String keyName, Class<?>[] fieldClasses, String[] fieldNames) {
        this.version = version;
        this.keyType = this.getField(keyFieldClass);
        this.keyName = keyName;
        this.fieldClasses = new Class[fieldClasses.length];
        this.fieldNames = fieldNames;
        if (fieldClasses.length != fieldNames.length) {
            throw new IllegalArgumentException();
        }
        this.isVariableLength = false;
        this.fixedLength = 0;
        for (int i = 0; i < fieldClasses.length; ++i) {
            this.fieldClasses[i] = fieldClasses[i];
            Field field = this.getField(fieldClasses[i]);
            if (field.isVariableLength()) {
                this.isVariableLength = true;
            }
            this.fixedLength += field.length();
            if (fieldNames[i].indexOf(NAME_SEPARATOR) < 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.isVariableLength) {
            this.fixedLength = 0;
        }
    }

    public Schema(int version, String keyName, Class<?>[] fieldClasses, String[] fieldNames) {
        this(version, LongField.class, keyName, fieldClasses, fieldNames);
    }

    Schema(int version, byte keyFieldType, byte[] fieldTypes, String packedFieldNames) {
        this.version = version;
        this.keyType = Field.getField(keyFieldType);
        this.parseNames(packedFieldNames);
        if (fieldTypes.length != this.fieldNames.length) {
            throw new IllegalArgumentException();
        }
        this.fieldClasses = new Class[fieldTypes.length];
        this.isVariableLength = false;
        this.fixedLength = 0;
        for (int i = 0; i < fieldTypes.length; ++i) {
            Field field = Field.getField(fieldTypes[i]);
            this.fieldClasses[i] = field.getClass();
            if (field.isVariableLength()) {
                this.isVariableLength = true;
            }
            this.fixedLength += field.length();
        }
        if (this.isVariableLength) {
            this.fixedLength = 0;
        }
    }

    boolean useLongKeyNodes() {
        return this.keyType instanceof LongField;
    }

    public Class<? extends Field> getKeyFieldClass() {
        return this.keyType.getClass();
    }

    Field getKeyFieldType() {
        return this.keyType;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public Class<?>[] getFieldClasses() {
        return this.fieldClasses;
    }

    public String[] getFieldNames() {
        return this.fieldNames;
    }

    public int getFieldCount() {
        return this.fieldClasses.length;
    }

    private void parseNames(String packedNames) {
        ArrayList<String> nameList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(packedNames, NAME_SEPARATOR);
        while (st.hasMoreElements()) {
            nameList.add(st.nextToken());
        }
        this.keyName = (String)nameList.remove(0);
        this.fieldNames = new String[nameList.size()];
        nameList.toArray(this.fieldNames);
    }

    String getPackedFieldNames() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.keyName);
        buf.append(NAME_SEPARATOR);
        for (int i = 0; i < this.fieldNames.length; ++i) {
            buf.append(this.fieldNames[i]);
            buf.append(NAME_SEPARATOR);
        }
        return buf.toString();
    }

    byte[] getFieldTypes() {
        byte[] fieldTypes = new byte[this.fieldClasses.length];
        for (int i = 0; i < this.fieldClasses.length; ++i) {
            fieldTypes[i] = this.getField(this.fieldClasses[i]).getFieldType();
        }
        return fieldTypes;
    }

    public int getVersion() {
        return this.version;
    }

    public boolean isVariableLength() {
        return this.isVariableLength;
    }

    public int getFixedLength() {
        return this.fixedLength;
    }

    public Record createRecord(long key) {
        return this.createRecord(new LongField(key));
    }

    public Record createRecord(Field key) {
        if (!this.getKeyFieldClass().equals(key.getClass())) {
            throw new IllegalArgumentException("expected key field type of " + this.keyType.getClass().getSimpleName());
        }
        Field[] fieldValues = new Field[this.fieldClasses.length];
        for (int i = 0; i < this.fieldClasses.length; ++i) {
            try {
                fieldValues[i] = (Field)this.fieldClasses[i].newInstance();
                continue;
            }
            catch (Exception e) {
                throw new AssertException();
            }
        }
        return new Record(key, fieldValues);
    }

    Field getField(int colIndex) {
        try {
            return (Field)this.fieldClasses[colIndex].newInstance();
        }
        catch (Exception e) {
            throw new AssertException(e.getMessage());
        }
    }

    private Field getField(Class<?> fieldClass) {
        try {
            return (Field)fieldClass.newInstance();
        }
        catch (Exception e) {
            throw new AssertException(e.getMessage());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Schema)) {
            return false;
        }
        Schema otherSchema = (Schema)obj;
        if (this.version != otherSchema.version || !this.keyType.getClass().equals(otherSchema.keyType.getClass()) || this.fieldClasses.length != otherSchema.fieldClasses.length) {
            return false;
        }
        for (int i = 0; i < this.fieldClasses.length; ++i) {
            if (this.fieldClasses[i].getClass().equals(otherSchema.fieldClasses[i].getClass())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.keyName);
        buf.append("(key,");
        buf.append(this.keyType.getClass().getSimpleName());
        buf.append(")");
        for (int i = 0; i < this.fieldNames.length; ++i) {
            buf.append("\n");
            buf.append(this.fieldNames[i]);
            buf.append("(");
            buf.append(this.fieldClasses[i].getSimpleName());
            buf.append(")");
        }
        return buf.toString();
    }
}

