/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.ChainedBuffer;
import db.Field;
import db.NodeMgr;
import db.Record;
import db.Schema;
import db.Table;
import db.VarKeyInteriorNode;
import db.VarKeyNode;
import db.buffers.DataBuffer;
import ghidra.util.Msg;
import ghidra.util.datastruct.IntArrayList;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class VarKeyRecordNode
extends VarKeyNode {
    private static final int ID_SIZE = 4;
    private static final int PREV_LEAF_ID_OFFSET = 6;
    private static final int NEXT_LEAF_ID_OFFSET = 10;
    static final int HEADER_SIZE = 14;
    private static final int OFFSET_SIZE = 4;
    private static final int INDIRECT_OPTION_SIZE = 1;
    private static final int ENTRY_SIZE = 5;

    VarKeyRecordNode(NodeMgr nodeMgr, DataBuffer buf) {
        super(nodeMgr, buf);
    }

    VarKeyRecordNode(NodeMgr nodeMgr, int prevLeafId, int nextLeafId, Field keyType) throws IOException {
        super(nodeMgr, (byte)4, keyType);
        this.buffer.putInt(6, prevLeafId);
        this.buffer.putInt(10, nextLeafId);
    }

    VarKeyRecordNode(NodeMgr nodeMgr, Field keyType) throws IOException {
        super(nodeMgr, (byte)4, keyType);
        this.buffer.putInt(6, -1);
        this.buffer.putInt(10, -1);
    }

    void logConsistencyError(String tableName, String msg, Throwable t) throws IOException {
        Msg.debug((Object)this, (Object)("Consistency Error (" + tableName + "): " + msg));
        Msg.debug((Object)this, (Object)("  bufferID=" + this.getBufferId() + " key[0]=" + this.getKey(0)));
        if (t != null) {
            Msg.error((Object)this, (Object)("Consistency Error (" + tableName + ")"), (Throwable)t);
        }
    }

    @Override
    public boolean isConsistent(String tableName, TaskMonitor monitor) throws IOException, CancelledException {
        VarKeyRecordNode node;
        boolean consistent = true;
        Field prevKey = null;
        for (int i = 0; i < this.keyCount; ++i) {
            Field key = this.getKey(i);
            if (i != 0 && key.compareTo(prevKey) <= 0) {
                consistent = false;
                this.logConsistencyError(tableName, "key[" + i + "] <= key[" + (i - 1) + "]", null);
                Msg.debug((Object)this, (Object)("  key[" + i + "].minKey = " + key));
                Msg.debug((Object)this, (Object)("  key[" + (i - 1) + "].minKey = " + prevKey));
            }
            prevKey = key;
        }
        if ((this.parent == null || this.parent.isLeftmostKey(this.getKey(0))) && this.getPreviousLeaf() != null) {
            consistent = false;
            this.logConsistencyError(tableName, "previous-leaf should not exist", null);
        }
        if ((node = this.getNextLeaf()) != null) {
            if (this.parent == null || this.parent.isRightmostKey(this.getKey(0))) {
                consistent = false;
                this.logConsistencyError(tableName, "next-leaf should not exist", null);
            } else {
                VarKeyRecordNode me = node.getPreviousLeaf();
                if (me != this) {
                    consistent = false;
                    this.logConsistencyError(tableName, "next-leaf is not linked to this leaf", null);
                }
            }
        } else if (this.parent != null && !this.parent.isRightmostKey(this.getKey(0))) {
            consistent = false;
            this.logConsistencyError(tableName, "this leaf is not linked to next-leaf", null);
        }
        return consistent;
    }

    @Override
    VarKeyRecordNode getLeafNode(Field key) throws IOException {
        return this;
    }

    @Override
    VarKeyRecordNode getLeftmostLeafNode() throws IOException {
        VarKeyRecordNode leaf = this.getPreviousLeaf();
        return leaf != null ? leaf.getLeftmostLeafNode() : this;
    }

    VarKeyRecordNode getNextLeaf() throws IOException {
        VarKeyRecordNode leaf = null;
        int nextLeafId = this.buffer.getInt(10);
        if (nextLeafId >= 0) {
            leaf = (VarKeyRecordNode)this.nodeMgr.getVarKeyNode(nextLeafId);
        }
        return leaf;
    }

    VarKeyRecordNode getPreviousLeaf() throws IOException {
        VarKeyRecordNode leaf = null;
        int nextLeafId = this.buffer.getInt(6);
        if (nextLeafId >= 0) {
            leaf = (VarKeyRecordNode)this.nodeMgr.getVarKeyNode(nextLeafId);
        }
        return leaf;
    }

    int getKeyIndex(Field key) throws IOException {
        int min = 0;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            Field k = this.getKey(i);
            int rc = k.compareTo(key);
            if (rc == 0) {
                return i;
            }
            if (rc < 0) {
                min = i + 1;
                continue;
            }
            max = i - 1;
        }
        return -(min + 1);
    }

    VarKeyNode split() throws IOException {
        int oldSiblingId = this.buffer.getInt(10);
        VarKeyRecordNode newLeaf = this.createNewLeaf(this.buffer.getId(), oldSiblingId);
        DataBuffer newBuf = newLeaf.buffer;
        int newBufId = newBuf.getId();
        this.buffer.putInt(10, newBufId);
        if (oldSiblingId >= 0) {
            VarKeyRecordNode leaf = (VarKeyRecordNode)this.nodeMgr.getVarKeyNode(oldSiblingId);
            leaf.buffer.putInt(6, newBufId);
        }
        this.splitData(newLeaf);
        if (this.parent != null) {
            return this.parent.insert(newLeaf);
        }
        return new VarKeyInteriorNode(this.nodeMgr, this.getKey(0), this.buffer.getId(), newLeaf.getKey(0), newBufId);
    }

    VarKeyNode appendLeaf(VarKeyRecordNode leaf) throws IOException {
        leaf.buffer.putInt(6, this.buffer.getId());
        int rightLeafBufId = this.buffer.getInt(10);
        leaf.buffer.putInt(10, rightLeafBufId);
        int newBufId = leaf.buffer.getId();
        this.buffer.putInt(10, newBufId);
        if (rightLeafBufId >= 0) {
            VarKeyNode rightLeaf = this.nodeMgr.getVarKeyNode(rightLeafBufId);
            rightLeaf.buffer.putInt(6, newBufId);
        }
        if (this.parent != null) {
            return this.parent.insert(leaf);
        }
        return new VarKeyInteriorNode(this.nodeMgr, this.getKey(0), this.buffer.getId(), leaf.getKey(0), newBufId);
    }

    VarKeyNode putRecord(Record record, Table table) throws IOException {
        Field key = record.getKeyField();
        int index = this.getKeyIndex(key);
        if (index >= 0) {
            if (table != null) {
                table.updatedRecord(this.getRecord(table.getSchema(), index), record);
            }
            VarKeyNode newRoot = this.updateRecord(index, record);
            return newRoot;
        }
        if (this.insertRecord(index = -index - 1, record)) {
            if (index == 0 && this.parent != null) {
                this.parent.keyChanged(this.getKey(1), key, this);
            }
            if (table != null) {
                table.insertedRecord(record);
            }
            return this.getRoot();
        }
        if (index == this.keyCount) {
            VarKeyNode newRoot = this.appendNewLeaf(record);
            if (table != null) {
                table.insertedRecord(record);
            }
            return newRoot;
        }
        VarKeyRecordNode leaf = this.split().getLeafNode(key);
        return leaf.putRecord(record, table);
    }

    VarKeyNode appendNewLeaf(Record record) throws IOException {
        VarKeyRecordNode newLeaf = this.createNewLeaf(-1, -1);
        newLeaf.insertRecord(0, record);
        return this.appendLeaf(newLeaf);
    }

    VarKeyNode deleteRecord(Field key, Table table) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            return this.getRoot();
        }
        if (table != null) {
            table.deletedRecord(this.getRecord(table.getSchema(), index));
        }
        if (this.keyCount == 1) {
            VarKeyNode newRoot = this.removeLeaf();
            return newRoot;
        }
        this.remove(index);
        if (index == 0 && this.parent != null) {
            this.parent.keyChanged(key, this.getKey(0), this);
        }
        return this.getRoot();
    }

    Record getRecordBefore(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        index = index < 0 ? -index - 2 : --index;
        if (index < 0) {
            VarKeyRecordNode nextLeaf = this.getPreviousLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, nextLeaf.keyCount - 1) : null;
        }
        return this.getRecord(schema, index);
    }

    Record getRecordAfter(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        index = index < 0 ? -(index + 1) : ++index;
        if (index == this.keyCount) {
            VarKeyRecordNode nextLeaf = this.getNextLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, 0) : null;
        }
        return this.getRecord(schema, index);
    }

    Record getRecordAtOrBefore(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            index = -index - 2;
        }
        if (index < 0) {
            VarKeyRecordNode nextLeaf = this.getPreviousLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, nextLeaf.keyCount - 1) : null;
        }
        return this.getRecord(schema, index);
    }

    Record getRecordAtOrAfter(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            index = -(index + 1);
        }
        if (index == this.keyCount) {
            VarKeyRecordNode nextLeaf = this.getNextLeaf();
            return nextLeaf != null ? nextLeaf.getRecord(schema, 0) : null;
        }
        return this.getRecord(schema, index);
    }

    VarKeyRecordNode createNewLeaf(int prevLeafId, int nextLeafId) throws IOException {
        return new VarKeyRecordNode(this.nodeMgr, prevLeafId, nextLeafId, this.keyType);
    }

    @Override
    Field getKey(int index) throws IOException {
        Field key = this.keyType.newField();
        key.read(this.buffer, this.buffer.getInt(14 + index * 5));
        return key;
    }

    private int getRecordDataOffset(int index) throws IOException {
        int offset = this.buffer.getInt(14 + index * 5);
        return offset + this.keyType.readLength(this.buffer, offset);
    }

    private int getRecordKeyOffset(int index) {
        return this.buffer.getInt(14 + index * 5);
    }

    private void putRecordKeyOffset(int index, int offset) {
        this.buffer.putInt(14 + index * 5, offset);
    }

    private boolean hasIndirectStorage(int index) {
        return this.buffer.getByte(18 + index * 5) != 0;
    }

    private void enableIndirectStorage(int index, boolean state) {
        this.buffer.putByte(18 + index * 5, state ? (byte)1 : 0);
    }

    private int getFreeSpace() {
        return (this.keyCount == 0 ? this.buffer.length() : this.getRecordKeyOffset(this.keyCount - 1)) - this.keyCount * 5 - 14;
    }

    private int getFullRecordLength(int keyIndex) {
        if (keyIndex == 0) {
            return this.buffer.length() - this.getRecordKeyOffset(0);
        }
        return this.getRecordKeyOffset(keyIndex - 1) - this.getRecordKeyOffset(keyIndex);
    }

    private int moveRecords(int index, int offset) {
        int lastIndex = this.keyCount - 1;
        if (index == this.keyCount) {
            if (index == 0) {
                return this.buffer.length() + offset;
            }
            return this.getRecordKeyOffset(lastIndex) + offset;
        }
        int start = this.getRecordKeyOffset(lastIndex);
        int end = index == 0 ? this.buffer.length() : this.getRecordKeyOffset(index - 1);
        int len = end - start;
        this.buffer.move(start, start + offset, len);
        for (int i = index; i < this.keyCount; ++i) {
            this.putRecordKeyOffset(i, this.getRecordKeyOffset(i) + offset);
        }
        return end + offset;
    }

    Record getRecord(Schema schema, int index) throws IOException {
        Field key = this.getKey(index);
        Record record = schema.createRecord(key);
        if (this.hasIndirectStorage(index)) {
            int bufId = this.buffer.getInt(this.getRecordDataOffset(index));
            ChainedBuffer chainedBuffer = new ChainedBuffer(this.nodeMgr.getBufferMgr(), bufId);
            record.read(chainedBuffer, 0);
        } else {
            record.read(this.buffer, this.getRecordDataOffset(index));
        }
        return record;
    }

    Record getRecord(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            return null;
        }
        return this.getRecord(schema, index);
    }

    private int getSplitIndex() {
        int halfway = ((this.keyCount == 0 ? this.buffer.length() : this.getRecordKeyOffset(this.keyCount - 1)) + this.buffer.length()) / 2;
        int min = 0;
        int max = this.keyCount - 1;
        while (min <= max) {
            int i = (min + max) / 2;
            int offset = this.getRecordKeyOffset(i);
            if (offset == halfway) {
                return i;
            }
            if (offset < halfway) {
                max = i - 1;
                continue;
            }
            min = i + 1;
        }
        return min;
    }

    private void splitData(VarKeyRecordNode rightNode) {
        int splitIndex = this.getSplitIndex();
        int count = this.keyCount - splitIndex;
        int start = this.getRecordKeyOffset(this.keyCount - 1);
        int end = this.getRecordKeyOffset(splitIndex - 1);
        int splitLen = end - start;
        int rightOffset = this.buffer.length() - splitLen;
        DataBuffer newBuf = rightNode.buffer;
        newBuf.copy(rightOffset, this.buffer, start, splitLen);
        newBuf.copy(14, this.buffer, 14 + splitIndex * 5, count * 5);
        int offsetCorrection = this.buffer.length() - end;
        for (int i = 0; i < count; ++i) {
            rightNode.putRecordKeyOffset(i, rightNode.getRecordKeyOffset(i) + offsetCorrection);
        }
        this.setKeyCount(this.keyCount - count);
        rightNode.setKeyCount(count);
    }

    private VarKeyNode updateRecord(int index, Record record) throws IOException {
        boolean useIndirect;
        Field key = record.getKeyField();
        int keyLen = key.length();
        int offset = this.getRecordKeyOffset(index);
        int oldLen = this.getFullRecordLength(index) - keyLen;
        int len = record.length();
        int maxRecordLength = (this.buffer.length() - 14 >> 2) - 5 - keyLen;
        boolean wasIndirect = this.hasIndirectStorage(index);
        boolean bl = useIndirect = len > maxRecordLength;
        if (useIndirect) {
            len = 4;
            ChainedBuffer chainedBuffer = null;
            if (wasIndirect) {
                chainedBuffer = new ChainedBuffer(this.nodeMgr.getBufferMgr(), this.buffer.getInt(offset + keyLen));
                chainedBuffer.setSize(record.length(), false);
            } else {
                chainedBuffer = new ChainedBuffer(record.length(), this.nodeMgr.getBufferMgr());
                this.buffer.putInt(offset + keyLen + oldLen - 4, chainedBuffer.getId());
                this.enableIndirectStorage(index, true);
            }
            record.write(chainedBuffer, 0);
        } else if (wasIndirect) {
            this.removeChainedBuffer(this.buffer.getInt(offset + keyLen));
            this.enableIndirectStorage(index, false);
        }
        if (useIndirect || len <= this.getFreeSpace() + oldLen) {
            int dataShift = oldLen - len;
            if (dataShift != 0) {
                offset = this.moveRecords(index + 1, dataShift);
                this.putRecordKeyOffset(index, offset);
                key.write(this.buffer, offset);
            }
            if (!useIndirect) {
                record.write(this.buffer, offset + keyLen);
            }
            return this.getRoot();
        }
        VarKeyRecordNode leaf = this.deleteRecord(key, null).getLeafNode(key);
        return leaf.putRecord(record, null);
    }

    private boolean insertRecord(int keyIndex, Record record) throws IOException {
        int maxRecordLength;
        boolean useIndirect;
        Field key = record.getKeyField();
        int keyLen = key.length();
        if (keyLen > this.maxKeyLength) {
            throw new AssertException("Key exceeds maximum key length of " + this.maxKeyLength);
        }
        int len = record.length();
        boolean bl = useIndirect = len > (maxRecordLength = (this.buffer.length() - 14 >> 2) - 5 - keyLen);
        if (useIndirect) {
            len = 4;
        }
        if (len + keyLen + 5 > this.getFreeSpace()) {
            return false;
        }
        int offset = this.moveRecords(keyIndex, -(len + keyLen));
        int start = 14 + keyIndex * 5;
        len = (this.keyCount - keyIndex) * 5;
        this.buffer.move(start, start + 5, len);
        this.buffer.putInt(start, offset);
        this.setKeyCount(this.keyCount + 1);
        key.write(this.buffer, offset);
        if (useIndirect) {
            ChainedBuffer chainedBuffer = new ChainedBuffer(record.length(), this.nodeMgr.getBufferMgr());
            this.buffer.putInt(offset + keyLen, chainedBuffer.getId());
            record.write(chainedBuffer, 0);
        } else {
            record.write(this.buffer, offset + keyLen);
        }
        this.enableIndirectStorage(keyIndex, useIndirect);
        return true;
    }

    void remove(int index) throws IOException {
        if (index < 0 || index >= this.keyCount) {
            throw new AssertException();
        }
        if (this.hasIndirectStorage(index)) {
            this.removeChainedBuffer(this.buffer.getInt(this.getRecordDataOffset(index)));
            this.enableIndirectStorage(index, false);
        }
        int len = this.getFullRecordLength(index);
        this.moveRecords(index + 1, len);
        int start = 14 + (index + 1) * 5;
        len = (this.keyCount - index - 1) * 5;
        this.buffer.move(start, start - 5, len);
        this.setKeyCount(this.keyCount - 1);
    }

    VarKeyNode removeLeaf() throws IOException {
        for (int index = 0; index < this.keyCount; ++index) {
            if (!this.hasIndirectStorage(index)) continue;
            this.removeChainedBuffer(this.buffer.getInt(this.getRecordDataOffset(index)));
        }
        Field key = this.getKey(0);
        int prevBufferId = this.buffer.getInt(6);
        int nextBufferId = this.buffer.getInt(10);
        if (prevBufferId >= 0) {
            VarKeyRecordNode prevNode = (VarKeyRecordNode)this.nodeMgr.getVarKeyNode(prevBufferId);
            prevNode.getBuffer().putInt(10, nextBufferId);
        }
        if (nextBufferId >= 0) {
            VarKeyRecordNode nextNode = (VarKeyRecordNode)this.nodeMgr.getVarKeyNode(nextBufferId);
            nextNode.getBuffer().putInt(6, prevBufferId);
        }
        this.nodeMgr.deleteNode(this);
        if (this.parent == null) {
            return null;
        }
        return this.parent.deleteChild(key);
    }

    private void removeChainedBuffer(int bufferId) throws IOException {
        ChainedBuffer chainedBuffer = new ChainedBuffer(this.nodeMgr.getBufferMgr(), bufferId);
        chainedBuffer.delete();
    }

    @Override
    public void delete() throws IOException {
        for (int index = 0; index < this.keyCount; ++index) {
            if (!this.hasIndirectStorage(index)) continue;
            int offset = this.getRecordDataOffset(index);
            int bufferId = this.buffer.getInt(offset);
            this.removeChainedBuffer(bufferId);
            this.buffer.putInt(offset, -1);
        }
        this.nodeMgr.deleteNode(this);
    }

    @Override
    public int[] getBufferReferences() {
        IntArrayList idList = new IntArrayList();
        for (int i = 0; i < this.keyCount; ++i) {
            if (!this.hasIndirectStorage(i)) continue;
            try {
                int offset = this.getRecordDataOffset(i);
                idList.add(this.buffer.getInt(offset));
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return idList.toArray();
    }
}

