/*
 * Decompiled with CFR 0.152.
 */
package ghidra.launch;

import java.text.ParseException;

public class JavaVersion
implements Comparable<JavaVersion> {
    private int major;
    private int minor;
    private int patch;

    public JavaVersion(String version) throws ParseException {
        this.parse(version);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        if (this.major < 9) {
            return String.format("1.%d.%d_%d", this.major, this.minor, this.patch);
        }
        return String.format("%d.%d.%d", this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(JavaVersion other) {
        if (this.major > other.major) {
            return 1;
        }
        if (this.major < other.major) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaVersion other = (JavaVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }

    private void parse(String version) throws ParseException {
        String[] versionParts;
        int firstValue;
        int dashIndex;
        if (version == null) {
            throw new ParseException("Version is null", 0);
        }
        this.patch = 0;
        this.minor = 0;
        this.major = 0;
        if (version.startsWith("\"") && version.endsWith("\"")) {
            version = version.substring(1, version.length() - 1);
        }
        if ((dashIndex = version.indexOf(45)) > 0) {
            version = version.substring(0, dashIndex);
        }
        if ((firstValue = this.parse((versionParts = version.split("[._]"))[0], "first value")) == 1) {
            if (versionParts.length > 1) {
                this.major = this.parse(versionParts[1], "major");
                if (versionParts.length > 2) {
                    this.minor = this.parse(versionParts[2], "minor");
                    if (versionParts.length > 3) {
                        this.patch = this.parse(versionParts[3], "patch");
                    }
                }
            }
        } else if (firstValue >= 9) {
            this.major = this.parse(versionParts[0], "major");
            if (versionParts.length > 1) {
                this.minor = this.parse(versionParts[1], "minor");
                if (versionParts.length > 2) {
                    this.patch = this.parse(versionParts[2], "patch");
                }
            }
        } else {
            throw new ParseException("Failed to parse version: " + version, 0);
        }
    }

    private int parse(String versionPart, String versionPartName) throws ParseException {
        try {
            int i = Integer.parseInt(versionPart);
            if (i < 0) {
                throw new ParseException(versionPartName + " cannot be negative", 0);
            }
            return i;
        }
        catch (NumberFormatException e) {
            throw new ParseException("Failed to convert " + versionPartName + " version to integer", 0);
        }
    }
}

