/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import ghidra.app.plugin.core.datamgr.archive.SourceArchive;
import ghidra.docking.settings.Settings;
import ghidra.program.model.address.GlobalNamespace;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.LongLongDataType;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedLongLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.listing.Library;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.symbol.Namespace;
import ghidra.util.UniversalID;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class DataTypeUtilities {
    private static Map<String, DataType> cPrimitiveNameMap = new HashMap<String, DataType>();
    private static final Pattern DATATYPE_CONFLICT_PATTERN;

    public static Collection<DataType> getContainedDataTypes(DataType rootDataType) {
        HashMap<String, DataType> dataTypeMap = new HashMap<String, DataType>();
        LinkedList<DataType> unprocessedDataTypes = new LinkedList<DataType>();
        dataTypeMap.put(rootDataType.getPathName(), rootDataType);
        unprocessedDataTypes.add(rootDataType);
        while (!unprocessedDataTypes.isEmpty()) {
            DataType dataType = (DataType)unprocessedDataTypes.remove();
            List<DataType> directContainedDatatypes = DataTypeUtilities.getDirectContainedDatatypes(dataType);
            for (DataType containedDataType : directContainedDatatypes) {
                String path = containedDataType.getPathName();
                if (dataTypeMap.containsKey(path)) continue;
                dataTypeMap.put(path, containedDataType);
                unprocessedDataTypes.add(containedDataType);
            }
        }
        return dataTypeMap.values();
    }

    private static List<DataType> getDirectContainedDatatypes(DataType dt) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        if (dt instanceof Array) {
            Array array = (Array)dt;
            list.add(array.getDataType());
        } else if (dt instanceof Pointer) {
            Pointer ptr = (Pointer)dt;
            DataType ptrDt = ptr.getDataType();
            if (ptrDt != null) {
                list.add(ptrDt);
            }
        } else if (dt instanceof Composite) {
            Composite composite = (Composite)dt;
            int n = composite.getNumComponents();
            for (int i = 0; i < n; ++i) {
                DataTypeComponent component = composite.getComponent(i);
                list.add(component.getDataType());
            }
        } else if (dt instanceof TypeDef) {
            TypeDef typedef = (TypeDef)dt;
            list.add(typedef.getDataType());
        } else if (!(dt instanceof Enum)) {
            if (dt instanceof FunctionDefinition) {
                ParameterDefinition[] arguments;
                FunctionDefinition funDef = (FunctionDefinition)dt;
                list.add(funDef.getReturnType());
                for (ParameterDefinition parameter : arguments = funDef.getArguments()) {
                    list.add(parameter.getDataType());
                }
            } else if (!(dt instanceof BuiltInDataType || dt instanceof MissingBuiltInDataType || dt.equals(DataType.DEFAULT))) {
                throw new AssertException("Unknown data Type:" + dt.getDisplayName());
            }
        }
        return list;
    }

    public static boolean isSecondPartOfFirst(DataType firstDataType, DataType secondDataType) {
        if (firstDataType instanceof Pointer || secondDataType instanceof Pointer) {
            return false;
        }
        if (firstDataType.equals(secondDataType)) {
            return true;
        }
        if (firstDataType instanceof Array) {
            DataType elementDataType = ((Array)firstDataType).getDataType();
            return DataTypeUtilities.isSecondPartOfFirst(elementDataType, secondDataType);
        }
        if (firstDataType instanceof TypeDef) {
            DataType innerDataType = ((TypeDef)firstDataType).getDataType();
            return DataTypeUtilities.isSecondPartOfFirst(innerDataType, secondDataType);
        }
        if (firstDataType instanceof Composite) {
            Composite compositeDataType = (Composite)firstDataType;
            int numComponents = compositeDataType.getNumComponents();
            for (int i = 0; i < numComponents; ++i) {
                DataTypeComponent dtc = compositeDataType.getComponent(i);
                DataType dataTypeToCheck = dtc.getDataType();
                if (!DataTypeUtilities.isSecondPartOfFirst(dataTypeToCheck, secondDataType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isSameDataType(DataType dataType1, DataType dataType2) {
        UniversalID id1 = dataType1.getUniversalID();
        UniversalID id2 = dataType2.getUniversalID();
        if (id1 == null || id2 == null) {
            return false;
        }
        if (!id1.equals((Object)id2)) {
            return false;
        }
        SourceArchive sourceArchive1 = dataType1.getSourceArchive();
        SourceArchive sourceArchive2 = dataType2.getSourceArchive();
        if (sourceArchive1 == null || sourceArchive2 == null) {
            return false;
        }
        return sourceArchive1.getSourceArchiveID().equals((Object)sourceArchive2.getSourceArchiveID());
    }

    public static boolean isSameOrEquivalentDataType(DataType dataType1, DataType dataType2) {
        if (DataTypeUtilities.isSameDataType(dataType1, dataType2)) {
            return true;
        }
        return dataType1.isEquivalent(dataType2);
    }

    public static String getNameWithoutConflict(DataType dataType, boolean includeCategoryPath) {
        String name = includeCategoryPath ? dataType.getPathName() : dataType.getName();
        return DATATYPE_CONFLICT_PATTERN.matcher(name).replaceAll("");
    }

    public static boolean equalsIgnoreConflict(String name1, String name2) {
        name1 = DATATYPE_CONFLICT_PATTERN.matcher(name1).replaceAll("");
        name2 = DATATYPE_CONFLICT_PATTERN.matcher(name2).replaceAll("");
        return name1.equals(name2);
    }

    public static DataType getBaseDataType(DataType dt) {
        DataType baseDataType = dt;
        while (baseDataType instanceof Pointer || baseDataType instanceof Array) {
            if (baseDataType instanceof Pointer) {
                baseDataType = ((Pointer)baseDataType).getDataType();
                continue;
            }
            if (!(baseDataType instanceof Array)) continue;
            baseDataType = ((Array)baseDataType).getDataType();
        }
        return baseDataType;
    }

    public static DataType getArrayBaseDataType(Array arrayDt) {
        DataType dataType = arrayDt.getDataType();
        if (dataType instanceof Array) {
            return DataTypeUtilities.getArrayBaseDataType((Array)dataType);
        }
        return dataType;
    }

    private static int getArrayBaseElementLength(Array arrayDt) {
        DataType dataType = arrayDt.getDataType();
        if (dataType instanceof Array) {
            return DataTypeUtilities.getArrayBaseElementLength((Array)dataType);
        }
        return arrayDt.getElementLength();
    }

    private static String getArrayElementLengthForDynamic(Array arrayDt) {
        if (DataTypeUtilities.getArrayBaseDataType(arrayDt).getLength() <= 0) {
            return " {" + DataTypeUtilities.getArrayBaseElementLength(arrayDt) + "} ";
        }
        return "";
    }

    private static String getArrayDimensions(Array arrayDt) {
        String dimensionString = "[" + arrayDt.getNumElements() + "]";
        DataType dataType = arrayDt.getDataType();
        if (dataType instanceof Array) {
            dimensionString = dimensionString + DataTypeUtilities.getArrayDimensions((Array)dataType);
        }
        return dimensionString;
    }

    public static String getName(Array arrayDt, boolean showBaseSizeForDynamics) {
        StringBuffer buf = new StringBuffer();
        buf.append(DataTypeUtilities.getArrayBaseDataType(arrayDt).getName());
        if (showBaseSizeForDynamics) {
            buf.append(DataTypeUtilities.getArrayElementLengthForDynamic(arrayDt));
        }
        buf.append(DataTypeUtilities.getArrayDimensions(arrayDt));
        return buf.toString();
    }

    public static String getDisplayName(Array arrayDt, boolean showBaseSizeForDynamics) {
        StringBuffer buf = new StringBuffer();
        buf.append(DataTypeUtilities.getArrayBaseDataType(arrayDt).getDisplayName());
        if (showBaseSizeForDynamics) {
            buf.append(DataTypeUtilities.getArrayElementLengthForDynamic(arrayDt));
        }
        buf.append(DataTypeUtilities.getArrayDimensions(arrayDt));
        return buf.toString();
    }

    public static String getMnemonic(Array arrayDt, boolean showBaseSizeForDynamics, Settings settings) {
        StringBuffer buf = new StringBuffer();
        buf.append(DataTypeUtilities.getArrayBaseDataType(arrayDt).getMnemonic(settings));
        if (showBaseSizeForDynamics) {
            buf.append(DataTypeUtilities.getArrayElementLengthForDynamic(arrayDt));
        }
        buf.append(DataTypeUtilities.getArrayDimensions(arrayDt));
        return buf.toString();
    }

    public static Object getArrayValue(Array arrayDt, MemBuffer buf, Settings settings, int length) {
        if (!buf.getMemory().getAllInitializedAddressSet().contains(buf.getAddress())) {
            return null;
        }
        ArrayStringable as = ArrayStringable.getArrayStringable(arrayDt.getDataType());
        String value = as != null ? as.getArrayString(buf, settings, length) : null;
        return value;
    }

    public static String getArrayRepresentation(Array arrayDt, MemBuffer buf, Settings settings, int length) {
        try {
            buf.getByte(0);
            ArrayStringable as = ArrayStringable.getArrayStringable(arrayDt.getDataType());
            String value = as != null ? as.getArrayRepresentation(buf, settings, length) : null;
            return value != null ? value : "";
        }
        catch (MemoryAccessException memoryAccessException) {
            return "";
        }
    }

    public static Class<?> getArrayValueClass(Array arrayDt, Settings settings) {
        DataType dt = arrayDt.getDataType();
        if (dt instanceof TypeDef) {
            dt = ((TypeDef)dt).getBaseDataType();
        }
        if (dt instanceof ArrayStringable && ((ArrayStringable)dt).hasStringValue(settings)) {
            return String.class;
        }
        Class<?> valueClass = dt.getValueClass(settings);
        return valueClass != null ? Array.class : null;
    }

    public static CategoryPath getDataTypeCategoryPath(CategoryPath baseCategory, Namespace namespace) {
        Namespace ns = namespace;
        Object path = "";
        while (!(ns instanceof GlobalNamespace) && !(ns instanceof Library)) {
            if (((String)path).length() != 0) {
                path = "/" + (String)path;
            }
            path = ns.getName() + (String)path;
            ns = ns.getParentNamespace();
        }
        if (((String)path).length() == 0) {
            return baseCategory;
        }
        String categoryPath = "/" + (String)path;
        if (!baseCategory.equals(CategoryPath.ROOT)) {
            categoryPath = baseCategory.getPath() + categoryPath;
        }
        return new CategoryPath(categoryPath);
    }

    public static DataType findDataType(DataTypeManager dataTypeManager, Namespace namespace, String dtName, Class<? extends DataType> classConstraint) {
        return DataTypeUtilities.findDataType(dataTypeManager, dtName, classConstraint, (DataType categoryPath) -> DataTypeUtilities.hasPreferredNamespaceCategory(categoryPath, namespace));
    }

    public static DataType findNamespaceQualifiedDataType(DataTypeManager dataTypeManager, String dtNameWithNamespace, Class<? extends DataType> classConstraint) {
        String[] splitName = dtNameWithNamespace.split("::");
        String dtName = splitName[splitName.length - 1];
        return DataTypeUtilities.findDataType(dataTypeManager, dtName, classConstraint, (DataType dataType) -> DataTypeUtilities.hasPreferredNamespaceCategory(dataType, splitName));
    }

    public static DataType getCPrimitiveDataType(String dataTypeName) {
        if (dataTypeName.contains(" ")) {
            dataTypeName = dataTypeName.trim().replaceAll("\\s+", " ");
        }
        dataTypeName = dataTypeName.toLowerCase();
        return cPrimitiveNameMap.get(dataTypeName);
    }

    private static boolean hasPreferredNamespaceCategory(DataType dataType, String[] splitDataTypeName) {
        if (splitDataTypeName.length == 1) {
            return true;
        }
        CategoryPath categoryPath = dataType.getCategoryPath();
        for (int index = splitDataTypeName.length - 2; index >= 0; --index) {
            if (categoryPath.equals(CategoryPath.ROOT) || !categoryPath.getName().equals(splitDataTypeName[index])) {
                return false;
            }
            categoryPath = categoryPath.getParent();
        }
        return true;
    }

    private static boolean hasPreferredNamespaceCategory(DataType dataType, Namespace namespace) {
        if (namespace == null) {
            return true;
        }
        CategoryPath categoryPath = dataType.getCategoryPath();
        Namespace ns = namespace;
        while (!(ns instanceof GlobalNamespace) && !(ns instanceof Library)) {
            if (categoryPath.equals(CategoryPath.ROOT) || !categoryPath.getName().equals(ns.getName())) {
                return false;
            }
            categoryPath = categoryPath.getParent();
            ns = ns.getParentNamespace();
        }
        return true;
    }

    private static DataType findDataType(DataTypeManager dataTypeManager, String dtName, Class<? extends DataType> classConstraint, NamespaceMatcher preferredCategoryMatcher) {
        ArrayList<DataType> list = new ArrayList<DataType>();
        dataTypeManager.findDataTypes(dtName, list);
        if (!list.isEmpty()) {
            DataType anyDt = null;
            DataType preferredDataType = null;
            for (DataType existingDT : list) {
                if (classConstraint != null && !classConstraint.isAssignableFrom(existingDT.getClass())) continue;
                if (preferredCategoryMatcher == null && existingDT.getCategoryPath().equals(CategoryPath.ROOT)) {
                    return existingDT;
                }
                if (preferredCategoryMatcher.isNamespaceCategoryMatch(existingDT)) {
                    preferredDataType = existingDT;
                }
                anyDt = existingDT;
            }
            if (preferredDataType != null) {
                return preferredDataType;
            }
            return anyDt;
        }
        return null;
    }

    static {
        cPrimitiveNameMap.put("char", CharDataType.dataType);
        cPrimitiveNameMap.put("signed char", CharDataType.dataType);
        cPrimitiveNameMap.put("unsigned char", UnsignedCharDataType.dataType);
        cPrimitiveNameMap.put("short", ShortDataType.dataType);
        cPrimitiveNameMap.put("short int", ShortDataType.dataType);
        cPrimitiveNameMap.put("signed short", ShortDataType.dataType);
        cPrimitiveNameMap.put("signed short int", ShortDataType.dataType);
        cPrimitiveNameMap.put("unsigned short", UnsignedShortDataType.dataType);
        cPrimitiveNameMap.put("unsigned short int", UnsignedShortDataType.dataType);
        cPrimitiveNameMap.put("int", IntegerDataType.dataType);
        cPrimitiveNameMap.put("signed", IntegerDataType.dataType);
        cPrimitiveNameMap.put("signed int", IntegerDataType.dataType);
        cPrimitiveNameMap.put("unsigned", UnsignedIntegerDataType.dataType);
        cPrimitiveNameMap.put("unsigned int", UnsignedIntegerDataType.dataType);
        cPrimitiveNameMap.put("long", LongDataType.dataType);
        cPrimitiveNameMap.put("long int", LongDataType.dataType);
        cPrimitiveNameMap.put("signed long", LongDataType.dataType);
        cPrimitiveNameMap.put("signed long int", LongDataType.dataType);
        cPrimitiveNameMap.put("unsigned long", UnsignedLongDataType.dataType);
        cPrimitiveNameMap.put("long long", LongLongDataType.dataType);
        cPrimitiveNameMap.put("long long int", LongLongDataType.dataType);
        cPrimitiveNameMap.put("signed long long", LongLongDataType.dataType);
        cPrimitiveNameMap.put("signed long long int", LongLongDataType.dataType);
        cPrimitiveNameMap.put("unsigned long long", UnsignedLongLongDataType.dataType);
        cPrimitiveNameMap.put("unsigned long long int", UnsignedLongLongDataType.dataType);
        cPrimitiveNameMap.put("float", FloatDataType.dataType);
        cPrimitiveNameMap.put("double", DoubleDataType.dataType);
        cPrimitiveNameMap.put("long double", LongDoubleDataType.dataType);
        DATATYPE_CONFLICT_PATTERN = Pattern.compile(Pattern.quote(".conflict") + "_?[0-9]*");
    }

    private static interface NamespaceMatcher {
        public boolean isNamespaceCategoryMatch(DataType var1);
    }
}

