/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.function;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.function.ThunkFunctionAdapter;
import ghidra.program.database.map.AddressMap;
import ghidra.util.exception.VersionException;
import java.io.IOException;

public class ThunkFunctionAdapterV0
extends ThunkFunctionAdapter {
    static final int SCHEMA_VERSION = 0;
    private Table table;

    ThunkFunctionAdapterV0(DBHandle dbHandle, AddressMap addrMap, boolean create) throws VersionException, IOException {
        super(addrMap);
        if (create) {
            this.table = dbHandle.createTable("Thunk Functions", THUNK_FUNCTION_SCHEMA, new int[]{0});
        } else {
            this.table = dbHandle.getTable("Thunk Functions");
            if (this.table == null) {
                throw new VersionException(true);
            }
            int version = this.table.getSchema().getVersion();
            if (version != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    RecordIterator iterateThunkRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    RecordIterator iterateThunkRecords(long linkedFunctionKey) throws IOException {
        LongField field = new LongField(linkedFunctionKey);
        return this.table.indexIterator(0, (Field)field, (Field)field, true);
    }

    @Override
    Record getThunkRecord(long functionKey) throws IOException {
        return this.table.getRecord(functionKey);
    }

    @Override
    void removeThunkRecord(long functionKey) throws IOException {
        this.table.deleteRecord(functionKey);
    }

    @Override
    void updateThunkRecord(Record rec) throws IOException {
        this.table.putRecord(rec);
    }

    @Override
    Record createThunkRecord(long thunkFunctionId, long referencedFunctionId) throws IOException {
        Record rec = THUNK_FUNCTION_SCHEMA.createRecord(thunkFunctionId);
        rec.setField(0, (Field)new LongField(referencedFunctionId));
        this.table.putRecord(rec);
        return rec;
    }
}

