/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.DBBuffer;
import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.mem.MemoryBlockDB;
import ghidra.program.database.mem.MemoryMapDB;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.SegmentedAddress;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.exception.IOCancelledException;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

class MemoryMapDBAdapterV2
extends MemoryMapDBAdapter {
    private static final int VERSION = 2;
    private DBHandle handle;
    private Table blockTable;
    private MemoryMapDB memMap;
    private AddressMap addrMap;
    private MemoryBlockDB[] blocks = new MemoryBlockDB[0];

    MemoryMapDBAdapterV2(DBHandle handle, MemoryMapDB memMap, boolean create) throws VersionException, IOException {
        this.handle = handle;
        this.memMap = memMap;
        this.addrMap = memMap.getAddressMap();
        if (create) {
            this.blockTable = handle.createTable("Memory Blocks", BLOCK_SCHEMA);
        } else {
            this.blockTable = handle.getTable("Memory Blocks");
            if (this.blockTable == null) {
                throw new VersionException(handle.getTable("Memory Block") != null);
            }
            if (this.blockTable.getSchema().getVersion() != 2) {
                int version = this.blockTable.getSchema().getVersion();
                throw new VersionException(version < 2);
            }
        }
    }

    @Override
    void refreshMemory() throws IOException {
        Object[] updatedBlocks = new MemoryBlockDB[this.blockTable.getRecordCount()];
        RecordIterator it = this.blockTable.iterator();
        int index = 0;
        while (it.hasNext()) {
            Record blockRec = it.next();
            long key = blockRec.getKey();
            for (int n = 0; n < this.blocks.length; ++n) {
                if (this.blocks[n] == null || (long)this.blocks[n].getID() != key) continue;
                updatedBlocks[index] = this.blocks[n];
                ((MemoryBlockDB)updatedBlocks[index]).refresh(blockRec);
                this.blocks[n] = null;
                break;
            }
            if (updatedBlocks[index] == null) {
                updatedBlocks[index] = MemoryMapDBAdapter.getMemoryBlock(this, blockRec, null, this.memMap);
            }
            ++index;
        }
        for (int i = 0; i < this.blocks.length; ++i) {
            if (this.blocks[i] == null) continue;
            this.blocks[i].invalidate();
        }
        Arrays.sort(updatedBlocks);
        this.blocks = updatedBlocks;
    }

    @Override
    MemoryBlockDB[] getMemoryBlocks() {
        return this.blocks;
    }

    private int getSegment(Address addr) {
        if (addr instanceof SegmentedAddress) {
            return ((SegmentedAddress)addr).getSegment();
        }
        return 0;
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, DBBuffer buf, int permissions) throws AddressOverflowException, IOException {
        Address endAddr = startAddr.addNoWrap(buf.length() - 1);
        this.addrMap.getKey(endAddr, true);
        int blockID = (int)this.blockTable.getKey();
        Record blockRec = BLOCK_SCHEMA.createRecord((long)blockID);
        blockRec.setString(0, name);
        blockRec.setByteValue(3, (byte)permissions);
        blockRec.setLongValue(4, this.addrMap.getKey(startAddr, true));
        blockRec.setShortValue(5, (short)0);
        blockRec.setIntValue(8, buf.getId());
        blockRec.setLongValue(7, (long)buf.length());
        blockRec.setIntValue(9, this.getSegment(startAddr));
        this.blockTable.putRecord(blockRec);
        return new MemoryBlockDB(this, blockRec, buf, this.memMap);
    }

    @Override
    MemoryBlockDB createInitializedBlock(String name, Address startAddr, InputStream is, long length, int permissions) throws AddressOverflowException, IOException {
        Address endAddr = startAddr.addNoWrap(length - 1L);
        this.addrMap.getKey(endAddr, true);
        int blockID = (int)this.blockTable.getKey();
        Record blockRec = BLOCK_SCHEMA.createRecord((long)blockID);
        blockRec.setString(0, name);
        blockRec.setByteValue(3, (byte)permissions);
        blockRec.setLongValue(4, this.addrMap.getKey(startAddr, true));
        blockRec.setShortValue(5, (short)0);
        blockRec.setLongValue(7, length);
        blockRec.setIntValue(9, this.getSegment(startAddr));
        DBBuffer buf = this.createBuffer(length, is);
        blockRec.setIntValue(8, buf.getId());
        this.blockTable.putRecord(blockRec);
        return MemoryMapDBAdapter.getMemoryBlock(this, blockRec, buf, this.memMap);
    }

    @Override
    MemoryBlockDB createBlock(MemoryBlockType blockType, String name, Address startAddr, long length, Address mappedAddress, boolean initializeBytes, int permissions) throws AddressOverflowException, IOException {
        if (initializeBytes) {
            return this.createInitializedBlock(name, startAddr, null, length, permissions);
        }
        Address endAddr = startAddr.addNoWrap(length - 1L);
        this.addrMap.getKey(endAddr, true);
        int blockID = (int)this.blockTable.getKey();
        Record blockRec = BLOCK_SCHEMA.createRecord((long)blockID);
        blockRec.setString(0, name);
        blockRec.setByteValue(3, (byte)permissions);
        blockRec.setLongValue(4, this.addrMap.getKey(startAddr, true));
        blockRec.setShortValue(5, (short)this.encodeBlockType(blockType));
        blockRec.setLongValue(7, length);
        blockRec.setIntValue(9, this.getSegment(startAddr));
        blockRec.setIntValue(8, -1);
        if (mappedAddress != null) {
            blockRec.setLongValue(6, this.addrMap.getKey(mappedAddress, true));
        }
        this.blockTable.putRecord(blockRec);
        return MemoryMapDBAdapter.getMemoryBlock(this, blockRec, null, this.memMap);
    }

    private int encodeBlockType(MemoryBlockType blockType) {
        if (blockType == MemoryBlockType.BIT_MAPPED) {
            return 2;
        }
        if (blockType == MemoryBlockType.BYTE_MAPPED) {
            return 4;
        }
        return 1;
    }

    private DBBuffer createBuffer(long length, InputStream is) throws IOException {
        DBBuffer buf = this.handle.createBuffer((int)length);
        if (is != null) {
            try {
                buf.fill(is);
            }
            catch (IOCancelledException e) {
                buf.delete();
                throw e;
            }
        }
        return buf;
    }

    @Override
    MemoryBlockDB splitBlock(MemoryBlockDB block, long offset) throws IOException {
        return null;
    }

    @Override
    MemoryBlockDB joinBlocks(MemoryBlockDB block1, MemoryBlockDB block2) throws IOException {
        return null;
    }

    @Override
    void deleteMemoryBlock(MemoryBlockDB block) throws IOException {
        this.blockTable.deleteRecord((long)block.getID());
        block.invalidate();
    }

    @Override
    void deleteTable(DBHandle dbHandle) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    void updateBlockRecord(Record record) throws IOException {
        this.blockTable.putRecord(record);
    }

    @Override
    DBBuffer createBuffer(int length, byte initialValue) throws IOException {
        DBBuffer buffer = this.handle.createBuffer(length);
        buffer.fill(0, length - 1, initialValue);
        return buffer;
    }

    @Override
    DBBuffer getBuffer(int bufferID) throws IOException {
        if (bufferID >= 0) {
            return this.handle.getBuffer(bufferID);
        }
        return null;
    }
}

