/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.block;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressObjectMap;
import ghidra.program.model.block.CodeBlock;

class CodeBlockCache
extends AddressObjectMap {
    CodeBlockCache() {
    }

    CodeBlock getBlockAt(Address addr) {
        Object[] blocks = this.getObjects(addr);
        for (int i = 0; i < blocks.length; ++i) {
            CodeBlock block = (CodeBlock)blocks[i];
            Address startAddr = block.getFirstStartAddress();
            if (!startAddr.equals(addr)) continue;
            return block;
        }
        return null;
    }

    CodeBlock getBlockWithEntryAt(Address addr) {
        Object[] blocks = this.getObjects(addr);
        for (int i = 0; i < blocks.length; ++i) {
            CodeBlock block = (CodeBlock)blocks[i];
            Address[] starts = block.getStartAddresses();
            for (int j = 0; j < starts.length; ++j) {
                if (!starts[j].equals(addr)) continue;
                return block;
            }
        }
        return null;
    }

    CodeBlock[] getBlocksContaining(Address addr) {
        Object[] objs = this.getObjects(addr);
        int length = objs.length;
        if (length == 0) {
            return null;
        }
        CodeBlock[] blocks = new CodeBlock[objs.length];
        System.arraycopy(objs, 0, blocks, 0, length);
        return blocks;
    }

    CodeBlock getFirstBlockContaining(Address addr) {
        CodeBlock[] blocks = this.getBlocksContaining(addr);
        if (blocks == null) {
            return null;
        }
        if (blocks.length == 1) {
            return blocks[0];
        }
        int firstIndex = -1;
        Address minAddr = null;
        for (int i = 0; i < blocks.length; ++i) {
            if (minAddr != null && minAddr.compareTo(blocks[i].getFirstStartAddress()) <= 0) continue;
            minAddr = blocks[i].getFirstStartAddress();
            firstIndex = i;
        }
        return blocks[firstIndex];
    }
}

