/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import generic.stl.Pair;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsImpl;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.ArrayStringable;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.CharsetInfo;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeDisplayOptions;
import ghidra.program.model.data.DataTypeWithCharset;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.program.model.data.PascalStringDataType;
import ghidra.program.model.data.PascalUnicodeDataType;
import ghidra.program.model.data.RenderUnicodeSettingsDefinition;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.StringLayoutEnum;
import ghidra.program.model.data.StringRenderBuilder;
import ghidra.program.model.data.StringUTF8DataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicode32DataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.TranslationSettingsDefinition;
import ghidra.program.model.data.Unicode32DataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.WideChar16DataType;
import ghidra.program.model.data.WideChar32DataType;
import ghidra.program.model.data.WideCharDataType;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.listing.Data;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.WrappedMemBuffer;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.DataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.StringUtilities;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class StringDataInstance {
    public static final StringDataInstance NULL_INSTANCE = new StaticStringInstance(null, -1);
    public static final int MAX_STRING_LENGTH = 16384;
    public static final String DEFAULT_CHARSET_NAME = "US-ASCII";
    public static final String UNKNOWN = "??";
    public static final String UNKNOWN_DOT_DOT_DOT = "??...";
    private static final String BOM_RESULT_STR = "\ufeff";
    private static final int SIZEOF_PASCAL255_STR_LEN_FIELD = 1;
    private static final int SIZEOF_PASCAL64k_STR_LEN_FIELD = 2;
    private final String charsetName;
    private final int charSize;
    private final int paddedCharSize;
    private final StringLayoutEnum stringLayout;
    private final String translatedValue;
    private final Endian endianSetting;
    private boolean showTranslation;
    private RenderUnicodeSettingsDefinition.RENDER_ENUM renderSetting;
    private int length;
    private final MemBuffer buf;
    private static final Map<Pair<StringLayoutEnum, String>, DataType> dataTypeMap = new HashMap<Pair<StringLayoutEnum, String>, DataType>();

    public static boolean isString(Data data) {
        if (data == null) {
            return false;
        }
        DataType dt = data.getBaseDataType();
        if (dt instanceof AbstractStringDataType) {
            return true;
        }
        if (dt instanceof Array) {
            ArrayStringable as = ArrayStringable.getArrayStringable(((Array)dt).getDataType());
            return as != null && as.hasStringValue(data);
        }
        return false;
    }

    public static boolean isChar(Data data) {
        if (data == null) {
            return false;
        }
        DataType dt = data.getBaseDataType();
        return dt instanceof CharDataType || dt instanceof WideCharDataType || dt instanceof WideChar16DataType || dt instanceof WideChar32DataType;
    }

    public static StringDataInstance getStringDataInstance(Data data) {
        if (data == null) {
            return NULL_INSTANCE;
        }
        DataType dt = data.getBaseDataType();
        if (dt instanceof AbstractStringDataType) {
            return ((AbstractStringDataType)dt).getStringDataInstance(data, data, data.getLength());
        }
        if (dt instanceof Array) {
            ArrayStringable arrayStringable = ArrayStringable.getArrayStringable(((Array)dt).getDataType());
            return arrayStringable.getStringDataInstance(data, data, data.getLength());
        }
        return NULL_INSTANCE;
    }

    public static StringDataInstance getStringDataInstance(DataType stringDataType, MemBuffer buf, Settings settings, int length) {
        if (stringDataType instanceof AbstractStringDataType) {
            return ((AbstractStringDataType)stringDataType).getStringDataInstance(buf, settings, length);
        }
        if (stringDataType instanceof Array && ((Array)stringDataType).getDataType() instanceof ArrayStringable) {
            stringDataType = ((Array)stringDataType).getDataType();
        }
        if (stringDataType instanceof ArrayStringable && ((ArrayStringable)stringDataType).hasStringValue(settings)) {
            return ((ArrayStringable)stringDataType).getStringDataInstance(buf, settings, length);
        }
        return NULL_INSTANCE;
    }

    protected StringDataInstance() {
        this.buf = null;
        this.charSize = 0;
        this.paddedCharSize = 0;
        this.charsetName = UNKNOWN;
        this.translatedValue = null;
        this.stringLayout = StringLayoutEnum.FIXED_LEN;
        this.endianSetting = null;
        this.renderSetting = RenderUnicodeSettingsDefinition.RENDER_ENUM.ALL;
    }

    public StringDataInstance(DataType dataType, Settings settings, MemBuffer buf, int length) {
        settings = settings == null ? SettingsImpl.NO_SETTINGS : settings;
        this.buf = buf;
        this.charsetName = StringDataInstance.getCharsetNameFromDataTypeOrSettings(dataType, settings);
        this.paddedCharSize = this.charSize = CharsetInfo.getInstance().getCharsetCharSize(this.charsetName);
        this.stringLayout = StringDataInstance.getLayoutFromDataType(dataType);
        this.showTranslation = TranslationSettingsDefinition.TRANSLATION.isShowTranslated(settings);
        this.translatedValue = TranslationSettingsDefinition.TRANSLATION.getTranslatedValue(settings);
        this.renderSetting = (RenderUnicodeSettingsDefinition.RENDER_ENUM)RenderUnicodeSettingsDefinition.RENDER.getEnumValue(settings);
        this.endianSetting = EndianSettingsDefinition.ENDIAN.getEndianess(settings, null);
        this.length = length;
    }

    private StringDataInstance(StringDataInstance copyFrom, StringLayoutEnum newLayout, MemBuffer newBuf, int newLen) {
        this.charSize = copyFrom.charSize;
        this.paddedCharSize = copyFrom.paddedCharSize;
        this.translatedValue = null;
        this.charsetName = copyFrom.charsetName;
        this.stringLayout = newLayout;
        this.showTranslation = false;
        this.renderSetting = copyFrom.renderSetting;
        this.length = newLen;
        this.buf = newBuf;
        this.endianSetting = copyFrom.endianSetting;
    }

    private static StringLayoutEnum getLayoutFromDataType(DataType dataType) {
        if (dataType instanceof AbstractStringDataType) {
            return ((AbstractStringDataType)dataType).getStringLayout();
        }
        return StringLayoutEnum.NULL_TERMINATED_BOUNDED;
    }

    private static String getCharsetNameFromDataTypeOrSettings(DataType dataType, Settings settings) {
        return dataType instanceof DataTypeWithCharset ? ((DataTypeWithCharset)dataType).getCharsetName(settings) : DEFAULT_CHARSET_NAME;
    }

    public String getCharsetName() {
        return this.charsetName;
    }

    public Address getAddress() {
        return this.buf.getAddress();
    }

    private boolean isBadCharSize() {
        return this.paddedCharSize < 1 || this.paddedCharSize > 8 || this.charSize != 1 && this.charSize != 2 && this.charSize != 4 || this.paddedCharSize < this.charSize;
    }

    private boolean isProbe() {
        return this.length == -1;
    }

    private boolean isAlreadyDeterminedFixedLen() {
        return this.length >= 0 && this.stringLayout == StringLayoutEnum.FIXED_LEN;
    }

    public boolean isPascal() {
        return this.stringLayout == StringLayoutEnum.PASCAL_255 || this.stringLayout == StringLayoutEnum.PASCAL_64k;
    }

    public int getDataLength() {
        return this.length;
    }

    public int getStringLength() {
        if (this.stringLayout.isPascal()) {
            return this.getPascalLength();
        }
        if (this.isBadCharSize() || this.buf == null || this.isAlreadyDeterminedFixedLen()) {
            return this.length;
        }
        return this.getNullTerminatedLength();
    }

    private int getNullTerminatedLength() {
        int localLen = this.length;
        boolean localNT = this.stringLayout.isNullTerminated();
        if (this.isProbe() || this.stringLayout == StringLayoutEnum.NULL_TERMINATED_UNBOUNDED) {
            localLen = 16384;
            localNT = true;
        }
        int internalCharOffset = this.buf.isBigEndian() ? this.paddedCharSize - this.charSize : 0;
        byte[] charBuf = new byte[this.charSize];
        for (int offset = 0; offset < localLen; offset += this.paddedCharSize) {
            try {
                if (!this.readChar(charBuf, offset + internalCharOffset)) break;
                if (!localNT || !this.isNullChar(charBuf)) continue;
                return offset + this.paddedCharSize;
            }
            catch (AddressOutOfBoundsException exc) {
                return this.stringLayout == StringLayoutEnum.NULL_TERMINATED_UNBOUNDED ? -1 : offset;
            }
        }
        return this.stringLayout == StringLayoutEnum.NULL_TERMINATED_UNBOUNDED ? -1 : this.length;
    }

    public boolean hasNullTerminator() {
        if (!this.isPascal()) {
            String str = this.getStringValueNoTrim();
            return str != null && str.length() > 0 && str.charAt(str.length() - 1) == '\u0000';
        }
        return false;
    }

    private int getPascalLength() {
        try {
            switch (this.stringLayout) {
                case PASCAL_255: {
                    return 1 + this.buf.getUnsignedByte(0) * this.paddedCharSize;
                }
                case PASCAL_64k: {
                    return 2 + this.buf.getUnsignedShort(0) * this.paddedCharSize;
                }
            }
            return -1;
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("PascalString error: " + e.getMessage()));
            return -1;
        }
    }

    private boolean readChar(byte[] charBuf, int offset) {
        return this.buf.getBytes(charBuf, offset) == charBuf.length;
    }

    private boolean isNullChar(byte[] charBuf) {
        for (byte element : charBuf) {
            if (element == 0) continue;
            return false;
        }
        return true;
    }

    public String getStringValue() {
        String str = this.getStringValueNoTrim();
        return str != null && !this.isPascal() ? this.trimNulls(str) : str;
    }

    private String getStringValueNoTrim() {
        if (this.isProbe() || this.isBadCharSize()) {
            return null;
        }
        byte[] stringBytes = this.convertPaddedToUnpadded(this.getStringBytes());
        if (stringBytes == null) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        AdjustedCharsetInfo aci = this.getAdjustedCharsetInfo(stringBytes);
        String str = this.convertBytesToString(stringBytes, aci);
        return str;
    }

    private byte[] getStringBytes() {
        return this.isPascal() ? this.getPascalCharBytes() : this.getNormalStringCharBytes();
    }

    private byte[] getNormalStringCharBytes() {
        int strLength = this.getStringLength();
        return this.getBytesFromMemBuff(this.buf, strLength >= 0 ? strLength : this.length);
    }

    private byte[] getPascalCharBytes() {
        try {
            int offset;
            int len;
            switch (this.stringLayout) {
                case PASCAL_255: {
                    len = this.buf.getUnsignedByte(0) * this.paddedCharSize;
                    offset = 1;
                    break;
                }
                case PASCAL_64k: {
                    len = this.buf.getUnsignedShort(0) * this.paddedCharSize;
                    offset = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            WrappedMemBuffer pascalBuf = new WrappedMemBuffer(this.buf, offset);
            return this.getBytesFromMemBuff(pascalBuf, len);
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("PascalString error: " + e.getMessage()));
            return null;
        }
    }

    private boolean isValidOffcutOffset(int offcutBytes) {
        switch (this.stringLayout) {
            case PASCAL_255: {
                int n = 1;
            }
            case PASCAL_64k: {
                int n = 2;
            }
        }
        int minValid = 0;
        return offcutBytes >= minValid && offcutBytes < this.length;
    }

    private int getCharOffset(int charCount) {
        int charBytes = charCount * this.charSize;
        switch (this.stringLayout) {
            case PASCAL_255: {
                return Math.max(0, 1 + charBytes);
            }
            case PASCAL_64k: {
                return Math.max(0, 2 + charBytes);
            }
        }
        return charBytes;
    }

    private StringLayoutEnum getOffcutLayout() {
        switch (this.stringLayout) {
            case PASCAL_255: 
            case PASCAL_64k: {
                return StringLayoutEnum.FIXED_LEN;
            }
        }
        return this.stringLayout;
    }

    private byte[] getBytesFromMemBuff(MemBuffer memBuffer, int copyLen) {
        byte[] bytes = new byte[copyLen &= ~(this.paddedCharSize - 1)];
        if (memBuffer.getBytes(bytes, 0) != bytes.length) {
            return null;
        }
        return bytes;
    }

    private byte[] convertPaddedToUnpadded(byte[] paddedBytes) {
        if (this.paddedCharSize == this.charSize || paddedBytes == null) {
            return paddedBytes;
        }
        byte[] unpaddedBytes = new byte[paddedBytes.length / this.paddedCharSize * this.charSize];
        int srcOffset = this.buf.isBigEndian() ? this.paddedCharSize - this.charSize : 0;
        int destOffset = 0;
        while (srcOffset < paddedBytes.length) {
            System.arraycopy(paddedBytes, srcOffset, unpaddedBytes, destOffset, this.charSize);
            srcOffset += this.paddedCharSize;
            destOffset += this.charSize;
        }
        return unpaddedBytes;
    }

    private Endian getMemoryEndianness() {
        return this.buf.isBigEndian() ? Endian.BIG : Endian.LITTLE;
    }

    private String convertBytesToString(byte[] bytes, AdjustedCharsetInfo aci) {
        Charset cs = Charset.isSupported(aci.charsetName) ? Charset.forName(aci.charsetName) : null;
        return cs != null ? new String(bytes, aci.byteStartOffset, bytes.length - aci.byteStartOffset, cs) : StringDataInstance.convertBytesToStringCustomCharset(bytes, aci);
    }

    private AdjustedCharsetInfo getAdjustedCharsetInfo(byte[] bytes) {
        AdjustedCharsetInfo result = new AdjustedCharsetInfo(this.charsetName);
        if (CharsetInfo.isBOMCharset(this.charsetName)) {
            result.endian = StringDataInstance.getEndiannessFromBOM(bytes, this.charSize);
            if (result.endian != null) {
                result.byteStartOffset = this.charSize;
            }
            if (result.endian == null) {
                result.endian = this.endianSetting;
            }
            if (result.endian == null) {
                result.endian = this.getMemoryEndianness();
            }
            result.charsetName = result.charsetName + result.endian.toShortString();
        }
        if (result.endian == null) {
            result.endian = this.getMemoryEndianness();
        }
        return result;
    }

    private byte[] convertStringToBytes(String s, AdjustedCharsetInfo aci) {
        Charset cs = Charset.isSupported(aci.charsetName) ? Charset.forName(aci.charsetName) : null;
        return cs != null ? s.getBytes(cs) : null;
    }

    private static DataConverter getDataConverter(Endian endian) {
        return endian == Endian.BIG ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
    }

    private static String convertBytesToStringCustomCharset(byte[] bytes, AdjustedCharsetInfo aci) {
        switch (aci.charsetName) {
            case "UTF-32LE": 
            case "UTF-32BE": {
                DataConverter dc = StringDataInstance.getDataConverter(aci.endian);
                int[] codePoints = new int[(bytes.length - aci.byteStartOffset) / 4];
                for (int i = 0; i < codePoints.length; ++i) {
                    codePoints[i] = dc.getInt(bytes, aci.byteStartOffset + i * 4);
                    if (codePoints[i] >= 0 && codePoints[i] <= 0x10FFFF) continue;
                    codePoints[i] = 65533;
                }
                return new String(codePoints, 0, codePoints.length);
            }
        }
        return null;
    }

    private static Endian getEndiannessFromBOM(byte[] bytes, int charSize) {
        if (bytes.length < charSize) {
            return null;
        }
        int be_val = (int)BigEndianDataConverter.INSTANCE.getValue(bytes, charSize);
        switch (be_val) {
            case 65279: {
                return Endian.BIG;
            }
            case -131072: 
            case 65534: {
                return Endian.LITTLE;
            }
        }
        return null;
    }

    public String getStringRepresentation() {
        int codePoint;
        if (this.isProbe() || this.isBadCharSize()) {
            return UNKNOWN;
        }
        if (this.showTranslation && this.translatedValue != null) {
            return StringDataInstance.getTranslatedStringRepresentation(this.translatedValue);
        }
        byte[] stringBytes = this.convertPaddedToUnpadded(this.getStringBytes());
        if (stringBytes == null) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        AdjustedCharsetInfo aci = this.getAdjustedCharsetInfo(stringBytes);
        String stringValue = this.convertBytesToString(stringBytes, aci);
        if (stringValue == null) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        boolean canRecoverOriginalCharBytes = stringValue.length() - aci.byteStartOffset == stringBytes.length / this.charSize;
        StringRenderBuilder strBuf = new StringRenderBuilder(this.charSize);
        String string = stringValue = !this.isPascal() ? this.trimNulls(stringValue) : stringValue;
        if (stringValue.isEmpty() || stringValue.length() == 1 && stringValue.charAt(0) == '\u0000') {
            strBuf.addString("");
        }
        int strLength = stringValue.length();
        block10: for (int i = 0; i < strLength; i += Character.charCount(codePoint)) {
            byte[] originalCharBytes;
            codePoint = stringValue.codePointAt(i);
            if (canRecoverOriginalCharBytes) {
                originalCharBytes = new byte[this.charSize];
                System.arraycopy(stringBytes, i * this.charSize, originalCharBytes, 0, this.charSize);
            } else {
                String singleCharStr = new String(new int[]{codePoint}, 0, 1);
                originalCharBytes = this.convertStringToBytes(singleCharStr, aci);
            }
            if (StringUtilities.isControlCharacterOrBackslash((int)codePoint)) {
                strBuf.addString(StringUtilities.convertCodePointToEscapeSequence((int)codePoint));
                continue;
            }
            if (codePoint == 0 && this.renderSetting != RenderUnicodeSettingsDefinition.RENDER_ENUM.BYTE_SEQ) {
                strBuf.addEscapedChar('0');
                continue;
            }
            if (StringUtilities.isDisplayable((int)codePoint)) {
                strBuf.addCodePointChar(codePoint);
                continue;
            }
            if (StringUtilities.isUnicodeReplacementCodePoint((int)codePoint)) {
                if (canRecoverOriginalCharBytes && this.isMismatchedCharBytes(originalCharBytes, codePoint)) {
                    strBuf.addByteSeq(originalCharBytes);
                    continue;
                }
                strBuf.addCodePointChar(codePoint);
                continue;
            }
            RenderUnicodeSettingsDefinition.RENDER_ENUM thisCharRenderSetting = this.renderSetting;
            if (thisCharRenderSetting == RenderUnicodeSettingsDefinition.RENDER_ENUM.ALL) {
                if (codePoint <= 127) {
                    thisCharRenderSetting = RenderUnicodeSettingsDefinition.RENDER_ENUM.BYTE_SEQ;
                } else if (Character.isISOControl(codePoint) || !Character.isDefined(codePoint)) {
                    thisCharRenderSetting = RenderUnicodeSettingsDefinition.RENDER_ENUM.ESC_SEQ;
                }
            }
            switch (thisCharRenderSetting) {
                case ALL: {
                    strBuf.addCodePointChar(codePoint);
                    continue block10;
                }
                case BYTE_SEQ: {
                    strBuf.addByteSeq(originalCharBytes);
                    continue block10;
                }
                case ESC_SEQ: {
                    strBuf.addEscapedCodePoint(codePoint);
                }
            }
        }
        String result = strBuf.toString();
        String prefix = "";
        if (this.charsetName.startsWith("UTF") && result.startsWith("\"")) {
            switch (this.charSize) {
                case 1: {
                    prefix = "u8";
                    break;
                }
                case 2: {
                    prefix = "u";
                    break;
                }
                case 4: {
                    prefix = "U";
                }
            }
        }
        return prefix + result;
    }

    private String trimNulls(String s) {
        int lastGoodChar;
        for (lastGoodChar = s.length() - 1; lastGoodChar >= 0 && s.charAt(lastGoodChar) == '\u0000'; --lastGoodChar) {
        }
        return s.substring(0, lastGoodChar + 1);
    }

    public String getTranslatedValue() {
        return this.translatedValue;
    }

    public boolean isShowTranslation() {
        return this.showTranslation;
    }

    public String getCharRepresentation() {
        if (this.length < this.charSize) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        byte[] charBytes = this.convertPaddedToUnpadded(this.getStringBytes());
        if (charBytes == null) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        AdjustedCharsetInfo aci = this.getAdjustedCharsetInfo(charBytes);
        String stringValue = this.convertBytesToString(charBytes, aci);
        if (stringValue == null) {
            return UNKNOWN_DOT_DOT_DOT;
        }
        if (stringValue.length() == 0) {
            if (aci.byteStartOffset == 0) {
                return UNKNOWN;
            }
            stringValue = BOM_RESULT_STR;
        }
        int codePoint = stringValue.codePointAt(0);
        RenderUnicodeSettingsDefinition.RENDER_ENUM tmpRenderSetting = this.renderSetting;
        StringRenderBuilder strBuf = new StringRenderBuilder(this.charSize, '\'');
        if (StringUtilities.isControlCharacterOrBackslash((int)codePoint)) {
            strBuf.addString(StringUtilities.convertCodePointToEscapeSequence((int)codePoint));
        } else if (codePoint == 0 && this.renderSetting != RenderUnicodeSettingsDefinition.RENDER_ENUM.BYTE_SEQ) {
            strBuf.addEscapedChar('0');
        } else if (StringUtilities.isUnicodeReplacementCodePoint((int)codePoint) && this.renderSetting != RenderUnicodeSettingsDefinition.RENDER_ENUM.BYTE_SEQ) {
            strBuf.addCodePointChar(codePoint);
        } else if (StringUtilities.isDisplayable((int)codePoint)) {
            strBuf.addCodePointChar(codePoint);
        } else {
            boolean alwaysNeedsEscaping = this.renderSetting == RenderUnicodeSettingsDefinition.RENDER_ENUM.ALL && (Character.isISOControl(codePoint) || !Character.isDefined(codePoint) || codePoint == 65279);
            tmpRenderSetting = alwaysNeedsEscaping ? RenderUnicodeSettingsDefinition.RENDER_ENUM.ESC_SEQ : this.renderSetting;
            switch (tmpRenderSetting) {
                case ALL: {
                    strBuf.addCodePointChar(codePoint);
                    break;
                }
                case ESC_SEQ: {
                    strBuf.addEscapedCodePoint(codePoint);
                    break;
                }
                case BYTE_SEQ: {
                    strBuf.addByteSeq(charBytes);
                }
            }
        }
        String prefix = "";
        if (this.charsetName.startsWith("UTF") && tmpRenderSetting != RenderUnicodeSettingsDefinition.RENDER_ENUM.BYTE_SEQ) {
            switch (this.charSize) {
                case 1: {
                    prefix = "u8";
                    break;
                }
                case 2: {
                    prefix = "u";
                    break;
                }
                case 4: {
                    prefix = "U";
                }
            }
        }
        return prefix + strBuf.toString();
    }

    private boolean isMismatchedCharBytes(byte[] originalCharBytes, int codePoint) {
        long originalValue = DataConverter.getInstance((boolean)this.buf.isBigEndian()).getValue(originalCharBytes, originalCharBytes.length);
        return originalValue != (long)codePoint;
    }

    private static String getTranslatedStringRepresentation(String translatedString) {
        return "\u00bb" + translatedString + "\u00ab";
    }

    public String getLabel(String prefixStr, String abbrevPrefixStr, String defaultStr, DataTypeDisplayOptions options) {
        int codePoint;
        if (this.isProbe() || this.isBadCharSize()) {
            return defaultStr;
        }
        if (options.useAbbreviatedForm()) {
            return abbrevPrefixStr;
        }
        String str = this.getStringValue();
        if (str == null || str.length() == 0) {
            return prefixStr;
        }
        boolean needsUnderscore = false;
        StringBuilder buffer = new StringBuilder();
        int strLength = str.length();
        for (int i = 0; i < strLength && buffer.length() < options.getLabelStringLength(); i += Character.charCount(codePoint)) {
            codePoint = str.codePointAt(i);
            if (StringUtilities.isDisplayable((int)codePoint) && codePoint != 32) {
                if (needsUnderscore) {
                    buffer.append('_');
                    needsUnderscore = false;
                }
                buffer.appendCodePoint(codePoint);
                continue;
            }
            needsUnderscore = true;
        }
        return prefixStr + buffer.toString();
    }

    public String getOffcutLabelString(String prefixStr, String abbrevPrefixStr, String defaultStr, DataTypeDisplayOptions options, int byteOffset) {
        if (this.isBadCharSize() || this.isProbe()) {
            return defaultStr;
        }
        StringDataInstance sub = this.getByteOffcut(byteOffset);
        return sub.getLabel(prefixStr, abbrevPrefixStr, defaultStr, options);
    }

    public StringDataInstance getByteOffcut(int byteOffset) {
        if (this.isBadCharSize() || this.isProbe() || !this.isValidOffcutOffset(byteOffset)) {
            return NULL_INSTANCE;
        }
        int newLength = Math.max(0, this.length - byteOffset);
        StringDataInstance sub = new StringDataInstance(this, this.getOffcutLayout(), (MemBuffer)new WrappedMemBuffer(this.buf, byteOffset), newLength);
        return sub;
    }

    public StringDataInstance getCharOffcut(int offsetChars) {
        return this.getByteOffcut(this.getCharOffset(offsetChars));
    }

    public DataType getStringDataTypeGuess() {
        DataType result = dataTypeMap.get(new Pair((Object)this.stringLayout, (Object)this.charsetName));
        if (result == null) {
            result = dataTypeMap.get(new Pair((Object)this.stringLayout, null));
        }
        if (result == null) {
            result = StringDataType.dataType;
        }
        return result;
    }

    public String toString() {
        return this.getStringValue();
    }

    static {
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.PASCAL_255, null), PascalString255DataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.PASCAL_64k, null), PascalStringDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.FIXED_LEN, null), StringDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.NULL_TERMINATED_BOUNDED, null), StringDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.NULL_TERMINATED_UNBOUNDED, null), TerminatedStringDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.PASCAL_64k, (Object)"UTF-16"), PascalUnicodeDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.FIXED_LEN, (Object)"UTF-8"), StringUTF8DataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.FIXED_LEN, (Object)"UTF-16"), UnicodeDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.FIXED_LEN, (Object)"UTF-32"), Unicode32DataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.NULL_TERMINATED_UNBOUNDED, (Object)"UTF-16"), TerminatedUnicodeDataType.dataType);
        dataTypeMap.put((Pair<StringLayoutEnum, String>)new Pair((Object)StringLayoutEnum.NULL_TERMINATED_UNBOUNDED, (Object)"UTF-32"), TerminatedUnicode32DataType.dataType);
    }

    private static class AdjustedCharsetInfo {
        String charsetName;
        int byteStartOffset;
        Endian endian;

        public AdjustedCharsetInfo(String charsetName) {
            this.charsetName = charsetName;
        }
    }

    public static class StaticStringInstance
    extends StringDataInstance {
        private final String fakeStr;
        private final int fakeLen;

        public StaticStringInstance(String fakeStr, int fakeLen) {
            this.fakeStr = fakeStr;
            this.fakeLen = fakeLen;
        }

        @Override
        public String getStringValue() {
            return this.fakeStr;
        }

        @Override
        public String getStringRepresentation() {
            return this.fakeStr;
        }

        @Override
        public int getStringLength() {
            return this.fakeLen;
        }

        @Override
        public String getLabel(String prefixStr, String abbrevPrefixStr, String defaultStr, DataTypeDisplayOptions options) {
            return defaultStr;
        }

        @Override
        public String getOffcutLabelString(String prefixStr, String abbrevPrefixStr, String defaultStr, DataTypeDisplayOptions options, int offcutOffset) {
            return defaultStr;
        }
    }
}

