/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.lang.Register;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;
import java.util.Arrays;

public class RegisterValue {
    private static final int[] START_BYTE_MASK = new int[]{255, 127, 63, 31, 15, 7, 3, 1, 0};
    private static final int[] END_BYTE_MASK = new int[]{128, 192, 224, 240, 248, 252, 254, 255};
    private byte[] bytes;
    private int startBit;
    private int endBit;
    private Register register;

    public RegisterValue(Register register) {
        this.register = register;
        this.startBit = register.getLeastSignificatBitInBaseRegister();
        this.endBit = this.startBit + register.getBitLength() - 1;
        byte[] mask = register.getBaseMask();
        this.bytes = new byte[mask.length * 2];
    }

    public RegisterValue(Register register, BigInteger value) {
        this.register = register;
        byte[] mask = register.getBaseMask();
        this.startBit = register.getLeastSignificatBitInBaseRegister();
        this.endBit = this.startBit + register.getBitLength() - 1;
        value = value.shiftLeft(this.startBit);
        byte[] valueBytes = value.toByteArray();
        int lengthDiff = mask.length - valueBytes.length;
        byte signextend = (byte)(value.signum() < 0 ? -1 : 0);
        this.bytes = new byte[mask.length * 2];
        int n = mask.length;
        for (int i = 0; i < mask.length; ++i) {
            this.bytes[i] = mask[i];
            int valueByteIndex = i - lengthDiff;
            this.bytes[i + n] = valueByteIndex >= 0 ? (byte)(valueBytes[valueByteIndex] & mask[i]) : signextend;
        }
    }

    public RegisterValue(Register register, BigInteger value, BigInteger mask) {
        this(register, value);
        byte[] maskBytes = mask.shiftLeft(this.startBit).toByteArray();
        int baseMaskLen = this.bytes.length / 2;
        int maskIndex = maskBytes.length - 1;
        int i = baseMaskLen - 1;
        while (i >= 0) {
            this.bytes[i] = maskIndex < 0 ? (byte)0 : maskBytes[maskIndex];
            int n = baseMaskLen + i;
            this.bytes[n] = (byte)(this.bytes[n] & this.bytes[i]);
            --i;
            --maskIndex;
        }
    }

    public RegisterValue(Register register, byte[] bytes) {
        this.register = register;
        this.bytes = RegisterValue.adjustBytes(register.getBaseRegister(), bytes);
        this.applyRegisterMask(register.getBaseMask());
        this.startBit = register.getLeastSignificatBitInBaseRegister();
        this.endBit = this.startBit + register.getBitLength() - 1;
    }

    private void applyRegisterMask(byte[] baseMask) {
        if (baseMask.length != this.bytes.length / 2) {
            throw new AssertException();
        }
        int valueOffset = baseMask.length;
        for (int i = 0; i < baseMask.length; ++i) {
            int n = i;
            this.bytes[n] = (byte)(this.bytes[n] & baseMask[i]);
            int n2 = valueOffset + i;
            this.bytes[n2] = (byte)(this.bytes[n2] & baseMask[i]);
        }
    }

    private static byte[] adjustBytes(Register baseRegister, byte[] bytes) {
        int i;
        int newMaskIndex;
        int oldMaskIndex;
        int newValIndex;
        int oldValIndex;
        int keepLen;
        int oldSize = bytes.length;
        byte[] baseMask = baseRegister.getBaseMask();
        int newSize = baseMask.length * 2;
        if (oldSize == newSize) {
            return (byte[])bytes.clone();
        }
        byte[] newBytes = new byte[newSize];
        boolean isContext = baseRegister.isProcessorContext();
        int oldFieldLen = bytes.length / 2;
        int newFieldLen = baseMask.length;
        int n = keepLen = oldSize < newSize ? oldFieldLen : newFieldLen;
        if (isContext) {
            oldValIndex = oldFieldLen;
            newValIndex = newFieldLen;
            oldMaskIndex = 0;
            newMaskIndex = 0;
        } else {
            oldValIndex = oldSize - keepLen;
            newValIndex = newSize - keepLen;
            oldMaskIndex = oldFieldLen - keepLen;
            newMaskIndex = newFieldLen - keepLen;
        }
        int maskFill = newMaskIndex;
        for (i = 0; i < keepLen; ++i) {
            byte maskByte;
            if ((maskByte = bytes[oldMaskIndex++]) != -1) {
                maskFill = 0;
            }
            newBytes[newValIndex++] = (byte)(bytes[oldValIndex++] & maskByte);
            newBytes[newMaskIndex++] = maskByte;
        }
        for (i = 0; i < maskFill; ++i) {
            newBytes[i] = -1;
        }
        return newBytes;
    }

    public Register getRegister() {
        return this.register;
    }

    public RegisterValue combineValues(RegisterValue otherValue) {
        if (otherValue == null) {
            return this;
        }
        this.checkBaseRegister(otherValue.register);
        Register baseRegister = this.register.getBaseRegister();
        Register resultRegister = this.register;
        if (this.register != otherValue.getRegister()) {
            resultRegister = baseRegister;
        }
        byte[] resultBytes = new byte[otherValue.bytes.length];
        int n = this.bytes.length / 2;
        for (int i = 0; i < n; ++i) {
            byte mask = otherValue.bytes[i];
            int clearMask = ~mask;
            resultBytes[n + i] = (byte)(otherValue.bytes[n + i] & mask | this.bytes[n + i] & clearMask);
            resultBytes[i] = (byte)(this.bytes[i] | otherValue.bytes[i]);
        }
        return new RegisterValue(resultRegister, resultBytes);
    }

    private void checkBaseRegister(Register reg) {
        Register baseRegister = this.register.getBaseRegister();
        if (reg.getBaseRegister() != baseRegister) {
            throw new IllegalArgumentException("Register " + reg.getName() + " does not share common base register " + baseRegister.getName());
        }
    }

    public RegisterValue getBaseRegisterValue() {
        return new RegisterValue(this.register.getBaseRegister(), this.bytes);
    }

    public byte[] getBaseValueMask() {
        byte[] mask = this.register.getBaseMask();
        byte[] valueMask = new byte[mask.length];
        for (int i = 0; i < mask.length; ++i) {
            valueMask[i] = (byte)(mask[i] & this.bytes[i]);
        }
        return valueMask;
    }

    public BigInteger getValueMask() {
        BigInteger valueMask = new BigInteger(1, this.getBaseValueMask());
        return valueMask.shiftRight(this.startBit);
    }

    public RegisterValue assign(Register subRegister, RegisterValue value) {
        this.checkBaseRegister(subRegister);
        RegisterValue otherValue = new RegisterValue(subRegister, value.getUnsignedValueIgnoreMask(), value.getValueMask());
        return this.combineValues(otherValue);
    }

    public RegisterValue assign(Register subRegister, BigInteger value) {
        this.checkBaseRegister(subRegister);
        RegisterValue otherValue = new RegisterValue(subRegister, value);
        return this.combineValues(otherValue);
    }

    public RegisterValue clearBitValues(byte[] mask) {
        if (mask.length != this.bytes.length / 2) {
            throw new IllegalArgumentException("Mask length must be the same length as this objects mask");
        }
        byte[] resultBytes = new byte[this.bytes.length];
        int n = mask.length;
        for (int i = 0; i < n; ++i) {
            int clearMask = ~mask[i];
            resultBytes[n + i] = (byte)(this.bytes[n + i] & clearMask);
            resultBytes[i] = (byte)(this.bytes[i] & clearMask);
        }
        return new RegisterValue(this.register, resultBytes);
    }

    public byte[] toBytes() {
        return this.bytes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.register.hashCode();
        result = 31 * result + Arrays.hashCode(this.bytes);
        result = 31 * result + this.startBit;
        result = 31 * result + this.endBit;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RegisterValue other = (RegisterValue)obj;
        return this.register == other.register && Arrays.equals(this.bytes, other.bytes);
    }

    public String toString() {
        int len = this.bytes.length / 2;
        String maskStr = NumericUtilities.convertBytesToString((byte[])this.bytes, (int)0, (int)len, (String)"");
        String valStr = NumericUtilities.convertBytesToString((byte[])this.bytes, (int)len, (int)len, (String)"");
        return "RegisterValue(" + this.register.getName() + "): mask=0x" + maskStr + " value=0x" + valStr;
    }

    public boolean hasValue() {
        int totalBitLength = this.bytes.length * 4;
        int start = totalBitLength - this.endBit - 1;
        int end = totalBitLength - this.startBit - 1;
        int startByte = start / 8;
        int endByte = end / 8;
        int bitInStartByte = start % 8;
        int bitInEndByte = end % 8;
        if (startByte == endByte) {
            int mask = START_BYTE_MASK[bitInStartByte] & END_BYTE_MASK[bitInEndByte];
            return (this.bytes[startByte] & mask) == mask;
        }
        if ((this.bytes[startByte] & START_BYTE_MASK[bitInStartByte]) != START_BYTE_MASK[bitInStartByte]) {
            return false;
        }
        if ((this.bytes[endByte] & END_BYTE_MASK[bitInEndByte]) != END_BYTE_MASK[bitInEndByte]) {
            return false;
        }
        for (int i = startByte + 1; i < endByte; ++i) {
            if (this.bytes[i] == -1) continue;
            return false;
        }
        return true;
    }

    public BigInteger getUnsignedValue() {
        if (this.isMaskOn()) {
            return this.getUnsignedValueIgnoreMask();
        }
        return null;
    }

    public BigInteger getUnsignedValueIgnoreMask() {
        int totalBitLength = this.bytes.length * 4;
        int start = totalBitLength - this.endBit - 1;
        int end = totalBitLength - this.startBit - 1;
        int numBits = end - start + 1;
        int size = (end - start) / 8 + 1;
        int extraBytes = 0;
        if (size * 8 == numBits && this.getBit(start) == 1) {
            extraBytes = 1;
        }
        byte[] result = new byte[size + extraBytes];
        int endByte = end / 8 + this.bytes.length / 2;
        int bitInEndByte = end % 8;
        int lowShift = 7 - bitInEndByte;
        int highShift = bitInEndByte + 1;
        int highByteMask = START_BYTE_MASK[size * 8 - (end - start + 1)];
        for (int i = size - 1; i >= 0; --i) {
            int lowPart = (this.bytes[endByte] & END_BYTE_MASK[bitInEndByte]) >>> lowShift;
            int highPart = (this.bytes[endByte - 1] & START_BYTE_MASK[bitInEndByte + 1]) << highShift;
            result[i + extraBytes] = (byte)(highPart | lowPart);
            if (i == 0) {
                result[i + extraBytes] = (byte)(result[i + extraBytes] & highByteMask);
            }
            --endByte;
        }
        return new BigInteger(result);
    }

    public BigInteger getSignedValue() {
        if (this.isMaskOn()) {
            return this.getSignedValueIgnoreMask();
        }
        return null;
    }

    public BigInteger getSignedValueIgnoreMask() {
        int totalBitLength = this.bytes.length * 4;
        int start = totalBitLength - this.endBit - 1;
        int end = totalBitLength - this.startBit - 1;
        int size = (end - start) / 8 + 1;
        byte[] result = new byte[size];
        int endByte = end / 8 + this.bytes.length / 2;
        int bitInEndByte = end % 8;
        int lowShift = 7 - bitInEndByte;
        int highShift = bitInEndByte + 1;
        for (int i = size - 1; i >= 0; --i) {
            int lowPart = (this.bytes[endByte] & END_BYTE_MASK[bitInEndByte]) >>> lowShift;
            int highPart = (this.bytes[endByte - 1] & START_BYTE_MASK[bitInEndByte + 1]) << highShift;
            result[i] = (byte)(highPart | lowPart);
            if (i == 0) {
                result[i] = this.getBit(start) == 1 ? (byte)(result[i] | END_BYTE_MASK[size * 8 - (end - start + 1)]) : (byte)(result[i] & START_BYTE_MASK[size * 8 - (end - start + 1)]);
            }
            --endByte;
        }
        return new BigInteger(result);
    }

    private int getBit(int bitIndex) {
        int byteIndex = bitIndex / 8;
        int bitInByte = bitIndex % 8;
        int value = this.bytes[byteIndex + this.bytes.length / 2];
        if ((value = value & START_BYTE_MASK[bitInByte] & END_BYTE_MASK[bitInByte]) == 0) {
            return 0;
        }
        return 1;
    }

    private boolean isMaskOn() {
        int totalBitLength = this.bytes.length * 4;
        int start = totalBitLength - this.endBit - 1;
        int end = totalBitLength - this.startBit - 1;
        int startByte = start / 8;
        int endByte = end / 8;
        int bitInStartByte = start % 8;
        int bitInEndByte = end % 8;
        if (startByte == endByte) {
            int mask = START_BYTE_MASK[bitInStartByte] & END_BYTE_MASK[bitInEndByte];
            return (this.bytes[startByte] & mask) == mask;
        }
        if ((this.bytes[startByte] & START_BYTE_MASK[bitInStartByte]) != START_BYTE_MASK[bitInStartByte]) {
            return false;
        }
        if ((this.bytes[endByte] & END_BYTE_MASK[bitInEndByte]) != END_BYTE_MASK[bitInEndByte]) {
            return false;
        }
        for (int i = startByte + 1; i < endByte; ++i) {
            if (this.bytes[i] == -1) continue;
            return false;
        }
        return true;
    }

    private static boolean isMaskAllOn(byte[] bytes) {
        int cnt = bytes.length / 2;
        for (int i = 0; i < cnt; ++i) {
            if (bytes[i] == -1) continue;
            return false;
        }
        return true;
    }

    public boolean hasAnyValue() {
        int byteLength = this.bytes.length / 2;
        for (int i = 0; i < byteLength; ++i) {
            if (this.bytes[i] == 0) continue;
            return true;
        }
        return false;
    }

    public RegisterValue getRegisterValue(Register newRegister) {
        if (this.register == newRegister) {
            return this;
        }
        this.checkBaseRegister(newRegister);
        return new RegisterValue(newRegister, this.bytes);
    }
}

