/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import generic.jar.ResourceFile;
import ghidra.app.plugin.processors.generic.MemoryBlockDefinition;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.DefaultAddressFactory;
import ghidra.program.model.address.GenericAddressSpace;
import ghidra.program.model.address.SegmentedAddressSpace;
import ghidra.program.model.lang.BasicCompilerSpecDescription;
import ghidra.program.model.lang.BasicLanguageDescription;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecDescription;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Endian;
import ghidra.program.model.lang.InstructionPrototype;
import ghidra.program.model.lang.InvalidPrototype;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageDescription;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.OldLanguageMappingService;
import ghidra.program.model.lang.ParallelInstructionLanguageHelper;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.ProcessorContext;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterBuilder;
import ghidra.program.model.lang.RegisterManager;
import ghidra.program.model.listing.DefaultProgramContext;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.util.AddressLabelInfo;
import ghidra.util.ManualEntry;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;

class OldLanguage
implements Language {
    private LanguageDescription langDescription;
    private Endian endian;
    private AddressFactory addressFactory;
    private RegisterManager registerMgr;
    private List<CompilerSpecDescription> associatedCompilerSpecs = new ArrayList<CompilerSpecDescription>();
    private final ResourceFile oldLangFile;
    private static Set<String> EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    OldLanguage(ResourceFile oldLangFile) throws IOException {
        this.oldLangFile = oldLangFile;
        this.readOldLanguage(true);
    }

    OldLanguage(Element oldLanguageElement) throws JDOMException, SAXException {
        this.oldLangFile = null;
        this.parseOldLanguage(oldLanguageElement, false);
    }

    public String toString() {
        return this.getDescription() + "(Version " + this.getVersion() + ")";
    }

    void validate() throws JDOMException, SAXException, IOException {
        if (this.oldLangFile != null && this.addressFactory == null || this.registerMgr == null) {
            this.readOldLanguage(false);
        }
    }

    @Override
    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    @Override
    public ParallelInstructionLanguageHelper getParallelInstructionHelper() {
        throw new UnsupportedOperationException("Language for upgrade use only (getParallelInstructionHelper)");
    }

    @Override
    public int getInstructionAlignment() {
        return 1;
    }

    @Override
    public LanguageID getLanguageID() {
        return this.langDescription.getLanguageID();
    }

    @Override
    public Register getContextBaseRegister() {
        return this.registerMgr.getContextBaseRegister();
    }

    @Override
    public Register getRegister(Address addr, int size) {
        return this.registerMgr.getRegister(addr, size);
    }

    @Override
    public Register getRegister(AddressSpace addrspc, long offset, int size) {
        return this.registerMgr.getRegister(addrspc.getAddress(offset), size);
    }

    @Override
    public Register getRegister(String name) {
        return this.registerMgr.getRegister(name);
    }

    @Override
    public Register[] getRegisters() {
        return this.registerMgr.getRegisters();
    }

    @Override
    public Register[] getRegisters(Address address) {
        return this.registerMgr.getRegisters(address);
    }

    @Override
    public int getVersion() {
        return this.langDescription.getVersion();
    }

    @Override
    public int getMinorVersion() {
        return -1;
    }

    @Override
    public boolean isBigEndian() {
        return this.endian.isBigEndian();
    }

    @Override
    public InstructionPrototype parse(MemBuffer buf, ProcessorContext context, boolean inDelaySlot) {
        return new InvalidPrototype(this);
    }

    @Override
    public boolean supportsPcode() {
        return false;
    }

    LanguageDescription getDescription() {
        return this.langDescription;
    }

    private void readOldLanguage(boolean descriptionOnly) throws IOException {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(this.oldLangFile.getInputStream());
            SAXBuilder sax = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
            Document document = sax.build((InputStream)is);
            Element root = document.getRootElement();
            this.parseOldLanguage(root, descriptionOnly);
        }
        catch (SAXNotRecognizedException e) {
            throw new IOException("Failed to parse old language: " + this.oldLangFile, e);
        }
        catch (JDOMException e) {
            throw new IOException("Failed to parse old language: " + this.oldLangFile, e);
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse old language: " + this.oldLangFile, e);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    void parseOldLanguage(Element root, boolean descriptionOnly) throws SAXNotRecognizedException, SAXException {
        if (!"language".equals(root.getName())) {
            throw new SAXNotRecognizedException("Expected language document");
        }
        int version = OldLanguage.parseIntAttribute(root, "version");
        String endianString = root.getAttributeValue("endian");
        this.endian = Endian.toEndian(endianString);
        if (this.endian == null) {
            throw new SAXException("Invalid language endian value: " + endianString);
        }
        boolean descriptionFound = false;
        boolean spacesFound = false;
        boolean registersFound = false;
        for (Element element : root.getChildren()) {
            String elementName = element.getName();
            if ("description".equals(elementName)) {
                if (descriptionFound) {
                    throw new SAXException("only one 'description' element permitted");
                }
                descriptionFound = true;
                this.langDescription = this.parseDescription(element, version);
                continue;
            }
            if ("compiler".equals(elementName)) {
                this.associatedCompilerSpecs.add(this.parseCompilerSpecDescription(element));
                continue;
            }
            if ("spaces".equals(elementName)) {
                if (spacesFound) {
                    throw new SAXException("only one 'spaces' element permitted");
                }
                spacesFound = true;
                if (descriptionOnly) continue;
                this.addressFactory = this.parseAddressSpaces(element);
                continue;
            }
            if ("registers".equals(elementName)) {
                if (registersFound) {
                    throw new SAXException("only one 'registers' element permitted");
                }
                if (!spacesFound) {
                    throw new SAXException("'spaces' element must occur before 'registers' element within file");
                }
                registersFound = true;
                if (descriptionOnly) continue;
                this.registerMgr = this.parseRegisters(element, this.addressFactory);
                continue;
            }
            throw new SAXException("Unsupported language element '" + elementName + "'");
        }
        if (!descriptionFound) {
            throw new SAXException("Missing required 'description' element");
        }
        if (!spacesFound) {
            throw new SAXException("Missing required 'spaces' element");
        }
        if (!registersFound) {
            throw new SAXException("Missing required 'registers' element");
        }
    }

    private CompilerSpecDescription parseCompilerSpecDescription(Element element) throws SAXException {
        String name = element.getAttributeValue("name");
        String id = element.getAttributeValue("id");
        if (name == null || id == null) {
            throw new SAXException("Missing required compiler attribute (name or id)");
        }
        return new BasicCompilerSpecDescription(new CompilerSpecID(id), name);
    }

    private static int parseIntAttribute(Element element, String name) throws SAXException {
        String valStr = element.getAttributeValue(name);
        if (valStr == null) {
            throw new SAXException("Missing required " + element.getName() + " '" + name + "' attribute");
        }
        try {
            return XmlUtilities.parseInt((String)valStr);
        }
        catch (NumberFormatException e) {
            throw new SAXException("invalid integer attribute value: " + name + "=\"" + valStr + "\"");
        }
    }

    private boolean parseBooleanAttribute(Element element, String name, Boolean defaultVal) throws SAXException {
        String valStr = element.getAttributeValue(name);
        if (valStr == null) {
            if (defaultVal != null) {
                return defaultVal;
            }
            throw new SAXException("Missing required " + element.getName() + " '" + name + "' attribute");
        }
        boolean val = valStr.equalsIgnoreCase("yes") | valStr.equalsIgnoreCase("true");
        if (!val && !valStr.equalsIgnoreCase("no") & !valStr.equalsIgnoreCase("false")) {
            throw new SAXException("invalid boolean attribute value " + name + "=\"" + valStr + "\"");
        }
        return val;
    }

    private Address parseRegisterAddress(Element element, AddressFactory addrFactory) throws SAXException {
        String addrStr = element.getAttributeValue("address");
        String offsetStr = element.getAttributeValue("offset");
        if (addrStr == null && offsetStr == null) {
            throw new SAXException("Missing required " + element.getName() + " 'address' or 'offset' attribute");
        }
        Address addr = null;
        if (addrStr != null) {
            if (offsetStr != null) {
                throw new SAXException(element.getName() + " must not specify both 'address' and 'offset' attribute");
            }
            addr = XmlProgramUtilities.parseAddress(addrFactory, addrStr);
            if (addr == null) {
                throw new SAXException("invalid address attribute value: address=" + addrStr + "\"");
            }
        } else {
            try {
                addr = addrFactory.getRegisterSpace().getAddress(XmlUtilities.parseLong((String)offsetStr));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (addr == null) {
                throw new SAXException("invalid register offset value: offset=" + addrStr + "\"");
            }
        }
        return addr;
    }

    private RegisterManager parseRegisters(Element element, AddressFactory addrFactory) throws SAXException {
        RegisterBuilder regBuilder = new RegisterBuilder();
        List children = element.getChildren();
        for (Element childElement : children) {
            String elementName = childElement.getName();
            if ("context_register".equals(elementName) || "register".equals(elementName)) {
                boolean bigEndian = "context_register".equals(elementName) ? true : this.endian.isBigEndian();
                String name = childElement.getAttributeValue("name");
                if (name == null) {
                    throw new SAXException("Missing required register 'name' attribute");
                }
                Address addr = this.parseRegisterAddress(childElement, addrFactory);
                int bitsize = OldLanguage.parseIntAttribute(childElement, "bitsize");
                AddressSpace space = addr.getAddressSpace();
                regBuilder.addRegister(name, name, addr, (bitsize + 7) / 8, 0, bitsize, bigEndian, 0);
                if (space.isLoadedMemorySpace() && space instanceof GenericAddressSpace) {
                    ((GenericAddressSpace)space).setHasMappedRegisters(true);
                }
                if (!"context_register".equals(elementName)) continue;
                this.parseContextFields(childElement, regBuilder, addr, bitsize);
                continue;
            }
            throw new SAXException("Unsupported registers element '" + elementName + "'");
        }
        return regBuilder.getRegisterManager();
    }

    private void parseContextFields(Element element, RegisterBuilder regBuilder, Address addr, int contextBitLength) throws SAXException {
        List children = element.getChildren();
        for (Element childElement : children) {
            String elementName = childElement.getName();
            if (!"field".equals(childElement.getName())) {
                throw new SAXException("Unsupported context_register element '" + elementName + "'");
            }
            String name = childElement.getAttributeValue("name");
            if (name == null) {
                throw new SAXException("Missing required field 'name' attribute");
            }
            String range = childElement.getAttributeValue("range");
            if (range == null) {
                throw new SAXException("Missing required field 'range' attribute");
            }
            int lsb = -1;
            int msb = -1;
            try {
                String[] splitRange = range.split(",");
                lsb = Integer.parseInt(splitRange[0]);
                msb = Integer.parseInt(splitRange[1]);
                int fieldBitLength = msb - lsb + 1;
                lsb = contextBitLength - msb - 1;
                msb = lsb + fieldBitLength - 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            regBuilder.addRegister(name, name, addr, (contextBitLength + 7) / 8, lsb, msb - lsb + 1, true, 8);
        }
    }

    private AddressFactory parseAddressSpaces(Element element) throws SAXException {
        SegmentedAddressSpace defaultSpace = null;
        ArrayList<SegmentedAddressSpace> list = new ArrayList<SegmentedAddressSpace>();
        List children = element.getChildren();
        Iterator iter = children.iterator();
        int unique = 0;
        while (iter.hasNext()) {
            GenericAddressSpace space;
            Element childElement = (Element)iter.next();
            String elementName = childElement.getName();
            if (!"space".equals(elementName) && !"segmented_space".equals(elementName)) {
                throw new SAXException("Unsupported spaces element '" + elementName + "'");
            }
            String name = childElement.getAttributeValue("name");
            if (name == null) {
                throw new SAXException("Missing required space 'name' attribute");
            }
            String valStr = childElement.getAttributeValue("unique");
            if (valStr != null) {
                try {
                    unique = XmlUtilities.parseInt((String)valStr);
                }
                catch (NumberFormatException e) {
                    throw new SAXException("bad attribute value unique=\"" + valStr + "\"");
                }
            }
            if ("segmented_space".equals(elementName)) {
                space = new SegmentedAddressSpace(name, unique);
            } else {
                int type;
                String typeStr = childElement.getAttributeValue("type");
                if (typeStr == null) {
                    throw new SAXException("Missing required space 'type' attribute");
                }
                if ("ram".equalsIgnoreCase(typeStr)) {
                    type = 1;
                } else if ("code".equalsIgnoreCase(typeStr)) {
                    type = 2;
                } else if ("register".equalsIgnoreCase(typeStr)) {
                    type = 4;
                } else {
                    throw new SAXException("unsupported space type: " + typeStr);
                }
                int size = OldLanguage.parseIntAttribute(childElement, "size");
                int wordsize = 1;
                if (childElement.getAttribute("wordsize") != null) {
                    wordsize = OldLanguage.parseIntAttribute(childElement, "wordsize");
                }
                space = new GenericAddressSpace(name, 8 * size, wordsize, type, unique);
            }
            list.add((SegmentedAddressSpace)space);
            boolean isDefault = this.parseBooleanAttribute(childElement, "default", Boolean.FALSE);
            if (isDefault) {
                if (defaultSpace != null) {
                    throw new SAXException("only one default space may be specified");
                }
                defaultSpace = space;
            }
            ++unique;
        }
        if (defaultSpace == null) {
            throw new SAXException("default address space not specified");
        }
        AddressSpace[] spaces = new AddressSpace[list.size()];
        list.toArray(spaces);
        return new DefaultAddressFactory(spaces, defaultSpace);
    }

    private LanguageDescription parseDescription(Element element, int version) throws SAXException {
        LanguageID id = null;
        Processor processor = null;
        int size = 0;
        String variant = null;
        CompilerSpecID compilerSpecID = null;
        List children = element.getChildren();
        for (Element childElement : children) {
            String elementName = childElement.getName();
            String text = childElement.getText().trim();
            if (elementName.equals("name")) {
                LanguageCompilerSpecPair pair = OldLanguageMappingService.lookupMagicString(text, false);
                if (pair != null) {
                    id = pair.languageID;
                    compilerSpecID = pair.compilerSpecID;
                    continue;
                }
                throw new SAXException("Failed to map old language name: " + text);
            }
            if (elementName.equals("id")) {
                id = new LanguageID(text);
                continue;
            }
            if (elementName.equals("processor")) {
                processor = Processor.findOrPossiblyCreateProcessor(text);
                continue;
            }
            if (elementName.equals("variant")) {
                variant = text;
                continue;
            }
            if (!elementName.equals("size")) continue;
            try {
                size = Integer.parseInt(text);
            }
            catch (NumberFormatException e) {
                throw new SAXException(e);
            }
        }
        if (id == null) {
            throw new SAXException("Missing required description 'id' or 'name' element");
        }
        ArrayList<CompilerSpecDescription> complierSpecList = new ArrayList<CompilerSpecDescription>();
        if (compilerSpecID != null) {
            complierSpecList.add(new BasicCompilerSpecDescription(compilerSpecID, compilerSpecID.getIdAsString()));
        }
        return new BasicLanguageDescription(id, processor, this.endian, this.endian, size, variant, "", version, 0, true, complierSpecList, null);
    }

    public CompilerSpecID getOldCompilerSpecID() {
        Collection<CompilerSpecDescription> compatibleCompilerSpecDescriptions = this.langDescription.getCompatibleCompilerSpecDescriptions();
        if (!compatibleCompilerSpecDescriptions.isEmpty()) {
            return compatibleCompilerSpecDescriptions.iterator().next().getCompilerSpecID();
        }
        return null;
    }

    @Override
    public List<AddressLabelInfo> getDefaultLabels() {
        throw new UnsupportedOperationException("Language for upgrade use only (getDefaultLabels)");
    }

    @Override
    public Register getProgramCounter() {
        throw new UnsupportedOperationException("Language for upgrade use only (getProgramCounter)");
    }

    @Override
    public int getNumberOfUserDefinedOpNames() {
        throw new UnsupportedOperationException("Language for upgrade use only (getNumberOfUserDefinedOpNames)");
    }

    @Override
    public String getUserDefinedOpName(int index) {
        throw new UnsupportedOperationException("Language for upgrade use only (getUserDefinedOpName)");
    }

    @Override
    public boolean isVolatile(Address addr) {
        throw new UnsupportedOperationException("Language for upgrade use only (isVolatile)");
    }

    @Override
    public void applyContextSettings(DefaultProgramContext ctx) {
    }

    @Override
    public List<CompilerSpecDescription> getCompatibleCompilerSpecDescriptions() {
        return new ArrayList<CompilerSpecDescription>(this.associatedCompilerSpecs);
    }

    @Override
    public CompilerSpec getDefaultCompilerSpec() {
        throw new UnsupportedOperationException("Language for upgrade use only (getDefaultCompilerSpec)");
    }

    @Override
    public CompilerSpec getCompilerSpecByID(CompilerSpecID compilerSpecID) throws CompilerSpecNotFoundException {
        throw new UnsupportedOperationException("Language for upgrade use only (getCompilerSpecByID)");
    }

    @Override
    public MemoryBlockDefinition[] getDefaultMemoryBlocks() {
        throw new UnsupportedOperationException("Language for upgrade use only (getDefaultMemoryBlocks)");
    }

    @Override
    public List<AddressLabelInfo> getDefaultSymbols() {
        throw new UnsupportedOperationException("Language for upgrade use only (getDefaultSymbols)");
    }

    @Override
    public LanguageDescription getLanguageDescription() {
        return this.langDescription;
    }

    @Override
    public Processor getProcessor() {
        return this.langDescription.getProcessor();
    }

    @Override
    public String getSegmentedSpace() {
        throw new UnsupportedOperationException("Language for upgrade use only (getSegmentedSpace)");
    }

    @Override
    public AddressSetView getVolatileAddresses() {
        throw new UnsupportedOperationException("Language for upgrade use only (getVolatileAddresses)");
    }

    @Override
    public void reloadLanguage(TaskMonitor taskMonitor) {
        throw new UnsupportedOperationException("Language for upgrade use only (reloadLanguage)");
    }

    public int getAddressShiftAmount() {
        throw new UnsupportedOperationException("Language for upgrade use only (getAddressShiftAmount)");
    }

    @Override
    public String getProperty(String key) {
        return null;
    }

    @Override
    public Set<String> getPropertyKeys() {
        return EMPTY_SET;
    }

    @Override
    public String getProperty(String key, String defaultString) {
        return defaultString;
    }

    @Override
    public boolean getPropertyAsBoolean(String key, boolean defaultBoolean) {
        return defaultBoolean;
    }

    @Override
    public int getPropertyAsInt(String key, int defaultInt) {
        return defaultInt;
    }

    @Override
    public boolean hasProperty(String key) {
        return false;
    }

    @Override
    public ManualEntry getManualEntry(String instructionMnemonic) {
        return null;
    }

    @Override
    public Set<String> getManualInstructionMnemonicKeys() {
        return EMPTY_SET;
    }

    @Override
    public boolean hasManual() {
        return false;
    }

    @Override
    public AddressSpace getDefaultDataSpace() {
        return this.addressFactory.getDefaultAddressSpace();
    }

    @Override
    public AddressSpace getDefaultSpace() {
        return this.addressFactory.getDefaultAddressSpace();
    }

    @Override
    public Exception getManualException() {
        return null;
    }

    @Override
    public Register[] getSortedVectorRegisters() {
        throw new UnsupportedOperationException("Language for upgrade use only (getSortedVectorRegisters)");
    }
}

