/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DialogComponentProvider;
import docking.ToolTipManager;
import docking.options.editor.ButtonPanelFactory;
import docking.widgets.filechooser.GhidraFileChooser;
import ghidra.framework.main.BrowsePathPanel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.filechooser.ExtensionFileFilter;
import ghidra.util.filechooser.GhidraFileFilter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class EditPluginPathDialog
extends DialogComponentProvider {
    private static final int SIDE_MARGIN = 5;
    private static final Color INVALID_PATH_COLOR = Color.red.brighter();
    private static final Color INVALID_SELECTED_PATH_COLOR = Color.pink;
    private static final Color STATUS_MESSAGE_COLOR = Color.blue.brighter();
    static final String EMPTY_STATUS = " ";
    private ExtensionFileFilter JAR_FILTER = new ExtensionFileFilter(new String[]{"jar", "zip"}, "Plugin Jar Files");
    private static final byte UP = 0;
    private static final byte DOWN = 1;
    private static final byte REMOVE = 2;
    private DefaultListModel<String> listModel;
    private boolean pluginPathsChanged = false;
    private JScrollPane scrollPane;
    private JList<String> pluginPathsList;
    private BrowsePathPanel jarPathPanel;
    private GhidraFileChooser fileChooser;
    private JButton upButton;
    private JButton downButton;
    private JButton removeButton;
    private List<String> selectedInList;
    private JLabel statusMessage;
    private JPanel mainPanel;
    private String errorMsg;

    EditPluginPathDialog() {
        super("Edit Plugin Path", true, false, true, false);
        this.setHelpLocation(new HelpLocation("FrontEndPlugin", "Edit_Plugin_Path"));
        this.addWorkPanel(this.buildMainPanel());
        this.addOKButton();
        this.addApplyButton();
        this.addCancelButton();
        this.pluginPathsList.setModel(this.listModel);
    }

    protected JPanel buildMainPanel() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
        this.listModel = new DefaultListModel();
        this.setPluginPathsListData(Preferences.getPluginPaths());
        JPanel statusMessagePanel = new JPanel();
        this.statusMessage = new JLabel("Ready to set User Plugin Paths");
        this.statusMessage.setName("statusLabel");
        this.statusMessage.setForeground(STATUS_MESSAGE_COLOR);
        statusMessagePanel.add(this.statusMessage);
        this.mainPanel.add(this.buildPluginPathsPanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.mainPanel.add(this.buildJarDirectoryPanel());
        this.mainPanel.add(Box.createVerticalStrut(10));
        this.mainPanel.add(Box.createVerticalGlue());
        this.mainPanel.add(statusMessagePanel);
        this.mainPanel.invalidate();
        this.enableButtons(false);
        this.setApplyEnabled(false);
        return this.mainPanel;
    }

    protected void applyCallback() {
        File jarPath;
        String jarPathname = this.jarPathPanel.getPath();
        if (!(jarPathname.length() <= 0 || (jarPath = new File(jarPathname)).isDirectory() && jarPath.canRead())) {
            this.setStatusMessage("Bad Jar Directory: " + jarPathname);
            this.jarPathPanel.requestFocus();
            return;
        }
        this.handleApply();
    }

    protected void cancelCallback() {
        this.close();
        this.enableButtons(false);
        this.setStatusMessage(EMPTY_STATUS);
        this.setApplyEnabled(false);
        this.errorMsg = null;
    }

    protected void escapeCallback() {
        if (!this.jarPathPanel.hasFocus()) {
            super.escapeCallback();
        }
    }

    protected void okCallback() {
        if (this.isApplyEnabled()) {
            this.applyCallback();
        }
        if (this.errorMsg == null) {
            this.cancelCallback();
        }
    }

    public void show(PluginTool tool) {
        this.setPluginPathsListData(Preferences.getPluginPaths());
        this.initJarDirectory();
        this.setApplyEnabled(false);
        tool.showDialog(this);
    }

    void enableApply() {
        this.setApplyEnabled(this.pluginPathsChanged || this.jarPathPanel.isChanged());
    }

    void initJarDirectory() {
        this.setApplyEnabled(this.pluginPathsChanged);
        this.setStatusMessage(EMPTY_STATUS);
    }

    void setStatusMessage(String msg) {
        if (msg == null || msg.length() == 0) {
            msg = EMPTY_STATUS;
        }
        this.statusMessage.setText(msg);
        this.statusMessage.invalidate();
    }

    protected void setApplyEnabled(boolean state) {
        super.setApplyEnabled(state);
    }

    void addJarCallback() {
        this.setStatusMessage(EMPTY_STATUS);
        if (this.fileChooser == null) {
            this.fileChooser = new GhidraFileChooser((Component)this.getComponent());
            this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        this.fileChooser.setFileSelectionMode(0);
        this.fileChooser.setFileFilter((GhidraFileFilter)this.JAR_FILTER);
        this.fileChooser.setApproveButtonToolTipText("Choose Plugin Jar File");
        this.fileChooser.setApproveButtonText("Add Jar File");
        File dir = this.fileChooser.getSelectedFile();
        if (dir != null) {
            try {
                String dirPath = dir.getCanonicalPath();
                if (!this.listModel.contains(dirPath)) {
                    this.listModel.addElement(dirPath);
                    this.pluginPathsChanged = true;
                    this.setApplyEnabled(true);
                } else {
                    this.setStatusMessage(dirPath + " is already in the list.");
                }
            }
            catch (IOException e) {
                this.setStatusMessage(e.getMessage());
            }
        }
    }

    void addDirCallback() {
        this.setStatusMessage(EMPTY_STATUS);
        if (this.fileChooser == null) {
            this.fileChooser = new GhidraFileChooser((Component)this.getComponent());
            this.fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        }
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setFileFilter(GhidraFileFilter.ALL);
        this.fileChooser.setApproveButtonToolTipText("Choose Directory with Plugin class Files");
        this.fileChooser.setApproveButtonText("Add Directory");
        File dir = this.fileChooser.getSelectedFile();
        if (dir != null) {
            try {
                String dirPath = dir.getCanonicalPath();
                if (!this.listModel.contains(dirPath)) {
                    this.listModel.addElement(dirPath);
                    this.pluginPathsChanged = true;
                    this.setApplyEnabled(true);
                } else {
                    this.setStatusMessage(dirPath + " is already in the list.");
                }
            }
            catch (IOException e) {
                this.setStatusMessage(e.getMessage());
                Msg.error((Object)((Object)this), (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private String[] getUserPluginPaths() {
        Object[] pluginsArray = new String[this.listModel.size()];
        this.listModel.copyInto(pluginsArray);
        return pluginsArray;
    }

    private JPanel buildPluginPathsPanel() {
        this.upButton = ButtonPanelFactory.createButton((int)0);
        this.upButton.setName("UpArrow");
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPluginPathDialog.this.handleSelection((byte)0);
            }
        });
        this.downButton = ButtonPanelFactory.createButton((int)1);
        this.downButton.setName("DownArrow");
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPluginPathDialog.this.handleSelection((byte)1);
            }
        });
        JPanel arrowButtonsPanel = new JPanel(new FlowLayout(0, 10, 10));
        arrowButtonsPanel.add(this.upButton);
        arrowButtonsPanel.add(this.downButton);
        JButton addJarButton = ButtonPanelFactory.createButton((String)"Add Jar...");
        addJarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPluginPathDialog.this.addJarCallback();
            }
        });
        JButton addDirButton = ButtonPanelFactory.createButton((String)"Add Dir...");
        addDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPluginPathDialog.this.addDirCallback();
            }
        });
        this.removeButton = ButtonPanelFactory.createButton((String)"Remove");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPluginPathDialog.this.handleSelection((byte)2);
            }
        });
        Dimension d = addJarButton.getPreferredSize();
        addDirButton.setPreferredSize(d);
        this.removeButton.setPreferredSize(d);
        JPanel otherButtonsPanel = ButtonPanelFactory.createButtonPanel((JButton[])new JButton[]{addJarButton, addDirButton, this.removeButton}, (int)5);
        JPanel listButtonPanel = new JPanel(new BorderLayout(0, 0));
        listButtonPanel.add((Component)arrowButtonsPanel, "North");
        listButtonPanel.add((Component)otherButtonsPanel, "Center");
        JPanel scrollListPanel = new JPanel(new BorderLayout(10, 15));
        this.pluginPathsList = new JList();
        this.pluginPathsList.addListSelectionListener(new PathListSelectionListener());
        this.pluginPathsList.setSelectionMode(2);
        this.pluginPathsList.setCellRenderer(new PluginPathRenderer());
        this.scrollPane = new JScrollPane(this.pluginPathsList);
        this.scrollPane.setPreferredSize(new Dimension(250, 150));
        scrollListPanel.add((Component)this.scrollPane, "Center");
        JPanel pluginPathListPanel = new JPanel(new BorderLayout(0, 0));
        pluginPathListPanel.add((Component)scrollListPanel, "Center");
        pluginPathListPanel.add((Component)listButtonPanel, "East");
        pluginPathListPanel.setBorder(new TitledBorder("User Plugin Paths"));
        ToolTipManager.setToolTipText((JComponent)this.upButton, (String)"Changes the order of search for plugins");
        ToolTipManager.setToolTipText((JComponent)this.downButton, (String)"Changes the order of search for plugins");
        pluginPathListPanel.validate();
        return pluginPathListPanel;
    }

    private JPanel buildJarDirectoryPanel() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditPluginPathDialog.this.jarPathPanel.showFileChooser();
                EditPluginPathDialog.this.enableApply();
            }
        };
        this.jarPathPanel = new BrowsePathPanel(this, listener, "UserPluginJarDirectory");
        this.jarPathPanel.setText(Preferences.getProperty((String)"UserPluginJarDirectory"));
        this.jarPathPanel.setBorder(new TitledBorder("User Plugin Jar Directory"));
        return this.jarPathPanel;
    }

    private void enableButtons(boolean enabled) {
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
    }

    private void handleApply() {
        String[] userPluginPaths = this.getUserPluginPaths();
        Preferences.setPluginPaths((String[])userPluginPaths);
        String jarDirectoryName = this.jarPathPanel.getPath();
        if (jarDirectoryName.trim().length() == 0) {
            jarDirectoryName = null;
        }
        Preferences.setProperty((String)"UserPluginJarDirectory", (String)jarDirectoryName);
        this.errorMsg = null;
        if (Preferences.store()) {
            this.setStatusMessage("Saved plugin paths successfully!");
            this.setApplyEnabled(false);
            this.jarPathPanel.setChanged(false);
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)this.rootPanel, (String)"Restart Ghidra", (Object)"You must restart Ghidra in order\nfor path changes to take effect.");
        } else {
            this.setStatusMessage("");
            Msg.showError((Object)((Object)this), (Component)this.rootPanel, (String)"Error Saving Plugin Paths", (Object)"Failed to update user preferences (see log for details)");
        }
    }

    private void handleSelection(byte whichAction) {
        if (this.selectedInList == null) {
            this.enableButtons(false);
            return;
        }
        if (whichAction == 2) {
            ArrayList<String> tempList = new ArrayList<String>(this.selectedInList);
            for (String pathName : tempList) {
                int index = this.listModel.indexOf(pathName);
                if (index < 0) continue;
                this.listModel.remove(index);
            }
        } else {
            int newIndex = -1;
            int selIndex = this.pluginPathsList.getSelectedIndex();
            int size = this.listModel.size();
            String path = this.listModel.remove(selIndex);
            if (selIndex == 0) {
                if (whichAction == 0) {
                    this.listModel.add(this.listModel.size(), path);
                    newIndex = size - 1;
                } else {
                    this.listModel.add(1, path);
                    newIndex = 1;
                }
            } else if (whichAction == 0) {
                this.listModel.add(selIndex - 1, path);
                newIndex = selIndex - 1;
            } else if (selIndex == size - 1) {
                this.listModel.add(0, path);
                newIndex = 0;
            } else {
                this.listModel.add(selIndex + 1, path);
                newIndex = selIndex + 1;
            }
            if (newIndex >= 0) {
                this.pluginPathsList.setSelectedIndex(newIndex);
            }
        }
        this.setApplyEnabled(true);
        if (whichAction == 2) {
            this.enableButtons(false);
        }
    }

    private void setPluginPathsListData(String[] pluginPathNames) {
        this.listModel.clear();
        for (int p = 0; p < pluginPathNames.length; ++p) {
            this.listModel.addElement(pluginPathNames[p]);
        }
    }

    private class PathListSelectionListener
    implements ListSelectionListener {
        private PathListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String path;
            if (e.getValueIsAdjusting()) {
                return;
            }
            EditPluginPathDialog.this.selectedInList = null;
            EditPluginPathDialog.this.enableButtons(false);
            List<String> selectedValues = EditPluginPathDialog.this.pluginPathsList.getSelectedValuesList();
            if (selectedValues.isEmpty() && (path = EditPluginPathDialog.this.pluginPathsList.getSelectedValue()) != null) {
                selectedValues = Collections.singletonList(path);
            }
            EditPluginPathDialog.this.removeButton.setEnabled(false);
            if (selectedValues != null) {
                int numSelected = selectedValues.size();
                EditPluginPathDialog.this.selectedInList = new ArrayList<String>(selectedValues);
                if (numSelected == 1) {
                    if (EditPluginPathDialog.this.listModel.size() > 1) {
                        EditPluginPathDialog.this.enableButtons(true);
                    } else {
                        EditPluginPathDialog.this.removeButton.setEnabled(true);
                    }
                } else if (numSelected > 0) {
                    EditPluginPathDialog.this.removeButton.setEnabled(true);
                }
            }
        }
    }

    private class PluginPathRenderer
    extends JLabel
    implements ListCellRenderer<String> {
        public PluginPathRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value, int index, boolean isSelected, boolean cellHasFocus) {
            String pathName = EditPluginPathDialog.this.listModel.get(index);
            this.setText(pathName);
            this.setFont(list.getFont());
            boolean pathOK = new File(pathName).canRead();
            if (isSelected) {
                if (!pathOK) {
                    this.setForeground(INVALID_SELECTED_PATH_COLOR);
                } else {
                    this.setForeground(list.getSelectionForeground());
                }
                this.setBackground(list.getSelectionBackground());
            } else {
                if (!pathOK) {
                    this.setForeground(INVALID_PATH_COLOR);
                } else {
                    this.setForeground(list.getForeground());
                }
                this.setBackground(list.getBackground());
            }
            return this;
        }
    }
}

