/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main;

import docking.DockingUtils;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.ToolButton;
import ghidra.framework.model.Tool;
import ghidra.framework.model.ToolTemplate;
import ghidra.framework.model.Workspace;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolBar;

class RunningToolsPanel
extends JPanel {
    private JToolBar runningToolbar;
    private FrontEndPlugin plugin;
    private Map<Tool, ToolButton> runningTools;

    RunningToolsPanel(FrontEndPlugin plugin, Workspace ws) {
        super(new BorderLayout(0, 0));
        this.plugin = plugin;
        this.runningToolbar = new JToolBar(0){

            @Override
            public boolean isFloatable() {
                return false;
            }

            @Override
            public boolean isBorderPainted() {
                return false;
            }
        };
        DockingUtils.setTransparent((JComponent)this.runningToolbar);
        this.add((Component)this.runningToolbar, "Center");
        this.runningTools = new HashMap<Tool, ToolButton>(3);
        if (ws != null) {
            Tool[] tools;
            for (Tool element : tools = ws.getTools()) {
                this.addTool(element);
            }
        }
        this.validate();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.runningToolbar.getPreferredSize();
    }

    void addTool(Tool runningTool) {
        ToolButton toolButton = new ToolButton(this.plugin, runningTool, runningTool.getToolTemplate(true));
        this.runningToolbar.add((Component)((Object)toolButton));
        this.runningTools.put(runningTool, toolButton);
        this.runningToolbar.invalidate();
        this.validate();
        this.repaint();
    }

    void removeTool(Tool tool) {
        ToolButton button = this.runningTools.get(tool);
        if (button == null) {
            return;
        }
        this.runningToolbar.remove((Component)((Object)button));
        this.runningTools.remove(tool);
        this.runningToolbar.invalidate();
        button.dispose();
        this.validate();
        this.repaint();
    }

    void toolNameChanged(Tool changedTool) {
    }

    void updateToolButton(Tool tool, ToolTemplate template, Icon icon) {
        ToolButton button = this.runningTools.get(tool);
        if (button != null) {
            button.setToolTemplate(template, icon);
        }
        this.validate();
        this.repaint();
    }
}

