/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex;

import com.googlecode.d2j.dex.ClassVisitorFactory;
import com.googlecode.d2j.dex.DexExceptionHandler;
import com.googlecode.d2j.dex.ExDex2Asm;
import com.googlecode.d2j.node.DexFileNode;
import com.googlecode.d2j.reader.DexFileReader;
import com.googlecode.d2j.visitors.DexFileVisitor;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.dex.DexToJarExceptionHandler;
import ghidra.file.formats.android.dex.format.DexConstants;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FileCacheEntry;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileImpl;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.formats.gfilesystem.GFileSystemBase;
import ghidra.formats.gfilesystem.annotations.FileSystemInfo;
import ghidra.formats.gfilesystem.factory.GFileSystemBaseFactory;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.CryptoException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FilenameUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import utilities.util.FileUtilities;

@FileSystemInfo(type="dex2jar", description="Android DEX to JAR", factory=GFileSystemBaseFactory.class)
public class DexToJarFileSystem
extends GFileSystemBase {
    private GFileImpl jarFile;

    public DexToJarFileSystem(String fileSystemName, ByteProvider provider) {
        super(fileSystemName, provider);
    }

    public GFile getJarFile() {
        return this.jarFile;
    }

    protected InputStream getData(GFile file, TaskMonitor monitor) throws IOException, CancelledException, CryptoException {
        if (file.equals(this.jarFile)) {
            FileCacheEntry jarFileInfo = this.getJarFile(monitor);
            return new FileInputStream(jarFileInfo.file);
        }
        return null;
    }

    public List<GFile> getListing(GFile directory) throws IOException {
        return directory == null || directory.equals(this.root) ? Arrays.asList(this.jarFile) : Collections.emptyList();
    }

    public boolean isValid(TaskMonitor monitor) throws IOException {
        return DexConstants.isDexFile(this.provider);
    }

    private FileCacheEntry getJarFile(TaskMonitor monitor) throws CancelledException, IOException {
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor, 1L);
        upwtm.setMessage("Converting DEX to JAR...");
        FSRLRoot targetFSRL = this.getFSRL();
        FSRL containerFSRL = targetFSRL.getContainer();
        File containerFile = this.fsService.getFile(containerFSRL, monitor);
        FileCacheEntry derivedFileInfo = this.fsService.getDerivedFilePush(containerFSRL, "dex2jar", arg_0 -> this.lambda$getJarFile$1(containerFile, (TaskMonitor)upwtm, arg_0), monitor);
        return derivedFileInfo;
    }

    public void open(TaskMonitor monitor) throws CancelledException, IOException {
        FileCacheEntry jarFileInfo = this.getJarFile(monitor);
        FSRLRoot targetFSRL = this.getFSRL();
        FSRL containerFSRL = targetFSRL.getContainer();
        String baseName = FilenameUtils.removeExtension((String)containerFSRL.getName());
        String jarName = baseName + ".jar";
        FSRL jarFSRL = targetFSRL.withPathMD5(jarName, jarFileInfo.md5);
        this.jarFile = GFileImpl.fromFilename((GFileSystem)this, (GFile)this.root, (String)(baseName + ".jar"), (boolean)false, (long)jarFileInfo.file.length(), (FSRL)jarFSRL);
    }

    public void close() throws IOException {
        super.close();
    }

    public String getInfo(GFile file, TaskMonitor monitor) throws IOException {
        return null;
    }

    private /* synthetic */ void lambda$getJarFile$1(File containerFile, final TaskMonitor upwtm, OutputStream os) throws IOException, CancelledException {
        try (final ZipOutputStream outputStream = new ZipOutputStream(os);){
            final DexToJarExceptionHandler exceptionHandler = new DexToJarExceptionHandler();
            DexFileReader reader = new DexFileReader(FileUtilities.getBytesFromFile((File)containerFile));
            DexFileNode fileNode = new DexFileNode();
            try {
                reader.accept((DexFileVisitor)fileNode, 32);
            }
            catch (Exception ex) {
                exceptionHandler.handleFileException(ex);
            }
            DexFileVisitor visitor = new DexFileVisitor();
            reader.accept(visitor);
            ClassVisitorFactory classVisitorFactory = name -> new ClassVisitor(262144, (ClassVisitor)new ClassWriter(1)){

                public void visitEnd() {
                    byte[] data;
                    super.visitEnd();
                    ClassWriter cw = (ClassWriter)this.cv;
                    try {
                        data = cw.toByteArray();
                    }
                    catch (Exception ex) {
                        Msg.warn((Object)((Object)this), (Object)String.format("ASM fail to generate .class file: %s", name));
                        exceptionHandler.handleFileException(ex);
                        return;
                    }
                    try {
                        ZipEntry entry = new ZipEntry(name + ".class");
                        outputStream.putNextEntry(entry);
                        outputStream.write(data);
                        outputStream.closeEntry();
                        upwtm.incrementProgress(1L);
                    }
                    catch (IOException e) {
                        Msg.warn((Object)((Object)this), (Object)e);
                    }
                }
            };
            ExDex2Asm exDex2Asm = new ExDex2Asm((DexExceptionHandler)exceptionHandler);
            exDex2Asm.convertDex(fileNode, classVisitorFactory);
            if (exceptionHandler.getFileException() != null) {
                throw new IOException(exceptionHandler.getFileException());
            }
            outputStream.finish();
        }
    }
}

