/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.android.dex.format.AccessFlags;
import ghidra.file.formats.android.dex.format.AnnotationsDirectoryItem;
import ghidra.file.formats.android.dex.format.ClassDataItem;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.EncodedArrayItem;
import ghidra.file.formats.android.dex.format.TypeItem;
import ghidra.file.formats.android.dex.format.TypeList;
import ghidra.file.formats.android.dex.util.DexUtil;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class ClassDefItem
implements StructConverter {
    private int classIndex;
    private int accessFlags;
    private int superClassIndex;
    private int interfacesOffset;
    private int sourceFileIndex;
    private int annotationsOffset;
    private int classDataOffset;
    private int staticValuesOffset;
    private TypeList _interfaces;
    private AnnotationsDirectoryItem _annotationsDirectoryItem;
    private ClassDataItem _classDataItem;
    private EncodedArrayItem _staticValues;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassDefItem(BinaryReader reader) throws IOException {
        long oldIndex;
        this.classIndex = reader.readNextInt();
        this.accessFlags = reader.readNextInt();
        this.superClassIndex = reader.readNextInt();
        this.interfacesOffset = reader.readNextInt();
        this.sourceFileIndex = reader.readNextInt();
        this.annotationsOffset = reader.readNextInt();
        this.classDataOffset = reader.readNextInt();
        this.staticValuesOffset = reader.readNextInt();
        if (this.interfacesOffset > 0) {
            oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(this.interfacesOffset);
                this._interfaces = new TypeList(reader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
        if (this.annotationsOffset > 0) {
            oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(this.annotationsOffset);
                this._annotationsDirectoryItem = new AnnotationsDirectoryItem(reader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
        if (this.classDataOffset > 0) {
            oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(this.classDataOffset);
                this._classDataItem = new ClassDataItem(reader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
        if (this.staticValuesOffset > 0) {
            oldIndex = reader.getPointerIndex();
            try {
                reader.setPointerIndex(this.staticValuesOffset);
                this._staticValues = new EncodedArrayItem(reader);
            }
            finally {
                reader.setPointerIndex(oldIndex);
            }
        }
    }

    public int getClassIndex() {
        return this.classIndex;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getSuperClassIndex() {
        return this.superClassIndex;
    }

    public int getInterfacesOffset() {
        return this.interfacesOffset;
    }

    public int getSourceFileIndex() {
        return this.sourceFileIndex;
    }

    public int getAnnotationsOffset() {
        return this.annotationsOffset;
    }

    public int getClassDataOffset() {
        return this.classDataOffset;
    }

    public int getStaticValuesOffset() {
        return this.staticValuesOffset;
    }

    public TypeList getInterfaces() {
        return this._interfaces;
    }

    public AnnotationsDirectoryItem getAnnotationsDirectoryItem() {
        return this._annotationsDirectoryItem;
    }

    public ClassDataItem getClassDataItem() {
        return this._classDataItem;
    }

    public EncodedArrayItem getStaticValues() {
        return this._staticValues;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dataType = StructConverterUtil.toDataType(ClassDefItem.class);
        dataType.setCategoryPath(new CategoryPath("/dex"));
        return dataType;
    }

    public String toString(DexHeader header, int index, TaskMonitor monitor) throws CancelledException {
        StringBuilder builder = new StringBuilder();
        if (index != -1) {
            builder.append("Class Index: 0x" + Integer.toHexString(index) + "\n");
        }
        builder.append("Class: " + DexUtil.convertTypeIndexToString(header, this.getClassIndex()) + "\n");
        builder.append("Class Access Flags:\n" + AccessFlags.toString(this.getAccessFlags()) + "\n");
        builder.append("Superclass: " + DexUtil.convertTypeIndexToString(header, this.getSuperClassIndex()) + "\n");
        if (this.getInterfacesOffset() > 0) {
            builder.append("Interfaces: \n");
            TypeList interfaces = this.getInterfaces();
            for (TypeItem type : interfaces.getItems()) {
                monitor.checkCanceled();
                builder.append("\t" + DexUtil.convertTypeIndexToString(header, type.getType()) + "\n");
            }
        }
        if (this.getSourceFileIndex() > 0) {
            builder.append("Source File: " + DexUtil.convertToString(header, this.getSourceFileIndex()) + "\n");
        }
        return builder.toString();
    }
}

