/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.ios.dyldcache;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class DyldCacheData
implements StructConverter {
    private long libraryOffset;
    private long unknown0;
    private long unknown1;
    private long fileOffset;
    private String _path;

    public DyldCacheData(BinaryReader reader) throws IOException {
        this.libraryOffset = reader.readNextLong();
        this.unknown0 = reader.readNextLong();
        this.unknown1 = reader.readNextLong();
        this.fileOffset = reader.readNextLong();
        this._path = reader.readAsciiString(this.fileOffset);
    }

    public long getLibraryOffset() {
        return this.libraryOffset;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public long getUnknown(int index) {
        switch (index) {
            case 0: {
                return this.unknown0;
            }
            case 1: {
                return this.unknown1;
            }
        }
        return -1L;
    }

    public String getPath() {
        return this._path;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        return StructConverterUtil.toDataType((Object)this);
    }
}

