/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlTreeNode;

final class PdbMember {
    final String memberName;
    final String memberDataTypeName;
    final int memberOffset;
    final String memberKind;
    final int memberLength;

    PdbMember(XmlTreeNode node, TaskMonitor monitor) {
        this(node.getStartElement(), monitor);
    }

    PdbMember(XmlElement element, TaskMonitor monitor) {
        this.memberName = SymbolUtilities.replaceInvalidChars((String)element.getAttribute("name"), (boolean)false);
        this.memberDataTypeName = element.getAttribute("datatype");
        this.memberOffset = XmlUtilities.parseInt((String)element.getAttribute("offset"));
        this.memberKind = element.getAttribute("kind");
        this.memberLength = XmlUtilities.parseInt((String)element.getAttribute("length"));
    }
}

