/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import docking.widgets.fieldpanel.Layout;
import docking.widgets.fieldpanel.LayoutModel;
import docking.widgets.fieldpanel.field.EmptyTextField;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.listener.LayoutModelListener;
import docking.widgets.fieldpanel.support.SingleRowLayout;
import ghidra.app.plugin.core.byteviewer.FieldFactory;
import ghidra.app.plugin.core.byteviewer.IndexMap;
import ghidra.app.plugin.core.format.DataFormatModel;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

class ByteViewerLayoutModel
implements LayoutModel {
    private int width;
    private IndexMap indexMap;
    private List<LayoutModelListener> listeners;
    private FieldFactory[] factorys = new FieldFactory[0];
    private BigInteger numIndexes;

    ByteViewerLayoutModel() {
        this.listeners = new ArrayList<LayoutModelListener>(1);
        this.numIndexes = BigInteger.ZERO;
    }

    void dispose() {
        this.indexMap = null;
        this.listeners = null;
        this.factorys = null;
    }

    void setFactorys(FieldFactory[] fieldFactorys, DataFormatModel dataModel, int margin) {
        this.factorys = new FieldFactory[fieldFactorys.length];
        int x = margin;
        int defaultGroupSizeSpace = 1;
        for (int i = 0; i < this.factorys.length; ++i) {
            this.factorys[i] = fieldFactorys[i];
            this.factorys[i].setStartX(x);
            x += this.factorys[i].getWidth();
            if ((i + 1) % defaultGroupSizeSpace != 0) continue;
            x += margin * dataModel.getUnitDelimiterSize();
        }
        this.width = x - margin * dataModel.getUnitDelimiterSize() + margin;
        this.layoutChanged();
    }

    void setIndexMap(IndexMap indexMap) {
        if (indexMap == this.indexMap) {
            return;
        }
        this.indexMap = indexMap;
        this.numIndexes = indexMap == null ? BigInteger.ZERO : indexMap.getNumIndexes();
        this.indexSetChanged();
    }

    public void indexSetChanged() {
        for (LayoutModelListener listener : this.listeners) {
            listener.modelSizeChanged();
        }
    }

    public void layoutChanged() {
        for (LayoutModelListener listener : this.listeners) {
            listener.dataChanged(BigInteger.ZERO, this.numIndexes);
        }
    }

    public void dataChanged(BigInteger startIndex, BigInteger endIndex) {
        for (LayoutModelListener listener : this.listeners) {
            listener.dataChanged(startIndex, endIndex);
        }
    }

    public boolean isUniform() {
        return true;
    }

    public Dimension getPreferredViewSize() {
        return new Dimension(this.width, 500);
    }

    public BigInteger getNumIndexes() {
        return this.numIndexes;
    }

    public Layout getLayout(BigInteger index) {
        if (index.compareTo(this.numIndexes) >= 0) {
            return null;
        }
        ArrayList<Object> fields = new ArrayList<Object>(8);
        for (int i = 0; i < this.factorys.length; ++i) {
            Field field = this.factorys[i].getField(index);
            if (field == null) continue;
            fields.add(field);
        }
        if (fields.size() == 0) {
            if (this.factorys.length > 0) {
                FontMetrics fm = this.factorys[0].getMetrics();
                int height = fm.getMaxAscent() + fm.getMaxDescent();
                fields.add(new EmptyTextField(height, this.factorys[0].getStartX(), 0, this.factorys[0].getWidth()));
            } else {
                fields.add(new EmptyTextField(20, 0, 0, 10));
            }
        }
        Field[] fieldArray = new Field[fields.size()];
        fields.toArray(fieldArray);
        return new SingleRowLayout(fieldArray);
    }

    public void removeLayoutModelListener(LayoutModelListener listener) {
        this.listeners.remove(listener);
    }

    public void addLayoutModelListener(LayoutModelListener listener) {
        this.listeners.add(listener);
    }

    public int getIndexAfter(int index) {
        return index + 1;
    }

    public BigInteger getIndexAfter(BigInteger index) {
        BigInteger nextIndex = index.add(BigInteger.ONE);
        if (nextIndex.compareTo(this.numIndexes) >= 0) {
            return null;
        }
        return nextIndex;
    }

    public BigInteger getIndexBefore(BigInteger index) {
        if (index.compareTo(this.numIndexes) > 0) {
            return this.numIndexes.subtract(BigInteger.ONE);
        }
        BigInteger previousIndex = index.subtract(BigInteger.ONE);
        if (previousIndex.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        return previousIndex;
    }

    public void flushChanges() {
    }
}

