/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.nodetype;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import org.apache.jackrabbit.core.nodetype.BooleanConstraint;
import org.apache.jackrabbit.core.nodetype.DateConstraint;
import org.apache.jackrabbit.core.nodetype.InvalidConstraintException;
import org.apache.jackrabbit.core.nodetype.NameConstraint;
import org.apache.jackrabbit.core.nodetype.NumericConstraint;
import org.apache.jackrabbit.core.nodetype.PathConstraint;
import org.apache.jackrabbit.core.nodetype.ReferenceConstraint;
import org.apache.jackrabbit.core.nodetype.StringConstraint;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValueConstraint {
    protected static Logger log = LoggerFactory.getLogger((Class)ValueConstraint.class);
    public static final ValueConstraint[] EMPTY_ARRAY = new ValueConstraint[0];
    final String definition;

    protected ValueConstraint(String definition) {
        this.definition = definition;
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getDefinition(NamePathResolver resolver) {
        return this.definition;
    }

    public static ValueConstraint create(int type, String definition, NamePathResolver resolver) throws InvalidConstraintException {
        if (definition == null) {
            throw new IllegalArgumentException("illegal definition (null)");
        }
        switch (type) {
            case 1: {
                return new StringConstraint(definition);
            }
            case 6: {
                return new BooleanConstraint(definition);
            }
            case 2: {
                return new NumericConstraint(definition);
            }
            case 5: {
                return new DateConstraint(definition);
            }
            case 3: 
            case 4: {
                return new NumericConstraint(definition);
            }
            case 7: {
                return new NameConstraint(definition, resolver);
            }
            case 8: {
                return new PathConstraint(definition, resolver);
            }
            case 9: {
                return new ReferenceConstraint(definition, resolver);
            }
        }
        throw new IllegalArgumentException("unknown/unsupported target type for constraint: " + PropertyType.nameFromValue((int)type));
    }

    abstract void check(InternalValue var1) throws ConstraintViolationException, RepositoryException;

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ValueConstraint) {
            return this.definition.equals(((ValueConstraint)other).definition);
        }
        return false;
    }

    public int hashCode() {
        return this.definition.hashCode();
    }
}

