/*
 * Decompiled with CFR 0.152.
 */
package ghidra.server;

import ghidra.framework.store.local.LocalFileSystem;
import ghidra.server.Repository;
import ghidra.server.RepositoryManager;
import ghidra.server.UserManager;
import ghidra.util.exception.DuplicateNameException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UserAdmin {
    static final Logger log = LogManager.getLogger(UserAdmin.class);
    static final String ADD_USER_COMMAND = "-add";
    static final String REMOVE_USER_COMMAND = "-remove";
    static final String RESET_USER_COMMAND = "-reset";
    static final String SET_USER_DN_COMMAND = "-dn";
    static final String SET_ADMIN_COMMAND = "-admin";
    static final String ADMIN_CMD_DIR = LocalFileSystem.HIDDEN_DIR_PREFIX + "admin";
    static final String COMMAND_FILE_EXT = ".cmd";
    static final FileFilter CMD_FILE_FILTER = f -> f.isFile() && f.getName().endsWith(COMMAND_FILE_EXT);
    static final Comparator<File> FILE_DATE_COMPARATOR = (f1, f2) -> {
        long t2;
        long t1 = f1.lastModified();
        long diff = t1 - (t2 = f2.lastModified());
        if (diff == 0L) {
            return 0;
        }
        return diff < 0L ? -1 : 1;
    };

    private UserAdmin() {
    }

    private static String[] splitCommand(String cmd) {
        ArrayList<String> argList = new ArrayList<String>();
        int startIx = 0;
        int endIx = 0;
        int len = cmd.length();
        boolean insideQuote = false;
        while (endIx < len) {
            char c = cmd.charAt(endIx);
            if (!(insideQuote || startIx != endIx || c != ' ' && c != '\"')) {
                insideQuote = c == '\"';
                startIx = ++endIx;
                continue;
            }
            if (c == (insideQuote ? (char)'\"' : ' ')) {
                argList.add(cmd.substring(startIx, endIx));
                startIx = ++endIx;
                insideQuote = false;
                continue;
            }
            ++endIx;
        }
        if (startIx != endIx) {
            argList.add(cmd.substring(startIx, endIx));
        }
        String[] args = new String[argList.size()];
        argList.toArray(args);
        return args;
    }

    private static void processCommand(RepositoryManager repositoryMgr, String cmd) throws IOException {
        UserManager userMgr = repositoryMgr.getUserManager();
        String[] args = UserAdmin.splitCommand(cmd);
        if (ADD_USER_COMMAND.equals(args[0])) {
            String sid = args[1];
            try {
                userMgr.addUser(sid);
                log.info("User '" + sid + "' added");
            }
            catch (DuplicateNameException e) {
                log.error("Add User Failed: user '" + sid + "' already exists");
            }
        } else if (REMOVE_USER_COMMAND.equals(args[0])) {
            String sid = args[1];
            userMgr.removeUser(sid);
            log.info("User '" + sid + "' removed");
        } else if (RESET_USER_COMMAND.equals(args[0])) {
            String sid = args[1];
            if (!userMgr.resetPassword(sid)) {
                log.info("Failed to reset password for user '" + sid + "'");
            } else {
                log.info("User '" + sid + "' password reset to default password");
            }
        } else if (SET_USER_DN_COMMAND.equals(args[0])) {
            String sid = args[1];
            X500Principal x500User = new X500Principal(args[2]);
            if (userMgr.isValidUser(sid)) {
                userMgr.setDistinguishedName(sid, x500User);
                log.info("User '" + sid + "' DN set (" + x500User.getName() + ")");
            } else {
                try {
                    userMgr.addUser(sid, x500User);
                    log.info("User '" + sid + "' added with DN (" + x500User.getName() + ") and default password");
                }
                catch (DuplicateNameException duplicateNameException) {}
            }
        } else if (SET_ADMIN_COMMAND.equals(args[0])) {
            Repository rep;
            String sid = args[1];
            String repName = args[2];
            if (!userMgr.isValidUser(sid)) {
                try {
                    userMgr.addUser(sid);
                    log.info("User '" + sid + "' added");
                }
                catch (DuplicateNameException e) {
                    return;
                }
            }
            if ((rep = repositoryMgr.getRepository(repName)) == null) {
                log.error("Failed to add '" + sid + "' as admin, repository '" + repName + "' not found.");
            } else {
                rep.addAdmin(sid);
            }
        }
    }

    static void processCommands(RepositoryManager repositoryMgr) throws IOException {
        File cmdDir = new File(repositoryMgr.getRootDir(), ADMIN_CMD_DIR);
        if (!cmdDir.exists()) {
            cmdDir.mkdir();
            return;
        }
        File[] files = cmdDir.listFiles(CMD_FILE_FILTER);
        if (files == null) {
            log.error("Failed to access command queue " + cmdDir.getAbsolutePath() + ": possible permission problem");
            return;
        }
        Arrays.sort(files, FILE_DATE_COMPARATOR);
        if (files.length == 0) {
            return;
        }
        log.info("Processing " + files.length + " queued commands");
        for (File file : files) {
            ArrayList<String> cmdList = UserAdmin.readCommands(file);
            Iterator<String> it = cmdList.iterator();
            while (it.hasNext()) {
                UserAdmin.processCommand(repositoryMgr, it.next());
            }
            file.delete();
        }
    }

    private static ArrayList<String> readCommands(File cmdFile) throws IOException {
        String cmd;
        ArrayList<String> cmdList = new ArrayList<String>();
        BufferedReader rdr = new BufferedReader(new FileReader(cmdFile));
        while ((cmd = rdr.readLine()) != null) {
            if (cmd.length() == 0) continue;
            cmdList.add(cmd.trim());
        }
        rdr.close();
        return cmdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeCommands(ArrayList<String> cmdList, File cmdDir) throws IOException {
        File cmdFile = File.createTempFile("adm", ".tmp", cmdDir);
        Object cmdFilename = cmdFile.getName();
        cmdFilename = ((String)cmdFilename).substring(0, ((String)cmdFilename).length() - 4) + COMMAND_FILE_EXT;
        PrintWriter pw = new PrintWriter(new BufferedOutputStream(new FileOutputStream(cmdFile)));
        boolean success = false;
        try {
            for (String cmd : cmdList) {
                pw.println(cmd);
            }
            pw.close();
            if (!cmdFile.renameTo(new File(cmdFile.getParentFile(), (String)cmdFilename))) {
                throw new IOException("file error");
            }
            success = true;
        }
        finally {
            if (!success) {
                cmdFile.delete();
            }
        }
    }
}

