/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentProvider;
import docking.DialogComponentProvider;
import docking.DockingTool;
import docking.DockingWindowManager;
import docking.action.DockingActionIf;
import docking.actions.DockingToolActionManager;
import ghidra.framework.options.ToolOptions;
import ghidra.util.SystemUtilities;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;

public abstract class AbstractDockingTool
implements DockingTool {
    protected DockingWindowManager winMgr;
    protected DockingToolActionManager actionMgr;
    protected Map<String, ToolOptions> optionsMap = new HashMap<String, ToolOptions>();
    protected boolean configChangedFlag;

    @Override
    public boolean isVisible() {
        return this.winMgr.isVisible();
    }

    @Override
    public void setVisible(boolean visibility) {
        this.winMgr.setVisible(visibility);
    }

    @Override
    public void toFront() {
        JFrame frame = this.winMgr.getRootFrame();
        if (frame.getExtendedState() == 1) {
            frame.setExtendedState(0);
        }
        frame.toFront();
    }

    @Override
    public void addComponentProvider(ComponentProvider provider, boolean show) {
        Runnable r = () -> this.winMgr.addComponent(provider, show);
        SystemUtilities.runSwingNow((Runnable)r);
    }

    @Override
    public void removeComponentProvider(ComponentProvider provider) {
        Runnable r = () -> this.winMgr.removeComponent(provider);
        SystemUtilities.runSwingNow((Runnable)r);
    }

    @Override
    public ComponentProvider getComponentProvider(String name) {
        return this.winMgr.getComponentProvider(name);
    }

    @Override
    public void setStatusInfo(String text) {
        this.winMgr.setStatusText(text);
    }

    @Override
    public void addAction(DockingActionIf action) {
        this.actionMgr.addToolAction(action);
    }

    @Override
    public void removeAction(DockingActionIf action) {
        this.actionMgr.removeToolAction(action);
    }

    @Override
    public void addLocalAction(ComponentProvider provider, DockingActionIf action) {
        this.actionMgr.addLocalAction(provider, action);
    }

    @Override
    public void removeLocalAction(ComponentProvider provider, DockingActionIf action) {
        this.actionMgr.removeProviderAction(provider, action);
    }

    @Override
    public List<DockingActionIf> getAllActions() {
        return this.actionMgr.getAllActions();
    }

    @Override
    public List<DockingActionIf> getDockingActionsByOwnerName(String owner) {
        List<DockingActionIf> actions = this.actionMgr.getActions(owner);
        return actions;
    }

    @Override
    public List<DockingActionIf> getDockingActionsByFullActionName(String fullActionName) {
        HashSet<DockingActionIf> set = new HashSet<DockingActionIf>();
        set.addAll(this.actionMgr.getDockingActionsByFullActionName(fullActionName));
        set.addAll(this.winMgr.getActions(fullActionName));
        return new ArrayList<DockingActionIf>(set);
    }

    @Override
    public void showComponentProvider(ComponentProvider provider, boolean visible) {
        Runnable r = () -> this.winMgr.showComponent(provider, visible);
        SystemUtilities.runSwingNow((Runnable)r);
    }

    @Override
    public void showDialog(DialogComponentProvider dialogComponent) {
        DockingWindowManager.showDialog(this.getToolFrame(), dialogComponent);
    }

    public JFrame getToolFrame() {
        return this.winMgr.getRootFrame();
    }

    @Override
    public Window getProviderWindow(ComponentProvider provider) {
        return this.winMgr.getProviderWindow(provider);
    }

    @Override
    public void toFront(ComponentProvider provider) {
        Runnable r = () -> this.winMgr.toFront(provider);
        SystemUtilities.runSwingNow((Runnable)r);
    }

    @Override
    public boolean isVisible(ComponentProvider provider) {
        return this.winMgr.isVisible(provider);
    }

    @Override
    public boolean isActive(ComponentProvider provider) {
        return this.winMgr.isActiveProvider(provider);
    }

    @Override
    public void updateTitle(ComponentProvider provider) {
        this.winMgr.updateTitle(provider);
    }

    @Override
    public void contextChanged(ComponentProvider provider) {
        this.winMgr.contextChanged(provider);
    }

    @Override
    public DockingWindowManager getWindowManager() {
        return this.winMgr;
    }

    @Override
    public void setConfigChanged(boolean changed) {
        this.configChangedFlag = changed;
    }

    @Override
    public boolean hasConfigChanged() {
        return this.configChangedFlag;
    }
}

