/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ComponentPlaceholder;
import docking.ComponentProvider;
import docking.DockingWindowManager;
import docking.DockingWindowsContextSensitiveHelpListener;
import docking.GlobalMenuAndToolBarManager;
import docking.KeyBindingsManager;
import docking.MenuBarMenuHandler;
import docking.PopupActionManager;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.HelpAction;
import docking.action.KeyBindingAction;
import docking.action.ShowFocusCycleAction;
import docking.action.ShowFocusInfoAction;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import ghidra.util.HelpLocation;
import ghidra.util.ReservedKeyBindings;
import ghidra.util.SystemUtilities;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.MenuSelectionManager;

public class DockingActionManager {
    private HashSet<DockingActionIf> globalActions = new LinkedHashSet<DockingActionIf>();
    private MenuHandler menuBarMenuHandler;
    private MenuGroupMap menuGroupMap = new MenuGroupMap();
    private static boolean enableDiagnosticActions;
    private KeyBindingsManager keyBindingsManager;
    private GlobalMenuAndToolBarManager menuAndToolBarManager;
    private PopupActionManager popupActionManager;
    private DockingAction keyBindingsAction;

    DockingActionManager(DockingWindowManager winMgr) {
        this.menuBarMenuHandler = new MenuBarMenuHandler(winMgr);
        this.keyBindingsManager = new KeyBindingsManager(winMgr);
        this.menuAndToolBarManager = new GlobalMenuAndToolBarManager(winMgr, this.menuBarMenuHandler, this.menuGroupMap);
        this.popupActionManager = new PopupActionManager(winMgr, this.menuGroupMap);
        this.initializeHelpActions();
    }

    private void initializeHelpActions() {
        DockingWindowsContextSensitiveHelpListener.install();
        this.keyBindingsAction = new KeyBindingAction(this);
        this.keyBindingsManager.addReservedAction(new HelpAction(false, ReservedKeyBindings.HELP_KEY1));
        this.keyBindingsManager.addReservedAction(new HelpAction(false, ReservedKeyBindings.HELP_KEY2));
        this.keyBindingsManager.addReservedAction(new HelpAction(true, ReservedKeyBindings.HELP_INFO_KEY));
        this.keyBindingsManager.addReservedAction(this.keyBindingsAction);
        if (enableDiagnosticActions) {
            this.keyBindingsManager.addReservedAction(new ShowFocusInfoAction());
            this.keyBindingsManager.addReservedAction(new ShowFocusCycleAction());
        }
    }

    static void enableDiagnosticActions(boolean enable) {
        enableDiagnosticActions = enable;
    }

    static void setHelpLocation(JComponent c, HelpLocation helpLocation) {
        DockingWindowManager.getHelpService().registerHelp(c, helpLocation);
    }

    void removeAll(String owner) {
        Iterator<DockingActionIf> iter = new ArrayList<DockingActionIf>(this.globalActions).iterator();
        ArrayList<DockingActionIf> removedList = new ArrayList<DockingActionIf>();
        while (iter.hasNext()) {
            DockingActionIf action = iter.next();
            if (!owner.equals(action.getOwner())) continue;
            this.keyBindingsManager.removeAction(action);
            this.menuAndToolBarManager.removeAction(action);
            this.popupActionManager.removeAction(action);
            removedList.add(action);
        }
        this.globalActions.removeAll(removedList);
    }

    void addLocalAction(DockingActionIf action, ComponentProvider provider) {
        this.keyBindingsManager.addAction(action, provider);
    }

    void removeLocalAction(DockingActionIf action) {
        this.keyBindingsManager.removeAction(action);
    }

    void addToolAction(DockingActionIf action) {
        if (this.globalActions.add(action)) {
            this.keyBindingsManager.addAction(action, null);
            this.popupActionManager.addAction(action);
            this.menuAndToolBarManager.addAction(action);
        }
    }

    void removeToolAction(DockingActionIf action) {
        this.keyBindingsManager.removeAction(action);
        this.popupActionManager.removeAction(action);
        this.menuAndToolBarManager.removeAction(action);
        this.globalActions.remove(action);
    }

    public List<DockingActionIf> getAllDockingActionsByFullActionName(String fullActionName) {
        ArrayList<DockingActionIf> actions = new ArrayList<DockingActionIf>();
        SystemUtilities.runSwingNow(() -> {
            actions.addAll(this.getGlobalDockingActionsByFullActionName(fullActionName));
            actions.addAll(this.getLocalDockingActionsByFullActionName(fullActionName));
        });
        return actions;
    }

    private List<DockingActionIf> getGlobalDockingActionsByFullActionName(String fullActionName) {
        ArrayList<DockingActionIf> matchingActions = new ArrayList<DockingActionIf>();
        ArrayList<DockingActionIf> existingAction = new ArrayList<DockingActionIf>(this.globalActions);
        for (DockingActionIf action : existingAction) {
            if (!fullActionName.equals(action.getFullName())) continue;
            matchingActions.add(action);
        }
        return matchingActions;
    }

    private List<DockingActionIf> getLocalDockingActionsByFullActionName(String fullActionName) {
        ArrayList<DockingActionIf> matchingActions = new ArrayList<DockingActionIf>();
        ArrayList<DockingActionIf> existingAction = new ArrayList<DockingActionIf>(this.keyBindingsManager.getLocalActions());
        for (DockingActionIf action : existingAction) {
            if (!fullActionName.equals(action.getFullName())) continue;
            matchingActions.add(action);
        }
        return matchingActions;
    }

    public Action getDockingKeyAction(KeyStroke keyStroke) {
        return this.keyBindingsManager.getDockingKeyAction(keyStroke);
    }

    Set<DockingActionIf> getGlobalActions() {
        return this.globalActions;
    }

    void setActive(boolean active) {
        if (!active) {
            DockingActionManager.dismissMenus();
            DockingWindowManager.clearMouseOverHelp();
        }
    }

    static void dismissMenus() {
        MenuSelectionManager.defaultManager().clearSelectedPath();
    }

    void update() {
        this.menuAndToolBarManager.update();
        this.contextChangedAll();
    }

    void dispose() {
        this.keyBindingsManager.dispose();
        this.popupActionManager.dispose();
        this.menuAndToolBarManager.dispose();
        this.globalActions.clear();
    }

    void setMenuGroup(String[] menuPath, String group) {
        this.menuGroupMap.setMenuGroup(menuPath, group);
    }

    void setMenuGroup(String[] menuPath, String group, String menuSubGroup) {
        this.menuGroupMap.setMenuGroup(menuPath, group, menuSubGroup);
    }

    MenuHandler getMenuHandler() {
        return this.menuBarMenuHandler;
    }

    void contextChangedAll() {
        this.menuAndToolBarManager.contextChangedAll();
    }

    void contextChanged(ComponentPlaceholder placeHolder) {
        this.menuAndToolBarManager.contextChanged(placeHolder);
    }

    public MenuGroupMap getMenuGroupMap() {
        return this.menuGroupMap;
    }

    public void showPopupMenu(ComponentPlaceholder componentInfo, MouseEvent e) {
        this.popupActionManager.popupMenu(componentInfo, e);
    }
}

